/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.client;

import com.typesafe.config.Config;
import org.apache.drill.yarn.client.ClientCommand;
import org.apache.drill.yarn.client.ClientException;
import org.apache.drill.yarn.client.SimpleRestClient;
import org.apache.drill.yarn.client.StatusCommand;
import org.apache.drill.yarn.core.DoYUtil;
import org.apache.drill.yarn.core.DrillOnYarnConfig;
import org.apache.drill.yarn.core.YarnRMClient;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ResizeCommand
extends ClientCommand {
    private Config config;
    private YarnRMClient client;

    @Override
    public void run() throws ClientException {
        String cmd;
        this.config = DrillOnYarnConfig.config();
        this.client = this.getClient();
        System.out.println("Resizing cluster for Application ID: " + this.client.getAppId().toString());
        StatusCommand.Reporter reporter = new StatusCommand.Reporter(this.client);
        try {
            reporter.getReport();
        }
        catch (ClientException e) {
            reporter = null;
        }
        String prefix = this.opts.resizePrefix;
        int quantity = this.opts.resizeValue;
        if (prefix.equals("+")) {
            cmd = "grow";
            if (this.opts.verbose) {
                System.out.println("Growing cluster by " + quantity + " nodes.");
            }
        } else if (prefix.equals("-")) {
            cmd = "shrink";
            if (this.opts.verbose) {
                System.out.println("Shrinking cluster by " + quantity + " nodes.");
            }
        } else {
            cmd = "resize";
            if (this.opts.verbose) {
                System.out.println("Resizing cluster to " + quantity + " nodes.");
            }
        }
        if (this.sendResize(reporter.getAmUrl(), cmd, quantity)) {
            System.out.println("Use web UI or status command to check progress.");
        }
    }

    private boolean sendResize(String baseUrl, String cmd, int quantity) {
        try {
            Object response;
            if (DoYUtil.isBlank(baseUrl)) {
                return false;
            }
            SimpleRestClient restClient = new SimpleRestClient();
            String tail = "rest/" + cmd + "/" + quantity;
            String masterKey = this.config.getString(DrillOnYarnConfig.HTTP_REST_KEY);
            if (!DoYUtil.isBlank(masterKey)) {
                tail = tail + "?key=" + masterKey;
            }
            if (this.opts.verbose) {
                System.out.println("Resizing with POST " + baseUrl + "/" + tail);
            }
            String result = restClient.send(baseUrl, tail, true);
            JSONParser parser = new JSONParser();
            try {
                response = parser.parse(result);
            }
            catch (ParseException e) {
                System.err.println("Invalid response received from AM");
                if (this.opts.verbose) {
                    System.out.println(result);
                    System.out.println(e.getMessage());
                }
                return false;
            }
            JSONObject root = (JSONObject)response;
            System.out.println("AM responded: " + String.valueOf(root.get((Object)"message")));
            if ("ok".equals(root.get((Object)"status"))) {
                return true;
            }
            System.err.println("Failed to resize the application master.");
            return false;
        }
        catch (ClientException e) {
            System.err.println("Resize failed: " + e.getMessage());
            return false;
        }
    }
}

