/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.splunk.DataModelObject;
import com.splunk.FieldType;
import com.splunk.IPv4Comparison;
import com.splunk.PivotFilter;

public class IPv4PivotFilter
extends PivotFilter {
    private final IPv4Comparison comparison;
    private final String comparisonValue;

    IPv4PivotFilter(DataModelObject dataModelObject, String field, IPv4Comparison comparison, String comparisonValue) {
        super(dataModelObject, field);
        if (dataModelObject.getField(field).getType() != FieldType.IPV4) {
            throw new IllegalArgumentException("Field " + field + " on the data model object was of type " + dataModelObject.getField(field).getType().toString() + ", expected ipv4.");
        }
        this.comparison = comparison;
        this.comparisonValue = comparisonValue;
    }

    @Override
    JsonElement toJson() {
        JsonObject root = new JsonObject();
        this.addCommonFields(root);
        JsonObject filterRule = new JsonObject();
        filterRule.add("comparator", (JsonElement)new JsonPrimitive(this.comparison.toString()));
        filterRule.add("compareTo", (JsonElement)new JsonPrimitive(this.comparisonValue));
        root.add("rule", (JsonElement)filterRule);
        return root;
    }
}

