/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Args;
import com.splunk.RequestMessage;
import com.splunk.ResponseMessage;
import com.splunk.Service;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;

public class Receiver {
    Service service = null;

    Receiver(Service service) {
        this.service = service;
    }

    public Socket attach() throws IOException {
        return this.attach(null, null);
    }

    public Socket attach(String indexName) throws IOException {
        return this.attach(indexName, null);
    }

    public Socket attach(Args args) throws IOException {
        return this.attach(null, args);
    }

    public Socket attach(String indexName, Args args) throws IOException {
        Socket socket = this.service.open();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8"));
        String postUrl = "POST /services/receivers/stream";
        if (indexName != null) {
            postUrl = postUrl + "?index=" + indexName;
        }
        if (args != null && args.size() > 0) {
            postUrl = postUrl + (indexName == null ? "?" : "&");
            postUrl = postUrl + args.encode();
        }
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(String.format("%s HTTP/1.1", postUrl));
        headers.add("Accept-Encoding: identity");
        headers.add("X-Splunk-Input-Mode: Streaming");
        if (this.service.hasSplunkAuthCookies().booleanValue()) {
            headers.add(String.format("Cookie: %s", this.service.stringifyCookies()));
        } else {
            if (!this.service.cookieStore.isEmpty().booleanValue()) {
                headers.add(String.format("Cookie: %s", this.service.stringifyCookies()));
            }
            headers.add(String.format("Authorization: %s", this.service.getToken()));
        }
        headers.add("");
        headers.forEach(header -> writer.println((String)header));
        writer.flush();
        return socket;
    }

    public void submit(String data) {
        this.submit(null, null, data);
    }

    public void submit(String indexName, String data) {
        this.submit(indexName, null, data);
    }

    public void submit(Args args, String data) {
        this.submit(null, args, data);
    }

    public void submit(String indexName, Args args, String data) {
        String sendString = "";
        RequestMessage request = new RequestMessage("POST");
        request.setContent(data);
        if (indexName != null) {
            sendString = String.format("?index=%s", indexName);
        }
        if (args != null && args.size() > 0) {
            sendString = sendString + (indexName == null ? "?" : "&");
            sendString = sendString + args.encode();
        }
        ResponseMessage response = this.service.send(this.service.simpleReceiverEndPoint + sendString, request);
        try {
            response.getContent().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void log(String data) {
        this.submit(data);
    }

    public void log(String indexName, String data) {
        this.submit(indexName, data);
    }

    public void log(Args args, String data) {
        this.submit(args, data);
    }

    public void log(String indexName, Args args, String data) {
        this.submit(indexName, args, data);
    }
}

