/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.pcapdecoder;

import fr.bmartel.pcapdecoder.constant.HeaderBlocks;
import fr.bmartel.pcapdecoder.constant.MagicNumber;
import fr.bmartel.pcapdecoder.structure.BlockTypes;
import fr.bmartel.pcapdecoder.structure.PcapNgStructureParser;
import fr.bmartel.pcapdecoder.structure.types.IPcapngType;
import fr.bmartel.pcapdecoder.utils.DecodeException;
import fr.bmartel.pcapdecoder.utils.UtilFunctions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;

public class PcapDecoder {
    private byte[] data = null;
    private boolean isBigEndian = true;
    private ArrayList<IPcapngType> pcapSectionList = new ArrayList();

    public PcapDecoder(byte[] data) {
        this.data = data;
    }

    public PcapDecoder(String inputFilePath) {
        if (inputFilePath != null) {
            try {
                this.data = Files.readAllBytes(Paths.get(inputFilePath, new String[0]));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private byte detectEndianness(byte[] magicNumber) {
        if (UtilFunctions.compare32Bytes(MagicNumber.MAGIC_NUMBER_BIG_ENDIAN, magicNumber, this.isBigEndian)) {
            return 1;
        }
        if (UtilFunctions.compare32Bytes(MagicNumber.MAGIC_NUMBER_LITTLE_ENDIAN, magicNumber, this.isBigEndian)) {
            return 2;
        }
        return 0;
    }

    private int parseBlockLength(byte[] length, boolean isBigEndian) {
        if (isBigEndian) {
            int blockLength = (this.data[0] << 32 & 0xFF) + (this.data[1] << 16 & 0xFF) + (this.data[2] << 8 & 0xFF) + (this.data[3] << 0 & 0xFF);
            return blockLength;
        }
        int blockLength = (length[0] << 0 & 0xFF) + (length[1] << 8 & 0xFF00) + (length[2] << 16 & 0xFF0000) + (length[3] << 32 & 0xFF000000);
        return blockLength;
    }

    private int parseDataBlock(BlockTypes type, byte[] data, int initIndex) {
        try {
            byte[] dataBlock;
            int index = initIndex;
            int blockLength = this.parseBlockLength(Arrays.copyOfRange(data, index + 4, index + 8), this.isBigEndian);
            byte[] dataTemp = dataBlock = Arrays.copyOfRange(data, index + 8, index + (blockLength - 4));
            if (type == BlockTypes.SECTION_HEADER_BLOCK) {
                dataTemp = Arrays.copyOfRange(dataBlock, 4, dataBlock.length);
            }
            PcapNgStructureParser structure = new PcapNgStructureParser(type, dataTemp, this.isBigEndian);
            structure.decode();
            this.pcapSectionList.add(structure.getPcapStruct());
            return index += blockLength - 1 + 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int processSectionType(BlockTypes type, int initIndex) throws DecodeException {
        int index = initIndex;
        if (UtilFunctions.compare32Bytes(HeaderBlocks.SECTION_TYPE_LIST.get(type.toString()), Arrays.copyOfRange(this.data, index, index + 4), this.isBigEndian)) {
            if (type == BlockTypes.SECTION_HEADER_BLOCK) {
                byte endianess = this.detectEndianness(Arrays.copyOfRange(Arrays.copyOfRange(this.data, index + 8, index + 12), 0, 4));
                if (endianess == 1) {
                    this.isBigEndian = true;
                } else if (endianess == 2) {
                    this.isBigEndian = false;
                }
            }
            if ((index = this.parseDataBlock(type, this.data, index)) == -1) {
                throw new DecodeException();
            }
            return index;
        }
        return index;
    }

    public byte decode() {
        if (this.data == null || this.data.length < 4) {
            return -1;
        }
        int initIndex = 0;
        try {
            int formerIndex = 0;
            while (initIndex != this.data.length) {
                initIndex = this.processSectionType(BlockTypes.SECTION_HEADER_BLOCK, initIndex);
                initIndex = this.processSectionType(BlockTypes.INTERFACE_DESCRIPTION_BLOCK, initIndex);
                initIndex = this.processSectionType(BlockTypes.ENHANCES_PACKET_BLOCK, initIndex);
                initIndex = this.processSectionType(BlockTypes.SIMPLE_PACKET_BLOCK, initIndex);
                initIndex = this.processSectionType(BlockTypes.NAME_RESOLUTION_BLOCK, initIndex);
                initIndex = this.processSectionType(BlockTypes.INTERFACE_STATISTICS_BLOCK, initIndex);
                if (formerIndex == (initIndex = this.processSectionType(BlockTypes.PACKET_BLOCK, initIndex)) && formerIndex != 0) {
                    throw new DecodeException("File parsing error | format not recognized");
                }
                formerIndex = initIndex;
            }
        }
        catch (DecodeException e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    public ArrayList<IPcapngType> getSectionList() {
        return this.pcapSectionList;
    }
}

