/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.pcapdecoder.structure.options;

import fr.bmartel.pcapdecoder.structure.BlockTypes;
import fr.bmartel.pcapdecoder.structure.options.IPcapngOptions;
import fr.bmartel.pcapdecoder.structure.options.abstr.OptionsAbstr;
import fr.bmartel.pcapdecoder.structure.options.impl.OptionsEnhancedHeader;
import fr.bmartel.pcapdecoder.structure.options.impl.OptionsInterfaceDescriptionHeader;
import fr.bmartel.pcapdecoder.structure.options.impl.OptionsInterfaceStatisticsHeader;
import fr.bmartel.pcapdecoder.structure.options.impl.OptionsNameResolutionHeader;
import fr.bmartel.pcapdecoder.structure.options.impl.OptionsRecordNameResolutionHeader;
import fr.bmartel.pcapdecoder.structure.options.impl.OptionsSectionHeader;
import fr.bmartel.pcapdecoder.structure.options.inter.IOptions;
import fr.bmartel.pcapdecoder.structure.options.inter.IOptionsRecordNameResolution;

public class PcapOptions
implements IPcapngOptions {
    private int optionCode = -1;
    private int optionLength = -1;
    private byte[] optionValue = null;
    private boolean isBigEndian = true;
    private BlockTypes type = null;
    private IOptions option = null;

    public PcapOptions(int optionCode, int optionLength, byte[] optionValue, boolean isBigEndian, BlockTypes type, IOptions option) {
        this.optionCode = optionCode;
        this.optionLength = optionLength;
        this.optionValue = optionValue;
        this.isBigEndian = isBigEndian;
        this.type = type;
        this.option = option;
    }

    public void decode() {
        OptionsAbstr optionsAbstr;
        if (this.type == BlockTypes.SECTION_HEADER_BLOCK) {
            optionsAbstr = new OptionsSectionHeader(this.optionCode, this.optionValue, this.isBigEndian, this.option);
        }
        if (this.type == BlockTypes.INTERFACE_DESCRIPTION_BLOCK) {
            optionsAbstr = new OptionsInterfaceDescriptionHeader(this.optionCode, this.optionValue, this.isBigEndian, this.option);
        }
        if (this.type == BlockTypes.ENHANCES_PACKET_BLOCK) {
            optionsAbstr = new OptionsEnhancedHeader(this.optionCode, this.optionValue, this.isBigEndian, this.option);
        }
        if (this.type == BlockTypes.INTERFACE_STATISTICS_BLOCK) {
            optionsAbstr = new OptionsInterfaceStatisticsHeader(this.optionCode, this.optionValue, this.isBigEndian, this.option);
        }
        if (this.type == BlockTypes.NAME_RESOLUTION_BLOCK) {
            optionsAbstr = this.option instanceof IOptionsRecordNameResolution ? new OptionsRecordNameResolutionHeader(this.optionCode, this.optionValue, this.isBigEndian, this.option) : new OptionsNameResolutionHeader(this.optionCode, this.optionValue, this.isBigEndian, this.option);
        }
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public int getOptionLength() {
        return this.optionLength;
    }

    @Override
    public byte[] getOptionValue() {
        return this.optionValue;
    }

    public boolean isBigEndian() {
        return this.isBigEndian;
    }

    public BlockTypes getType() {
        return this.type;
    }
}

