/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kudu;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.kudu.KuduScanSpec;
import org.apache.drill.exec.store.kudu.KuduStoragePlugin;
import org.apache.drill.exec.store.kudu.KuduStoragePluginConfig;
import org.apache.drill.exec.store.kudu.KuduSubScan;
import org.apache.drill.exec.store.schedule.AffinityCreator;
import org.apache.drill.exec.store.schedule.AssignmentCreator;
import org.apache.drill.exec.store.schedule.CompleteWork;
import org.apache.drill.exec.store.schedule.EndpointByteMap;
import org.apache.drill.exec.store.schedule.EndpointByteMapImpl;
import org.apache.kudu.client.LocatedTablet;

@JsonTypeName(value="kudu-scan")
public class KuduGroupScan
extends AbstractGroupScan {
    private static final long DEFAULT_TABLET_SIZE = 1000L;
    private KuduStoragePlugin kuduStoragePlugin;
    private List<SchemaPath> columns;
    private KuduScanSpec kuduScanSpec;
    private boolean filterPushedDown = false;
    private List<KuduWork> kuduWorkList = Lists.newArrayList();
    private ListMultimap<Integer, KuduWork> assignments;
    private List<EndpointAffinity> affinities;

    @JsonCreator
    public KuduGroupScan(@JsonProperty(value="kuduScanSpec") KuduScanSpec kuduScanSpec, @JsonProperty(value="kuduStoragePluginConfig") KuduStoragePluginConfig kuduStoragePluginConfig, @JsonProperty(value="columns") List<SchemaPath> columns, @JacksonInject StoragePluginRegistry pluginRegistry) throws IOException, ExecutionSetupException {
        this((KuduStoragePlugin)pluginRegistry.resolve((StoragePluginConfig)kuduStoragePluginConfig, KuduStoragePlugin.class), kuduScanSpec, columns);
    }

    public KuduGroupScan(KuduStoragePlugin kuduStoragePlugin, KuduScanSpec kuduScanSpec, List<SchemaPath> columns) {
        super((String)null);
        this.kuduStoragePlugin = kuduStoragePlugin;
        this.kuduScanSpec = kuduScanSpec;
        this.columns = columns == null || columns.size() == 0 ? ALL_COLUMNS : columns;
        this.init();
    }

    private void init() {
        String tableName = this.kuduScanSpec.getTableName();
        Collection endpoints = this.kuduStoragePlugin.getContext().getBits();
        HashMap endpointMap = Maps.newHashMap();
        for (CoordinationProtos.DrillbitEndpoint endpoint : endpoints) {
            endpointMap.put(endpoint.getAddress(), endpoint);
        }
        try {
            List locations = this.kuduStoragePlugin.getClient().openTable(tableName).getTabletsLocations(10000L);
            for (LocatedTablet tablet : locations) {
                KuduWork work = new KuduWork(tablet.getPartition().getPartitionKeyStart(), tablet.getPartition().getPartitionKeyEnd());
                for (LocatedTablet.Replica replica : tablet.getReplicas()) {
                    String host = replica.getRpcHost();
                    CoordinationProtos.DrillbitEndpoint ep = (CoordinationProtos.DrillbitEndpoint)endpointMap.get(host);
                    if (ep == null) continue;
                    work.getByteMap().add(ep, 1000L);
                }
                this.kuduWorkList.add(work);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private KuduGroupScan(KuduGroupScan that) {
        super((AbstractGroupScan)that);
        this.kuduStoragePlugin = that.kuduStoragePlugin;
        this.columns = that.columns;
        this.kuduScanSpec = that.kuduScanSpec;
        this.filterPushedDown = that.filterPushedDown;
        this.kuduWorkList = that.kuduWorkList;
        this.assignments = that.assignments;
    }

    public GroupScan clone(List<SchemaPath> columns) {
        KuduGroupScan newScan = new KuduGroupScan(this);
        newScan.columns = columns;
        return newScan;
    }

    public List<EndpointAffinity> getOperatorAffinity() {
        if (this.affinities == null) {
            this.affinities = AffinityCreator.getAffinityMap(this.kuduWorkList);
        }
        return this.affinities;
    }

    public int getMaxParallelizationWidth() {
        return this.kuduWorkList.size();
    }

    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> incomingEndpoints) {
        this.assignments = AssignmentCreator.getMappings(incomingEndpoints, this.kuduWorkList);
    }

    public KuduSubScan getSpecificScan(int minorFragmentId) {
        List workList = this.assignments.get((Object)minorFragmentId);
        ArrayList scanSpecList = Lists.newArrayList();
        for (KuduWork work : workList) {
            scanSpecList.add(new KuduSubScan.KuduSubScanSpec(this.getTableName(), work.getPartitionKeyStart(), work.getPartitionKeyEnd()));
        }
        return new KuduSubScan(this.kuduStoragePlugin, scanSpecList, this.columns);
    }

    public ScanStats getScanStats() {
        long recordCount = 100000L * (long)this.kuduWorkList.size();
        return new ScanStats(ScanStats.GroupScanProperty.NO_EXACT_ROW_COUNT, (double)recordCount, 1.0, (double)recordCount);
    }

    @JsonIgnore
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument((boolean)children.isEmpty());
        return new KuduGroupScan(this);
    }

    @JsonIgnore
    public KuduStoragePlugin getStoragePlugin() {
        return this.kuduStoragePlugin;
    }

    @JsonIgnore
    public String getTableName() {
        return this.getKuduScanSpec().getTableName();
    }

    public String getDigest() {
        return this.toString();
    }

    public String toString() {
        return "KuduGroupScan [KuduScanSpec=" + String.valueOf(this.kuduScanSpec) + ", columns=" + String.valueOf(this.columns) + "]";
    }

    @JsonProperty
    public KuduStoragePluginConfig getKuduStoragePluginConfig() {
        return this.kuduStoragePlugin.getConfig();
    }

    @JsonProperty
    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public KuduScanSpec getKuduScanSpec() {
        return this.kuduScanSpec;
    }

    @JsonIgnore
    public boolean canPushdownProjects(List<SchemaPath> columns) {
        return true;
    }

    @JsonIgnore
    public void setFilterPushedDown(boolean b) {
        this.filterPushedDown = true;
    }

    @JsonIgnore
    public boolean isFilterPushedDown() {
        return this.filterPushedDown;
    }

    @VisibleForTesting
    public KuduGroupScan() {
        super((String)null);
    }

    @VisibleForTesting
    public void setKuduScanSpec(KuduScanSpec kuduScanSpec) {
        this.kuduScanSpec = kuduScanSpec;
    }

    private static class KuduWork
    implements CompleteWork {
        private final EndpointByteMapImpl byteMap = new EndpointByteMapImpl();
        private final byte[] partitionKeyStart;
        private final byte[] partitionKeyEnd;

        public KuduWork(byte[] partitionKeyStart, byte[] partitionKeyEnd) {
            this.partitionKeyStart = partitionKeyStart;
            this.partitionKeyEnd = partitionKeyEnd;
        }

        public byte[] getPartitionKeyStart() {
            return this.partitionKeyStart;
        }

        public byte[] getPartitionKeyEnd() {
            return this.partitionKeyEnd;
        }

        public long getTotalBytes() {
            return 1000L;
        }

        public EndpointByteMap getByteMap() {
            return this.byteMap;
        }

        public int compareTo(CompleteWork o) {
            return 0;
        }
    }
}

