/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.persist;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.apache.tephra.ChangeId;
import org.apache.tephra.TransactionManager;
import org.apache.tephra.manager.InvalidTxList;
import org.apache.tephra.persist.TransactionVisibilityState;
import org.apache.tephra.shaded.com.google.common.base.Objects;
import org.apache.tephra.shaded.com.google.common.collect.Maps;

public class TransactionSnapshot
implements TransactionVisibilityState {
    private long timestamp;
    private long readPointer;
    private long writePointer;
    private Collection<Long> invalid;
    private NavigableMap<Long, TransactionManager.InProgressTx> inProgress;
    private Map<Long, Set<ChangeId>> committingChangeSets;
    private Map<Long, Set<ChangeId>> committedChangeSets;

    public TransactionSnapshot(long timestamp, long readPointer, long writePointer, Collection<Long> invalid, NavigableMap<Long, TransactionManager.InProgressTx> inProgress, Map<Long, Set<ChangeId>> committing, Map<Long, Set<ChangeId>> committed) {
        this(timestamp, readPointer, writePointer, invalid, inProgress);
        this.committingChangeSets = committing;
        this.committedChangeSets = committed;
    }

    public TransactionSnapshot(long timestamp, long readPointer, long writePointer, Collection<Long> invalid, NavigableMap<Long, TransactionManager.InProgressTx> inProgress) {
        this.timestamp = timestamp;
        this.readPointer = readPointer;
        this.writePointer = writePointer;
        this.invalid = invalid;
        this.inProgress = inProgress;
        this.committingChangeSets = Collections.emptyMap();
        this.committedChangeSets = Collections.emptyMap();
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getReadPointer() {
        return this.readPointer;
    }

    @Override
    public long getWritePointer() {
        return this.writePointer;
    }

    @Override
    public Collection<Long> getInvalid() {
        return this.invalid;
    }

    @Override
    public NavigableMap<Long, TransactionManager.InProgressTx> getInProgress() {
        return this.inProgress;
    }

    @Override
    public long getVisibilityUpperBound() {
        Map.Entry<Long, TransactionManager.InProgressTx> firstInProgress = this.inProgress.firstEntry();
        if (firstInProgress == null) {
            return this.readPointer;
        }
        return firstInProgress.getValue().getVisibilityUpperBound();
    }

    public Map<Long, Set<ChangeId>> getCommittingChangeSets() {
        return this.committingChangeSets;
    }

    public Map<Long, Set<ChangeId>> getCommittedChangeSets() {
        return this.committedChangeSets;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TransactionSnapshot)) {
            return false;
        }
        TransactionSnapshot other = (TransactionSnapshot)obj;
        return this.readPointer == other.readPointer && this.writePointer == other.writePointer && this.invalid.equals(other.invalid) && this.inProgress.equals(other.inProgress) && this.committingChangeSets.equals(other.committingChangeSets) && this.committedChangeSets.equals(other.committedChangeSets);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("timestamp", this.timestamp).add("readPointer", this.readPointer).add("writePointer", this.writePointer).add("invalidSize", this.invalid.size()).add("inProgressSize", this.inProgress.size()).add("committingSize", this.committingChangeSets.size()).add("committedSize", this.committedChangeSets.size()).toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.readPointer, this.writePointer, this.invalid, this.inProgress, this.committingChangeSets, this.committedChangeSets);
    }

    public static TransactionSnapshot copyFrom(long snapshotTime, long readPointer, long writePointer, InvalidTxList invalidTxList, NavigableMap<Long, TransactionManager.InProgressTx> inProgress, Map<Long, TransactionManager.ChangeSet> committing, NavigableMap<Long, TransactionManager.ChangeSet> committed) {
        LongArrayList invalidCopy = new LongArrayList(invalidTxList.toSortedArray());
        TreeMap<Long, TransactionManager.InProgressTx> inProgressCopy = Maps.newTreeMap(inProgress);
        HashMap<Long, Set<ChangeId>> committingCopy = Maps.newHashMap();
        for (Map.Entry<Long, TransactionManager.ChangeSet> entry : committing.entrySet()) {
            committingCopy.put(entry.getKey(), new HashSet<ChangeId>(entry.getValue().getChangeIds()));
        }
        TreeMap<Long, Set<ChangeId>> committedCopy = new TreeMap<Long, Set<ChangeId>>();
        for (Map.Entry entry : committed.entrySet()) {
            committedCopy.put((Long)entry.getKey(), (Set<ChangeId>)new HashSet<ChangeId>(((TransactionManager.ChangeSet)entry.getValue()).getChangeIds()));
        }
        return new TransactionSnapshot(snapshotTime, readPointer, writePointer, (Collection<Long>)invalidCopy, inProgressCopy, committingCopy, committedCopy);
    }
}

