/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.shaded.org.apache.twill.common;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public final class Threads {
    public static final Executor SAME_THREAD_EXECUTOR = new Executor(){

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    };

    public static ThreadFactory createDaemonThreadFactory(final String nameFormat) {
        final AtomicLong id = new AtomicLong(0L);
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName(String.format(nameFormat, id.getAndIncrement()));
                return t;
            }
        };
    }

    private Threads() {
    }
}

