/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.iceberg;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Base64;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.iceberg.CombinedScanTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(using=IcebergWorkSerializer.class)
@JsonDeserialize(using=IcebergWorkDeserializer.class)
public class IcebergWork {
    private final CombinedScanTask scanTask;

    public IcebergWork(CombinedScanTask scanTask) {
        this.scanTask = scanTask;
    }

    public CombinedScanTask getScanTask() {
        return this.scanTask;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcebergWork that = (IcebergWork)o;
        return Objects.equals(this.scanTask, that.scanTask);
    }

    public int hashCode() {
        return Objects.hash(this.scanTask);
    }

    public String toString() {
        return new StringJoiner(", ", IcebergWork.class.getSimpleName() + "[", "]").add("scanTask=" + String.valueOf(this.scanTask)).toString();
    }

    public static class IcebergWorkSerializer
    extends StdSerializer<IcebergWork> {
        public static final String SCAN_TASK_FIELD = "scanTask";

        public IcebergWorkSerializer() {
            super(IcebergWork.class);
        }

        public void serialize(IcebergWork value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            CombinedScanTask scanTask = value.getScanTask();
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                 ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
                objectOutputStream.writeObject(scanTask);
                gen.writeStringField(SCAN_TASK_FIELD, Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray()));
            }
            gen.writeEndObject();
        }
    }

    public static class IcebergWorkDeserializer
    extends StdDeserializer<IcebergWork> {
        private static final Logger logger = LoggerFactory.getLogger(IcebergWorkDeserializer.class);

        public IcebergWorkDeserializer() {
            super(IcebergWork.class);
        }

        public IcebergWork deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            IcebergWork icebergWork;
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            String scanTaskString = node.get("scanTask").asText();
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(Base64.getDecoder().decode(scanTaskString)));
            try {
                Object scanTask = ois.readObject();
                icebergWork = new IcebergWork((CombinedScanTask)scanTask);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ois.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (ClassNotFoundException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            }
            ois.close();
            return icebergWork;
        }
    }
}

