/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.metadata;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.metastore.components.tables.TableMetadataUnit;
import org.apache.drill.metastore.metadata.BaseMetadata;
import org.apache.drill.metastore.metadata.TableMetadata;
import org.apache.drill.metastore.statistics.ColumnStatistics;
import org.apache.drill.metastore.statistics.StatisticsHolder;
import org.apache.hadoop.fs.Path;

public class BaseTableMetadata
extends BaseMetadata
implements TableMetadata {
    private final Path location;
    private final Map<String, String> partitionKeys;
    private final List<SchemaPath> interestingColumns;

    private BaseTableMetadata(BaseTableMetadataBuilder builder) {
        super(builder);
        this.location = builder.location;
        this.partitionKeys = builder.partitionKeys;
        this.interestingColumns = builder.interestingColumns;
    }

    public boolean isPartitionColumn(String fieldName) {
        return this.partitionKeys.containsKey(fieldName);
    }

    boolean isPartitioned() {
        return !this.partitionKeys.isEmpty();
    }

    @Override
    public Path getLocation() {
        return this.location;
    }

    @Override
    public List<SchemaPath> getInterestingColumns() {
        return this.interestingColumns;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseTableMetadata that = (BaseTableMetadata)o;
        return Objects.equals(this.location, that.location) && Objects.equals(this.partitionKeys, that.partitionKeys) && Objects.equals(this.interestingColumns, that.interestingColumns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.location, this.partitionKeys, this.interestingColumns);
    }

    public String toString() {
        return new StringJoiner(",\n", BaseTableMetadata.class.getSimpleName() + "[\n", "]").add("location=" + String.valueOf(this.location)).add("partitionKeys=" + String.valueOf(this.partitionKeys)).add("interestingColumns=" + String.valueOf(this.interestingColumns)).add("tableInfo=" + String.valueOf(this.tableInfo)).add("metadataInfo=" + String.valueOf(this.metadataInfo)).add("schema=" + String.valueOf(this.schema)).add("columnsStatistics=" + String.valueOf(this.columnsStatistics)).add("metadataStatistics=" + String.valueOf(this.metadataStatistics)).add("lastModifiedTime=" + this.lastModifiedTime).toString();
    }

    @Override
    public BaseTableMetadata cloneWithStats(Map<SchemaPath, ColumnStatistics<?>> columnStatistics, List<StatisticsHolder<?>> tableStatistics) {
        HashMap mergedTableStatistics = new HashMap(this.metadataStatistics);
        tableStatistics.stream().filter(statisticsHolder -> statisticsHolder.getStatisticsKind().isExact() || !this.metadataStatistics.containsKey(statisticsHolder.getStatisticsKind().getName()) || !((StatisticsHolder)this.metadataStatistics.get(statisticsHolder.getStatisticsKind().getName())).getStatisticsKind().isExact()).forEach(statisticsHolder -> mergedTableStatistics.put(statisticsHolder.getStatisticsKind().getName(), statisticsHolder));
        HashMap newColumnsStatistics = new HashMap(this.columnsStatistics);
        this.columnsStatistics.forEach((columnName, value) -> {
            ColumnStatistics sourceStatistics = (ColumnStatistics)columnStatistics.get(columnName);
            if (sourceStatistics != null) {
                newColumnsStatistics.put((SchemaPath)columnName, value.genericClone(sourceStatistics));
            }
        });
        return ((BaseTableMetadataBuilder)((BaseTableMetadataBuilder)((BaseTableMetadataBuilder)((BaseTableMetadataBuilder)((BaseTableMetadataBuilder)((BaseTableMetadataBuilder)BaseTableMetadata.builder().tableInfo(this.tableInfo)).metadataInfo(this.metadataInfo)).location(this.location).schema(this.schema)).columnsStatistics(newColumnsStatistics)).metadataStatistics(mergedTableStatistics.values())).lastModifiedTime(this.lastModifiedTime)).partitionKeys(this.partitionKeys).interestingColumns(this.interestingColumns).build();
    }

    @Override
    protected void toMetadataUnitBuilder(TableMetadataUnit.Builder builder) {
        if (this.location != null) {
            builder.location(this.location.toUri().getPath());
        }
        builder.partitionKeys(this.partitionKeys);
        if (this.interestingColumns != null) {
            builder.interestingColumns(this.interestingColumns.stream().map(SchemaPath::toString).collect(Collectors.toList()));
        }
    }

    public BaseTableMetadataBuilder toBuilder() {
        return ((BaseTableMetadataBuilder)((BaseTableMetadataBuilder)((BaseTableMetadataBuilder)((BaseTableMetadataBuilder)((BaseTableMetadataBuilder)((BaseTableMetadataBuilder)BaseTableMetadata.builder().tableInfo(this.tableInfo)).metadataInfo(this.metadataInfo)).location(this.location).schema(this.schema)).columnsStatistics(this.columnsStatistics)).metadataStatistics(this.metadataStatistics.values())).lastModifiedTime(this.lastModifiedTime)).partitionKeys(this.partitionKeys).interestingColumns(this.interestingColumns);
    }

    public static BaseTableMetadataBuilder builder() {
        return new BaseTableMetadataBuilder();
    }

    public static class BaseTableMetadataBuilder
    extends BaseMetadata.BaseMetadataBuilder<BaseTableMetadataBuilder> {
        private Path location;
        private Map<String, String> partitionKeys;
        private List<SchemaPath> interestingColumns;

        public BaseTableMetadataBuilder location(Path location) {
            this.location = location;
            return this.self();
        }

        public BaseTableMetadataBuilder partitionKeys(Map<String, String> partitionKeys) {
            this.partitionKeys = partitionKeys;
            return this.self();
        }

        public BaseTableMetadataBuilder interestingColumns(List<SchemaPath> interestingColumns) {
            this.interestingColumns = interestingColumns;
            return this.self();
        }

        @Override
        protected void checkRequiredValues() {
            super.checkRequiredValues();
            Objects.requireNonNull(this.partitionKeys, "partitionKeys were not set");
        }

        @Override
        public BaseTableMetadata build() {
            this.checkRequiredValues();
            return new BaseTableMetadata(this);
        }

        @Override
        protected BaseTableMetadataBuilder self() {
            return this;
        }

        @Override
        protected BaseTableMetadataBuilder metadataUnitInternal(TableMetadataUnit unit) {
            if (unit.location() != null) {
                this.location(new Path(unit.location()));
            }
            this.partitionKeys(unit.partitionKeys());
            if (unit.interestingColumns() != null) {
                this.interestingColumns(unit.interestingColumns().stream().map(SchemaPath::parseFromString).collect(Collectors.toList()));
            }
            return this.self();
        }
    }
}

