/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.metadata;

import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.drill.metastore.components.tables.TableMetadataUnit;
import org.apache.drill.metastore.metadata.BaseMetadata;
import org.apache.drill.metastore.metadata.LocationProvider;
import org.apache.hadoop.fs.Path;

public class RowGroupMetadata
extends BaseMetadata
implements LocationProvider {
    private Map<String, Float> hostAffinity;
    private int rowGroupIndex;
    private Path path;

    private RowGroupMetadata(RowGroupMetadataBuilder builder) {
        super(builder);
        this.hostAffinity = builder.hostAffinity;
        this.rowGroupIndex = builder.rowGroupIndex;
        this.path = builder.path;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public Path getLocation() {
        return this.path.getParent();
    }

    public int getRowGroupIndex() {
        return this.rowGroupIndex;
    }

    public Map<String, Float> getHostAffinity() {
        return this.hostAffinity;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RowGroupMetadata that = (RowGroupMetadata)o;
        return this.rowGroupIndex == that.rowGroupIndex && Objects.equals(this.hostAffinity, that.hostAffinity) && Objects.equals(this.path, that.path);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.hostAffinity, this.rowGroupIndex, this.path);
    }

    public String toString() {
        return new StringJoiner(",\n", RowGroupMetadata.class.getSimpleName() + "[\n", "]").add("hostAffinity=" + String.valueOf(this.hostAffinity)).add("rowGroupIndex=" + this.rowGroupIndex).add("path=" + String.valueOf(this.path)).add("tableInfo=" + String.valueOf(this.tableInfo)).add("metadataInfo=" + String.valueOf(this.metadataInfo)).add("schema=" + String.valueOf(this.schema)).add("columnsStatistics=" + String.valueOf(this.columnsStatistics)).add("metadataStatistics=" + String.valueOf(this.metadataStatistics)).add("lastModifiedTime=" + this.lastModifiedTime).toString();
    }

    @Override
    protected void toMetadataUnitBuilder(TableMetadataUnit.Builder builder) {
        builder.hostAffinity(this.hostAffinity);
        builder.rowGroupIndex(this.rowGroupIndex);
        builder.path(this.path.toUri().getPath());
        builder.location(this.getLocation().toUri().getPath());
    }

    public RowGroupMetadataBuilder toBuilder() {
        return ((RowGroupMetadataBuilder)((RowGroupMetadataBuilder)((RowGroupMetadataBuilder)((RowGroupMetadataBuilder)((RowGroupMetadataBuilder)((RowGroupMetadataBuilder)RowGroupMetadata.builder().tableInfo(this.tableInfo)).metadataInfo(this.metadataInfo)).schema(this.schema)).columnsStatistics(this.columnsStatistics)).metadataStatistics(this.metadataStatistics.values())).lastModifiedTime(this.lastModifiedTime)).hostAffinity(this.hostAffinity).rowGroupIndex(this.rowGroupIndex).path(this.path);
    }

    public static RowGroupMetadataBuilder builder() {
        return new RowGroupMetadataBuilder();
    }

    public static class RowGroupMetadataBuilder
    extends BaseMetadata.BaseMetadataBuilder<RowGroupMetadataBuilder> {
        private Map<String, Float> hostAffinity;
        private Integer rowGroupIndex;
        private Path path;

        public RowGroupMetadataBuilder hostAffinity(Map<String, Float> hostAffinity) {
            this.hostAffinity = hostAffinity;
            return this.self();
        }

        public RowGroupMetadataBuilder rowGroupIndex(int rowGroupIndex) {
            this.rowGroupIndex = rowGroupIndex;
            return this.self();
        }

        public RowGroupMetadataBuilder path(Path path) {
            this.path = path;
            return this.self();
        }

        @Override
        protected void checkRequiredValues() {
            super.checkRequiredValues();
            Objects.requireNonNull(this.rowGroupIndex, "rowGroupIndex was not set");
            Objects.requireNonNull(this.hostAffinity, "hostAffinity was not set");
            Objects.requireNonNull(this.path, "path was not set");
        }

        @Override
        public RowGroupMetadata build() {
            this.checkRequiredValues();
            return new RowGroupMetadata(this);
        }

        @Override
        protected RowGroupMetadataBuilder self() {
            return this;
        }

        @Override
        protected RowGroupMetadataBuilder metadataUnitInternal(TableMetadataUnit unit) {
            this.hostAffinity(unit.hostAffinity());
            this.rowGroupIndex(unit.rowGroupIndex());
            if (unit.path() != null) {
                this.path(new Path(unit.path()));
            }
            return this.self();
        }
    }
}

