/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo.plan;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.exec.store.mongo.common.MongoOp;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;

class RexToMongoTranslator
extends RexVisitorImpl<BsonValue> {
    private final JavaTypeFactory typeFactory;
    private final List<String> inFields;
    private static final Map<SqlOperator, String> MONGO_OPERATORS = ImmutableMap.builder().put((Object)SqlStdOperatorTable.DIVIDE, (Object)"$divide").put((Object)SqlStdOperatorTable.MULTIPLY, (Object)"$multiply").put((Object)SqlStdOperatorTable.ABS, (Object)"$abs").put((Object)SqlStdOperatorTable.ACOS, (Object)"$acos").put((Object)SqlStdOperatorTable.ASIN, (Object)"$asin").put((Object)SqlStdOperatorTable.ATAN, (Object)"$atan").put((Object)SqlStdOperatorTable.ATAN2, (Object)"$atan2").put((Object)SqlStdOperatorTable.CEIL, (Object)"$ceil").put((Object)SqlStdOperatorTable.CONCAT, (Object)"$concat").put((Object)SqlStdOperatorTable.COS, (Object)"$cos").put((Object)SqlStdOperatorTable.DAYOFMONTH, (Object)"$dayOfMonth").put((Object)SqlStdOperatorTable.WEEK, (Object)"$isoWeek").put((Object)SqlStdOperatorTable.YEAR, (Object)"$isoWeekYear").put((Object)SqlStdOperatorTable.DAYOFWEEK, (Object)"$isoDayOfWeek").put((Object)SqlStdOperatorTable.DAYOFYEAR, (Object)"$dayOfYear").put((Object)SqlStdOperatorTable.RADIANS, (Object)"$degreesToRadians").put((Object)SqlStdOperatorTable.DENSE_RANK, (Object)"$denseRank").put((Object)SqlStdOperatorTable.EXP, (Object)"$exp").put((Object)SqlStdOperatorTable.FLOOR, (Object)"$floor").put((Object)SqlStdOperatorTable.HOUR, (Object)"$hour").put((Object)SqlStdOperatorTable.LN, (Object)"$ln").put((Object)SqlStdOperatorTable.LOG10, (Object)"$log10").put((Object)SqlStdOperatorTable.MINUTE, (Object)"$minute").put((Object)SqlStdOperatorTable.MOD, (Object)"$mod").put((Object)SqlStdOperatorTable.MONTH, (Object)"$month").put((Object)SqlStdOperatorTable.POWER, (Object)"$pow").put((Object)SqlStdOperatorTable.DEGREES, (Object)"$radiansToDegrees").put((Object)SqlStdOperatorTable.RAND, (Object)"$rand").put((Object)SqlStdOperatorTable.REPLACE, (Object)"$replaceAll").put((Object)SqlStdOperatorTable.ROUND, (Object)"$round").put((Object)SqlStdOperatorTable.SECOND, (Object)"$second").put((Object)SqlStdOperatorTable.SIN, (Object)"$sin").put((Object)SqlStdOperatorTable.SQRT, (Object)"$sqrt").put((Object)SqlStdOperatorTable.SUBSTRING, (Object)"$substr").put((Object)SqlStdOperatorTable.PLUS, (Object)"$add").put((Object)SqlStdOperatorTable.MINUS, (Object)"$subtract").put((Object)SqlStdOperatorTable.TAN, (Object)"$tan").put((Object)SqlStdOperatorTable.TRIM, (Object)"trim").put((Object)SqlStdOperatorTable.TRUNCATE, (Object)"$trunc").put((Object)SqlStdOperatorTable.AND, (Object)MongoOp.AND.getCompareOp()).put((Object)SqlStdOperatorTable.OR, (Object)MongoOp.OR.getCompareOp()).put((Object)SqlStdOperatorTable.NOT, (Object)MongoOp.NOT.getCompareOp()).put((Object)SqlStdOperatorTable.EQUALS, (Object)MongoOp.EQUAL.getCompareOp()).put((Object)SqlStdOperatorTable.NOT_EQUALS, (Object)MongoOp.NOT_EQUAL.getCompareOp()).put((Object)SqlStdOperatorTable.GREATER_THAN, (Object)MongoOp.GREATER.getCompareOp()).put((Object)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Object)MongoOp.GREATER_OR_EQUAL.getCompareOp()).put((Object)SqlStdOperatorTable.LESS_THAN, (Object)MongoOp.LESS.getCompareOp()).put((Object)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Object)MongoOp.LESS_OR_EQUAL.getCompareOp()).build();

    protected RexToMongoTranslator(JavaTypeFactory typeFactory, List<String> inFields) {
        super(true);
        this.typeFactory = typeFactory;
        this.inFields = inFields;
    }

    public BsonValue visitLiteral(RexLiteral literal) {
        if (literal.getValue() == null) {
            return BsonNull.VALUE;
        }
        return BsonDocument.parse((String)String.format("{$literal: %s}", RexToLixTranslator.translateLiteral((RexLiteral)literal, (RelDataType)literal.getType(), (JavaTypeFactory)this.typeFactory, (RexImpTable.NullAs)RexImpTable.NullAs.NOT_POSSIBLE)));
    }

    public BsonValue visitInputRef(RexInputRef inputRef) {
        return new BsonString("$" + this.inFields.get(inputRef.getIndex()));
    }

    public BsonValue visitCall(RexCall call) {
        BsonDocument result;
        RexNode op1;
        String name = RexToMongoTranslator.isItem(call);
        if (name != null) {
            return new BsonString("'$" + name + "'");
        }
        List strings = call.operands.stream().map(operand -> (BsonValue)operand.accept((RexVisitor)this)).collect(Collectors.toList());
        if (call.getKind() == SqlKind.CAST) {
            return (BsonValue)strings.get(0);
        }
        SqlOperator sqlOperator = call.getOperator();
        String stdOperator = MONGO_OPERATORS.get(sqlOperator);
        if (stdOperator != null) {
            return new BsonDocument(stdOperator, (BsonValue)new BsonArray(strings));
        }
        if (sqlOperator == SqlStdOperatorTable.ITEM && (op1 = (RexNode)call.operands.get(1)) instanceof RexLiteral) {
            if (op1.getType().getSqlTypeName() == SqlTypeName.INTEGER) {
                return new BsonDocument("$arrayElemAt", (BsonValue)new BsonArray(Arrays.asList((BsonValue)strings.get(0), new BsonInt32(((Integer)((RexLiteral)op1).getValueAs(Integer.class)).intValue()))));
            }
            if (op1.getType().getSqlTypeName() == SqlTypeName.CHAR) {
                return new BsonString(((BsonValue)strings.get(0)).asString().getValue() + "." + (String)((RexLiteral)op1).getValueAs(String.class));
            }
        }
        if (sqlOperator == SqlStdOperatorTable.CASE) {
            result = new BsonDocument();
            BsonArray args = new BsonArray();
            result.put("$cond", (BsonValue)args);
            for (int i = 0; i < strings.size(); i += 2) {
                args.add((BsonValue)strings.get(i));
                args.add((BsonValue)strings.get(i + 1));
                if (i == strings.size() - 3) {
                    args.add((BsonValue)strings.get(i + 2));
                    break;
                }
                if (i == strings.size() - 2) {
                    args.add((BsonValue)BsonNull.VALUE);
                    break;
                }
                BsonArray innerArgs = new BsonArray();
                BsonDocument innerDocument = new BsonDocument();
                innerDocument.put("$cond", (BsonValue)innerArgs);
                args.add((BsonValue)innerDocument);
                args = innerArgs;
            }
            return result;
        }
        if (sqlOperator == SqlStdOperatorTable.IS_NULL) {
            result = new BsonDocument();
            BsonArray args = new BsonArray();
            args.add((BsonValue)strings.get(0));
            args.add((BsonValue)BsonNull.VALUE);
            result.put(MongoOp.EQUAL.getCompareOp(), (BsonValue)args);
            return result;
        }
        if (sqlOperator == SqlStdOperatorTable.IS_NOT_NULL) {
            result = new BsonDocument();
            BsonArray args = new BsonArray();
            args.add((BsonValue)strings.get(0));
            args.add((BsonValue)BsonNull.VALUE);
            result.put(MongoOp.NOT_EQUAL.getCompareOp(), (BsonValue)args);
            return result;
        }
        throw new IllegalArgumentException("Translation of " + String.valueOf(call) + " is not supported by MongoProject");
    }

    public static String isItem(RexCall call) {
        if (call.getOperator() != SqlStdOperatorTable.ITEM) {
            return null;
        }
        RexNode op0 = (RexNode)call.operands.get(0);
        RexNode op1 = (RexNode)call.operands.get(1);
        if (op0 instanceof RexInputRef && ((RexInputRef)op0).getIndex() == 0 && op1 instanceof RexLiteral && ((RexLiteral)op1).getValue2() instanceof String) {
            return (String)((RexLiteral)op1).getValue2();
        }
        return null;
    }

    public static boolean supportsExpression(RexNode expr) {
        return (Boolean)expr.accept((RexVisitor)new RexMongoChecker());
    }

    private static class RexMongoChecker
    extends RexVisitorImpl<Boolean> {
        protected RexMongoChecker() {
            super(true);
        }

        public Boolean visitLiteral(RexLiteral literal) {
            return true;
        }

        public Boolean visitInputRef(RexInputRef inputRef) {
            return inputRef.getType().getSqlTypeName() != SqlTypeName.DYNAMIC_STAR;
        }

        public Boolean visitCall(RexCall call) {
            if (RexToMongoTranslator.isItem(call) != null || call.getKind() == SqlKind.CAST || call.getOperator() == SqlStdOperatorTable.CASE || MONGO_OPERATORS.get(call.getOperator()) != null) {
                return true;
            }
            if (call.getOperator() == SqlStdOperatorTable.ITEM) {
                RexNode op = (RexNode)call.operands.get(1);
                return op instanceof RexLiteral && (op.getType().getSqlTypeName() == SqlTypeName.INTEGER || op.getType().getSqlTypeName() == SqlTypeName.CHAR);
            }
            return false;
        }
    }
}

