/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.AbstractBase;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.hive.HivePartition;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveStoragePlugin;
import org.apache.drill.exec.store.hive.HiveStoragePluginConfig;
import org.apache.drill.exec.store.hive.HiveTableWithColumnCache;
import org.apache.drill.exec.store.hive.HiveUtilities;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.mapred.InputSplit;

@JsonTypeName(value="hive-sub-scan")
public class HiveSubScan
extends AbstractBase
implements SubScan {
    public static final String OPERATOR_TYPE = "HIVE_SUB_SCAN";
    private final HiveReadEntry hiveReadEntry;
    private final List<List<InputSplit>> inputSplits = new ArrayList<List<InputSplit>>();
    private final HiveStoragePlugin hiveStoragePlugin;
    private final List<List<String>> splits;
    private final List<String> splitClasses;
    private final HiveTableWithColumnCache table;
    private final List<HivePartition> partitions;
    private final List<SchemaPath> columns;
    private final Map<String, String> confProperties;

    @JsonCreator
    public HiveSubScan(@JacksonInject StoragePluginRegistry registry, @JsonProperty(value="userName") String userName, @JsonProperty(value="splits") List<List<String>> splits, @JsonProperty(value="hiveReadEntry") HiveReadEntry hiveReadEntry, @JsonProperty(value="splitClasses") List<String> splitClasses, @JsonProperty(value="columns") List<SchemaPath> columns, @JsonProperty(value="hiveStoragePluginConfig") HiveStoragePluginConfig hiveStoragePluginConfig, @JsonProperty(value="confProperties") Map<String, String> confProperties) throws IOException, ExecutionSetupException, ReflectiveOperationException {
        this(userName, splits, hiveReadEntry, splitClasses, columns, (HiveStoragePlugin)registry.resolve((StoragePluginConfig)hiveStoragePluginConfig, HiveStoragePlugin.class), confProperties);
    }

    public HiveSubScan(String userName, List<List<String>> splits, HiveReadEntry hiveReadEntry, List<String> splitClasses, List<SchemaPath> columns, HiveStoragePlugin hiveStoragePlugin, Map<String, String> confProperties) throws IOException, ReflectiveOperationException {
        super(userName);
        this.hiveReadEntry = hiveReadEntry;
        this.table = hiveReadEntry.getTable();
        this.partitions = hiveReadEntry.getPartitions();
        this.splits = splits;
        this.splitClasses = splitClasses;
        this.columns = columns;
        this.hiveStoragePlugin = hiveStoragePlugin;
        this.confProperties = confProperties;
        for (int i = 0; i < splits.size(); ++i) {
            this.inputSplits.add(HiveSubScan.deserializeInputSplit(splits.get(i), splitClasses.get(i)));
        }
    }

    @JsonProperty
    public List<List<String>> getSplits() {
        return this.splits;
    }

    @JsonProperty
    public HiveReadEntry getHiveReadEntry() {
        return this.hiveReadEntry;
    }

    @JsonProperty
    public List<String> getSplitClasses() {
        return this.splitClasses;
    }

    @JsonProperty
    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public HiveStoragePluginConfig getHiveStoragePluginConfig() {
        return this.hiveStoragePlugin.getConfig();
    }

    @JsonProperty
    public Map<String, String> getConfProperties() {
        return this.confProperties;
    }

    @JsonIgnore
    public HiveTableWithColumnCache getTable() {
        return this.table;
    }

    @JsonIgnore
    public List<HivePartition> getPartitions() {
        return this.partitions;
    }

    @JsonIgnore
    public List<List<InputSplit>> getInputSplits() {
        return this.inputSplits;
    }

    @JsonIgnore
    public HiveStoragePlugin getStoragePlugin() {
        return this.hiveStoragePlugin;
    }

    @JsonIgnore
    public HiveConf getHiveConf() {
        return HiveUtilities.generateHiveConf(this.hiveStoragePlugin.getHiveConf(), this.confProperties);
    }

    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return (T)physicalVisitor.visitSubScan((SubScan)this, value);
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) throws ExecutionSetupException {
        try {
            return new HiveSubScan(this.getUserName(), this.splits, this.hiveReadEntry, this.splitClasses, this.columns, this.hiveStoragePlugin, this.confProperties);
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new ExecutionSetupException((Throwable)e);
        }
    }

    public Iterator<PhysicalOperator> iterator() {
        return ImmutableSet.of().iterator();
    }

    public String getOperatorType() {
        return OPERATOR_TYPE;
    }

    private static List<InputSplit> deserializeInputSplit(List<String> base64, String className) throws IOException, ReflectiveOperationException {
        Constructor<?> constructor = Class.forName(className).getDeclaredConstructor(new Class[0]);
        if (constructor == null) {
            throw new ReflectiveOperationException("Class " + className + " does not implement a default constructor.");
        }
        constructor.setAccessible(true);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        for (String str : base64) {
            InputSplit split = (InputSplit)constructor.newInstance(new Object[0]);
            ByteArrayDataInput byteArrayDataInput = ByteStreams.newDataInput((byte[])Base64.decodeBase64((String)str));
            split.readFields((DataInput)byteArrayDataInput);
            splits.add(split);
        }
        return splits;
    }
}

