/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.CommittedDatatype;
import io.jhdf.GroupImpl;
import io.jhdf.ObjectHeader;
import io.jhdf.Superblock;
import io.jhdf.SymbolTableEntry;
import io.jhdf.api.Attribute;
import io.jhdf.api.Dataset;
import io.jhdf.api.Group;
import io.jhdf.api.Node;
import io.jhdf.api.NodeType;
import io.jhdf.dataset.DatasetLoader;
import io.jhdf.dataset.NoParent;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.InMemoryHdfException;
import io.jhdf.object.message.DataSpaceMessage;
import io.jhdf.object.message.DataTypeMessage;
import io.jhdf.storage.HdfBackingStorage;
import io.jhdf.storage.HdfFileChannel;
import io.jhdf.storage.HdfInMemoryByteBuffer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfFile
implements Group,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(HdfFile.class);
    private final Optional<Path> optionalFile;
    private final HdfBackingStorage hdfBackingStorage;
    private final Group rootGroup;
    private final Set<HdfFile> openExternalFiles;

    public HdfFile(File file) {
        this(file.toPath());
    }

    public HdfFile(URI uri) {
        this(Paths.get(uri));
    }

    public static HdfFile fromBytes(byte[] bytes) {
        logger.info("Reading HDF5 file from byte[]");
        return HdfFile.fromByteBuffer(ByteBuffer.wrap(bytes));
    }

    public static HdfFile fromByteBuffer(ByteBuffer byteBuffer) {
        logger.info("Reading HDF5 file from ByteBuffer");
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        boolean validSignature = false;
        int offset = 0;
        while (offset < byteBuffer.capacity()) {
            logger.trace("Checking for signature at offset = {}", (Object)offset);
            validSignature = Superblock.verifySignature(byteBuffer, offset);
            if (validSignature) {
                logger.debug("Found valid signature at offset = {}", (Object)offset);
                break;
            }
            offset = Math.toIntExact(HdfFile.nextOffset(offset));
        }
        if (!validSignature) {
            throw new HdfException("No valid HDF5 signature found");
        }
        byteBuffer.position(offset);
        Superblock superblock = Superblock.readSuperblock(byteBuffer);
        if (superblock.getBaseAddressByte() != (long)offset) {
            throw new HdfException("Invalid superblock base address detected");
        }
        HdfInMemoryByteBuffer hdfBackingStorage = new HdfInMemoryByteBuffer(byteBuffer, superblock);
        return new HdfFile(hdfBackingStorage);
    }

    private HdfFile(HdfBackingStorage hdfBackingStorage) {
        this.openExternalFiles = new HashSet<HdfFile>();
        this.hdfBackingStorage = hdfBackingStorage;
        this.optionalFile = Optional.empty();
        Superblock superblock = hdfBackingStorage.getSuperblock();
        if (superblock instanceof Superblock.SuperblockV0V1) {
            Superblock.SuperblockV0V1 sb = (Superblock.SuperblockV0V1)superblock;
            SymbolTableEntry ste = new SymbolTableEntry(hdfBackingStorage, sb.getRootGroupSymbolTableAddress() - sb.getBaseAddressByte());
            this.rootGroup = GroupImpl.createRootGroup(hdfBackingStorage, ste.getObjectHeaderAddress(), this);
        } else if (superblock instanceof Superblock.SuperblockV2V3) {
            Superblock.SuperblockV2V3 sb = (Superblock.SuperblockV2V3)superblock;
            this.rootGroup = GroupImpl.createRootGroup(hdfBackingStorage, sb.getRootGroupObjectHeaderAddress(), this);
        } else {
            throw new HdfException("Unrecognized superblock version = " + superblock.getVersionOfSuperblock());
        }
    }

    public static HdfFile fromInputStream(InputStream inputStream) {
        try {
            Path tempFile = Files.createTempFile(null, "-stream.hdf5", new FileAttribute[0]);
            logger.info("Creating temp file [{}]", (Object)tempFile.toAbsolutePath());
            tempFile.toFile().deleteOnExit();
            Files.copy(inputStream, tempFile, StandardCopyOption.REPLACE_EXISTING);
            logger.debug("Read stream to temp file [{}]", (Object)tempFile.toAbsolutePath());
            return new HdfFile(tempFile);
        }
        catch (IOException e) {
            throw new HdfException("Failed to open input stream", e);
        }
    }

    public HdfFile(Path hdfFile) {
        Path absoluteFile;
        block8: {
            this.openExternalFiles = new HashSet<HdfFile>();
            absoluteFile = hdfFile.toAbsolutePath();
            logger.info("Opening HDF5 file '{}'...", (Object)absoluteFile);
            this.optionalFile = Optional.of(hdfFile);
            try {
                FileChannel fc = FileChannel.open(hdfFile, StandardOpenOption.READ);
                boolean validSignature = false;
                long offset = 0L;
                while (offset < fc.size()) {
                    logger.trace("Checking for signature at offset = {}", (Object)offset);
                    validSignature = Superblock.verifySignature(fc, offset);
                    if (validSignature) {
                        logger.debug("Found valid signature at offset = {}", (Object)offset);
                        break;
                    }
                    offset = HdfFile.nextOffset(offset);
                }
                if (!validSignature) {
                    throw new HdfException("No valid HDF5 signature found");
                }
                Superblock superblock = Superblock.readSuperblock(fc, offset);
                if (superblock.getBaseAddressByte() != offset) {
                    throw new HdfException("Invalid superblock base address detected");
                }
                this.hdfBackingStorage = new HdfFileChannel(fc, superblock);
                if (superblock instanceof Superblock.SuperblockV0V1) {
                    Superblock.SuperblockV0V1 sb = (Superblock.SuperblockV0V1)superblock;
                    SymbolTableEntry ste = new SymbolTableEntry(this.hdfBackingStorage, sb.getRootGroupSymbolTableAddress() - sb.getBaseAddressByte());
                    this.rootGroup = GroupImpl.createRootGroup(this.hdfBackingStorage, ste.getObjectHeaderAddress(), this);
                    break block8;
                }
                if (superblock instanceof Superblock.SuperblockV2V3) {
                    Superblock.SuperblockV2V3 sb = (Superblock.SuperblockV2V3)superblock;
                    this.rootGroup = GroupImpl.createRootGroup(this.hdfBackingStorage, sb.getRootGroupObjectHeaderAddress(), this);
                    break block8;
                }
                throw new HdfException("Unrecognized superblock version = " + superblock.getVersionOfSuperblock());
            }
            catch (IOException e) {
                throw new HdfException("Failed to open file '" + absoluteFile + "' . Is it a HDF5 file?", e);
            }
        }
        logger.info("Opened HDF5 file '{}'", (Object)absoluteFile);
    }

    private static long nextOffset(long offset) {
        if (offset == 0L) {
            return 512L;
        }
        return offset * 2L;
    }

    public long getUserBlockSize() {
        return this.hdfBackingStorage.getUserBlockSize();
    }

    public ByteBuffer getUserBlockBuffer() {
        return this.hdfBackingStorage.mapNoOffset(0L, this.hdfBackingStorage.getUserBlockSize());
    }

    @Override
    public void close() {
        if (!this.inMemory()) {
            for (HdfFile externalHdfFile : this.openExternalFiles) {
                externalHdfFile.close();
                logger.info("Closed external file '{}'", (Object)externalHdfFile.getFileAsPath().toAbsolutePath());
            }
            this.hdfBackingStorage.close();
            logger.info("Closed HDF file '{}'", (Object)this.getFileAsPath().toAbsolutePath());
        }
    }

    public long size() {
        return this.hdfBackingStorage.size();
    }

    @Override
    public boolean isGroup() {
        return true;
    }

    @Override
    public Map<String, Node> getChildren() {
        return this.rootGroup.getChildren();
    }

    @Override
    public String getName() {
        return this.optionalFile.map(Path::getFileName).map(Path::toString).orElse("In-Memory no backing file");
    }

    @Override
    public String getPath() {
        return "/";
    }

    @Override
    public Map<String, Attribute> getAttributes() {
        return this.rootGroup.getAttributes();
    }

    @Override
    public Attribute getAttribute(String name) {
        return this.rootGroup.getAttribute(name);
    }

    public String toString() {
        return "HdfFile [file=" + this.getName() + "]";
    }

    @Override
    public NodeType getType() {
        return NodeType.FILE;
    }

    @Override
    public Group getParent() {
        return null;
    }

    @Override
    public File getFile() {
        Path fileAsPath = this.getFileAsPath();
        return fileAsPath.getFileSystem() == FileSystems.getDefault() ? fileAsPath.toFile() : null;
    }

    @Override
    public Path getFileAsPath() {
        return this.optionalFile.orElseThrow(() -> new HdfException("No backing file. In-memory"));
    }

    @Override
    public long getAddress() {
        return this.rootGroup.getAddress();
    }

    @Override
    public Iterator<Node> iterator() {
        return this.rootGroup.iterator();
    }

    @Override
    public Node getChild(String name) {
        return this.rootGroup.getChild(name);
    }

    @Override
    public Node getByPath(String path) {
        path = StringUtils.stripStart((String)path, (String)"/");
        return this.rootGroup.getByPath(path);
    }

    @Override
    public Dataset getDatasetByPath(String path) {
        path = StringUtils.stripStart((String)path, (String)"/");
        return this.rootGroup.getDatasetByPath(path);
    }

    @Override
    public HdfFile getHdfFile() {
        return this;
    }

    public void addExternalFile(HdfFile hdfFile) {
        if (this.inMemory()) {
            throw new InMemoryHdfException();
        }
        this.openExternalFiles.add(hdfFile);
    }

    @Override
    public boolean isLink() {
        return false;
    }

    @Override
    public boolean isAttributeCreationOrderTracked() {
        return this.rootGroup.isAttributeCreationOrderTracked();
    }

    @Override
    public boolean isLinkCreationOrderTracked() {
        return this.rootGroup.isLinkCreationOrderTracked();
    }

    public HdfBackingStorage getHdfBackingStorage() {
        return this.hdfBackingStorage;
    }

    public boolean inMemory() {
        return this.hdfBackingStorage.inMemory();
    }

    public Node getNodeByAddress(long address) {
        Node node;
        ObjectHeader objectHeader = ObjectHeader.readObjectHeader(this.hdfBackingStorage, address);
        String name = "__ADDRESS__" + address;
        if (objectHeader.hasMessageOfType(DataSpaceMessage.class)) {
            logger.trace("Creating dataset [{}]", (Object)name);
            node = DatasetLoader.createDataset(this.hdfBackingStorage, objectHeader, name, NoParent.INSTANCE);
        } else if (objectHeader.hasMessageOfType(DataTypeMessage.class)) {
            logger.trace("Creating committed data type [{}]", (Object)name);
            node = new CommittedDatatype(this.hdfBackingStorage, address, name, NoParent.INSTANCE);
        } else {
            logger.trace("Creating group [{}]", (Object)name);
            node = GroupImpl.createGroup(this.hdfBackingStorage, address, name, NoParent.INSTANCE);
        }
        return node;
    }

    static {
        String versionStr = HdfFile.class.getPackage().getImplementationVersion();
        if (versionStr != null) {
            logger.info("jHDF version: {}", (Object)HdfFile.class.getPackage().getImplementationVersion());
        } else {
            logger.warn("Using development version of jHDF");
        }
    }
}

