/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset;

import io.jhdf.object.datatype.DataType;
import io.jhdf.storage.HdfBackingStorage;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;

public final class DatasetReader {
    private DatasetReader() {
        throw new AssertionError((Object)"No instances of DatasetReader");
    }

    public static Object readDataset(DataType type, ByteBuffer buffer, int[] dimensions, HdfBackingStorage hdfBackingStorage) {
        boolean isScalar;
        if (dimensions.length == 0) {
            isScalar = true;
            dimensions = new int[]{1};
        } else {
            isScalar = false;
        }
        Object data = type.fillData(buffer, dimensions, hdfBackingStorage);
        if (isScalar && data.getClass().isArray()) {
            return Array.get(data, 0);
        }
        return data;
    }

    public static Object readDataset(DataType type, ByteBuffer buffer, int elements, HdfBackingStorage hdfBackingStorage) {
        return type.fillData(buffer, new int[]{elements}, hdfBackingStorage);
    }
}

