/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.RawCellBuilder;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.regionserver.OnlineRegions;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.phoenix.util.ServerUtil;

public class DelegateRegionCoprocessorEnvironment
implements RegionCoprocessorEnvironment {
    private final Configuration config;
    private RegionCoprocessorEnvironment delegate;
    private ServerUtil.ConnectionType connectionType;

    public DelegateRegionCoprocessorEnvironment(RegionCoprocessorEnvironment delegate, ServerUtil.ConnectionType connectionType) {
        this.delegate = delegate;
        this.connectionType = connectionType;
        this.config = ServerUtil.ConnectionFactory.getTypeSpecificConfiguration(connectionType, delegate.getConfiguration());
    }

    public int getVersion() {
        return this.delegate.getVersion();
    }

    public String getHBaseVersion() {
        return this.delegate.getHBaseVersion();
    }

    public int getPriority() {
        return this.delegate.getPriority();
    }

    public int getLoadSequence() {
        return this.delegate.getLoadSequence();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public ClassLoader getClassLoader() {
        return this.delegate.getClassLoader();
    }

    public Region getRegion() {
        return this.delegate.getRegion();
    }

    public RegionInfo getRegionInfo() {
        return this.delegate.getRegionInfo();
    }

    public ConcurrentMap<String, Object> getSharedData() {
        return this.delegate.getSharedData();
    }

    public RegionCoprocessor getInstance() {
        return (RegionCoprocessor)this.delegate.getInstance();
    }

    public OnlineRegions getOnlineRegions() {
        return this.delegate.getOnlineRegions();
    }

    public ServerName getServerName() {
        return this.delegate.getServerName();
    }

    public Connection getConnection() {
        return ServerUtil.ConnectionFactory.getConnection(this.connectionType, this.delegate);
    }

    public MetricRegistry getMetricRegistryForRegionServer() {
        return this.delegate.getMetricRegistryForRegionServer();
    }

    public Connection createConnection(Configuration conf) throws IOException {
        return this.delegate.createConnection(conf);
    }

    public RawCellBuilder getCellBuilder() {
        return this.delegate.getCellBuilder();
    }
}

