/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.protobuf.ByteString;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.ExtendedCellBuilder;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TagUtil;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.CoreCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcUtil;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.phoenix.cache.GlobalCache;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.coprocessor.AddColumnMutator;
import org.apache.phoenix.coprocessor.ColumnMutator;
import org.apache.phoenix.coprocessor.DropColumnMutator;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.coprocessor.PhoenixMetaDataCoprocessorHost;
import org.apache.phoenix.coprocessor.TableInfo;
import org.apache.phoenix.coprocessor.generated.MetaDataProtos;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.ProjectedColumnExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.visitor.StatelessTraverseAllExpressionVisitor;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.metrics.Metrics;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.PSchema;
import org.apache.phoenix.protobuf.ProtobufUtil;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PMetaDataEntity;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SequenceAllocation;
import org.apache.phoenix.schema.SequenceAlreadyExistsException;
import org.apache.phoenix.schema.SequenceKey;
import org.apache.phoenix.schema.SequenceNotFoundException;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.task.SystemTaskParams;
import org.apache.phoenix.schema.task.Task;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.cache.Cache;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.apache.phoenix.util.UpgradeUtil;
import org.apache.phoenix.util.ViewUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CoreCoprocessor
public class MetaDataEndpointImpl
extends MetaDataProtocol
implements RegionCoprocessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaDataEndpointImpl.class);
    public static final String ROW_KEY_ORDER_OPTIMIZABLE = "ROW_KEY_ORDER_OPTIMIZABLE";
    public static final byte[] ROW_KEY_ORDER_OPTIMIZABLE_BYTES = Bytes.toBytes((String)"ROW_KEY_ORDER_OPTIMIZABLE");
    private static final byte[] CHILD_TABLE_BYTES = new byte[]{PTable.LinkType.CHILD_TABLE.getSerializedValue()};
    private static final byte[] PHYSICAL_TABLE_BYTES = new byte[]{PTable.LinkType.PHYSICAL_TABLE.getSerializedValue()};
    private static final Cell TABLE_TYPE_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.TABLE_TYPE_BYTES);
    private static final Cell TABLE_SEQ_NUM_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.TABLE_SEQ_NUM_BYTES);
    private static final Cell COLUMN_COUNT_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.COLUMN_COUNT_BYTES);
    private static final Cell SALT_BUCKETS_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.SALT_BUCKETS_BYTES);
    private static final Cell PK_NAME_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.PK_NAME_BYTES);
    private static final Cell DATA_TABLE_NAME_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.DATA_TABLE_NAME_BYTES);
    private static final Cell INDEX_STATE_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.INDEX_STATE_BYTES);
    private static final Cell IMMUTABLE_ROWS_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.IMMUTABLE_ROWS_BYTES);
    private static final Cell VIEW_EXPRESSION_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.VIEW_STATEMENT_BYTES);
    private static final Cell DEFAULT_COLUMN_FAMILY_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.DEFAULT_COLUMN_FAMILY_NAME_BYTES);
    private static final Cell DISABLE_WAL_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.DISABLE_WAL_BYTES);
    private static final Cell MULTI_TENANT_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.MULTI_TENANT_BYTES);
    private static final Cell VIEW_TYPE_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.VIEW_TYPE_BYTES);
    private static final Cell VIEW_INDEX_ID_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.VIEW_INDEX_ID_BYTES);
    private static final Cell VIEW_INDEX_ID_DATA_TYPE_BYTES_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.VIEW_INDEX_ID_DATA_TYPE_BYTES);
    private static final Cell INDEX_TYPE_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.INDEX_TYPE_BYTES);
    private static final Cell INDEX_DISABLE_TIMESTAMP_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.INDEX_DISABLE_TIMESTAMP_BYTES);
    private static final Cell STORE_NULLS_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.STORE_NULLS_BYTES);
    private static final Cell EMPTY_KEYVALUE_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])QueryConstants.EMPTY_COLUMN_BYTES);
    private static final Cell BASE_COLUMN_COUNT_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.BASE_COLUMN_COUNT_BYTES);
    private static final Cell ROW_KEY_ORDER_OPTIMIZABLE_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])ROW_KEY_ORDER_OPTIMIZABLE_BYTES);
    private static final Cell TRANSACTIONAL_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.TRANSACTIONAL_BYTES);
    private static final Cell TRANSACTION_PROVIDER_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.TRANSACTION_PROVIDER_BYTES);
    private static final Cell UPDATE_CACHE_FREQUENCY_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.UPDATE_CACHE_FREQUENCY_BYTES);
    private static final Cell IS_NAMESPACE_MAPPED_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.IS_NAMESPACE_MAPPED_BYTES);
    private static final Cell AUTO_PARTITION_SEQ_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.AUTO_PARTITION_SEQ_BYTES);
    private static final Cell APPEND_ONLY_SCHEMA_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.APPEND_ONLY_SCHEMA_BYTES);
    private static final Cell STORAGE_SCHEME_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.STORAGE_SCHEME_BYTES);
    private static final Cell ENCODING_SCHEME_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.ENCODING_SCHEME_BYTES);
    private static final Cell USE_STATS_FOR_PARALLELIZATION_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.USE_STATS_FOR_PARALLELIZATION_BYTES);
    private static final Cell PHOENIX_TTL_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.PHOENIX_TTL_BYTES);
    private static final Cell PHOENIX_TTL_HWM_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.PHOENIX_TTL_HWM_BYTES);
    private static final Cell LAST_DDL_TIMESTAMP_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.LAST_DDL_TIMESTAMP_BYTES);
    private static final Cell CHANGE_DETECTION_ENABLED_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.CHANGE_DETECTION_ENABLED_BYTES);
    private static final List<Cell> TABLE_KV_COLUMNS = Lists.newArrayList((Object[])new Cell[]{EMPTY_KEYVALUE_KV, TABLE_TYPE_KV, TABLE_SEQ_NUM_KV, COLUMN_COUNT_KV, SALT_BUCKETS_KV, PK_NAME_KV, DATA_TABLE_NAME_KV, INDEX_STATE_KV, IMMUTABLE_ROWS_KV, VIEW_EXPRESSION_KV, DEFAULT_COLUMN_FAMILY_KV, DISABLE_WAL_KV, MULTI_TENANT_KV, VIEW_TYPE_KV, VIEW_INDEX_ID_KV, VIEW_INDEX_ID_DATA_TYPE_BYTES_KV, INDEX_TYPE_KV, INDEX_DISABLE_TIMESTAMP_KV, STORE_NULLS_KV, BASE_COLUMN_COUNT_KV, ROW_KEY_ORDER_OPTIMIZABLE_KV, TRANSACTIONAL_KV, TRANSACTION_PROVIDER_KV, UPDATE_CACHE_FREQUENCY_KV, IS_NAMESPACE_MAPPED_KV, AUTO_PARTITION_SEQ_KV, APPEND_ONLY_SCHEMA_KV, STORAGE_SCHEME_KV, ENCODING_SCHEME_KV, USE_STATS_FOR_PARALLELIZATION_KV, PHOENIX_TTL_KV, PHOENIX_TTL_HWM_KV, LAST_DDL_TIMESTAMP_KV, CHANGE_DETECTION_ENABLED_KV});
    private static final int TABLE_TYPE_INDEX;
    private static final int TABLE_SEQ_NUM_INDEX;
    private static final int COLUMN_COUNT_INDEX;
    private static final int SALT_BUCKETS_INDEX;
    private static final int PK_NAME_INDEX;
    private static final int DATA_TABLE_NAME_INDEX;
    private static final int INDEX_STATE_INDEX;
    private static final int IMMUTABLE_ROWS_INDEX;
    private static final int VIEW_STATEMENT_INDEX;
    private static final int DEFAULT_COLUMN_FAMILY_INDEX;
    private static final int DISABLE_WAL_INDEX;
    private static final int MULTI_TENANT_INDEX;
    private static final int VIEW_TYPE_INDEX;
    private static final int VIEW_INDEX_ID_DATA_TYPE_INDEX;
    private static final int VIEW_INDEX_ID_INDEX;
    private static final int INDEX_TYPE_INDEX;
    private static final int STORE_NULLS_INDEX;
    private static final int BASE_COLUMN_COUNT_INDEX;
    private static final int ROW_KEY_ORDER_OPTIMIZABLE_INDEX;
    private static final int TRANSACTIONAL_INDEX;
    private static final int TRANSACTION_PROVIDER_INDEX;
    private static final int UPDATE_CACHE_FREQUENCY_INDEX;
    private static final int INDEX_DISABLE_TIMESTAMP;
    private static final int IS_NAMESPACE_MAPPED_INDEX;
    private static final int AUTO_PARTITION_SEQ_INDEX;
    private static final int APPEND_ONLY_SCHEMA_INDEX;
    private static final int STORAGE_SCHEME_INDEX;
    private static final int QUALIFIER_ENCODING_SCHEME_INDEX;
    private static final int USE_STATS_FOR_PARALLELIZATION_INDEX;
    private static final int PHOENIX_TTL_INDEX;
    private static final int PHOENIX_TTL_HWM_INDEX;
    private static final int LAST_DDL_TIMESTAMP_INDEX;
    private static final int CHANGE_DETECTION_ENABLED_INDEX;
    private static final KeyValue DECIMAL_DIGITS_KV;
    private static final KeyValue COLUMN_SIZE_KV;
    private static final KeyValue NULLABLE_KV;
    private static final KeyValue DATA_TYPE_KV;
    private static final KeyValue ORDINAL_POSITION_KV;
    private static final KeyValue SORT_ORDER_KV;
    private static final KeyValue ARRAY_SIZE_KV;
    private static final KeyValue VIEW_CONSTANT_KV;
    private static final KeyValue IS_VIEW_REFERENCED_KV;
    private static final KeyValue COLUMN_DEF_KV;
    private static final KeyValue IS_ROW_TIMESTAMP_KV;
    private static final KeyValue COLUMN_QUALIFIER_KV;
    private static final KeyValue LINK_TYPE_KV;
    private static final List<Cell> COLUMN_KV_COLUMNS;
    private static final Cell QUALIFIER_COUNTER_KV;
    private static final int DECIMAL_DIGITS_INDEX;
    private static final int COLUMN_SIZE_INDEX;
    private static final int NULLABLE_INDEX;
    private static final int DATA_TYPE_INDEX;
    private static final int ORDINAL_POSITION_INDEX;
    private static final int SORT_ORDER_INDEX;
    private static final int ARRAY_SIZE_INDEX;
    private static final int VIEW_CONSTANT_INDEX;
    private static final int IS_VIEW_REFERENCED_INDEX;
    private static final int COLUMN_DEF_INDEX;
    private static final int IS_ROW_TIMESTAMP_INDEX;
    private static final int COLUMN_QUALIFIER_INDEX;
    private static final int EXCLUDED_COLUMN_LINK_TYPE_KV_INDEX;
    private static final int LINK_TYPE_INDEX = 0;
    public static final byte[] VIEW_MODIFIED_PROPERTY_BYTES;
    private static final Cell CLASS_NAME_KV;
    private static final Cell JAR_PATH_KV;
    private static final Cell RETURN_TYPE_KV;
    private static final Cell NUM_ARGS_KV;
    private static final Cell TYPE_KV;
    private static final Cell IS_CONSTANT_KV;
    private static final Cell DEFAULT_VALUE_KV;
    private static final Cell MIN_VALUE_KV;
    private static final Cell MAX_VALUE_KV;
    private static final Cell IS_ARRAY_KV;
    private static final List<Cell> FUNCTION_KV_COLUMNS;
    private static final int CLASS_NAME_INDEX;
    private static final int JAR_PATH_INDEX;
    private static final int RETURN_TYPE_INDEX;
    private static final int NUM_ARGS_INDEX;
    private static final List<Cell> FUNCTION_ARG_KV_COLUMNS;
    private static final int IS_ARRAY_INDEX;
    private static final int IS_CONSTANT_INDEX;
    private static final int DEFAULT_VALUE_INDEX;
    private static final int MIN_VALUE_INDEX;
    private static final int MAX_VALUE_INDEX;
    private static boolean failConcurrentMutateAddColumnOneTimeForTesting;
    private RegionCoprocessorEnvironment env;
    private PhoenixMetaDataCoprocessorHost phoenixAccessCoprocessorHost;
    private boolean accessCheckEnabled;
    private boolean blockWriteRebuildIndex;
    private int maxIndexesPerTable;
    private boolean isTablesMappingEnabled;
    private boolean allowSplittableSystemCatalogRollback;

    public static PName newPName(byte[] buffer) {
        return buffer == null ? null : MetaDataEndpointImpl.newPName(buffer, 0, buffer.length);
    }

    public static PName newPName(byte[] keyBuffer, int keyOffset, int keyLength) {
        if (keyLength <= 0) {
            return null;
        }
        int length = SchemaUtil.getVarCharLength(keyBuffer, keyOffset, keyLength);
        return PNameFactory.newName(keyBuffer, keyOffset, length);
    }

    public static void setFailConcurrentMutateAddColumnOneTimeForTesting(boolean fail) {
        failConcurrentMutateAddColumnOneTimeForTesting = fail;
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        if (!(env instanceof RegionCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on a table region!");
        }
        this.env = (RegionCoprocessorEnvironment)env;
        this.phoenixAccessCoprocessorHost = new PhoenixMetaDataCoprocessorHost(this.env);
        Configuration config = env.getConfiguration();
        this.accessCheckEnabled = config.getBoolean("phoenix.acls.enabled", false);
        this.blockWriteRebuildIndex = config.getBoolean("phoenix.index.failure.block.write", false);
        this.maxIndexesPerTable = config.getInt("phoenix.index.maxIndexesPerTable", 10);
        this.isTablesMappingEnabled = SchemaUtil.isNamespaceMappingEnabled(PTableType.TABLE, new ReadOnlyProps(config.iterator()));
        this.allowSplittableSystemCatalogRollback = config.getBoolean("phoenix.allow.system.catalog.rollback", false);
        LOGGER.info("Starting Tracing-Metrics Systems");
        Tracing.addTraceMetricsSource();
        Metrics.ensureConfigured();
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    public Iterable<Service> getServices() {
        return Collections.singleton(this);
    }

    @Override
    public void getTable(RpcController controller, MetaDataProtos.GetTableRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
        byte[] tenantId = request.getTenantId().toByteArray();
        byte[] schemaName = request.getSchemaName().toByteArray();
        byte[] tableName = request.getTableName().toByteArray();
        byte[] key = SchemaUtil.getTableKey(tenantId, schemaName, tableName);
        long tableTimeStamp = request.getTableTimestamp();
        try {
            Region region = this.env.getRegion();
            MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkTableKeyInRegion(key, region);
            if (result != null) {
                done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            long currentTime = EnvironmentEdgeManager.currentTimeMillis();
            PTable table = this.doGetTable(tenantId, schemaName, tableName, request.getClientTimestamp(), null, request.getClientVersion());
            if (table == null) {
                builder.setReturnCode(MetaDataProtos.MutationCode.TABLE_NOT_FOUND);
                builder.setMutationTime(currentTime);
                done.run((Object)builder.build());
                return;
            }
            this.getCoprocessorHost().preGetTable(Bytes.toString((byte[])tenantId), SchemaUtil.getTableName(schemaName, tableName), TableName.valueOf((byte[])table.getPhysicalName().getBytes()));
            if (request.getClientVersion() < MIN_SPLITTABLE_SYSTEM_CATALOG && table.getType() == PTableType.VIEW && table.getViewType() != PTable.ViewType.MAPPED) {
                try (PhoenixConnection connection = QueryUtil.getConnectionOnServer(this.env.getConfiguration()).unwrap(PhoenixConnection.class);){
                    PTable pTable = PhoenixRuntime.getTableNoCache(connection, table.getParentName().getString());
                    table = ViewUtil.addDerivedColumnsFromParent(connection, table, pTable);
                }
            }
            builder.setReturnCode(MetaDataProtos.MutationCode.TABLE_ALREADY_EXISTS);
            builder.setMutationTime(currentTime);
            if (this.blockWriteRebuildIndex) {
                long disableIndexTimestamp = table.getIndexDisableTimestamp();
                long minNonZerodisableIndexTimestamp = disableIndexTimestamp > 0L ? disableIndexTimestamp : Long.MAX_VALUE;
                for (PTable index : table.getIndexes()) {
                    disableIndexTimestamp = index.getIndexDisableTimestamp();
                    if (disableIndexTimestamp <= 0L || index.getIndexState() != PIndexState.ACTIVE && index.getIndexState() != PIndexState.PENDING_ACTIVE && index.getIndexState() != PIndexState.PENDING_DISABLE || disableIndexTimestamp >= minNonZerodisableIndexTimestamp) continue;
                    minNonZerodisableIndexTimestamp = disableIndexTimestamp;
                }
                if (minNonZerodisableIndexTimestamp != Long.MAX_VALUE) {
                    builder.setMutationTime(minNonZerodisableIndexTimestamp - 1L);
                }
            }
            if (table.getType() != PTableType.TABLE || table.getTimeStamp() != tableTimeStamp) {
                builder.setTable(PTableImpl.toProto(table));
            }
            done.run((Object)builder.build());
        }
        catch (Throwable t) {
            LOGGER.error("getTable failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(SchemaUtil.getTableName(schemaName, tableName), t));
        }
    }

    private PhoenixMetaDataCoprocessorHost getCoprocessorHost() {
        return this.phoenixAccessCoprocessorHost;
    }

    private PTable buildTable(byte[] key, ImmutableBytesPtr cacheKey, Region region, long clientTimeStamp, int clientVersion) throws IOException, SQLException {
        PTable newTable;
        Scan scan = MetaDataUtil.newTableRowsScan(key, 0L, clientTimeStamp);
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        try (RegionScanner scanner = region.getScanner(scan);){
            PTable oldTable = (PTable)metaDataCache.getIfPresent((Object)cacheKey);
            long tableTimeStamp = oldTable == null ? -1L : oldTable.getTimeStamp();
            newTable = this.getTable(scanner, clientTimeStamp, tableTimeStamp, clientVersion);
            if (newTable != null && (oldTable == null || tableTimeStamp < newTable.getTimeStamp() || this.blockWriteRebuildIndex && newTable.getIndexDisableTimestamp() > 0L)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Caching table " + Bytes.toStringBinary((byte[])cacheKey.get(), (int)cacheKey.getOffset(), (int)cacheKey.getLength()) + " at seqNum " + newTable.getSequenceNumber() + " with newer timestamp " + newTable.getTimeStamp() + " versus " + tableTimeStamp);
                }
                metaDataCache.put((Object)cacheKey, (Object)newTable);
            }
        }
        return newTable;
    }

    private List<PFunction> buildFunctions(List<byte[]> keys, Region region, long clientTimeStamp, boolean isReplace, List<Mutation> deleteMutationsForReplace) throws IOException, SQLException {
        ArrayList keyRanges = Lists.newArrayListWithExpectedSize((int)keys.size());
        for (byte[] key : keys) {
            byte[] stopKey = ByteUtil.concat(key, new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY});
            ByteUtil.nextKey(stopKey, stopKey.length);
            keyRanges.add(PVarbinary.INSTANCE.getKeyRange(key, true, stopKey, false));
        }
        Scan scan = new Scan();
        scan.setTimeRange(0L, clientTimeStamp);
        ScanRanges scanRanges = ScanRanges.createPointLookup(keyRanges);
        scanRanges.initializeScan(scan);
        scan.setFilter((Filter)scanRanges.getSkipScanFilter());
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        ArrayList<PFunction> functions = new ArrayList<PFunction>();
        PFunction function = null;
        try (RegionScanner scanner = region.getScanner(scan);){
            for (int i = 0; i < keys.size(); ++i) {
                function = null;
                function = this.getFunction(scanner, isReplace, clientTimeStamp, deleteMutationsForReplace);
                if (function == null) {
                    List<PFunction> list = null;
                    return list;
                }
                byte[] functionKey = SchemaUtil.getFunctionKey(function.getTenantId() == null ? ByteUtil.EMPTY_BYTE_ARRAY : function.getTenantId().getBytes(), Bytes.toBytes((String)function.getFunctionName()));
                metaDataCache.put((Object)new GlobalCache.FunctionBytesPtr(functionKey), (Object)function);
                functions.add(function);
            }
            ArrayList<PFunction> arrayList = functions;
            return arrayList;
        }
    }

    private List<PSchema> buildSchemas(List<byte[]> keys, Region region, long clientTimeStamp, ImmutableBytesPtr cacheKey) throws IOException, SQLException {
        ArrayList keyRanges = Lists.newArrayListWithExpectedSize((int)keys.size());
        for (byte[] key : keys) {
            byte[] stopKey = ByteUtil.concat(key, new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY});
            ByteUtil.nextKey(stopKey, stopKey.length);
            keyRanges.add(PVarbinary.INSTANCE.getKeyRange(key, true, stopKey, false));
        }
        Scan scan = new Scan();
        if (clientTimeStamp != Long.MAX_VALUE && clientTimeStamp != Long.MIN_VALUE) {
            scan.setTimeRange(0L, clientTimeStamp + 1L);
        } else {
            scan.setTimeRange(0L, clientTimeStamp);
        }
        ScanRanges scanRanges = ScanRanges.createPointLookup(keyRanges);
        scanRanges.initializeScan(scan);
        scan.setFilter((Filter)scanRanges.getSkipScanFilter());
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        ArrayList<PSchema> schemas = new ArrayList<PSchema>();
        PSchema schema = null;
        try (RegionScanner scanner = region.getScanner(scan);){
            for (int i = 0; i < keys.size(); ++i) {
                schema = null;
                schema = this.getSchema(scanner, clientTimeStamp);
                if (schema == null) {
                    List<PSchema> list = null;
                    return list;
                }
                metaDataCache.put((Object)cacheKey, (Object)schema);
                schemas.add(schema);
            }
            ArrayList<PSchema> arrayList = schemas;
            return arrayList;
        }
    }

    private void addIndexToTable(PName tenantId, PName schemaName, PName indexName, PName tableName, long clientTimeStamp, List<PTable> indexes, int clientVersion) throws IOException, SQLException {
        byte[] tenantIdBytes = tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantId.getBytes();
        PTable indexTable = this.doGetTable(tenantIdBytes, schemaName.getBytes(), indexName.getBytes(), clientTimeStamp, null, clientVersion);
        if (indexTable == null) {
            ServerUtil.throwIOException("Index not found", new TableNotFoundException(schemaName.getString(), indexName.getString()));
            return;
        }
        indexes.add(indexTable);
    }

    private void addExcludedColumnToTable(List<PColumn> pColumns, PName colName, PName famName, long timestamp) {
        PColumnImpl pColumn = PColumnImpl.createExcludedColumn(famName, colName, timestamp);
        pColumns.add(pColumn);
    }

    private void addColumnToTable(List<Cell> results, PName colName, PName famName, Cell[] colKeyValues, List<PColumn> columns, boolean isSalted, int baseColumnCount, boolean isRegularView) {
        Cell sortOrderKv;
        int i = 0;
        int j = 0;
        while (i < results.size() && j < COLUMN_KV_COLUMNS.size()) {
            Cell kv = results.get(i);
            Cell searchKv = COLUMN_KV_COLUMNS.get(j);
            int cmp = Bytes.compareTo((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength(), (byte[])searchKv.getQualifierArray(), (int)searchKv.getQualifierOffset(), (int)searchKv.getQualifierLength());
            if (cmp == 0) {
                colKeyValues[j++] = kv;
                ++i;
                continue;
            }
            if (cmp > 0) {
                colKeyValues[j++] = null;
                continue;
            }
            ++i;
        }
        if (colKeyValues[DATA_TYPE_INDEX] == null || colKeyValues[NULLABLE_INDEX] == null || colKeyValues[ORDINAL_POSITION_INDEX] == null) {
            throw new IllegalStateException("Didn't find all required key values in '" + colName.getString() + "' column metadata row");
        }
        Cell columnSizeKv = colKeyValues[COLUMN_SIZE_INDEX];
        Integer maxLength = columnSizeKv == null ? null : Integer.valueOf(PInteger.INSTANCE.getCodec().decodeInt(columnSizeKv.getValueArray(), columnSizeKv.getValueOffset(), SortOrder.getDefault()));
        Cell decimalDigitKv = colKeyValues[DECIMAL_DIGITS_INDEX];
        Integer scale = decimalDigitKv == null ? null : Integer.valueOf(PInteger.INSTANCE.getCodec().decodeInt(decimalDigitKv.getValueArray(), decimalDigitKv.getValueOffset(), SortOrder.getDefault()));
        Cell ordinalPositionKv = colKeyValues[ORDINAL_POSITION_INDEX];
        int position = PInteger.INSTANCE.getCodec().decodeInt(ordinalPositionKv.getValueArray(), ordinalPositionKv.getValueOffset(), SortOrder.getDefault()) + (isSalted ? 1 : 0);
        Cell excludedColumnKv = colKeyValues[EXCLUDED_COLUMN_LINK_TYPE_KV_INDEX];
        if (excludedColumnKv != null && colKeyValues[DATA_TYPE_INDEX].getTimestamp() <= excludedColumnKv.getTimestamp()) {
            PTable.LinkType linkType = PTable.LinkType.fromSerializedValue(excludedColumnKv.getValueArray()[excludedColumnKv.getValueOffset()]);
            if (linkType != PTable.LinkType.EXCLUDED_COLUMN) {
                throw new IllegalStateException("Link type should be EXCLUDED_COLUMN but found an unxpected link type for key value " + excludedColumnKv);
            }
            this.addExcludedColumnToTable(columns, colName, famName, excludedColumnKv.getTimestamp());
            return;
        }
        Cell nullableKv = colKeyValues[NULLABLE_INDEX];
        boolean isNullable = PInteger.INSTANCE.getCodec().decodeInt(nullableKv.getValueArray(), nullableKv.getValueOffset(), SortOrder.getDefault()) != 0;
        Cell dataTypeKv = colKeyValues[DATA_TYPE_INDEX];
        PDataType dataType = PDataType.fromTypeId(PInteger.INSTANCE.getCodec().decodeInt(dataTypeKv.getValueArray(), dataTypeKv.getValueOffset(), SortOrder.getDefault()));
        if (maxLength == null && dataType == PBinary.INSTANCE) {
            dataType = PVarbinary.INSTANCE;
        }
        SortOrder sortOrder = (sortOrderKv = colKeyValues[SORT_ORDER_INDEX]) == null ? SortOrder.getDefault() : SortOrder.fromSystemValue(PInteger.INSTANCE.getCodec().decodeInt(sortOrderKv.getValueArray(), sortOrderKv.getValueOffset(), SortOrder.getDefault()));
        Cell arraySizeKv = colKeyValues[ARRAY_SIZE_INDEX];
        Integer arraySize = arraySizeKv == null ? null : Integer.valueOf(PInteger.INSTANCE.getCodec().decodeInt(arraySizeKv.getValueArray(), arraySizeKv.getValueOffset(), SortOrder.getDefault()));
        Cell viewConstantKv = colKeyValues[VIEW_CONSTANT_INDEX];
        byte[] viewConstant = viewConstantKv == null ? null : new ImmutableBytesPtr(viewConstantKv.getValueArray(), viewConstantKv.getValueOffset(), viewConstantKv.getValueLength()).copyBytesIfNecessary();
        Cell isViewReferencedKv = colKeyValues[IS_VIEW_REFERENCED_INDEX];
        boolean isViewReferenced = isViewReferencedKv != null && Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(isViewReferencedKv.getValueArray(), isViewReferencedKv.getValueOffset(), isViewReferencedKv.getValueLength()));
        Cell columnDefKv = colKeyValues[COLUMN_DEF_INDEX];
        String expressionStr = columnDefKv == null ? null : (String)PVarchar.INSTANCE.toObject(columnDefKv.getValueArray(), columnDefKv.getValueOffset(), columnDefKv.getValueLength());
        Cell isRowTimestampKV = colKeyValues[IS_ROW_TIMESTAMP_INDEX];
        boolean isRowTimestamp = isRowTimestampKV == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(isRowTimestampKV.getValueArray(), isRowTimestampKV.getValueOffset(), isRowTimestampKV.getValueLength()));
        boolean isPkColumn = famName == null || famName.getString() == null;
        Cell columnQualifierKV = colKeyValues[COLUMN_QUALIFIER_INDEX];
        byte[] columnQualifierBytes = columnQualifierKV != null ? Arrays.copyOfRange(columnQualifierKV.getValueArray(), columnQualifierKV.getValueOffset(), columnQualifierKV.getValueOffset() + columnQualifierKV.getValueLength()) : (isPkColumn ? null : colName.getBytes());
        PColumnImpl column = new PColumnImpl(colName, famName, dataType, maxLength, scale, isNullable, position - 1, sortOrder, arraySize, viewConstant, isViewReferenced, expressionStr, isRowTimestamp, false, columnQualifierBytes, results.get(0).getTimestamp());
        columns.add(column);
    }

    private void addArgumentToFunction(List<Cell> results, PName functionName, PName type, Cell[] functionKeyValues, List<PFunction.FunctionArgument> arguments, short argPosition) throws SQLException {
        int i = 0;
        int j = 0;
        while (i < results.size() && j < FUNCTION_ARG_KV_COLUMNS.size()) {
            Cell kv = results.get(i);
            Cell searchKv = FUNCTION_ARG_KV_COLUMNS.get(j);
            int cmp = Bytes.compareTo((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength(), (byte[])searchKv.getQualifierArray(), (int)searchKv.getQualifierOffset(), (int)searchKv.getQualifierLength());
            if (cmp == 0) {
                functionKeyValues[j++] = kv;
                ++i;
                continue;
            }
            if (cmp > 0) {
                functionKeyValues[j++] = null;
                continue;
            }
            ++i;
        }
        Cell isArrayKv = functionKeyValues[IS_ARRAY_INDEX];
        boolean isArrayType = isArrayKv == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(isArrayKv.getValueArray(), isArrayKv.getValueOffset(), isArrayKv.getValueLength()));
        Cell isConstantKv = functionKeyValues[IS_CONSTANT_INDEX];
        boolean isConstant = isConstantKv == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(isConstantKv.getValueArray(), isConstantKv.getValueOffset(), isConstantKv.getValueLength()));
        Cell defaultValueKv = functionKeyValues[DEFAULT_VALUE_INDEX];
        String defaultValue = defaultValueKv == null ? null : (String)PVarchar.INSTANCE.toObject(defaultValueKv.getValueArray(), defaultValueKv.getValueOffset(), defaultValueKv.getValueLength());
        Cell minValueKv = functionKeyValues[MIN_VALUE_INDEX];
        String minValue = minValueKv == null ? null : (String)PVarchar.INSTANCE.toObject(minValueKv.getValueArray(), minValueKv.getValueOffset(), minValueKv.getValueLength());
        Cell maxValueKv = functionKeyValues[MAX_VALUE_INDEX];
        String maxValue = maxValueKv == null ? null : (String)PVarchar.INSTANCE.toObject(maxValueKv.getValueArray(), maxValueKv.getValueOffset(), maxValueKv.getValueLength());
        PFunction.FunctionArgument arg = new PFunction.FunctionArgument(type.getString(), isArrayType, isConstant, defaultValue == null ? null : LiteralExpression.newConstant(new LiteralParseNode(defaultValue).getValue()), minValue == null ? null : LiteralExpression.newConstant(new LiteralParseNode(minValue).getValue()), maxValue == null ? null : LiteralExpression.newConstant(new LiteralParseNode(maxValue).getValue()), argPosition);
        arguments.add(arg);
    }

    private PTable getTable(RegionScanner scanner, long clientTimeStamp, long tableTimeStamp, int clientVersion) throws IOException, SQLException {
        Cell viewTypeKv;
        Cell dataTableNameKv;
        Integer saltBucketNum;
        int tenantIdLength;
        ArrayList results = Lists.newArrayList();
        scanner.next((List)results);
        if (results.isEmpty()) {
            return null;
        }
        Cell[] tableKeyValues = new Cell[TABLE_KV_COLUMNS.size()];
        Cell[] colKeyValues = new Cell[COLUMN_KV_COLUMNS.size()];
        Cell keyValue = (Cell)results.get(0);
        byte[] keyBuffer = keyValue.getRowArray();
        short keyLength = keyValue.getRowLength();
        int keyOffset = keyValue.getRowOffset();
        PName tenantId = MetaDataEndpointImpl.newPName(keyBuffer, keyOffset, keyLength);
        int n = tenantIdLength = tenantId == null ? 0 : tenantId.getBytes().length;
        if (tenantIdLength == 0) {
            tenantId = null;
        }
        PName schemaName = MetaDataEndpointImpl.newPName(keyBuffer, keyOffset + tenantIdLength + 1, keyLength);
        int schemaNameLength = schemaName.getBytes().length;
        int tableNameLength = keyLength - schemaNameLength - 1 - tenantIdLength - 1;
        byte[] tableNameBytes = new byte[tableNameLength];
        System.arraycopy(keyBuffer, keyOffset + schemaNameLength + 1 + tenantIdLength + 1, tableNameBytes, 0, tableNameLength);
        PName tableName = PNameFactory.newName(tableNameBytes);
        int offset = tenantIdLength + schemaNameLength + tableNameLength + 3;
        long timeStamp = keyValue.getTimestamp();
        int i = 0;
        int j = 0;
        while (i < results.size() && j < TABLE_KV_COLUMNS.size()) {
            Cell kv = (Cell)results.get(i);
            Cell searchKv = TABLE_KV_COLUMNS.get(j);
            int cmp = Bytes.compareTo((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength(), (byte[])searchKv.getQualifierArray(), (int)searchKv.getQualifierOffset(), (int)searchKv.getQualifierLength());
            if (cmp == 0) {
                timeStamp = Math.max(timeStamp, kv.getTimestamp());
                tableKeyValues[j++] = kv;
                ++i;
                continue;
            }
            if (cmp > 0) {
                timeStamp = Math.max(timeStamp, kv.getTimestamp());
                tableKeyValues[j++] = null;
                continue;
            }
            ++i;
        }
        if (tableKeyValues[TABLE_TYPE_INDEX] == null || tableKeyValues[TABLE_SEQ_NUM_INDEX] == null || tableKeyValues[COLUMN_COUNT_INDEX] == null) {
            Cell cell = (Cell)results.get(0);
            LOGGER.error("Found invalid metadata rows for rowkey " + Bytes.toString((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength()));
            return null;
        }
        Cell tableTypeKv = tableKeyValues[TABLE_TYPE_INDEX];
        PTableType tableType = PTableType.fromSerializedValue(tableTypeKv.getValueArray()[tableTypeKv.getValueOffset()]);
        Cell tableSeqNumKv = tableKeyValues[TABLE_SEQ_NUM_INDEX];
        long tableSeqNum = PLong.INSTANCE.getCodec().decodeLong(tableSeqNumKv.getValueArray(), tableSeqNumKv.getValueOffset(), SortOrder.getDefault());
        Cell columnCountKv = tableKeyValues[COLUMN_COUNT_INDEX];
        int columnCount = PInteger.INSTANCE.getCodec().decodeInt(columnCountKv.getValueArray(), columnCountKv.getValueOffset(), SortOrder.getDefault());
        Cell pkNameKv = tableKeyValues[PK_NAME_INDEX];
        PName pkName = pkNameKv != null ? MetaDataEndpointImpl.newPName(pkNameKv.getValueArray(), pkNameKv.getValueOffset(), pkNameKv.getValueLength()) : null;
        Cell saltBucketNumKv = tableKeyValues[SALT_BUCKETS_INDEX];
        Integer n2 = saltBucketNum = saltBucketNumKv != null ? Integer.valueOf(PInteger.INSTANCE.getCodec().decodeInt(saltBucketNumKv.getValueArray(), saltBucketNumKv.getValueOffset(), SortOrder.getDefault())) : null;
        if (saltBucketNum != null && saltBucketNum == 0) {
            saltBucketNum = null;
        }
        PName dataTableName = (dataTableNameKv = tableKeyValues[DATA_TABLE_NAME_INDEX]) != null ? MetaDataEndpointImpl.newPName(dataTableNameKv.getValueArray(), dataTableNameKv.getValueOffset(), dataTableNameKv.getValueLength()) : null;
        Cell indexStateKv = tableKeyValues[INDEX_STATE_INDEX];
        PIndexState indexState = indexStateKv == null ? null : PIndexState.fromSerializedValue(indexStateKv.getValueArray()[indexStateKv.getValueOffset()]);
        Cell immutableRowsKv = tableKeyValues[IMMUTABLE_ROWS_INDEX];
        boolean isImmutableRows = immutableRowsKv == null ? false : (Boolean)PBoolean.INSTANCE.toObject(immutableRowsKv.getValueArray(), immutableRowsKv.getValueOffset(), immutableRowsKv.getValueLength());
        Cell defaultFamilyNameKv = tableKeyValues[DEFAULT_COLUMN_FAMILY_INDEX];
        PName defaultFamilyName = defaultFamilyNameKv != null ? MetaDataEndpointImpl.newPName(defaultFamilyNameKv.getValueArray(), defaultFamilyNameKv.getValueOffset(), defaultFamilyNameKv.getValueLength()) : null;
        Cell viewStatementKv = tableKeyValues[VIEW_STATEMENT_INDEX];
        String viewStatement = viewStatementKv != null ? (String)PVarchar.INSTANCE.toObject(viewStatementKv.getValueArray(), viewStatementKv.getValueOffset(), viewStatementKv.getValueLength()) : null;
        Cell disableWALKv = tableKeyValues[DISABLE_WAL_INDEX];
        boolean disableWAL = disableWALKv == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(disableWALKv.getValueArray(), disableWALKv.getValueOffset(), disableWALKv.getValueLength()));
        Cell multiTenantKv = tableKeyValues[MULTI_TENANT_INDEX];
        boolean multiTenant = multiTenantKv == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(multiTenantKv.getValueArray(), multiTenantKv.getValueOffset(), multiTenantKv.getValueLength()));
        Cell storeNullsKv = tableKeyValues[STORE_NULLS_INDEX];
        boolean storeNulls = storeNullsKv == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(storeNullsKv.getValueArray(), storeNullsKv.getValueOffset(), storeNullsKv.getValueLength()));
        Cell transactionalKv = tableKeyValues[TRANSACTIONAL_INDEX];
        Cell transactionProviderKv = tableKeyValues[TRANSACTION_PROVIDER_INDEX];
        TransactionFactory.Provider transactionProvider = null;
        if (transactionProviderKv == null) {
            if (transactionalKv != null && Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(transactionalKv.getValueArray(), transactionalKv.getValueOffset(), transactionalKv.getValueLength()))) {
                transactionProvider = TransactionFactory.Provider.TEPHRA;
            }
        } else {
            transactionProvider = TransactionFactory.Provider.fromCode(PTinyint.INSTANCE.getCodec().decodeByte(transactionProviderKv.getValueArray(), transactionProviderKv.getValueOffset(), SortOrder.getDefault()));
        }
        PTable.ViewType viewType = (viewTypeKv = tableKeyValues[VIEW_TYPE_INDEX]) == null ? null : PTable.ViewType.fromSerializedValue(viewTypeKv.getValueArray()[viewTypeKv.getValueOffset()]);
        PDataType viewIndexIdType = this.getViewIndexIdType(tableKeyValues);
        Long viewIndexId = this.getViewIndexId(tableKeyValues, viewIndexIdType);
        Cell indexTypeKv = tableKeyValues[INDEX_TYPE_INDEX];
        PTable.IndexType indexType = indexTypeKv == null ? null : PTable.IndexType.fromSerializedValue(indexTypeKv.getValueArray()[indexTypeKv.getValueOffset()]);
        Cell baseColumnCountKv = tableKeyValues[BASE_COLUMN_COUNT_INDEX];
        int baseColumnCount = baseColumnCountKv == null ? 0 : PInteger.INSTANCE.getCodec().decodeInt(baseColumnCountKv.getValueArray(), baseColumnCountKv.getValueOffset(), SortOrder.getDefault());
        Cell rowKeyOrderOptimizableKv = tableKeyValues[ROW_KEY_ORDER_OPTIMIZABLE_INDEX];
        boolean rowKeyOrderOptimizable = rowKeyOrderOptimizableKv == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(rowKeyOrderOptimizableKv.getValueArray(), rowKeyOrderOptimizableKv.getValueOffset(), rowKeyOrderOptimizableKv.getValueLength()));
        Cell updateCacheFrequencyKv = tableKeyValues[UPDATE_CACHE_FREQUENCY_INDEX];
        long updateCacheFrequency = updateCacheFrequencyKv == null ? 0L : PLong.INSTANCE.getCodec().decodeLong(updateCacheFrequencyKv.getValueArray(), updateCacheFrequencyKv.getValueOffset(), SortOrder.getDefault());
        byte[] tagUpdateCacheFreq = updateCacheFrequencyKv == null ? HConstants.EMPTY_BYTE_ARRAY : TagUtil.concatTags((byte[])HConstants.EMPTY_BYTE_ARRAY, (Cell)updateCacheFrequencyKv);
        boolean viewModifiedUpdateCacheFrequency = PTableType.VIEW.equals((Object)tableType) && Bytes.contains((byte[])tagUpdateCacheFreq, (byte[])VIEW_MODIFIED_PROPERTY_BYTES);
        Cell indexDisableTimestampKv = tableKeyValues[INDEX_DISABLE_TIMESTAMP];
        long indexDisableTimestamp = indexDisableTimestampKv == null ? 0L : PLong.INSTANCE.getCodec().decodeLong(indexDisableTimestampKv.getValueArray(), indexDisableTimestampKv.getValueOffset(), SortOrder.getDefault());
        Cell isNamespaceMappedKv = tableKeyValues[IS_NAMESPACE_MAPPED_INDEX];
        boolean isNamespaceMapped = isNamespaceMappedKv == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(isNamespaceMappedKv.getValueArray(), isNamespaceMappedKv.getValueOffset(), isNamespaceMappedKv.getValueLength()));
        Cell autoPartitionSeqKv = tableKeyValues[AUTO_PARTITION_SEQ_INDEX];
        String autoPartitionSeq = autoPartitionSeqKv != null ? (String)PVarchar.INSTANCE.toObject(autoPartitionSeqKv.getValueArray(), autoPartitionSeqKv.getValueOffset(), autoPartitionSeqKv.getValueLength()) : null;
        Cell isAppendOnlySchemaKv = tableKeyValues[APPEND_ONLY_SCHEMA_INDEX];
        boolean isAppendOnlySchema = isAppendOnlySchemaKv == null ? false : Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(isAppendOnlySchemaKv.getValueArray(), isAppendOnlySchemaKv.getValueOffset(), isAppendOnlySchemaKv.getValueLength()));
        Cell storageSchemeKv = tableKeyValues[STORAGE_SCHEME_INDEX];
        PTable.ImmutableStorageScheme storageScheme = storageSchemeKv == null ? PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN : PTable.ImmutableStorageScheme.fromSerializedValue((Byte)PTinyint.INSTANCE.toObject(storageSchemeKv.getValueArray(), storageSchemeKv.getValueOffset(), storageSchemeKv.getValueLength()));
        Cell encodingSchemeKv = tableKeyValues[QUALIFIER_ENCODING_SCHEME_INDEX];
        PTable.QualifierEncodingScheme encodingScheme = encodingSchemeKv == null ? PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS : PTable.QualifierEncodingScheme.fromSerializedValue((Byte)PTinyint.INSTANCE.toObject(encodingSchemeKv.getValueArray(), encodingSchemeKv.getValueOffset(), encodingSchemeKv.getValueLength()));
        Cell useStatsForParallelizationKv = tableKeyValues[USE_STATS_FOR_PARALLELIZATION_INDEX];
        Boolean useStatsForParallelization = useStatsForParallelizationKv == null ? null : Boolean.valueOf(Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(useStatsForParallelizationKv.getValueArray(), useStatsForParallelizationKv.getValueOffset(), useStatsForParallelizationKv.getValueLength())));
        Cell phoenixTTLKv = tableKeyValues[PHOENIX_TTL_INDEX];
        long phoenixTTL = phoenixTTLKv == null ? 0L : PLong.INSTANCE.getCodec().decodeLong(phoenixTTLKv.getValueArray(), phoenixTTLKv.getValueOffset(), SortOrder.getDefault());
        Cell phoenixTTLHWMKv = tableKeyValues[PHOENIX_TTL_HWM_INDEX];
        long phoenixTTLHWM = phoenixTTLHWMKv == null ? 0L : PLong.INSTANCE.getCodec().decodeLong(phoenixTTLHWMKv.getValueArray(), phoenixTTLHWMKv.getValueOffset(), SortOrder.getDefault());
        byte[] tagPhoenixTTL = phoenixTTLKv == null ? HConstants.EMPTY_BYTE_ARRAY : CellUtil.getTagArray((Cell)phoenixTTLKv);
        boolean viewModifiedPhoenixTTL = PTableType.VIEW.equals((Object)tableType) && Bytes.contains((byte[])tagPhoenixTTL, (byte[])VIEW_MODIFIED_PROPERTY_BYTES);
        Cell lastDDLTimestampKv = tableKeyValues[LAST_DDL_TIMESTAMP_INDEX];
        Long lastDDLTimestamp = lastDDLTimestampKv == null ? null : Long.valueOf(PLong.INSTANCE.getCodec().decodeLong(lastDDLTimestampKv.getValueArray(), lastDDLTimestampKv.getValueOffset(), SortOrder.getDefault()));
        Cell changeDetectionEnabledKv = tableKeyValues[CHANGE_DETECTION_ENABLED_INDEX];
        boolean isChangeDetectionEnabled = changeDetectionEnabledKv != null && Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(changeDetectionEnabledKv.getValueArray(), changeDetectionEnabledKv.getValueOffset(), changeDetectionEnabledKv.getValueLength()));
        byte[] tagUseStatsForParallelization = useStatsForParallelizationKv == null ? HConstants.EMPTY_BYTE_ARRAY : TagUtil.concatTags((byte[])HConstants.EMPTY_BYTE_ARRAY, (Cell)useStatsForParallelizationKv);
        boolean viewModifiedUseStatsForParallelization = PTableType.VIEW.equals((Object)tableType) && Bytes.contains((byte[])tagUseStatsForParallelization, (byte[])VIEW_MODIFIED_PROPERTY_BYTES);
        ArrayList columns = Lists.newArrayListWithExpectedSize((int)columnCount);
        ArrayList indexes = Lists.newArrayList();
        ArrayList physicalTables = Lists.newArrayList();
        PName parentTableName = tableType == PTableType.INDEX ? dataTableName : null;
        PName parentSchemaName = tableType == PTableType.INDEX ? schemaName : null;
        PTable.EncodedCQCounter cqCounter = !EncodedColumnsUtil.usesEncodedColumnNames(encodingScheme) || tableType == PTableType.VIEW ? PTable.EncodedCQCounter.NULL_COUNTER : new PTable.EncodedCQCounter();
        boolean isRegularView = tableType == PTableType.VIEW && viewType != PTable.ViewType.MAPPED;
        while (true) {
            results.clear();
            scanner.next((List)results);
            if (results.isEmpty()) break;
            Cell colKv = (Cell)results.get(0);
            short colKeyLength = colKv.getRowLength();
            PName colName = MetaDataEndpointImpl.newPName(colKv.getRowArray(), colKv.getRowOffset() + offset, colKeyLength - offset);
            int colKeyOffset = offset + colName.getBytes().length + 1;
            PName famName = MetaDataEndpointImpl.newPName(colKv.getRowArray(), colKv.getRowOffset() + colKeyOffset, colKeyLength - colKeyOffset);
            if (this.isQualifierCounterKV(colKv)) {
                Integer value = PInteger.INSTANCE.getCodec().decodeInt(colKv.getValueArray(), colKv.getValueOffset(), SortOrder.ASC);
                cqCounter.setValue(famName.getString(), value);
                continue;
            }
            if (Bytes.compareTo((byte[])PhoenixDatabaseMetaData.LINK_TYPE_BYTES, (int)0, (int)PhoenixDatabaseMetaData.LINK_TYPE_BYTES.length, (byte[])colKv.getQualifierArray(), (int)colKv.getQualifierOffset(), (int)colKv.getQualifierLength()) == 0) {
                PTable.LinkType linkType = PTable.LinkType.fromSerializedValue(colKv.getValueArray()[colKv.getValueOffset()]);
                if (linkType == PTable.LinkType.INDEX_TABLE) {
                    this.addIndexToTable(tenantId, schemaName, famName, tableName, clientTimeStamp, indexes, clientVersion);
                    continue;
                }
                if (linkType == PTable.LinkType.PHYSICAL_TABLE) {
                    physicalTables.add(famName);
                    continue;
                }
                if (linkType == PTable.LinkType.PARENT_TABLE) {
                    parentTableName = PNameFactory.newName(SchemaUtil.getTableNameFromFullName(famName.getBytes()));
                    parentSchemaName = PNameFactory.newName(SchemaUtil.getSchemaNameFromFullName(famName.getBytes()));
                    continue;
                }
                if (linkType != PTable.LinkType.EXCLUDED_COLUMN) continue;
                this.addExcludedColumnToTable(columns, colName, famName, colKv.getTimestamp());
                continue;
            }
            this.addColumnToTable(results, colName, famName, colKeyValues, columns, saltBucketNum != null, baseColumnCount, isRegularView);
        }
        return new PTableImpl.Builder().setType(tableType).setState(indexState).setTimeStamp(timeStamp).setIndexDisableTimestamp(indexDisableTimestamp).setSequenceNumber(tableSeqNum).setImmutableRows(isImmutableRows).setViewStatement(viewStatement).setDisableWAL(disableWAL).setMultiTenant(multiTenant).setStoreNulls(storeNulls).setViewType(viewType).setViewIndexIdType(viewIndexIdType).setViewIndexId(viewIndexId).setIndexType(indexType).setTransactionProvider(transactionProvider).setUpdateCacheFrequency(updateCacheFrequency).setNamespaceMapped(isNamespaceMapped).setAutoPartitionSeqName(autoPartitionSeq).setAppendOnlySchema(isAppendOnlySchema).setImmutableStorageScheme(storageScheme == null ? PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN : storageScheme).setQualifierEncodingScheme(encodingScheme == null ? PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS : encodingScheme).setBaseColumnCount(baseColumnCount).setEncodedCQCounter(cqCounter).setUseStatsForParallelization(useStatsForParallelization).setPhoenixTTL(phoenixTTL).setPhoenixTTLHighWaterMark(phoenixTTLHWM).setExcludedColumns((List<PColumn>)ImmutableList.of()).setTenantId(tenantId).setSchemaName(schemaName).setTableName(tableName).setPkName(pkName).setDefaultFamilyName(defaultFamilyName).setRowKeyOrderOptimizable(rowKeyOrderOptimizable).setBucketNum(saltBucketNum).setIndexes(indexes == null ? Collections.emptyList() : indexes).setParentSchemaName(parentSchemaName).setParentTableName(parentTableName).setPhysicalNames((List<PName>)(physicalTables == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)physicalTables))).setViewModifiedUpdateCacheFrequency(viewModifiedUpdateCacheFrequency).setViewModifiedUseStatsForParallelization(viewModifiedUseStatsForParallelization).setViewModifiedPhoenixTTL(viewModifiedPhoenixTTL).setLastDDLTimestamp(lastDDLTimestamp).setIsChangeDetectionEnabled(isChangeDetectionEnabled).setColumns(columns).build();
    }

    private Long getViewIndexId(Cell[] tableKeyValues, PDataType viewIndexIdType) {
        Cell viewIndexIdKv = tableKeyValues[VIEW_INDEX_ID_INDEX];
        return viewIndexIdKv == null ? null : this.decodeViewIndexId(viewIndexIdKv, viewIndexIdType);
    }

    private PTable modifyIndexStateForOldClient(int clientVersion, PTable table) throws SQLException {
        if (table == null) {
            return table;
        }
        if (table.getIndexState() == PIndexState.PENDING_ACTIVE && clientVersion < MetaDataProtocol.MIN_PENDING_ACTIVE_INDEX) {
            table = PTableImpl.builderWithColumns(table, PTableImpl.getColumnsToClone(table)).setState(PIndexState.ACTIVE).build();
        }
        if (table.getIndexState() == PIndexState.PENDING_DISABLE && clientVersion < MetaDataProtocol.MIN_PENDING_DISABLE_INDEX) {
            table = PTableImpl.builderWithColumns(table, PTableImpl.getColumnsToClone(table)).setState(PIndexState.DISABLE).build();
        }
        return table;
    }

    private Long decodeViewIndexId(Cell viewIndexIdKv, PDataType viewIndexIdType) {
        return viewIndexIdType.getCodec().decodeLong(viewIndexIdKv.getValueArray(), viewIndexIdKv.getValueOffset(), SortOrder.getDefault());
    }

    private PDataType getViewIndexIdType(Cell[] tableKeyValues) {
        Cell dataTypeKv = tableKeyValues[VIEW_INDEX_ID_DATA_TYPE_INDEX];
        return dataTypeKv == null ? MetaDataUtil.getLegacyViewIndexIdDataType() : PDataType.fromTypeId(PInteger.INSTANCE.getCodec().decodeInt(dataTypeKv.getValueArray(), dataTypeKv.getValueOffset(), SortOrder.getDefault()));
    }

    private boolean isQualifierCounterKV(Cell kv) {
        int cmp = Bytes.compareTo((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength(), (byte[])QUALIFIER_COUNTER_KV.getQualifierArray(), (int)QUALIFIER_COUNTER_KV.getQualifierOffset(), (int)QUALIFIER_COUNTER_KV.getQualifierLength());
        return cmp == 0;
    }

    private PSchema getSchema(RegionScanner scanner, long clientTimeStamp) throws IOException, SQLException {
        int tenantIdLength;
        ArrayList results = Lists.newArrayList();
        scanner.next((List)results);
        if (results.isEmpty()) {
            return null;
        }
        Cell keyValue = (Cell)results.get(0);
        byte[] keyBuffer = keyValue.getRowArray();
        short keyLength = keyValue.getRowLength();
        int keyOffset = keyValue.getRowOffset();
        PName tenantId = MetaDataEndpointImpl.newPName(keyBuffer, keyOffset, keyLength);
        int n = tenantIdLength = tenantId == null ? 0 : tenantId.getBytes().length;
        if (tenantIdLength == 0) {
            tenantId = null;
        }
        PName schemaName = MetaDataEndpointImpl.newPName(keyBuffer, keyOffset + tenantIdLength + 1, keyLength - tenantIdLength - 1);
        long timeStamp = keyValue.getTimestamp();
        return new PSchema(schemaName.getString(), timeStamp);
    }

    private PFunction getFunction(RegionScanner scanner, boolean isReplace, long clientTimeStamp, List<Mutation> deleteMutationsForReplace) throws IOException, SQLException {
        PName tenantId;
        int tenantIdLength;
        ArrayList results = Lists.newArrayList();
        scanner.next((List)results);
        if (results.isEmpty()) {
            return null;
        }
        Cell[] functionKeyValues = new Cell[FUNCTION_KV_COLUMNS.size()];
        Cell[] functionArgKeyValues = new Cell[FUNCTION_ARG_KV_COLUMNS.size()];
        Cell keyValue = (Cell)results.get(0);
        byte[] keyBuffer = keyValue.getRowArray();
        short keyLength = keyValue.getRowLength();
        int keyOffset = keyValue.getRowOffset();
        long currentTimeMillis = EnvironmentEdgeManager.currentTimeMillis();
        if (isReplace) {
            long deleteTimeStamp = clientTimeStamp == Long.MAX_VALUE ? currentTimeMillis - 1L : (keyValue.getTimestamp() < clientTimeStamp ? clientTimeStamp - 1L : keyValue.getTimestamp());
            deleteMutationsForReplace.add((Mutation)new Delete(keyBuffer, keyOffset, (int)keyLength, deleteTimeStamp));
        }
        int n = tenantIdLength = (tenantId = MetaDataEndpointImpl.newPName(keyBuffer, keyOffset, keyLength)) == null ? 0 : tenantId.getBytes().length;
        if (tenantIdLength == 0) {
            tenantId = null;
        }
        PName functionName = MetaDataEndpointImpl.newPName(keyBuffer, keyOffset + tenantIdLength + 1, keyLength - tenantIdLength - 1);
        int functionNameLength = functionName.getBytes().length + 1;
        int offset = tenantIdLength + functionNameLength + 1;
        long timeStamp = keyValue.getTimestamp();
        int i = 0;
        int j = 0;
        while (i < results.size() && j < FUNCTION_KV_COLUMNS.size()) {
            Cell kv = (Cell)results.get(i);
            Cell searchKv = FUNCTION_KV_COLUMNS.get(j);
            int cmp = Bytes.compareTo((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength(), (byte[])searchKv.getQualifierArray(), (int)searchKv.getQualifierOffset(), (int)searchKv.getQualifierLength());
            if (cmp == 0) {
                timeStamp = Math.max(timeStamp, kv.getTimestamp());
                functionKeyValues[j++] = kv;
                ++i;
                continue;
            }
            if (cmp > 0) {
                timeStamp = Math.max(timeStamp, kv.getTimestamp());
                functionKeyValues[j++] = null;
                continue;
            }
            ++i;
        }
        if (functionKeyValues[CLASS_NAME_INDEX] == null || functionKeyValues[NUM_ARGS_INDEX] == null) {
            throw new IllegalStateException("Didn't find expected key values for function row in metadata row");
        }
        Cell classNameKv = functionKeyValues[CLASS_NAME_INDEX];
        PName className = MetaDataEndpointImpl.newPName(classNameKv.getValueArray(), classNameKv.getValueOffset(), classNameKv.getValueLength());
        Cell jarPathKv = functionKeyValues[JAR_PATH_INDEX];
        PName jarPath = null;
        if (jarPathKv != null) {
            jarPath = MetaDataEndpointImpl.newPName(jarPathKv.getValueArray(), jarPathKv.getValueOffset(), jarPathKv.getValueLength());
        }
        Cell numArgsKv = functionKeyValues[NUM_ARGS_INDEX];
        int numArgs = PInteger.INSTANCE.getCodec().decodeInt(numArgsKv.getValueArray(), numArgsKv.getValueOffset(), SortOrder.getDefault());
        Cell returnTypeKv = functionKeyValues[RETURN_TYPE_INDEX];
        PName returnType = returnTypeKv == null ? null : MetaDataEndpointImpl.newPName(returnTypeKv.getValueArray(), returnTypeKv.getValueOffset(), returnTypeKv.getValueLength());
        ArrayList arguments = Lists.newArrayListWithExpectedSize((int)numArgs);
        for (int k = 0; k < numArgs; ++k) {
            results.clear();
            scanner.next((List)results);
            if (results.isEmpty()) break;
            Cell typeKv = (Cell)results.get(0);
            if (isReplace) {
                long deleteTimeStamp = clientTimeStamp == Long.MAX_VALUE ? currentTimeMillis - 1L : (typeKv.getTimestamp() < clientTimeStamp ? clientTimeStamp - 1L : typeKv.getTimestamp());
                deleteMutationsForReplace.add((Mutation)new Delete(typeKv.getRowArray(), typeKv.getRowOffset(), (int)typeKv.getRowLength(), deleteTimeStamp));
            }
            short typeKeyLength = typeKv.getRowLength();
            PName typeName = MetaDataEndpointImpl.newPName(typeKv.getRowArray(), typeKv.getRowOffset() + offset, typeKeyLength - offset - 3);
            int argPositionOffset = offset + typeName.getBytes().length + 1;
            short argPosition = Bytes.toShort((byte[])typeKv.getRowArray(), (int)(typeKv.getRowOffset() + argPositionOffset), (int)(typeKeyLength - argPositionOffset));
            this.addArgumentToFunction(results, functionName, typeName, functionArgKeyValues, arguments, argPosition);
        }
        Collections.sort(arguments, new Comparator<PFunction.FunctionArgument>(){

            @Override
            public int compare(PFunction.FunctionArgument o1, PFunction.FunctionArgument o2) {
                return o1.getArgPosition() - o2.getArgPosition();
            }
        });
        return new PFunction(tenantId, functionName.getString(), arguments, returnType.getString(), className.getString(), jarPath == null ? null : jarPath.getString(), timeStamp);
    }

    private PTable buildDeletedTable(byte[] key, ImmutableBytesPtr cacheKey, Region region, long clientTimeStamp) throws IOException {
        if (clientTimeStamp == Long.MAX_VALUE) {
            return null;
        }
        Scan scan = MetaDataUtil.newTableRowsScan(key, clientTimeStamp, Long.MAX_VALUE);
        scan.setFilter((Filter)new FirstKeyOnlyFilter());
        scan.setRaw(true);
        ArrayList results = Lists.newArrayList();
        try (RegionScanner scanner = region.getScanner(scan);){
            scanner.next((List)results);
        }
        for (Cell kv : results) {
            KeyValue.Type type = KeyValue.Type.codeToType((byte)kv.getTypeByte());
            if (type != KeyValue.Type.DeleteFamily) continue;
            Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
            PTable table = MetaDataEndpointImpl.newDeletedTableMarker(kv.getTimestamp());
            metaDataCache.put((Object)cacheKey, (Object)table);
            return table;
        }
        return null;
    }

    private PFunction buildDeletedFunction(byte[] key, ImmutableBytesPtr cacheKey, Region region, long clientTimeStamp) throws IOException {
        Cell kv;
        if (clientTimeStamp == Long.MAX_VALUE) {
            return null;
        }
        Scan scan = MetaDataUtil.newTableRowsScan(key, clientTimeStamp, Long.MAX_VALUE);
        scan.setFilter((Filter)new FirstKeyOnlyFilter());
        scan.setRaw(true);
        ArrayList results = Lists.newArrayList();
        try (RegionScanner scanner = region.getScanner(scan);){
            scanner.next((List)results);
        }
        if (!results.isEmpty() && ((Cell)results.get(0)).getTimestamp() > clientTimeStamp && (kv = (Cell)results.get(0)).getTypeByte() == KeyValue.Type.Delete.getCode()) {
            Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
            PFunction function = MetaDataEndpointImpl.newDeletedFunctionMarker(kv.getTimestamp());
            metaDataCache.put((Object)cacheKey, (Object)function);
            return function;
        }
        return null;
    }

    private PSchema buildDeletedSchema(byte[] key, ImmutableBytesPtr cacheKey, Region region, long clientTimeStamp) throws IOException {
        Cell kv;
        if (clientTimeStamp == Long.MAX_VALUE) {
            return null;
        }
        Scan scan = MetaDataUtil.newTableRowsScan(key, clientTimeStamp, Long.MAX_VALUE);
        scan.setFilter((Filter)new FirstKeyOnlyFilter());
        scan.setRaw(true);
        ArrayList results = Lists.newArrayList();
        try (RegionScanner scanner = region.getScanner(scan);){
            scanner.next((List)results);
        }
        if (!results.isEmpty() && ((Cell)results.get(0)).getTimestamp() > clientTimeStamp && (kv = (Cell)results.get(0)).getTypeByte() == KeyValue.Type.Delete.getCode()) {
            Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
            PSchema schema = MetaDataEndpointImpl.newDeletedSchemaMarker(kv.getTimestamp());
            metaDataCache.put((Object)cacheKey, (Object)schema);
            return schema;
        }
        return null;
    }

    private static PTable newDeletedTableMarker(long timestamp) {
        try {
            return new PTableImpl.Builder().setType(PTableType.TABLE).setTimeStamp(timestamp).setPkColumns(Collections.emptyList()).setAllColumns(Collections.emptyList()).setFamilyAttributes(Collections.emptyList()).setRowKeySchema(RowKeySchema.EMPTY_SCHEMA).setIndexes(Collections.emptyList()).setPhysicalNames(Collections.emptyList()).build();
        }
        catch (SQLException e) {
            return null;
        }
    }

    private static PFunction newDeletedFunctionMarker(long timestamp) {
        return new PFunction(timestamp);
    }

    private static PSchema newDeletedSchemaMarker(long timestamp) {
        return new PSchema(timestamp);
    }

    private static boolean isTableDeleted(PTable table) {
        return table.getName() == null;
    }

    private static boolean isSchemaDeleted(PSchema schema) {
        return schema.getSchemaName() == null;
    }

    private static boolean isFunctionDeleted(PFunction function) {
        return function.getFunctionName() == null;
    }

    private PTable loadTable(RegionCoprocessorEnvironment env, byte[] key, ImmutableBytesPtr cacheKey, long clientTimeStamp, long asOfTimeStamp, int clientVersion) throws IOException, SQLException {
        Region region = env.getRegion();
        PTable table = this.getTableFromCache(cacheKey, clientTimeStamp, clientVersion);
        if (table != null || (table = this.buildTable(key, cacheKey, region, asOfTimeStamp, clientVersion)) != null) {
            return table;
        }
        if (table == null && (table = this.buildDeletedTable(key, cacheKey, region, clientTimeStamp)) != null) {
            return table;
        }
        return null;
    }

    private PTable getTableFromCache(ImmutableBytesPtr cacheKey, long clientTimeStamp, int clientVersion) {
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        PTable table = (PTable)metaDataCache.getIfPresent((Object)cacheKey);
        return table;
    }

    private PFunction loadFunction(RegionCoprocessorEnvironment env, byte[] key, ImmutableBytesPtr cacheKey, long clientTimeStamp, long asOfTimeStamp, boolean isReplace, List<Mutation> deleteMutationsForReplace) throws IOException, SQLException {
        Region region = env.getRegion();
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        PFunction function = (PFunction)metaDataCache.getIfPresent((Object)cacheKey);
        if (function != null && !isReplace) {
            return function;
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1);
        arrayList.add(key);
        List<PFunction> functions = this.buildFunctions(arrayList, region, asOfTimeStamp, isReplace, deleteMutationsForReplace);
        if (functions != null) {
            return functions.get(0);
        }
        if (function == null && (function = this.buildDeletedFunction(key, cacheKey, region, clientTimeStamp)) != null) {
            return function;
        }
        return null;
    }

    private PSchema loadSchema(RegionCoprocessorEnvironment env, byte[] key, ImmutableBytesPtr cacheKey, long clientTimeStamp, long asOfTimeStamp) throws IOException, SQLException {
        Region region = env.getRegion();
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        PSchema schema = (PSchema)metaDataCache.getIfPresent((Object)cacheKey);
        if (schema != null) {
            return schema;
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1);
        arrayList.add(key);
        List<PSchema> schemas = this.buildSchemas(arrayList, region, asOfTimeStamp, cacheKey);
        if (schemas != null) {
            return schemas.get(0);
        }
        if (schema == null && (schema = this.buildDeletedSchema(key, cacheKey, region, clientTimeStamp)) != null) {
            return schema;
        }
        return null;
    }

    private static void getParentAndPhysicalNames(List<Mutation> tableMetadata, byte[][] parentTenantSchemaTableNames, byte[][] physicalSchemaTableNames) {
        int size = tableMetadata.size();
        byte[][] rowKeyMetaData = new byte[3][];
        MetaDataUtil.getTenantIdAndSchemaAndTableName(tableMetadata, rowKeyMetaData);
        Mutation physicalTableRow = null;
        Mutation parentTableRow = null;
        boolean physicalTableLinkFound = false;
        boolean parentTableLinkFound = false;
        if (size >= 2) {
            for (int i = size - 1; i >= 1; --i) {
                Mutation m = tableMetadata.get(i);
                if (m instanceof Put) {
                    PTable.LinkType linkType = MetaDataUtil.getLinkType(m);
                    if (linkType == PTable.LinkType.PHYSICAL_TABLE) {
                        physicalTableRow = m;
                        physicalTableLinkFound = true;
                    }
                    if (linkType == PTable.LinkType.PARENT_TABLE) {
                        parentTableRow = m;
                        parentTableLinkFound = true;
                    }
                }
                if (physicalTableLinkFound && parentTableLinkFound) break;
            }
        }
        if (!parentTableLinkFound) {
            parentTenantSchemaTableNames[0] = null;
            parentTenantSchemaTableNames[1] = null;
            parentTenantSchemaTableNames[2] = null;
        }
        if (!physicalTableLinkFound) {
            physicalSchemaTableNames[0] = null;
            physicalSchemaTableNames[1] = null;
            physicalSchemaTableNames[2] = null;
        }
        if (physicalTableLinkFound) {
            MetaDataEndpointImpl.getSchemaTableNames(physicalTableRow, physicalSchemaTableNames);
        }
        if (parentTableLinkFound) {
            MetaDataEndpointImpl.getSchemaTableNames(parentTableRow, parentTenantSchemaTableNames);
        }
    }

    private static void getSchemaTableNames(Mutation row, byte[][] schemaTableNames) {
        byte[][] rowKeyMetaData = new byte[5][];
        SchemaUtil.getVarChars(row.getRow(), 5, rowKeyMetaData);
        byte[] tenantId = rowKeyMetaData[0];
        byte[] colBytes = rowKeyMetaData[3];
        byte[] famBytes = rowKeyMetaData[4];
        if ((colBytes == null || colBytes.length == 0) && famBytes != null && famBytes.length > 0) {
            byte[] sName = SchemaUtil.getSchemaNameFromFullName(famBytes).getBytes(StandardCharsets.UTF_8);
            byte[] tName = SchemaUtil.getTableNameFromFullName(famBytes).getBytes(StandardCharsets.UTF_8);
            schemaTableNames[0] = tenantId;
            schemaTableNames[1] = sName;
            schemaTableNames[2] = tName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTable(RpcController controller, MetaDataProtos.CreateTableRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
        byte[][] rowKeyMetaData = new byte[3][];
        byte[] schemaName = null;
        byte[] tableName = null;
        String fullTableName = null;
        try {
            int clientVersion = request.getClientVersion();
            List<Mutation> tableMetadata = ProtobufUtil.getMutations(request);
            MetaDataUtil.getTenantIdAndSchemaAndTableName(tableMetadata, rowKeyMetaData);
            byte[] tenantIdBytes = rowKeyMetaData[0];
            schemaName = rowKeyMetaData[1];
            tableName = rowKeyMetaData[2];
            fullTableName = SchemaUtil.getTableName(schemaName, tableName);
            boolean isNamespaceMapped = MetaDataUtil.isNameSpaceMapped(tableMetadata, GenericKeyValueBuilder.INSTANCE, new ImmutableBytesWritable());
            PTable.IndexType indexType = MetaDataUtil.getIndexType(tableMetadata, GenericKeyValueBuilder.INSTANCE, new ImmutableBytesWritable());
            byte[] parentSchemaName = null;
            byte[] parentTableName = null;
            PTable parentTable = request.hasParentTable() ? PTableImpl.createFromProto(request.getParentTable()) : null;
            PTableType tableType = MetaDataUtil.getTableType(tableMetadata, GenericKeyValueBuilder.INSTANCE, new ImmutableBytesWritable());
            byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes, schemaName, tableName);
            ImmutableBytesPtr cacheKey = new ImmutableBytesPtr(tableKey);
            long clientTimeStamp = MetaDataUtil.getClientTimeStamp(tableMetadata);
            PTable table = null;
            table = this.loadTable(this.env, tableKey, cacheKey, clientTimeStamp, Long.MAX_VALUE, clientVersion);
            if (table != null) {
                if (table.getTimeStamp() < clientTimeStamp) {
                    if (!MetaDataEndpointImpl.isTableDeleted(table)) {
                        builder.setReturnCode(MetaDataProtos.MutationCode.TABLE_ALREADY_EXISTS);
                        builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                        builder.setTable(PTableImpl.toProto(table));
                        done.run((Object)builder.build());
                        return;
                    }
                } else {
                    builder.setReturnCode(MetaDataProtos.MutationCode.NEWER_TABLE_FOUND);
                    builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                    builder.setTable(PTableImpl.toProto(table));
                    done.run((Object)builder.build());
                    return;
                }
            }
            if (!Bytes.toString((byte[])schemaName).equals("SYSTEM")) {
                ViewUtil.dropChildViews(this.env, tenantIdBytes, schemaName, tableName, ViewUtil.getSystemTableForChildLinks(clientVersion, this.env.getConfiguration()).getName());
            }
            byte[] parentTableKey = null;
            HashSet<TableName> indexes = new HashSet<TableName>();
            byte[] cPhysicalName = SchemaUtil.getPhysicalHBaseTableName(schemaName, tableName, isNamespaceMapped).getBytes();
            byte[] cParentPhysicalName = null;
            if (tableType == PTableType.VIEW) {
                byte[][] parentSchemaTableNames = new byte[3][];
                byte[][] parentPhysicalSchemaTableNames = new byte[3][];
                MetaDataEndpointImpl.getParentAndPhysicalNames(tableMetadata, parentSchemaTableNames, parentPhysicalSchemaTableNames);
                if (parentPhysicalSchemaTableNames[2] != null) {
                    if (parentTable == null) {
                        Object tenantId;
                        parentTable = this.doGetTable(ByteUtil.EMPTY_BYTE_ARRAY, parentPhysicalSchemaTableNames[1], parentPhysicalSchemaTableNames[2], clientTimeStamp, clientVersion);
                        if (parentTable == null) {
                            builder.setReturnCode(MetaDataProtos.MutationCode.PARENT_TABLE_NOT_FOUND);
                            builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                            done.run((Object)builder.build());
                            return;
                        }
                        if (parentSchemaTableNames[2] != null && Bytes.compareTo((byte[])parentSchemaTableNames[2], (byte[])parentPhysicalSchemaTableNames[2]) != 0 && (parentTable = this.doGetTable((byte[])(tenantId = (Object)(parentSchemaTableNames[0] == null ? ByteUtil.EMPTY_BYTE_ARRAY : parentSchemaTableNames[0])), parentSchemaTableNames[1], parentSchemaTableNames[2], clientTimeStamp, clientVersion)) == null) {
                            parentTable = this.doGetTable(ByteUtil.EMPTY_BYTE_ARRAY, parentSchemaTableNames[1], parentSchemaTableNames[2], clientTimeStamp, clientVersion);
                        }
                        if (parentTable == null) {
                            builder.setReturnCode(MetaDataProtos.MutationCode.PARENT_TABLE_NOT_FOUND);
                            builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                            done.run((Object)builder.build());
                            return;
                        }
                    }
                    parentTableKey = SchemaUtil.getTableKey(ByteUtil.EMPTY_BYTE_ARRAY, parentPhysicalSchemaTableNames[1], parentPhysicalSchemaTableNames[2]);
                    cParentPhysicalName = parentTable.getPhysicalName().getBytes();
                    for (PTable index : parentTable.getIndexes()) {
                        indexes.add(TableName.valueOf((byte[])index.getPhysicalName().getBytes()));
                    }
                } else {
                    cParentPhysicalName = SchemaUtil.getPhysicalHBaseTableName(schemaName, tableName, isNamespaceMapped).getBytes();
                }
                parentSchemaName = parentPhysicalSchemaTableNames[1];
                parentTableName = parentPhysicalSchemaTableNames[2];
            } else if (tableType == PTableType.INDEX) {
                parentSchemaName = schemaName;
                parentTableName = MetaDataUtil.getParentTableName(tableMetadata);
                parentTableKey = SchemaUtil.getTableKey(tenantIdBytes, parentSchemaName, parentTableName);
                if (parentTable == null) {
                    parentTable = this.doGetTable(tenantIdBytes, parentSchemaName, parentTableName, clientTimeStamp, null, request.getClientVersion());
                }
                if (PTable.IndexType.LOCAL == indexType) {
                    cPhysicalName = parentTable.getPhysicalName().getBytes();
                    cParentPhysicalName = parentTable.getPhysicalName().getBytes();
                } else if (parentTable.getType() == PTableType.VIEW) {
                    cPhysicalName = MetaDataUtil.getViewIndexPhysicalName(parentTable.getPhysicalName().getBytes());
                    cParentPhysicalName = parentTable.getPhysicalName().getBytes();
                } else {
                    cParentPhysicalName = SchemaUtil.getPhysicalHBaseTableName(parentSchemaName, parentTableName, isNamespaceMapped).getBytes();
                }
            }
            this.getCoprocessorHost().preCreateTable(Bytes.toString((byte[])tenantIdBytes), fullTableName, tableType == PTableType.VIEW ? null : TableName.valueOf((byte[])cPhysicalName), cParentPhysicalName == null ? null : TableName.valueOf(cParentPhysicalName), tableType, Collections.emptySet(), indexes);
            Region region = this.env.getRegion();
            ArrayList locks = Lists.newArrayList();
            try {
                Throwable tableHeaderPut;
                PhoenixConnection connection;
                this.acquireLock(region, tableKey, locks);
                MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkTableKeyInRegion(tableKey, region);
                if (result != null) {
                    done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                    return;
                }
                if (parentTableName != null) {
                    if (tableType == PTableType.INDEX || this.allowSplittableSystemCatalogRollback) {
                        result = MetaDataEndpointImpl.checkTableKeyInRegion(parentTableKey, region);
                        if (result != null) {
                            LOGGER.error("Unable to lock parentTableKey " + Bytes.toStringBinary((byte[])parentTableKey));
                            MetaDataProtos.MutationCode code = tableType == PTableType.INDEX ? MetaDataProtos.MutationCode.TABLE_NOT_IN_REGION : MetaDataProtos.MutationCode.UNALLOWED_TABLE_MUTATION;
                            builder.setReturnCode(code);
                            builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                            done.run((Object)builder.build());
                            return;
                        }
                        this.acquireLock(region, parentTableKey, locks);
                    }
                    if (this.execeededIndexQuota(tableType, parentTable)) {
                        builder.setReturnCode(MetaDataProtos.MutationCode.TOO_MANY_INDEXES);
                        builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                        done.run((Object)builder.build());
                        return;
                    }
                }
                if (tableType != PTableType.VIEW) {
                    UpgradeUtil.addRowKeyOrderOptimizableCell(tableMetadata, tableKey, clientTimeStamp);
                }
                if (parentTable != null && parentTable.getAutoPartitionSeqName() != null) {
                    long autoPartitionNum = 1L;
                    try {
                        connection = QueryUtil.getConnectionOnServer(this.env.getConfiguration()).unwrap(PhoenixConnection.class);
                        Throwable throwable = null;
                        try (Statement stmt2 = connection.createStatement();){
                            String seqName = parentTable.getAutoPartitionSeqName();
                            String seqNextValueSql = String.format("SELECT NEXT VALUE FOR %s", seqName);
                            PhoenixStatement ps = stmt2.unwrap(PhoenixStatement.class);
                            QueryPlan plan = ps.compileQuery(seqNextValueSql);
                            ResultIterator resultIterator = plan.iterator();
                            PhoenixResultSet rs = ps.newResultSet(resultIterator, plan.getProjector(), plan.getContext());
                            rs.next();
                            autoPartitionNum = rs.getLong(1);
                        }
                        catch (Throwable stmt2) {
                            throwable = stmt2;
                            throw stmt2;
                        }
                        finally {
                            if (connection != null) {
                                if (throwable != null) {
                                    try {
                                        connection.close();
                                    }
                                    catch (Throwable stmt2) {
                                        throwable.addSuppressed(stmt2);
                                    }
                                } else {
                                    connection.close();
                                }
                            }
                        }
                    }
                    catch (SequenceNotFoundException e) {
                        builder.setReturnCode(MetaDataProtos.MutationCode.AUTO_PARTITION_SEQUENCE_NOT_FOUND);
                        builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                        done.run((Object)builder.build());
                        ServerUtil.releaseRowLocks(locks);
                        return;
                    }
                    PColumn autoPartitionCol = parentTable.getPKColumns().get(MetaDataUtil.getAutoPartitionColIndex(parentTable));
                    if (!PLong.INSTANCE.isCoercibleTo(autoPartitionCol.getDataType(), autoPartitionNum)) {
                        builder.setReturnCode(MetaDataProtos.MutationCode.CANNOT_COERCE_AUTO_PARTITION_ID);
                        builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                        done.run((Object)builder.build());
                        return;
                    }
                    builder.setAutoPartitionNum(autoPartitionNum);
                    tableHeaderPut = MetaDataUtil.getPutOnlyTableHeaderRow(tableMetadata);
                    NavigableMap familyCellMap = tableHeaderPut.getFamilyCellMap();
                    List cells = (List)familyCellMap.get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES);
                    Cell cell = (Cell)cells.get(0);
                    String autoPartitionWhere = QueryUtil.getViewPartitionClause(MetaDataUtil.getAutoPartitionColumnName(parentTable), autoPartitionNum);
                    String hbaseVersion = VersionInfo.getVersion();
                    ImmutableBytesPtr ptr = new ImmutableBytesPtr();
                    KeyValueBuilder kvBuilder = KeyValueBuilder.get(hbaseVersion);
                    MetaDataUtil.getMutationValue((Mutation)tableHeaderPut, PhoenixDatabaseMetaData.VIEW_STATEMENT_BYTES, kvBuilder, ptr);
                    byte[] value = ptr.copyBytesIfNecessary();
                    byte[] viewStatement = null;
                    viewStatement = !Bytes.equals((byte[])value, (byte[])QueryConstants.EMPTY_COLUMN_VALUE_BYTES) ? Bytes.add((byte[])value, (byte[])Bytes.toBytes((String)" AND "), (byte[])Bytes.toBytes((String)autoPartitionWhere)) : Bytes.toBytes((String)QueryUtil.getViewStatement(parentTable.getSchemaName().getString(), parentTable.getTableName().getString(), autoPartitionWhere));
                    Cell viewStatementCell = PhoenixKeyValueUtil.newKeyValue(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), PhoenixDatabaseMetaData.VIEW_STATEMENT_BYTES, 0, PhoenixDatabaseMetaData.VIEW_STATEMENT_BYTES.length, cell.getTimestamp(), viewStatement, 0, viewStatement.length, cell.getType());
                    cells.add(viewStatementCell);
                    Put autoPartitionPut = MetaDataUtil.getPutOnlyAutoPartitionColumn(parentTable, tableMetadata);
                    familyCellMap = autoPartitionPut.getFamilyCellMap();
                    cells = (List)familyCellMap.get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES);
                    cell = (Cell)cells.get(0);
                    PDataType dataType = autoPartitionCol.getDataType();
                    Object val = dataType.toObject(autoPartitionNum, (PDataType)PLong.INSTANCE);
                    byte[] bytes = new byte[dataType.getByteSize() + 1];
                    dataType.toBytes(val, bytes, 0);
                    Cell viewConstantCell = PhoenixKeyValueUtil.newKeyValue(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), PhoenixDatabaseMetaData.VIEW_CONSTANT_BYTES, 0, PhoenixDatabaseMetaData.VIEW_CONSTANT_BYTES.length, cell.getTimestamp(), bytes, 0, bytes.length, cell.getType());
                    cells.add(viewConstantCell);
                }
                Long indexId = null;
                if (request.hasAllocateIndexId() && request.getAllocateIndexId()) {
                    String tenantIdStr = tenantIdBytes.length == 0 ? null : Bytes.toString((byte[])tenantIdBytes);
                    connection = QueryUtil.getConnectionOnServer(this.env.getConfiguration()).unwrap(PhoenixConnection.class);
                    tableHeaderPut = null;
                    try {
                        PName physicalName = parentTable.getPhysicalName();
                        long seqValue = this.getViewIndexSequenceValue(connection, tenantIdStr, parentTable, physicalName);
                        Put tableHeaderPut2 = MetaDataUtil.getPutOnlyTableHeaderRow(tableMetadata);
                        NavigableMap familyCellMap = tableHeaderPut2.getFamilyCellMap();
                        List cells = (List)familyCellMap.get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES);
                        Cell cell = (Cell)cells.get(0);
                        PDataType<?> dataType = MetaDataUtil.getIndexDataType(tableMetadata, GenericKeyValueBuilder.INSTANCE, new ImmutableBytesWritable());
                        Object val = dataType.toObject(seqValue, (PDataType)PLong.INSTANCE);
                        byte[] bytes = new byte[dataType.getByteSize() + 1];
                        dataType.toBytes(val, bytes, 0);
                        Cell indexIdCell = PhoenixKeyValueUtil.newKeyValue(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), PhoenixDatabaseMetaData.VIEW_INDEX_ID_BYTES, 0, PhoenixDatabaseMetaData.VIEW_INDEX_ID_BYTES.length, cell.getTimestamp(), bytes, 0, bytes.length, cell.getType());
                        cells.add(indexIdCell);
                        indexId = seqValue;
                    }
                    catch (Throwable physicalName) {
                        tableHeaderPut = physicalName;
                        throw physicalName;
                    }
                    finally {
                        if (connection != null) {
                            if (tableHeaderPut != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable physicalName) {
                                    tableHeaderPut.addSuppressed(physicalName);
                                }
                            } else {
                                connection.close();
                            }
                        }
                    }
                }
                if (tableType == PTableType.VIEW) {
                    List<Mutation> childLinkMutations;
                    MetaDataProtos.MetaDataResponse response;
                    if (clientVersion < MIN_SPLITTABLE_SYSTEM_CATALOG && ViewUtil.getSystemTableForChildLinks(clientVersion, this.env.getConfiguration()).equals((Object)SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME_BYTES, this.env.getConfiguration())) && (response = this.processRemoteRegionMutations(PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME_BYTES, childLinkMutations = MetaDataUtil.removeChildLinkMutations(tableMetadata), MetaDataProtos.MutationCode.UNABLE_TO_CREATE_CHILD_LINK)) != null) {
                        done.run((Object)response);
                        return;
                    }
                    ViewUtil.addTagsToPutsForViewAlteredProperties(tableMetadata, parentTable, (ExtendedCellBuilder)this.env.getCellBuilder());
                }
                if (MetaDataUtil.isTableDirectlyQueried(tableType)) {
                    tableMetadata.add((Mutation)MetaDataUtil.getLastDDLTimestampUpdate(tableKey, clientTimeStamp, EnvironmentEdgeManager.currentTimeMillis()));
                }
                ArrayList localMutations = Lists.newArrayListWithExpectedSize((int)tableMetadata.size());
                ArrayList remoteMutations = Lists.newArrayListWithExpectedSize((int)2);
                this.separateLocalAndRemoteMutations(region, tableMetadata, localMutations, remoteMutations);
                if (!remoteMutations.isEmpty()) {
                    if (parentTable != null && tableType == PTableType.VIEW && parentTable.getEncodingScheme() != PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS) {
                        MetaDataProtos.MetaDataResponse response = this.processRemoteRegionMutations(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, remoteMutations, MetaDataProtos.MutationCode.UNABLE_TO_UPDATE_PARENT_TABLE);
                        this.clearRemoteTableFromCache(clientTimeStamp, parentTable.getSchemaName() != null ? parentTable.getSchemaName().getBytes() : ByteUtil.EMPTY_BYTE_ARRAY, parentTable.getTableName().getBytes());
                        if (response != null) {
                            done.run((Object)response);
                            return;
                        }
                    } else {
                        String msg = "Found unexpected mutations while creating " + fullTableName;
                        LOGGER.error(msg);
                        for (Mutation m : remoteMutations) {
                            LOGGER.debug("Mutation rowkey : " + Bytes.toStringBinary((byte[])m.getRow()));
                            LOGGER.debug("Mutation family cell map : " + m.getFamilyCellMap());
                        }
                        throw new IllegalStateException(msg);
                    }
                }
                MetaDataEndpointImpl.mutateRowsWithLocks(this.accessCheckEnabled, region, localMutations, Collections.emptySet(), 0L, 0L);
                Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
                if (parentTableKey != null) {
                    metaDataCache.invalidate((Object)new ImmutableBytesPtr(parentTableKey));
                }
                metaDataCache.invalidate((Object)cacheKey);
                long currentTimeStamp = MetaDataUtil.getClientTimeStamp(tableMetadata);
                builder.setReturnCode(MetaDataProtos.MutationCode.TABLE_NOT_FOUND);
                if (indexId != null) {
                    builder.setViewIndexId(indexId);
                    builder.setViewIndexIdType(PLong.INSTANCE.getSqlType());
                }
                builder.setMutationTime(currentTimeStamp);
                PTable newTable = this.buildTable(tableKey, cacheKey, region, clientTimeStamp, clientVersion);
                if (newTable != null) {
                    builder.setTable(PTableImpl.toProto(newTable));
                }
                done.run((Object)builder.build());
            }
            finally {
                ServerUtil.releaseRowLocks(locks);
            }
        }
        catch (Throwable t) {
            LOGGER.error("createTable failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(fullTableName, t));
        }
    }

    private long getViewIndexSequenceValue(PhoenixConnection connection, String tenantIdStr, PTable parentTable, PName physicalName) throws SQLException {
        int nSequenceSaltBuckets = connection.getQueryServices().getSequenceSaltBuckets();
        SequenceKey key = MetaDataUtil.getViewIndexSequenceKey(tenantIdStr, physicalName, nSequenceSaltBuckets, parentTable.isNamespaceMapped());
        long sequenceTimestamp = Long.MAX_VALUE;
        try {
            connection.getQueryServices().createSequence(key.getTenantId(), key.getSchemaName(), key.getSequenceName(), -32768L, 1L, 1L, Long.MIN_VALUE, Long.MAX_VALUE, false, sequenceTimestamp);
        }
        catch (SequenceAlreadyExistsException sequenceAlreadyExistsException) {
            // empty catch block
        }
        long[] seqValues = new long[1];
        SQLException[] sqlExceptions = new SQLException[1];
        connection.getQueryServices().incrementSequences(Collections.singletonList(new SequenceAllocation(key, 1L)), Long.MAX_VALUE, seqValues, sqlExceptions);
        if (sqlExceptions[0] != null) {
            throw sqlExceptions[0];
        }
        return seqValues[0];
    }

    private boolean execeededIndexQuota(PTableType tableType, PTable parentTable) {
        return PTableType.INDEX == tableType && parentTable.getIndexes().size() >= this.maxIndexesPerTable;
    }

    private void separateLocalAndRemoteMutations(Region region, List<Mutation> mutations, List<Mutation> localMutations, List<Mutation> remoteMutations) {
        RegionInfo regionInfo = region.getRegionInfo();
        for (Mutation mutation : mutations) {
            if (regionInfo.containsRow(mutation.getRow())) {
                localMutations.add(mutation);
                continue;
            }
            remoteMutations.add(mutation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropTable(RpcController controller, MetaDataProtos.DropTableRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
        boolean isCascade = request.getCascade();
        byte[][] rowKeyMetaData = new byte[3][];
        String tableType = request.getTableType();
        byte[] schemaName = null;
        byte[] tableOrViewName = null;
        boolean dropTableStats = false;
        int clientVersion = request.getClientVersion();
        try {
            PTable loadedTable;
            byte[] parentLockKey;
            byte[] parentTableName;
            MetaDataProtocol.MetaDataMutationResult result;
            Region region;
            byte[] lockKey;
            ArrayList sharedTablesToDelete;
            ArrayList tableNamesToDelete;
            byte[] tenantIdBytes;
            ArrayList childLinkMutations;
            List<Mutation> tableMetadata;
            block55: {
                tableMetadata = ProtobufUtil.getMutations(request);
                childLinkMutations = Lists.newArrayList();
                MetaDataUtil.getTenantIdAndSchemaAndTableName(tableMetadata, rowKeyMetaData);
                tenantIdBytes = rowKeyMetaData[0];
                schemaName = rowKeyMetaData[1];
                tableOrViewName = rowKeyMetaData[2];
                PTableType pTableType = PTableType.fromSerializedValue(tableType);
                if (pTableType == PTableType.SYSTEM) {
                    builder.setReturnCode(MetaDataProtos.MutationCode.UNALLOWED_TABLE_MUTATION);
                    builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                    done.run((Object)builder.build());
                    return;
                }
                tableNamesToDelete = Lists.newArrayList();
                sharedTablesToDelete = Lists.newArrayList();
                lockKey = SchemaUtil.getTableKey(tenantIdBytes, schemaName, tableOrViewName);
                result = MetaDataEndpointImpl.checkTableKeyInRegion(lockKey, region = this.env.getRegion());
                if (result != null) {
                    done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                    return;
                }
                parentTableName = MetaDataUtil.getParentTableName(tableMetadata);
                parentLockKey = null;
                if (parentTableName != null && pTableType == PTableType.INDEX && (result = MetaDataEndpointImpl.checkTableKeyInRegion(parentLockKey = SchemaUtil.getTableKey(tenantIdBytes, schemaName, parentTableName), region)) != null) {
                    done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                    return;
                }
                long clientTimeStamp = MetaDataUtil.getClientTimeStamp(tableMetadata);
                loadedTable = this.doGetTable(tenantIdBytes, schemaName, tableOrViewName, clientTimeStamp, null, request.getClientVersion());
                if (loadedTable == null) {
                    builder.setReturnCode(MetaDataProtos.MutationCode.TABLE_NOT_FOUND);
                    builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                    done.run((Object)builder.build());
                    return;
                }
                this.getCoprocessorHost().preDropTable(Bytes.toString((byte[])tenantIdBytes), SchemaUtil.getTableName(schemaName, tableOrViewName), TableName.valueOf((byte[])loadedTable.getPhysicalName().getBytes()), this.getParentPhysicalTableName(loadedTable), pTableType, loadedTable.getIndexes());
                if (pTableType == PTableType.TABLE || pTableType == PTableType.VIEW) {
                    try (Table hTable = ServerUtil.getHTableForCoprocessorScan(this.env, ViewUtil.getSystemTableForChildLinks(clientVersion, this.env.getConfiguration()));){
                        Pair<List<PTable>, List<TableInfo>> descendantViews = ViewUtil.findAllDescendantViews(hTable, this.env.getConfiguration(), tenantIdBytes, schemaName, tableOrViewName, clientTimeStamp, true);
                        List legitimateChildViews = (List)descendantViews.getFirst();
                        List orphanChildViews = (List)descendantViews.getSecond();
                        if (!legitimateChildViews.isEmpty()) {
                            if (!isCascade) {
                                LOGGER.error("DROP without CASCADE on tables or views with child views is not permitted");
                                builder.setReturnCode(MetaDataProtos.MutationCode.UNALLOWED_TABLE_MUTATION);
                                builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                                done.run((Object)builder.build());
                                return;
                            }
                            if (clientVersion < MIN_SPLITTABLE_SYSTEM_CATALOG && !SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME_BYTES, this.env.getConfiguration()).equals((Object)hTable.getName())) {
                                LOGGER.error("Dropping a table or view that has child views is not permitted for old clients connecting to a new server with old metadata (even if CASCADE is provided). Please upgrade the client at least to  5.1.0");
                                builder.setReturnCode(MetaDataProtos.MutationCode.UNALLOWED_TABLE_MUTATION);
                                builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                                done.run((Object)builder.build());
                                return;
                            }
                        }
                        if (!isCascade || legitimateChildViews.isEmpty() && orphanChildViews.isEmpty() || clientVersion < MIN_SPLITTABLE_SYSTEM_CATALOG && !SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME_BYTES, this.env.getConfiguration()).equals((Object)hTable.getName())) break block55;
                        try {
                            PhoenixConnection conn = QueryUtil.getConnectionOnServer(this.env.getConfiguration()).unwrap(PhoenixConnection.class);
                            Object object = null;
                            try {
                                Task.addTask(new SystemTaskParams.SystemTaskParamsBuilder().setConn(conn).setTaskType(PTable.TaskType.DROP_CHILD_VIEWS).setTenantId(Bytes.toString((byte[])tenantIdBytes)).setSchemaName(Bytes.toString((byte[])schemaName)).setTableName(Bytes.toString((byte[])tableOrViewName)).setTaskStatus(PTable.TaskStatus.CREATED.toString()).setData(null).setPriority(null).setStartTs(null).setEndTs(null).setAccessCheckEnabled(this.accessCheckEnabled).build());
                            }
                            catch (Throwable throwable) {
                                object = throwable;
                                throw throwable;
                            }
                            finally {
                                if (conn != null) {
                                    if (object != null) {
                                        try {
                                            conn.close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)object).addSuppressed(throwable);
                                        }
                                    } else {
                                        conn.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable t) {
                            LOGGER.error("Adding a task to drop child views failed!", t);
                        }
                    }
                }
            }
            ArrayList locks = Lists.newArrayList();
            try {
                MetaDataProtos.MetaDataResponse response;
                this.acquireLock(region, lockKey, locks);
                if (parentLockKey != null) {
                    this.acquireLock(region, parentLockKey, locks);
                }
                ArrayList<ImmutableBytesPtr> invalidateList = new ArrayList<ImmutableBytesPtr>();
                result = this.doDropTable(lockKey, tenantIdBytes, schemaName, tableOrViewName, parentTableName, PTableType.fromSerializedValue(tableType), tableMetadata, childLinkMutations, invalidateList, tableNamesToDelete, sharedTablesToDelete, request.getClientVersion());
                if (result.getMutationCode() != MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
                    done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                    return;
                }
                Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
                ArrayList localMutations = Lists.newArrayListWithExpectedSize((int)tableMetadata.size());
                ArrayList remoteMutations = Lists.newArrayList();
                this.separateLocalAndRemoteMutations(region, tableMetadata, localMutations, remoteMutations);
                if (!remoteMutations.isEmpty()) {
                    String msg = "Found unexpected mutations while dropping table " + SchemaUtil.getTableName(schemaName, tableOrViewName);
                    LOGGER.error(msg);
                    for (Mutation m : remoteMutations) {
                        LOGGER.debug("Mutation rowkey : " + Bytes.toStringBinary((byte[])m.getRow()));
                        LOGGER.debug("Mutation family cell map : " + m.getFamilyCellMap());
                    }
                    throw new IllegalStateException(msg);
                }
                MetaDataEndpointImpl.mutateRowsWithLocks(this.accessCheckEnabled, region, localMutations, Collections.emptySet(), 0L, 0L);
                long currentTime = MetaDataUtil.getClientTimeStamp(tableMetadata);
                for (ImmutableBytesPtr ckey : invalidateList) {
                    metaDataCache.put((Object)ckey, (Object)MetaDataEndpointImpl.newDeletedTableMarker(currentTime));
                }
                if (parentLockKey != null) {
                    ImmutableBytesPtr parentCacheKey = new ImmutableBytesPtr(parentLockKey);
                    metaDataCache.invalidate((Object)parentCacheKey);
                }
                if ((response = this.processRemoteRegionMutations(ViewUtil.getSystemTableForChildLinks(request.getClientVersion(), this.env.getConfiguration()).getName(), childLinkMutations, MetaDataProtos.MutationCode.UNABLE_TO_DELETE_CHILD_LINK)) != null) {
                    done.run((Object)response);
                    return;
                }
                done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                dropTableStats = true;
            }
            finally {
                ServerUtil.releaseRowLocks(locks);
                if (dropTableStats) {
                    Thread statsDeleteHandler = new Thread((Runnable)new StatsDeleteHandler(this.env, loadedTable, tableNamesToDelete, sharedTablesToDelete), "thread-statsdeletehandler");
                    statsDeleteHandler.setDaemon(true);
                    statsDeleteHandler.start();
                }
            }
        }
        catch (Throwable t) {
            LOGGER.error("dropTable failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(SchemaUtil.getTableName(schemaName, tableOrViewName), t));
        }
    }

    private Region.RowLock acquireLock(Region region, byte[] lockKey, List<Region.RowLock> locks) throws IOException {
        Region.RowLock rowLock = region.getRowLock(lockKey, false);
        if (rowLock == null) {
            throw new IOException("Failed to acquire lock on " + Bytes.toStringBinary((byte[])lockKey));
        }
        if (locks != null) {
            locks.add(rowLock);
        }
        return rowLock;
    }

    private MetaDataProtos.MetaDataResponse processRemoteRegionMutations(byte[] systemTableName, List<Mutation> remoteMutations, MetaDataProtos.MutationCode mutationCode) throws IOException {
        if (remoteMutations.isEmpty()) {
            return null;
        }
        MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
        try (Table hTable = ServerUtil.getHTableForCoprocessorScan(this.env, SchemaUtil.getPhysicalTableName(systemTableName, this.env.getConfiguration()));){
            hTable.batch(remoteMutations, null);
        }
        catch (Throwable t) {
            LOGGER.error("Unable to write mutations to " + Bytes.toString((byte[])systemTableName), t);
            builder.setReturnCode(mutationCode);
            builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
            return builder.build();
        }
        return null;
    }

    private MetaDataProtocol.MetaDataMutationResult doDropTable(byte[] key, byte[] tenantId, byte[] schemaName, byte[] tableName, byte[] parentTableName, PTableType tableType, List<Mutation> catalogMutations, List<Mutation> childLinkMutations, List<ImmutableBytesPtr> invalidateList, List<byte[]> tableNamesToDelete, List<MetaDataProtocol.SharedTableState> sharedTablesToDelete, int clientVersion) throws IOException, SQLException {
        Region region = this.env.getRegion();
        ImmutableBytesPtr cacheKey = new ImmutableBytesPtr(key);
        long clientTimeStamp = MetaDataUtil.getClientTimeStamp(catalogMutations);
        PTable table = this.getTableFromCache(cacheKey, clientTimeStamp, clientVersion);
        if (table != null || (table = this.buildTable(key, cacheKey, region, Long.MAX_VALUE, clientVersion)) != null) {
            if (table.getTimeStamp() < clientTimeStamp) {
                if (MetaDataEndpointImpl.isTableDeleted(table) || tableType != table.getType()) {
                    return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
                }
            } else {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.NEWER_TABLE_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
            }
        }
        if (table == null) {
            if (this.buildDeletedTable(key, cacheKey, region, clientTimeStamp) != null) {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.NEWER_TABLE_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
            }
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
        }
        if (parentTableName != null && table.getParentTableName() != null && !Arrays.equals(parentTableName, table.getParentTableName().getBytes())) {
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
        }
        Scan scan = MetaDataUtil.newTableRowsScan(key, 0L, clientTimeStamp);
        ArrayList indexNames = Lists.newArrayList();
        ArrayList results = Lists.newArrayList();
        try (RegionScanner scanner = region.getScanner(scan);){
            scanner.next((List)results);
            if (results.isEmpty()) {
                MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
                return metaDataMutationResult;
            }
            if (tableType == PTableType.INDEX && table.getViewIndexId() != null) {
                sharedTablesToDelete.add(new MetaDataProtocol.SharedTableState(table));
            } else if (tableType != PTableType.VIEW) {
                tableNamesToDelete.add(table.getPhysicalName().getBytes());
            }
            invalidateList.add(cacheKey);
            byte[][] rowKeyMetaData = new byte[5][];
            do {
                Cell kv;
                int nColumns;
                if ((nColumns = SchemaUtil.getVarChars((kv = (Cell)results.get(0)).getRowArray(), kv.getRowOffset(), kv.getRowLength(), 0, rowKeyMetaData)) == 5 && rowKeyMetaData[4].length > 0 && Bytes.compareTo((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength(), (byte[])PhoenixDatabaseMetaData.LINK_TYPE_BYTES, (int)0, (int)PhoenixDatabaseMetaData.LINK_TYPE_BYTES.length) == 0) {
                    PTable.LinkType linkType = PTable.LinkType.fromSerializedValue(kv.getValueArray()[kv.getValueOffset()]);
                    if (rowKeyMetaData[3].length == 0 && linkType == PTable.LinkType.INDEX_TABLE) {
                        indexNames.add(rowKeyMetaData[4]);
                    } else if (tableType == PTableType.VIEW && (linkType == PTable.LinkType.PARENT_TABLE || linkType == PTable.LinkType.PHYSICAL_TABLE)) {
                        Cell parentTenantIdCell = MetaDataUtil.getCell(results, PhoenixDatabaseMetaData.PARENT_TENANT_ID_BYTES);
                        PName parentTenantId = parentTenantIdCell != null ? PNameFactory.newName(parentTenantIdCell.getValueArray(), parentTenantIdCell.getValueOffset(), parentTenantIdCell.getValueLength()) : null;
                        byte[] linkKey = MetaDataUtil.getChildLinkKey(parentTenantId, table.getParentSchemaName(), table.getParentTableName(), table.getTenantId(), table.getName());
                        Delete linkDelete = new Delete(linkKey, clientTimeStamp);
                        childLinkMutations.add((Mutation)linkDelete);
                    }
                }
                Delete delete = new Delete(kv.getRowArray(), kv.getRowOffset(), (int)kv.getRowLength(), clientTimeStamp);
                catalogMutations.add((Mutation)delete);
                results.clear();
                scanner.next((List)results);
            } while (!results.isEmpty());
        }
        for (byte[] indexName : indexNames) {
            byte[] indexKey = SchemaUtil.getTableKey(tenantId, schemaName, indexName);
            Delete delete = new Delete(indexKey, clientTimeStamp);
            catalogMutations.add((Mutation)delete);
            MetaDataProtocol.MetaDataMutationResult result = this.doDropTable(indexKey, tenantId, schemaName, indexName, tableName, PTableType.INDEX, catalogMutations, childLinkMutations, invalidateList, tableNamesToDelete, sharedTablesToDelete, clientVersion);
            if (result.getMutationCode() == MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) continue;
            return result;
        }
        if (clientVersion < MIN_SPLITTABLE_SYSTEM_CATALOG && tableType == PTableType.VIEW) {
            var22_21 = null;
            try (PhoenixConnection connection = QueryUtil.getConnectionOnServer(this.env.getConfiguration()).unwrap(PhoenixConnection.class);){
                PTable pTable = PhoenixRuntime.getTableNoCache(connection, table.getParentName().getString());
                table = ViewUtil.addDerivedColumnsAndIndexesFromParent(connection, table, pTable);
            }
            catch (Throwable throwable) {
                var22_21 = throwable;
                throw throwable;
            }
        }
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS, EnvironmentEdgeManager.currentTimeMillis(), table, tableNamesToDelete, sharedTablesToDelete);
    }

    private Optional<MetaDataProtocol.MetaDataMutationResult> validateIfMutationAllowedOnParent(PTable parentTable, List<Mutation> tableMetadata, PTableType expectedType, long clientTimeStamp, byte[] tenantId, byte[] schemaName, byte[] tableOrViewName, List<PTable> childViews, int clientVersion) throws IOException, SQLException {
        MetaDataProtocol.MetaDataMutationResult metaDataMutationResult;
        boolean isMutationAllowed = true;
        boolean isSchemaMutationAllowed = true;
        if (expectedType == PTableType.TABLE || expectedType == PTableType.VIEW) {
            try (Table hTable = ServerUtil.getHTableForCoprocessorScan(this.env, ViewUtil.getSystemTableForChildLinks(clientVersion, this.env.getConfiguration()));){
                childViews.addAll((Collection)ViewUtil.findAllDescendantViews(hTable, this.env.getConfiguration(), tenantId, schemaName, tableOrViewName, clientTimeStamp, false).getFirst());
            }
            if (!childViews.isEmpty()) {
                if (clientVersion < MIN_SPLITTABLE_SYSTEM_CATALOG) {
                    isMutationAllowed = false;
                    LOGGER.error("Unable to add or drop a column as the client is older than {}", (Object)"5.1.0");
                } else if (this.allowSplittableSystemCatalogRollback) {
                    isMutationAllowed = false;
                    LOGGER.error("Unable to add or drop a column as the {} config is set to true", (Object)"phoenix.allow.system.catalog.rollback");
                }
            }
            if (expectedType == PTableType.VIEW) {
                isSchemaMutationAllowed = this.validatePhoenixTTLAttributeSettingForView(parentTable, childViews, tableMetadata, PhoenixDatabaseMetaData.PHOENIX_TTL_BYTES);
            }
        }
        if (!isMutationAllowed) {
            metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), null);
            return Optional.of(metaDataMutationResult);
        }
        if (!isSchemaMutationAllowed) {
            metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.UNALLOWED_SCHEMA_MUTATION, EnvironmentEdgeManager.currentTimeMillis(), null);
            return Optional.of(metaDataMutationResult);
        }
        return Optional.empty();
    }

    /*
     * Exception decompiling
     */
    private MetaDataProtocol.MetaDataMutationResult mutateColumn(List<Mutation> tableMetadata, ColumnMutator mutator, int clientVersion, PTable parentTable, boolean isAddingOrDroppingColumns) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [27[TRYBLOCK]], but top level block is 60[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void clearRemoteTableFromCache(long clientTimeStamp, byte[] schemaName, byte[] tableName) throws SQLException {
        Properties props = new Properties();
        if (clientTimeStamp != Long.MAX_VALUE) {
            props.setProperty("CurrentSCN", Long.toString(clientTimeStamp));
        }
        try (PhoenixConnection connection = QueryUtil.getConnectionOnServer(props, this.env.getConfiguration()).unwrap(PhoenixConnection.class);){
            ConnectionQueryServices queryServices = connection.getQueryServices();
            queryServices.clearTableFromCache(ByteUtil.EMPTY_BYTE_ARRAY, schemaName, tableName, clientTimeStamp);
        }
    }

    private boolean validatePhoenixTTLAttributeSettingForView(PTable parentTable, List<PTable> childViews, List<Mutation> tableMetadata, byte[] phoenixTtlBytes) {
        boolean hasNewPhoenixTTLAttribute = false;
        boolean isSchemaMutationAllowed = true;
        for (Mutation m : tableMetadata) {
            Put p;
            List cells;
            if (!(m instanceof Put) || (cells = (p = (Put)m).get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, phoenixTtlBytes)) == null || cells.size() <= 0) continue;
            Cell cell = (Cell)cells.get(0);
            long newPhoenixTTL = (Long)PLong.INSTANCE.toObject(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            hasNewPhoenixTTLAttribute = newPhoenixTTL != 0L;
        }
        if (hasNewPhoenixTTLAttribute) {
            if (parentTable != null && parentTable.getPhoenixTTL() != 0L) {
                isSchemaMutationAllowed = false;
            }
            if (!childViews.isEmpty()) {
                isSchemaMutationAllowed = false;
            }
        }
        return isSchemaMutationAllowed;
    }

    @Override
    public void addColumn(RpcController controller, MetaDataProtos.AddColumnRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        try {
            List<Mutation> tableMetaData = ProtobufUtil.getMutations(request);
            PTable parentTable = request.hasParentTable() ? PTableImpl.createFromProto(request.getParentTable()) : null;
            boolean addingColumns = request.getAddingColumns();
            MetaDataProtocol.MetaDataMutationResult result = this.mutateColumn(tableMetaData, new AddColumnMutator(), request.getClientVersion(), parentTable, addingColumns);
            if (result != null) {
                done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
            }
        }
        catch (Throwable e) {
            LOGGER.error("Add column failed: ", e);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException("Error when adding column: ", e));
        }
    }

    private PTable doGetTable(byte[] tenantId, byte[] schemaName, byte[] tableName, long clientTimeStamp, int clientVersion) throws IOException, SQLException {
        return this.doGetTable(tenantId, schemaName, tableName, clientTimeStamp, null, clientVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PTable doGetTable(byte[] tenantId, byte[] schemaName, byte[] tableName, long clientTimeStamp, Region.RowLock rowLock, int clientVersion) throws IOException, SQLException {
        Region region = this.env.getRegion();
        byte[] key = SchemaUtil.getTableKey(tenantId, schemaName, tableName);
        if (!region.getRegionInfo().containsRow(key)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.GET_TABLE_ERROR).setSchemaName(Bytes.toString((byte[])schemaName)).setTableName(Bytes.toString((byte[])tableName)).build().buildException();
        }
        ImmutableBytesPtr cacheKey = new ImmutableBytesPtr(key);
        boolean wasLocked = rowLock != null;
        try {
            if (!wasLocked) {
                rowLock = this.acquireLock(region, key, null);
            }
            PTable table = this.getTableFromCache(cacheKey, clientTimeStamp, clientVersion);
            if ((table = this.modifyIndexStateForOldClient(clientVersion, table)) != null && table.getTimeStamp() < clientTimeStamp) {
                if (MetaDataEndpointImpl.isTableDeleted(table)) {
                    PTable pTable = null;
                    return pTable;
                }
                PTable pTable = table;
                return pTable;
            }
            table = this.buildTable(key, cacheKey, region, Long.MAX_VALUE, clientVersion);
            if (table != null && table.getTimeStamp() <= clientTimeStamp || this.blockWriteRebuildIndex && table.getIndexDisableTimestamp() > 0L) {
                PTable pTable = table;
                return pTable;
            }
            PTable pTable = table = this.buildTable(key, cacheKey, region, clientTimeStamp, clientVersion);
            return pTable;
        }
        finally {
            if (!wasLocked && rowLock != null) {
                rowLock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PFunction> doGetFunctions(List<byte[]> keys, long clientTimeStamp) throws IOException, SQLException {
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        Region region = this.env.getRegion();
        Collections.sort(keys, new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                return Bytes.compareTo((byte[])o1, (byte[])o2);
            }
        });
        ArrayList<Region.RowLock> rowLocks = new ArrayList<Region.RowLock>(keys.size());
        try {
            ArrayList<PFunction> arrayList;
            Object key;
            for (int i = 0; i < keys.size(); ++i) {
                this.acquireLock(region, keys.get(i), rowLocks);
            }
            ArrayList<PFunction> functionsAvailable = new ArrayList<PFunction>(keys.size());
            int numFunctions = keys.size();
            Iterator<byte[]> iterator = keys.iterator();
            while (iterator.hasNext()) {
                key = iterator.next();
                PFunction function = (PFunction)metaDataCache.getIfPresent((Object)new GlobalCache.FunctionBytesPtr((byte[])key));
                if (function == null || function.getTimeStamp() >= clientTimeStamp) continue;
                if (MetaDataEndpointImpl.isFunctionDeleted(function)) {
                    List<PFunction> list = null;
                    return list;
                }
                functionsAvailable.add(function);
                iterator.remove();
            }
            if (functionsAvailable.size() == numFunctions) {
                key = functionsAvailable;
                return key;
            }
            List<PFunction> buildFunctions = this.buildFunctions(keys, region, clientTimeStamp, false, Collections.emptyList());
            if (buildFunctions == null || buildFunctions.isEmpty()) {
                arrayList = null;
                return arrayList;
            }
            functionsAvailable.addAll(buildFunctions);
            if (functionsAvailable.size() == numFunctions) {
                arrayList = functionsAvailable;
                return arrayList;
            }
            arrayList = null;
            return arrayList;
        }
        finally {
            ServerUtil.releaseRowLocks(rowLocks);
        }
    }

    @Override
    public void dropColumn(RpcController controller, MetaDataProtos.DropColumnRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        List<Mutation> tableMetaData = null;
        ArrayList tableNamesToDelete = Lists.newArrayList();
        ArrayList sharedTablesToDelete = Lists.newArrayList();
        try {
            tableMetaData = ProtobufUtil.getMutations(request);
            PTable parentTable = request.hasParentTable() ? PTableImpl.createFromProto(request.getParentTable()) : null;
            MetaDataProtocol.MetaDataMutationResult result = this.mutateColumn(tableMetaData, new DropColumnMutator(this.env.getConfiguration()), request.getClientVersion(), parentTable, true);
            if (result != null) {
                done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
            }
        }
        catch (Throwable e) {
            LOGGER.error("Drop column failed: ", e);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException("Error when dropping column: ", e));
        }
    }

    private MetaDataProtocol.MetaDataMutationResult dropIndexes(RegionCoprocessorEnvironment env, PTable table, List<ImmutableBytesPtr> invalidateList, List<Region.RowLock> locks, long clientTimeStamp, List<Mutation> tableMetaData, PColumn columnToDelete, List<byte[]> tableNamesToDelete, List<MetaDataProtocol.SharedTableState> sharedTablesToDelete, int clientVersion) throws IOException, SQLException {
        Region region = env.getRegion();
        PhoenixConnection connection = table.getIndexes().isEmpty() ? null : QueryUtil.getConnectionOnServer(env.getConfiguration()).unwrap(PhoenixConnection.class);
        for (PTable index : table.getIndexes()) {
            if (index.getName().getString().contains("#")) continue;
            byte[] tenantId = index.getTenantId() == null ? ByteUtil.EMPTY_BYTE_ARRAY : index.getTenantId().getBytes();
            IndexMaintainer indexMaintainer = index.getIndexMaintainer(table, connection);
            byte[] indexKey = SchemaUtil.getTableKey(tenantId, index.getSchemaName().getBytes(), index.getTableName().getBytes());
            Pair columnToDeleteInfo = new Pair((Object)columnToDelete.getFamilyName().getString(), (Object)columnToDelete.getName().getString());
            ColumnReference colDropRef = new ColumnReference(columnToDelete.getFamilyName().getBytes(), columnToDelete.getColumnQualifierBytes());
            boolean isColumnIndexed = indexMaintainer.getIndexedColumnInfo().contains(columnToDeleteInfo);
            boolean isCoveredColumn = indexMaintainer.getCoveredColumns().contains(colDropRef);
            if (isColumnIndexed) {
                Delete delete = new Delete(indexKey, clientTimeStamp);
                byte[] linkKey = MetaDataUtil.getParentLinkKey(tenantId, table.getSchemaName().getBytes(), table.getTableName().getBytes(), index.getTableName().getBytes());
                Delete linkDelete = new Delete(linkKey, clientTimeStamp);
                tableMetaData.add((Mutation)delete);
                tableMetaData.add((Mutation)linkDelete);
                this.acquireLock(region, indexKey, locks);
                ArrayList childLinksMutations = Lists.newArrayList();
                MetaDataProtocol.MetaDataMutationResult result = this.doDropTable(indexKey, tenantId, index.getSchemaName().getBytes(), index.getTableName().getBytes(), table.getName().getBytes(), index.getType(), tableMetaData, childLinksMutations, invalidateList, tableNamesToDelete, sharedTablesToDelete, clientVersion);
                if (result.getMutationCode() != MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
                    return result;
                }
                if (!childLinksMutations.isEmpty()) {
                    LOGGER.error("Found unexpected child link mutations while dropping an index " + childLinksMutations);
                }
                invalidateList.add(new ImmutableBytesPtr(indexKey));
                continue;
            }
            if (!isCoveredColumn) continue;
            invalidateList.add(new ImmutableBytesPtr(indexKey));
        }
        if (connection != null) {
            connection.close();
        }
        return null;
    }

    private MetaDataProtocol.MetaDataMutationResult dropRemoteIndexes(RegionCoprocessorEnvironment env, PTable table, long clientTimeStamp, PColumn columnToDelete, List<byte[]> tableNamesToDelete, List<MetaDataProtocol.SharedTableState> sharedTablesToDelete) throws SQLException {
        PhoenixConnection connection = table.getIndexes().isEmpty() ? null : QueryUtil.getConnectionOnServer(env.getConfiguration()).unwrap(PhoenixConnection.class);
        for (PTable index : table.getIndexes()) {
            byte[] tenantId = index.getTenantId() == null ? ByteUtil.EMPTY_BYTE_ARRAY : index.getTenantId().getBytes();
            IndexMaintainer indexMaintainer = index.getIndexMaintainer(table, connection);
            byte[] indexKey = SchemaUtil.getTableKey(tenantId, index.getSchemaName().getBytes(), index.getTableName().getBytes());
            Pair columnToDeleteInfo = new Pair((Object)columnToDelete.getFamilyName().getString(), (Object)columnToDelete.getName().getString());
            ColumnReference colDropRef = new ColumnReference(columnToDelete.getFamilyName().getBytes(), columnToDelete.getColumnQualifierBytes());
            boolean isColumnIndexed = indexMaintainer.getIndexedColumnInfo().contains(columnToDeleteInfo);
            boolean isCoveredColumn = indexMaintainer.getCoveredColumns().contains(colDropRef);
            if (isColumnIndexed) {
                ConnectionQueryServices queryServices;
                MetaDataProtocol.MetaDataMutationResult result;
                Delete delete = new Delete(indexKey, clientTimeStamp);
                byte[] linkKey = MetaDataUtil.getParentLinkKey(tenantId, table.getSchemaName().getBytes(), table.getTableName().getBytes(), index.getTableName().getBytes());
                Delete linkDelete = new Delete(linkKey, clientTimeStamp);
                ArrayList remoteDropMetadata = Lists.newArrayListWithExpectedSize((int)2);
                remoteDropMetadata.add(delete);
                remoteDropMetadata.add(linkDelete);
                Properties props = new Properties();
                if (tenantId != null) {
                    props.setProperty("TenantId", Bytes.toString((byte[])tenantId));
                }
                if (clientTimeStamp != Long.MAX_VALUE) {
                    props.setProperty("CurrentSCN", Long.toString(clientTimeStamp));
                }
                if ((result = (queryServices = connection.getQueryServices()).dropTable(remoteDropMetadata, PTableType.INDEX, false)).getTableNamesToDelete() != null && !result.getTableNamesToDelete().isEmpty()) {
                    tableNamesToDelete.addAll(result.getTableNamesToDelete());
                }
                if (result.getSharedTablesToDelete() != null && !result.getSharedTablesToDelete().isEmpty()) {
                    sharedTablesToDelete.addAll(result.getSharedTablesToDelete());
                }
                if (result.getMutationCode() == MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) continue;
                return result;
            }
            if (!isCoveredColumn) continue;
            this.clearRemoteTableFromCache(clientTimeStamp, index.getSchemaName() != null ? index.getSchemaName().getBytes() : ByteUtil.EMPTY_BYTE_ARRAY, index.getTableName().getBytes());
        }
        if (connection != null) {
            connection.close();
        }
        return null;
    }

    @Override
    public void clearCache(RpcController controller, MetaDataProtos.ClearCacheRequest request, RpcCallback<MetaDataProtos.ClearCacheResponse> done) {
        GlobalCache cache = GlobalCache.getInstance(this.env);
        Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
        metaDataCache.invalidateAll();
        long unfreedBytes = cache.clearTenantCache();
        MetaDataProtos.ClearCacheResponse.Builder builder = MetaDataProtos.ClearCacheResponse.newBuilder();
        builder.setUnfreedBytes(unfreedBytes);
        done.run((Object)builder.build());
    }

    @Override
    public void getVersion(RpcController controller, MetaDataProtos.GetVersionRequest request, RpcCallback<MetaDataProtos.GetVersionResponse> done) {
        PTable systemCatalog;
        long version;
        MetaDataProtos.GetVersionResponse.Builder builder;
        block6: {
            builder = MetaDataProtos.GetVersionResponse.newBuilder();
            Configuration config = this.env.getConfiguration();
            if (this.isTablesMappingEnabled && MetaDataProtocol.MIN_NAMESPACE_MAPPED_PHOENIX_VERSION > request.getClientVersion()) {
                LOGGER.error("Old client is not compatible when system tables are upgraded to map to namespace");
                ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.isTablesMappingEnabled).toString(), (Throwable)new DoNotRetryIOException("Old client is not compatible when system tables are upgraded to map to namespace")));
            }
            version = MetaDataUtil.encodeVersion(this.env.getHBaseVersion(), config);
            systemCatalog = null;
            try {
                systemCatalog = this.doGetTable(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.SYSTEM_CATALOG_SCHEMA_BYTES, PhoenixDatabaseMetaData.SYSTEM_CATALOG_TABLE_BYTES, Long.MAX_VALUE, null, request.getClientVersion());
            }
            catch (Throwable t) {
                boolean isErrorSwallowed = false;
                if (t instanceof SQLException && ((SQLException)t).getErrorCode() == SQLExceptionCode.GET_TABLE_ERROR.getErrorCode()) {
                    Region region = this.env.getRegion();
                    byte[] key = SchemaUtil.getTableKey(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.SYSTEM_CATALOG_SCHEMA_BYTES, PhoenixDatabaseMetaData.SYSTEM_CATALOG_TABLE_BYTES);
                    if (!region.getRegionInfo().containsRow(key) && request.getClientVersion() < MIN_SPLITTABLE_SYSTEM_CATALOG) {
                        LOGGER.debug("The pre-4.15 client is trying to get SYSTEM.CATALOG region that contains head row");
                        isErrorSwallowed = true;
                    }
                }
                if (isErrorSwallowed) break block6;
                LOGGER.error("loading system catalog table inside getVersion failed", t);
                ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.isTablesMappingEnabled).toString(), t));
            }
        }
        if (systemCatalog != null) {
            builder.setSystemCatalogTimestamp(systemCatalog.getTimeStamp());
        }
        builder.setVersion(version);
        done.run((Object)builder.build());
    }

    /*
     * Exception decompiling
     */
    @Override
    public void updateIndexState(RpcController controller, MetaDataProtos.UpdateIndexStateRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 76[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static MetaDataProtocol.MetaDataMutationResult checkKeyInRegion(byte[] key, Region region, MetaDataProtocol.MutationCode code) {
        return ServerUtil.isKeyInRegion(key, region) ? null : new MetaDataProtocol.MetaDataMutationResult(code, EnvironmentEdgeManager.currentTimeMillis(), null);
    }

    private static MetaDataProtocol.MetaDataMutationResult checkTableKeyInRegion(byte[] key, Region region) {
        MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkKeyInRegion(key, region, MetaDataProtocol.MutationCode.TABLE_NOT_IN_REGION);
        if (result != null) {
            LOGGER.error("Table rowkey " + Bytes.toStringBinary((byte[])key) + " is not in the current region " + region.getRegionInfo());
        }
        return result;
    }

    private static MetaDataProtocol.MetaDataMutationResult checkFunctionKeyInRegion(byte[] key, Region region) {
        return MetaDataEndpointImpl.checkKeyInRegion(key, region, MetaDataProtocol.MutationCode.FUNCTION_NOT_IN_REGION);
    }

    private static MetaDataProtocol.MetaDataMutationResult checkSchemaKeyInRegion(byte[] key, Region region) {
        return MetaDataEndpointImpl.checkKeyInRegion(key, region, MetaDataProtocol.MutationCode.SCHEMA_NOT_IN_REGION);
    }

    @Override
    public void clearTableFromCache(RpcController controller, MetaDataProtos.ClearTableFromCacheRequest request, RpcCallback<MetaDataProtos.ClearTableFromCacheResponse> done) {
        byte[] schemaName = request.getSchemaName().toByteArray();
        byte[] tableName = request.getTableName().toByteArray();
        try {
            byte[] tenantId = request.getTenantId().toByteArray();
            byte[] key = SchemaUtil.getTableKey(tenantId, schemaName, tableName);
            ImmutableBytesPtr cacheKey = new ImmutableBytesPtr(key);
            Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
            metaDataCache.invalidate((Object)cacheKey);
        }
        catch (Throwable t) {
            LOGGER.error("clearTableFromCache failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(SchemaUtil.getTableName(schemaName, tableName), t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getSchema(RpcController controller, MetaDataProtos.GetSchemaRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
        Region region = this.env.getRegion();
        String schemaName = request.getSchemaName();
        byte[] lockKey = SchemaUtil.getSchemaKey(schemaName);
        MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkSchemaKeyInRegion(lockKey, region);
        if (result != null) {
            done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
            return;
        }
        long clientTimeStamp = request.getClientTimestamp();
        ArrayList locks = Lists.newArrayList();
        try {
            this.getCoprocessorHost().preGetSchema(schemaName);
            this.acquireLock(region, lockKey, locks);
            ImmutableBytesPtr cacheKey = new ImmutableBytesPtr(lockKey);
            PSchema schema = this.loadSchema(this.env, lockKey, cacheKey, clientTimeStamp, clientTimeStamp);
            if (schema != null && schema.getTimeStamp() < clientTimeStamp) {
                if (!MetaDataEndpointImpl.isSchemaDeleted(schema)) {
                    builder.setReturnCode(MetaDataProtos.MutationCode.SCHEMA_ALREADY_EXISTS);
                    builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                    builder.setSchema(PSchema.toProto(schema));
                    done.run((Object)builder.build());
                    return;
                }
                builder.setReturnCode(MetaDataProtos.MutationCode.NEWER_SCHEMA_FOUND);
                builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                builder.setSchema(PSchema.toProto(schema));
                done.run((Object)builder.build());
                return;
            }
        }
        catch (Exception e) {
            long currentTime = EnvironmentEdgeManager.currentTimeMillis();
            builder.setReturnCode(MetaDataProtos.MutationCode.SCHEMA_NOT_FOUND);
            builder.setMutationTime(currentTime);
            done.run((Object)builder.build());
            return;
        }
        finally {
            ServerUtil.releaseRowLocks(locks);
        }
    }

    @Override
    public void getFunctions(RpcController controller, MetaDataProtos.GetFunctionsRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
        byte[] tenantId = request.getTenantId().toByteArray();
        ArrayList<String> functionNames = new ArrayList<String>(request.getFunctionNamesCount());
        try {
            Region region = this.env.getRegion();
            List<ByteString> functionNamesList = request.getFunctionNamesList();
            List<Long> functionTimestampsList = request.getFunctionTimestampsList();
            ArrayList<byte[]> keys = new ArrayList<byte[]>(request.getFunctionNamesCount());
            ArrayList<Pair> functions = new ArrayList<Pair>(request.getFunctionNamesCount());
            for (int i = 0; i < functionNamesList.size(); ++i) {
                byte[] functionName = functionNamesList.get(i).toByteArray();
                functionNames.add(Bytes.toString((byte[])functionName));
                byte[] key = SchemaUtil.getFunctionKey(tenantId, functionName);
                MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkFunctionKeyInRegion(key, region);
                if (result != null) {
                    done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                    return;
                }
                functions.add(new Pair((Object)functionName, (Object)functionTimestampsList.get(i)));
                keys.add(key);
            }
            long currentTime = EnvironmentEdgeManager.currentTimeMillis();
            List<PFunction> functionsAvailable = this.doGetFunctions(keys, request.getClientTimestamp());
            if (functionsAvailable == null) {
                builder.setReturnCode(MetaDataProtos.MutationCode.FUNCTION_NOT_FOUND);
                builder.setMutationTime(currentTime);
                done.run((Object)builder.build());
                return;
            }
            builder.setReturnCode(MetaDataProtos.MutationCode.FUNCTION_ALREADY_EXISTS);
            builder.setMutationTime(currentTime);
            for (PFunction function : functionsAvailable) {
                builder.addFunction(PFunction.toProto(function));
            }
            done.run((Object)builder.build());
            return;
        }
        catch (Throwable t) {
            LOGGER.error("getFunctions failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(((Object)functionNames).toString(), t));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createFunction(RpcController controller, MetaDataProtos.CreateFunctionRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
        byte[][] rowKeyMetaData = new byte[2][];
        byte[] functionName = null;
        try {
            List<Mutation> functionMetaData = ProtobufUtil.getMutations(request);
            boolean temporaryFunction = request.getTemporary();
            MetaDataUtil.getTenantIdAndFunctionName(functionMetaData, rowKeyMetaData);
            byte[] tenantIdBytes = rowKeyMetaData[0];
            functionName = rowKeyMetaData[1];
            byte[] lockKey = SchemaUtil.getFunctionKey(tenantIdBytes, functionName);
            Region region = this.env.getRegion();
            MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkFunctionKeyInRegion(lockKey, region);
            if (result != null) {
                done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            ArrayList locks = Lists.newArrayList();
            long clientTimeStamp = MetaDataUtil.getClientTimeStamp(functionMetaData);
            try {
                this.acquireLock(region, lockKey, locks);
                GlobalCache.FunctionBytesPtr cacheKey = new GlobalCache.FunctionBytesPtr(lockKey);
                PFunction function = this.loadFunction(this.env, lockKey, cacheKey, clientTimeStamp, clientTimeStamp, request.getReplace(), functionMetaData);
                if (function != null) {
                    if (function.getTimeStamp() < clientTimeStamp) {
                        if (!MetaDataEndpointImpl.isFunctionDeleted(function)) {
                            builder.setReturnCode(MetaDataProtos.MutationCode.FUNCTION_ALREADY_EXISTS);
                            builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                            builder.addFunction(PFunction.toProto(function));
                            done.run((Object)builder.build());
                            if (!request.getReplace()) {
                                return;
                            }
                        }
                    } else {
                        builder.setReturnCode(MetaDataProtos.MutationCode.NEWER_FUNCTION_FOUND);
                        builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                        builder.addFunction(PFunction.toProto(function));
                        done.run((Object)builder.build());
                        return;
                    }
                }
                if (!temporaryFunction) {
                    MetaDataEndpointImpl.mutateRowsWithLocks(this.accessCheckEnabled, region, functionMetaData, Collections.emptySet(), 0L, 0L);
                }
                Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
                metaDataCache.invalidate((Object)cacheKey);
                long currentTimeStamp = MetaDataUtil.getClientTimeStamp(functionMetaData);
                builder.setReturnCode(MetaDataProtos.MutationCode.FUNCTION_NOT_FOUND);
                builder.setMutationTime(currentTimeStamp);
                done.run((Object)builder.build());
                return;
            }
            finally {
                ServerUtil.releaseRowLocks(locks);
            }
        }
        catch (Throwable t) {
            LOGGER.error("createFunction failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(Bytes.toString(functionName), t));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropFunction(RpcController controller, MetaDataProtos.DropFunctionRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        byte[][] rowKeyMetaData = new byte[2][];
        byte[] functionName = null;
        try {
            List<Mutation> functionMetaData = ProtobufUtil.getMutations(request);
            MetaDataUtil.getTenantIdAndFunctionName(functionMetaData, rowKeyMetaData);
            byte[] tenantIdBytes = rowKeyMetaData[0];
            functionName = rowKeyMetaData[1];
            byte[] lockKey = SchemaUtil.getFunctionKey(tenantIdBytes, functionName);
            Region region = this.env.getRegion();
            MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkFunctionKeyInRegion(lockKey, region);
            if (result != null) {
                done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            ArrayList locks = Lists.newArrayList();
            long clientTimeStamp = MetaDataUtil.getClientTimeStamp(functionMetaData);
            try {
                this.acquireLock(region, lockKey, locks);
                ArrayList<byte[]> keys = new ArrayList<byte[]>(1);
                keys.add(lockKey);
                ArrayList<ImmutableBytesPtr> invalidateList = new ArrayList<ImmutableBytesPtr>();
                result = this.doDropFunction(clientTimeStamp, keys, functionMetaData, invalidateList);
                if (result.getMutationCode() != MetaDataProtocol.MutationCode.FUNCTION_ALREADY_EXISTS) {
                    done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                    return;
                }
                MetaDataEndpointImpl.mutateRowsWithLocks(this.accessCheckEnabled, region, functionMetaData, Collections.emptySet(), 0L, 0L);
                Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
                long currentTime = MetaDataUtil.getClientTimeStamp(functionMetaData);
                for (ImmutableBytesPtr ptr : invalidateList) {
                    metaDataCache.invalidate((Object)ptr);
                    metaDataCache.put((Object)ptr, (Object)MetaDataEndpointImpl.newDeletedFunctionMarker(currentTime));
                }
                done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            finally {
                ServerUtil.releaseRowLocks(locks);
            }
        }
        catch (Throwable t) {
            LOGGER.error("dropFunction failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(Bytes.toString(functionName), t));
            return;
        }
    }

    private MetaDataProtocol.MetaDataMutationResult doDropFunction(long clientTimeStamp, List<byte[]> keys, List<Mutation> functionMetaData, List<ImmutableBytesPtr> invalidateList) throws IOException, SQLException {
        ArrayList<byte[]> keysClone = new ArrayList<byte[]>(keys);
        List<PFunction> functions = this.doGetFunctions(keysClone, clientTimeStamp);
        if (functions == null || functions.isEmpty()) {
            if (this.buildDeletedFunction(keys.get(0), new GlobalCache.FunctionBytesPtr(keys.get(0)), this.env.getRegion(), clientTimeStamp) != null) {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_ALREADY_EXISTS, EnvironmentEdgeManager.currentTimeMillis(), null);
            }
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
        }
        if (functions != null && !functions.isEmpty() && functions.get(0).getTimeStamp() < clientTimeStamp) {
            if (MetaDataEndpointImpl.isFunctionDeleted(functions.get(0))) {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
            }
            invalidateList.add(new GlobalCache.FunctionBytesPtr(keys.get(0)));
            Region region = this.env.getRegion();
            Scan scan = MetaDataUtil.newTableRowsScan(keys.get(0), 0L, clientTimeStamp);
            ArrayList results = Lists.newArrayList();
            try (RegionScanner scanner = region.getScanner(scan);){
                scanner.next((List)results);
                if (results.isEmpty()) {
                    MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
                    return metaDataMutationResult;
                }
                do {
                    Cell kv = (Cell)results.get(0);
                    Delete delete = new Delete(kv.getRowArray(), kv.getRowOffset(), (int)kv.getRowLength(), clientTimeStamp);
                    functionMetaData.add((Mutation)delete);
                    results.clear();
                    scanner.next((List)results);
                } while (!results.isEmpty());
            }
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_ALREADY_EXISTS, EnvironmentEdgeManager.currentTimeMillis(), functions, true);
        }
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSchema(RpcController controller, MetaDataProtos.CreateSchemaRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
        String schemaName = null;
        try {
            List<Mutation> schemaMutations = ProtobufUtil.getMutations(request);
            schemaName = request.getSchemaName();
            Put m = MetaDataUtil.getPutOnlyTableHeaderRow(schemaMutations);
            byte[] lockKey = m.getRow();
            Region region = this.env.getRegion();
            MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkSchemaKeyInRegion(lockKey, region);
            if (result != null) {
                done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            ArrayList locks = Lists.newArrayList();
            long clientTimeStamp = MetaDataUtil.getClientTimeStamp(schemaMutations);
            try {
                this.acquireLock(region, lockKey, locks);
                ImmutableBytesPtr cacheKey = new ImmutableBytesPtr(lockKey);
                PSchema schema = this.loadSchema(this.env, lockKey, cacheKey, clientTimeStamp, clientTimeStamp);
                if (schema != null) {
                    if (schema.getTimeStamp() < clientTimeStamp) {
                        if (!MetaDataEndpointImpl.isSchemaDeleted(schema)) {
                            builder.setReturnCode(MetaDataProtos.MutationCode.SCHEMA_ALREADY_EXISTS);
                            builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                            builder.setSchema(PSchema.toProto(schema));
                            done.run((Object)builder.build());
                            return;
                        }
                    } else {
                        builder.setReturnCode(MetaDataProtos.MutationCode.NEWER_SCHEMA_FOUND);
                        builder.setMutationTime(EnvironmentEdgeManager.currentTimeMillis());
                        builder.setSchema(PSchema.toProto(schema));
                        done.run((Object)builder.build());
                        return;
                    }
                }
                MetaDataEndpointImpl.mutateRowsWithLocks(this.accessCheckEnabled, region, schemaMutations, Collections.emptySet(), 0L, 0L);
                Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
                if (cacheKey != null) {
                    metaDataCache.invalidate((Object)cacheKey);
                }
                long currentTimeStamp = MetaDataUtil.getClientTimeStamp(schemaMutations);
                builder.setReturnCode(MetaDataProtos.MutationCode.SCHEMA_NOT_FOUND);
                builder.setMutationTime(currentTimeStamp);
                done.run((Object)builder.build());
                return;
            }
            finally {
                ServerUtil.releaseRowLocks(locks);
            }
        }
        catch (Throwable t) {
            LOGGER.error("Creating the schema" + schemaName + "failed", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(schemaName, t));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropSchema(RpcController controller, MetaDataProtos.DropSchemaRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
        String schemaName = null;
        try {
            List<Mutation> schemaMetaData = ProtobufUtil.getMutations(request);
            schemaName = request.getSchemaName();
            this.getCoprocessorHost().preDropSchema(schemaName);
            byte[] lockKey = SchemaUtil.getSchemaKey(schemaName);
            Region region = this.env.getRegion();
            MetaDataProtocol.MetaDataMutationResult result = MetaDataEndpointImpl.checkSchemaKeyInRegion(lockKey, region);
            if (result != null) {
                done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            ArrayList locks = Lists.newArrayList();
            long clientTimeStamp = MetaDataUtil.getClientTimeStamp(schemaMetaData);
            try {
                this.acquireLock(region, lockKey, locks);
                ArrayList<ImmutableBytesPtr> invalidateList = new ArrayList<ImmutableBytesPtr>(1);
                result = this.doDropSchema(clientTimeStamp, schemaName, lockKey, schemaMetaData, invalidateList);
                if (result.getMutationCode() != MetaDataProtocol.MutationCode.SCHEMA_ALREADY_EXISTS) {
                    done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                    return;
                }
                MetaDataEndpointImpl.mutateRowsWithLocks(this.accessCheckEnabled, region, schemaMetaData, Collections.emptySet(), 0L, 0L);
                Cache<ImmutableBytesPtr, PMetaDataEntity> metaDataCache = GlobalCache.getInstance(this.env).getMetaDataCache();
                long currentTime = MetaDataUtil.getClientTimeStamp(schemaMetaData);
                for (ImmutableBytesPtr ptr : invalidateList) {
                    metaDataCache.invalidate((Object)ptr);
                    metaDataCache.put((Object)ptr, (Object)MetaDataEndpointImpl.newDeletedSchemaMarker(currentTime));
                }
                done.run((Object)MetaDataProtocol.MetaDataMutationResult.toProto(result));
                return;
            }
            finally {
                ServerUtil.releaseRowLocks(locks);
            }
        }
        catch (Throwable t) {
            LOGGER.error("drop schema failed:", t);
            ProtobufUtil.setControllerException(controller, ServerUtil.createIOException(schemaName, t));
            return;
        }
    }

    private MetaDataProtocol.MetaDataMutationResult doDropSchema(long clientTimeStamp, String schemaName, byte[] key, List<Mutation> schemaMutations, List<ImmutableBytesPtr> invalidateList) throws IOException, SQLException {
        PSchema schema = this.loadSchema(this.env, key, new ImmutableBytesPtr(key), clientTimeStamp, clientTimeStamp);
        boolean areTablesExists = false;
        if (schema == null) {
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.SCHEMA_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
        }
        if (schema.getTimeStamp() < clientTimeStamp) {
            Region region = this.env.getRegion();
            Scan scan = MetaDataUtil.newTableRowsScan(SchemaUtil.getKeyForSchema(null, schemaName), 0L, clientTimeStamp);
            ArrayList results = Lists.newArrayList();
            try (RegionScanner scanner = region.getScanner(scan);){
                scanner.next((List)results);
                if (results.isEmpty()) {
                    MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.SCHEMA_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
                    return metaDataMutationResult;
                }
                do {
                    Cell kv;
                    if (Bytes.compareTo((byte[])(kv = (Cell)results.get(0)).getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength(), (byte[])key, (int)0, (int)key.length) != 0) {
                        areTablesExists = true;
                        break;
                    }
                    results.clear();
                    scanner.next((List)results);
                } while (!results.isEmpty());
            }
            if (areTablesExists) {
                return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLES_EXIST_ON_SCHEMA, schema, EnvironmentEdgeManager.currentTimeMillis());
            }
            invalidateList.add(new ImmutableBytesPtr(key));
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.SCHEMA_ALREADY_EXISTS, schema, EnvironmentEdgeManager.currentTimeMillis());
        }
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.SCHEMA_NOT_FOUND, EnvironmentEdgeManager.currentTimeMillis(), null);
    }

    static void mutateRowsWithLocks(boolean accessCheckEnabled, final Region region, final List<Mutation> mutations, final Set<byte[]> rowsToLock, final long nonceGroup, final long nonce) throws IOException {
        if (accessCheckEnabled) {
            User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    RpcCall rpcContext = RpcUtil.getRpcContext();
                    try {
                        RpcUtil.setRpcContext(null);
                        region.mutateRowsWithLocks((Collection)mutations, (Collection)rowsToLock, nonceGroup, nonce);
                    }
                    catch (Throwable e) {
                        throw new IOException(e);
                    }
                    finally {
                        RpcUtil.setRpcContext(rpcContext);
                    }
                    return null;
                }
            });
        } else {
            region.mutateRowsWithLocks(mutations, rowsToLock, nonceGroup, nonce);
        }
    }

    private TableName getParentPhysicalTableName(PTable table) {
        return table.getType() == PTableType.VIEW || table.getType() == PTableType.INDEX && table.getViewIndexId() != null ? TableName.valueOf((byte[])table.getPhysicalName().getBytes()) : (table.getType() == PTableType.INDEX ? TableName.valueOf((byte[])SchemaUtil.getPhysicalHBaseTableName(table.getParentSchemaName(), table.getParentTableName(), table.isNamespaceMapped()).getBytes()) : TableName.valueOf((byte[])SchemaUtil.getPhysicalHBaseTableName(table.getSchemaName(), table.getTableName(), table.isNamespaceMapped()).getBytes()));
    }

    static {
        Collections.sort(TABLE_KV_COLUMNS, CellComparatorImpl.COMPARATOR);
        TABLE_TYPE_INDEX = TABLE_KV_COLUMNS.indexOf(TABLE_TYPE_KV);
        TABLE_SEQ_NUM_INDEX = TABLE_KV_COLUMNS.indexOf(TABLE_SEQ_NUM_KV);
        COLUMN_COUNT_INDEX = TABLE_KV_COLUMNS.indexOf(COLUMN_COUNT_KV);
        SALT_BUCKETS_INDEX = TABLE_KV_COLUMNS.indexOf(SALT_BUCKETS_KV);
        PK_NAME_INDEX = TABLE_KV_COLUMNS.indexOf(PK_NAME_KV);
        DATA_TABLE_NAME_INDEX = TABLE_KV_COLUMNS.indexOf(DATA_TABLE_NAME_KV);
        INDEX_STATE_INDEX = TABLE_KV_COLUMNS.indexOf(INDEX_STATE_KV);
        IMMUTABLE_ROWS_INDEX = TABLE_KV_COLUMNS.indexOf(IMMUTABLE_ROWS_KV);
        VIEW_STATEMENT_INDEX = TABLE_KV_COLUMNS.indexOf(VIEW_EXPRESSION_KV);
        DEFAULT_COLUMN_FAMILY_INDEX = TABLE_KV_COLUMNS.indexOf(DEFAULT_COLUMN_FAMILY_KV);
        DISABLE_WAL_INDEX = TABLE_KV_COLUMNS.indexOf(DISABLE_WAL_KV);
        MULTI_TENANT_INDEX = TABLE_KV_COLUMNS.indexOf(MULTI_TENANT_KV);
        VIEW_TYPE_INDEX = TABLE_KV_COLUMNS.indexOf(VIEW_TYPE_KV);
        VIEW_INDEX_ID_DATA_TYPE_INDEX = TABLE_KV_COLUMNS.indexOf(VIEW_INDEX_ID_DATA_TYPE_BYTES_KV);
        VIEW_INDEX_ID_INDEX = TABLE_KV_COLUMNS.indexOf(VIEW_INDEX_ID_KV);
        INDEX_TYPE_INDEX = TABLE_KV_COLUMNS.indexOf(INDEX_TYPE_KV);
        STORE_NULLS_INDEX = TABLE_KV_COLUMNS.indexOf(STORE_NULLS_KV);
        BASE_COLUMN_COUNT_INDEX = TABLE_KV_COLUMNS.indexOf(BASE_COLUMN_COUNT_KV);
        ROW_KEY_ORDER_OPTIMIZABLE_INDEX = TABLE_KV_COLUMNS.indexOf(ROW_KEY_ORDER_OPTIMIZABLE_KV);
        TRANSACTIONAL_INDEX = TABLE_KV_COLUMNS.indexOf(TRANSACTIONAL_KV);
        TRANSACTION_PROVIDER_INDEX = TABLE_KV_COLUMNS.indexOf(TRANSACTION_PROVIDER_KV);
        UPDATE_CACHE_FREQUENCY_INDEX = TABLE_KV_COLUMNS.indexOf(UPDATE_CACHE_FREQUENCY_KV);
        INDEX_DISABLE_TIMESTAMP = TABLE_KV_COLUMNS.indexOf(INDEX_DISABLE_TIMESTAMP_KV);
        IS_NAMESPACE_MAPPED_INDEX = TABLE_KV_COLUMNS.indexOf(IS_NAMESPACE_MAPPED_KV);
        AUTO_PARTITION_SEQ_INDEX = TABLE_KV_COLUMNS.indexOf(AUTO_PARTITION_SEQ_KV);
        APPEND_ONLY_SCHEMA_INDEX = TABLE_KV_COLUMNS.indexOf(APPEND_ONLY_SCHEMA_KV);
        STORAGE_SCHEME_INDEX = TABLE_KV_COLUMNS.indexOf(STORAGE_SCHEME_KV);
        QUALIFIER_ENCODING_SCHEME_INDEX = TABLE_KV_COLUMNS.indexOf(ENCODING_SCHEME_KV);
        USE_STATS_FOR_PARALLELIZATION_INDEX = TABLE_KV_COLUMNS.indexOf(USE_STATS_FOR_PARALLELIZATION_KV);
        PHOENIX_TTL_INDEX = TABLE_KV_COLUMNS.indexOf(PHOENIX_TTL_KV);
        PHOENIX_TTL_HWM_INDEX = TABLE_KV_COLUMNS.indexOf(PHOENIX_TTL_HWM_KV);
        LAST_DDL_TIMESTAMP_INDEX = TABLE_KV_COLUMNS.indexOf(LAST_DDL_TIMESTAMP_KV);
        CHANGE_DETECTION_ENABLED_INDEX = TABLE_KV_COLUMNS.indexOf(CHANGE_DETECTION_ENABLED_KV);
        DECIMAL_DIGITS_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.DECIMAL_DIGITS_BYTES);
        COLUMN_SIZE_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.COLUMN_SIZE_BYTES);
        NULLABLE_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.NULLABLE_BYTES);
        DATA_TYPE_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.DATA_TYPE_BYTES);
        ORDINAL_POSITION_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.ORDINAL_POSITION_BYTES);
        SORT_ORDER_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.SORT_ORDER_BYTES);
        ARRAY_SIZE_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.ARRAY_SIZE_BYTES);
        VIEW_CONSTANT_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.VIEW_CONSTANT_BYTES);
        IS_VIEW_REFERENCED_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.IS_VIEW_REFERENCED_BYTES);
        COLUMN_DEF_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.COLUMN_DEF_BYTES);
        IS_ROW_TIMESTAMP_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.IS_ROW_TIMESTAMP_BYTES);
        COLUMN_QUALIFIER_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.COLUMN_QUALIFIER_BYTES);
        LINK_TYPE_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.LINK_TYPE_BYTES);
        COLUMN_KV_COLUMNS = Lists.newArrayList((Object[])new Cell[]{DECIMAL_DIGITS_KV, COLUMN_SIZE_KV, NULLABLE_KV, DATA_TYPE_KV, ORDINAL_POSITION_KV, SORT_ORDER_KV, DATA_TABLE_NAME_KV, ARRAY_SIZE_KV, VIEW_CONSTANT_KV, IS_VIEW_REFERENCED_KV, COLUMN_DEF_KV, IS_ROW_TIMESTAMP_KV, COLUMN_QUALIFIER_KV, LINK_TYPE_KV});
        COLUMN_KV_COLUMNS.sort((Comparator<Cell>)CellComparator.getInstance());
        QUALIFIER_COUNTER_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.COLUMN_QUALIFIER_COUNTER_BYTES);
        DECIMAL_DIGITS_INDEX = COLUMN_KV_COLUMNS.indexOf(DECIMAL_DIGITS_KV);
        COLUMN_SIZE_INDEX = COLUMN_KV_COLUMNS.indexOf(COLUMN_SIZE_KV);
        NULLABLE_INDEX = COLUMN_KV_COLUMNS.indexOf(NULLABLE_KV);
        DATA_TYPE_INDEX = COLUMN_KV_COLUMNS.indexOf(DATA_TYPE_KV);
        ORDINAL_POSITION_INDEX = COLUMN_KV_COLUMNS.indexOf(ORDINAL_POSITION_KV);
        SORT_ORDER_INDEX = COLUMN_KV_COLUMNS.indexOf(SORT_ORDER_KV);
        ARRAY_SIZE_INDEX = COLUMN_KV_COLUMNS.indexOf(ARRAY_SIZE_KV);
        VIEW_CONSTANT_INDEX = COLUMN_KV_COLUMNS.indexOf(VIEW_CONSTANT_KV);
        IS_VIEW_REFERENCED_INDEX = COLUMN_KV_COLUMNS.indexOf(IS_VIEW_REFERENCED_KV);
        COLUMN_DEF_INDEX = COLUMN_KV_COLUMNS.indexOf(COLUMN_DEF_KV);
        IS_ROW_TIMESTAMP_INDEX = COLUMN_KV_COLUMNS.indexOf(IS_ROW_TIMESTAMP_KV);
        COLUMN_QUALIFIER_INDEX = COLUMN_KV_COLUMNS.indexOf(COLUMN_QUALIFIER_KV);
        EXCLUDED_COLUMN_LINK_TYPE_KV_INDEX = COLUMN_KV_COLUMNS.indexOf(LINK_TYPE_KV);
        VIEW_MODIFIED_PROPERTY_BYTES = TagUtil.fromList((List)ImmutableList.of((Object)new ArrayBackedTag(70, Bytes.toBytes((int)1))));
        CLASS_NAME_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.CLASS_NAME_BYTES);
        JAR_PATH_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.JAR_PATH_BYTES);
        RETURN_TYPE_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.RETURN_TYPE_BYTES);
        NUM_ARGS_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.NUM_ARGS_BYTES);
        TYPE_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.TYPE_BYTES);
        IS_CONSTANT_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.IS_CONSTANT_BYTES);
        DEFAULT_VALUE_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.DEFAULT_VALUE_BYTES);
        MIN_VALUE_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.MIN_VALUE_BYTES);
        MAX_VALUE_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.MAX_VALUE_BYTES);
        IS_ARRAY_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.IS_ARRAY_BYTES);
        FUNCTION_KV_COLUMNS = Arrays.asList(EMPTY_KEYVALUE_KV, CLASS_NAME_KV, JAR_PATH_KV, RETURN_TYPE_KV, NUM_ARGS_KV);
        Collections.sort(FUNCTION_KV_COLUMNS, CellComparatorImpl.COMPARATOR);
        CLASS_NAME_INDEX = FUNCTION_KV_COLUMNS.indexOf(CLASS_NAME_KV);
        JAR_PATH_INDEX = FUNCTION_KV_COLUMNS.indexOf(JAR_PATH_KV);
        RETURN_TYPE_INDEX = FUNCTION_KV_COLUMNS.indexOf(RETURN_TYPE_KV);
        NUM_ARGS_INDEX = FUNCTION_KV_COLUMNS.indexOf(NUM_ARGS_KV);
        FUNCTION_ARG_KV_COLUMNS = Arrays.asList(TYPE_KV, IS_ARRAY_KV, IS_CONSTANT_KV, DEFAULT_VALUE_KV, MIN_VALUE_KV, MAX_VALUE_KV);
        Collections.sort(FUNCTION_ARG_KV_COLUMNS, CellComparatorImpl.COMPARATOR);
        IS_ARRAY_INDEX = FUNCTION_ARG_KV_COLUMNS.indexOf(IS_ARRAY_KV);
        IS_CONSTANT_INDEX = FUNCTION_ARG_KV_COLUMNS.indexOf(IS_CONSTANT_KV);
        DEFAULT_VALUE_INDEX = FUNCTION_ARG_KV_COLUMNS.indexOf(DEFAULT_VALUE_KV);
        MIN_VALUE_INDEX = FUNCTION_ARG_KV_COLUMNS.indexOf(MIN_VALUE_KV);
        MAX_VALUE_INDEX = FUNCTION_ARG_KV_COLUMNS.indexOf(MAX_VALUE_KV);
        failConcurrentMutateAddColumnOneTimeForTesting = false;
    }

    private static class ViewInfo {
        private byte[] tenantId;
        private byte[] schemaName;
        private byte[] viewName;

        public ViewInfo(byte[] tenantId, byte[] schemaName, byte[] viewName) {
            this.tenantId = tenantId;
            this.schemaName = schemaName;
            this.viewName = viewName;
        }

        public byte[] getTenantId() {
            return this.tenantId;
        }

        public byte[] getSchemaName() {
            return this.schemaName;
        }

        public byte[] getViewName() {
            return this.viewName;
        }
    }

    public static class ColumnFinder
    extends StatelessTraverseAllExpressionVisitor<Void> {
        private boolean columnFound;
        private final Expression columnExpression;

        public ColumnFinder(Expression columnExpression) {
            this.columnExpression = columnExpression;
            this.columnFound = false;
        }

        private Void process(Expression expression) {
            if (expression.equals(this.columnExpression)) {
                this.columnFound = true;
            }
            return null;
        }

        @Override
        public Void visit(KeyValueColumnExpression expression) {
            return this.process(expression);
        }

        @Override
        public Void visit(RowKeyColumnExpression expression) {
            return this.process(expression);
        }

        @Override
        public Void visit(ProjectedColumnExpression expression) {
            return this.process(expression);
        }

        public boolean getColumnFound() {
            return this.columnFound;
        }
    }

    private static class StatsDeleteHandler
    implements Runnable {
        PTable deletedTable;
        List<byte[]> physicalTableNames;
        List<MetaDataProtocol.SharedTableState> sharedTableStates;
        RegionCoprocessorEnvironment env;

        StatsDeleteHandler(RegionCoprocessorEnvironment env, PTable deletedTable, List<byte[]> physicalTableNames, List<MetaDataProtocol.SharedTableState> sharedTableStates) {
            this.deletedTable = deletedTable;
            this.physicalTableNames = physicalTableNames;
            this.sharedTableStates = sharedTableStates;
            this.env = env;
        }

        @Override
        public void run() {
            try {
                User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        try (PhoenixConnection connection = QueryUtil.getConnectionOnServer(env.getConfiguration()).unwrap(PhoenixConnection.class);){
                            try {
                                MetaDataUtil.deleteFromStatsTable(connection, deletedTable, physicalTableNames, sharedTableStates);
                                LOGGER.info("Table stats deleted successfully, tablename is {}.", (Object)deletedTable.getPhysicalName().getString());
                            }
                            catch (Throwable t) {
                                LOGGER.warn("Exception while deleting stats of table " + deletedTable.getPhysicalName().getString() + " please check and delete stats manually");
                            }
                        }
                        return null;
                    }
                });
            }
            catch (IOException e) {
                LOGGER.warn("Exception while deleting stats of table " + this.deletedTable.getPhysicalName().getString() + " please check and delete stats manually");
            }
        }
    }
}

