/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.phoenix.coprocessor.BaseRegionScanner;
import org.apache.phoenix.filter.PagedFilter;
import org.apache.phoenix.util.ScanUtil;

public class PagedRegionScanner
extends BaseRegionScanner {
    protected Region region;
    protected Scan scan;
    protected PagedFilter pageFilter;

    public PagedRegionScanner(Region region, RegionScanner scanner, Scan scan) {
        super(scanner);
        this.region = region;
        this.scan = scan;
        this.pageFilter = ScanUtil.getPhoenixPagedFilter(scan);
        if (this.pageFilter != null) {
            this.pageFilter.init();
        }
    }

    private boolean next(List<Cell> results, boolean raw) throws IOException {
        try {
            boolean hasMore;
            boolean bl = hasMore = raw ? this.delegate.nextRaw(results) : this.delegate.next(results);
            if (this.pageFilter == null) {
                return hasMore;
            }
            if (!hasMore) {
                if (this.pageFilter.isStopped()) {
                    this.delegate.close();
                    byte[] rowKey = this.pageFilter.getRowKeyAtStop();
                    this.scan.withStartRow(rowKey, true);
                    this.delegate = this.region.getScanner(this.scan);
                    if (results.isEmpty()) {
                        ScanUtil.getDummyResult(rowKey, results);
                    }
                    this.pageFilter.init();
                    return true;
                }
                return false;
            }
            this.pageFilter.resetStartTime();
            return true;
        }
        catch (Exception e) {
            if (this.pageFilter != null) {
                this.pageFilter.init();
            }
            throw e;
        }
    }

    @Override
    public boolean next(List<Cell> results) throws IOException {
        return this.next(results, false);
    }

    @Override
    public boolean nextRaw(List<Cell> results) throws IOException {
        return this.next(results, true);
    }

    @Override
    public RegionScanner getNewRegionScanner(Scan scan) throws IOException {
        return new PagedRegionScanner(this.region, this.region.getScanner(scan), scan);
    }
}

