/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.RoundJodaDateExpression;
import org.apache.phoenix.util.DateUtil;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.chrono.GJChronology;

public class RoundYearExpression
extends RoundJodaDateExpression {
    public RoundYearExpression() {
    }

    public RoundYearExpression(List<Expression> children) {
        super(children);
    }

    @Override
    public long roundDateTime(DateTime dateTime) {
        return dateTime.year().roundHalfEvenCopy().getMillis();
    }

    @Override
    public long rangeLower(long epochMs) {
        DateTime rounded = new DateTime(this.roundDateTime(new DateTime(epochMs, (Chronology)GJChronology.getInstanceUTC())), (Chronology)GJChronology.getInstanceUTC());
        DateTime prev = rounded.minusYears(1);
        return DateUtil.rangeJodaHalfEven(rounded, prev, DateTimeFieldType.year());
    }

    @Override
    public long rangeUpper(long epochMs) {
        DateTime rounded = new DateTime(this.roundDateTime(new DateTime(epochMs, (Chronology)GJChronology.getInstanceUTC())), (Chronology)GJChronology.getInstanceUTC());
        DateTime next = rounded.plusYears(1);
        return DateUtil.rangeJodaHalfEven(rounded, next, DateTimeFieldType.year());
    }
}

