/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.exception;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.phoenix.hbase.index.exception.IndexWriteException;
import org.apache.phoenix.thirdparty.com.google.common.base.MoreObjects;

public class SingleIndexWriteFailureException
extends IndexWriteException {
    public static final String FAILED_MSG = "Failed to make index update:";
    private String table;
    private String mutationsMsg;

    public SingleIndexWriteFailureException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public SingleIndexWriteFailureException(String targetTableName, List<Mutation> mutations, Exception cause, boolean disableIndexOnFailure) {
        super(cause, disableIndexOnFailure);
        this.table = targetTableName;
        this.mutationsMsg = mutations.toString();
    }

    public SingleIndexWriteFailureException(String msg) {
        super(IndexWriteException.parseDisableIndexOnFailure(msg));
        Pattern pattern = Pattern.compile("Failed to make index update:.* table: ([\\S]*)\\s.*", 32);
        Matcher m = pattern.matcher(msg);
        if (m.find()) {
            this.table = m.group(1);
        }
    }

    public String getTableName() {
        return this.table;
    }

    @Override
    public String getMessage() {
        return (String)MoreObjects.firstNonNull((Object)super.getMessage(), (Object)"") + " " + FAILED_MSG + "\n\t table: " + this.table + "\n\t edits: " + this.mutationsMsg + "\n\tcause: " + this.getCause() == null ? "UNKNOWN" : this.getCause().getMessage();
    }
}

