/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.coprocessor.generated.PTableProtos;
import org.apache.phoenix.exception.DataExceedsCapacityException;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.visitor.StatelessTraverseAllExpressionVisitor;
import org.apache.phoenix.hbase.index.covered.IndexMetaData;
import org.apache.phoenix.hbase.index.covered.NonTxIndexBuilder;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.index.PhoenixIndexCodec;
import org.apache.phoenix.index.PhoenixIndexMetaData;
import org.apache.phoenix.index.PhoenixIndexMetaDataBuilder;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PRow;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;

public class PhoenixIndexBuilder
extends NonTxIndexBuilder {
    public static final String ATOMIC_OP_ATTRIB = "_ATOMIC_OP_ATTRIB";
    private static final byte[] ON_DUP_KEY_IGNORE_BYTES = new byte[]{1};
    private static final int ON_DUP_KEY_HEADER_BYTE_SIZE = 3;
    private PhoenixIndexMetaDataBuilder indexMetaDataBuilder;

    @Override
    public void setup(RegionCoprocessorEnvironment env) throws IOException {
        super.setup(env);
        this.indexMetaDataBuilder = new PhoenixIndexMetaDataBuilder(env);
    }

    private static List<Cell> flattenCells(Mutation m, int estimatedSize) throws IOException {
        ArrayList flattenedCells = Lists.newArrayListWithExpectedSize((int)estimatedSize);
        PhoenixIndexBuilder.flattenCells(m, flattenedCells);
        return flattenedCells;
    }

    private static void flattenCells(Mutation m, List<Cell> flattenedCells) throws IOException {
        for (List cells : m.getFamilyCellMap().values()) {
            flattenedCells.addAll(cells);
        }
    }

    @Override
    public PhoenixIndexMetaData getIndexMetaData(MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        return this.indexMetaDataBuilder.getIndexMetaData(miniBatchOp);
    }

    protected PhoenixIndexCodec getCodec() {
        return (PhoenixIndexCodec)this.codec;
    }

    @Override
    public void batchStarted(MiniBatchOperationInProgress<Mutation> miniBatchOp, IndexMetaData context) throws IOException {
    }

    @Override
    public boolean isAtomicOp(Mutation m) {
        return m.getAttribute(ATOMIC_OP_ATTRIB) != null;
    }

    private static void transferCells(Mutation source, Mutation target) {
        target.getFamilyCellMap().putAll(source.getFamilyCellMap());
    }

    private static void transferAttributes(Mutation source, Mutation target) {
        for (Map.Entry entry : source.getAttributesMap().entrySet()) {
            target.setAttribute((String)entry.getKey(), (byte[])entry.getValue());
        }
    }

    private static List<Mutation> convertIncrementToPutInSingletonList(Increment inc) {
        byte[] rowKey = inc.getRow();
        Put put = new Put(rowKey);
        PhoenixIndexBuilder.transferCells((Mutation)inc, (Mutation)put);
        PhoenixIndexBuilder.transferAttributes((Mutation)inc, (Mutation)put);
        return Collections.singletonList(put);
    }

    @Override
    public List<Mutation> executeAtomicOp(Increment inc) throws IOException {
        byte[] opBytes = inc.getAttribute(ATOMIC_OP_ATTRIB);
        if (opBytes == null) {
            return null;
        }
        inc.setAttribute(ATOMIC_OP_ATTRIB, null);
        Put put = null;
        Delete delete = null;
        long ts = Long.MAX_VALUE;
        byte[] rowKey = inc.getRow();
        final Get get = new Get(rowKey);
        if (PhoenixIndexBuilder.isDupKeyIgnore(opBytes)) {
            get.setFilter((Filter)new FirstKeyOnlyFilter());
            try (RegionScanner scanner = this.env.getRegion().getScanner(new Scan(get));){
                ArrayList cells = new ArrayList();
                scanner.next(cells);
                List<Mutation> list = cells.isEmpty() ? PhoenixIndexBuilder.convertIncrementToPutInSingletonList(inc) : Collections.emptyList();
                return list;
            }
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(opBytes);
        DataInputStream input = new DataInputStream(stream);
        boolean skipFirstOp = input.readBoolean();
        int repeat = input.readShort();
        final int[] estimatedSizeHolder = new int[]{0};
        ArrayList operations = Lists.newArrayListWithExpectedSize((int)3);
        while (true) {
            StatelessTraverseAllExpressionVisitor<Void> visitor = new StatelessTraverseAllExpressionVisitor<Void>(){

                @Override
                public Void visit(KeyValueColumnExpression expression) {
                    get.addColumn(expression.getColumnFamily(), expression.getColumnQualifier());
                    estimatedSizeHolder[0] = estimatedSizeHolder[0] + 1;
                    return null;
                }
            };
            try {
                int nExpressions = WritableUtils.readVInt((DataInput)input);
                ArrayList expressions = Lists.newArrayListWithExpectedSize((int)nExpressions);
                for (int i = 0; i < nExpressions; ++i) {
                    Expression expression = ExpressionType.values()[WritableUtils.readVInt((DataInput)input)].newInstance();
                    expression.readFields(input);
                    expressions.add(expression);
                    expression.accept(visitor);
                }
                PTableProtos.PTable tableProto = PTableProtos.PTable.parseDelimitedFrom(input);
                PTable table = PTableImpl.createFromProto(tableProto);
                operations.add(new Pair((Object)table, (Object)expressions));
            }
            catch (EOFException e) {
                MultiKeyValueTuple tuple;
                int estimatedSize = estimatedSizeHolder[0];
                if (get.getFamilyMap().isEmpty()) {
                    get.setFilter((Filter)new FirstKeyOnlyFilter());
                }
                ArrayList flattenedCells = null;
                List cells = ((HRegion)this.env.getRegion()).get(get, false);
                if (cells.isEmpty()) {
                    if (skipFirstOp) {
                        if (operations.size() <= 1 && repeat <= 1) {
                            return PhoenixIndexBuilder.convertIncrementToPutInSingletonList(inc);
                        }
                        repeat = (short)(repeat - 1);
                    }
                    flattenedCells = PhoenixIndexBuilder.flattenCells((Mutation)inc, estimatedSize);
                    tuple = new MultiKeyValueTuple(flattenedCells);
                } else {
                    tuple = new MultiKeyValueTuple(cells);
                }
                ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                for (int opIndex = 0; opIndex < operations.size(); ++opIndex) {
                    Pair operation = (Pair)operations.get(opIndex);
                    PTable table = (PTable)operation.getFirst();
                    List expressions = (List)operation.getSecond();
                    for (int j = 0; j < repeat; ++j) {
                        ptr.set(rowKey);
                        if (flattenedCells != null) {
                            Collections.sort(flattenedCells, CellComparatorImpl.COMPARATOR);
                        }
                        PRow row = table.newRow(GenericKeyValueBuilder.INSTANCE, ts, ptr, false, (byte[][])new byte[0][]);
                        int adjust = table.getBucketNum() == null ? 1 : 2;
                        for (int i = 0; i < expressions.size(); ++i) {
                            Expression expression = (Expression)expressions.get(i);
                            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
                            expression.evaluate(tuple, ptr);
                            PColumn column = table.getColumns().get(i + adjust);
                            Object value = expression.getDataType().toObject(ptr, column.getSortOrder());
                            if (!column.getDataType().isSizeCompatible(ptr, value, column.getDataType(), expression.getSortOrder(), expression.getMaxLength(), expression.getScale(), column.getMaxLength(), column.getScale())) {
                                throw new DataExceedsCapacityException(column.getDataType(), column.getMaxLength(), column.getScale(), column.getName().getString());
                            }
                            column.getDataType().coerceBytes(ptr, value, expression.getDataType(), expression.getMaxLength(), expression.getScale(), expression.getSortOrder(), column.getMaxLength(), column.getScale(), column.getSortOrder(), table.rowKeyOrderOptimizable());
                            byte[] bytes = ByteUtil.copyKeyBytesIfNecessary(ptr);
                            row.setValue(column, bytes);
                        }
                        flattenedCells = Lists.newArrayListWithExpectedSize((int)estimatedSize);
                        List<Mutation> mutations = row.toRowMutations();
                        for (Mutation source : mutations) {
                            PhoenixIndexBuilder.flattenCells(source, flattenedCells);
                        }
                        tuple.setKeyValues(flattenedCells);
                    }
                    repeat = 1;
                }
                ArrayList mutations = Lists.newArrayListWithExpectedSize((int)2);
                for (int i = 0; i < tuple.size(); ++i) {
                    Cell cell = tuple.getValue(i);
                    if (KeyValue.Type.codeToType((byte)cell.getTypeByte()) == KeyValue.Type.Put) {
                        if (put == null) {
                            put = new Put(rowKey);
                            PhoenixIndexBuilder.transferAttributes((Mutation)inc, (Mutation)put);
                            mutations.add(put);
                        }
                        put.add(cell);
                        continue;
                    }
                    if (delete == null) {
                        delete = new Delete(rowKey);
                        PhoenixIndexBuilder.transferAttributes((Mutation)inc, (Mutation)delete);
                        mutations.add(delete);
                    }
                    delete.add(cell);
                }
                return mutations;
            }
        }
    }

    public static byte[] serializeOnDupKeyIgnore() {
        return ON_DUP_KEY_IGNORE_BYTES;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] serializeOnDupKeyUpdate(PTable table, List<Expression> expressions) {
        PTableProtos.PTable ptableProto = PTableImpl.toProto(table);
        int size = ptableProto.getSerializedSize();
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream(size * 2);){
            DataOutputStream output = new DataOutputStream(stream);
            output.writeBoolean(true);
            output.writeShort(1);
            WritableUtils.writeVInt((DataOutput)output, (int)expressions.size());
            for (int i = 0; i < expressions.size(); ++i) {
                Expression expression = expressions.get(i);
                WritableUtils.writeVInt((DataOutput)output, (int)ExpressionType.valueOf(expression).ordinal());
                expression.write(output);
            }
            ptableProto.writeDelimitedTo(output);
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] doNotSkipFirstOnDupKey(byte[] oldOnDupKeyBytes) {
        byte[] newOnDupKeyBytes = Arrays.copyOf(oldOnDupKeyBytes, oldOnDupKeyBytes.length);
        newOnDupKeyBytes[0] = 0;
        return newOnDupKeyBytes;
    }

    /*
     * Exception decompiling
     */
    public static byte[] combineOnDupKey(byte[] oldOnDupKeyBytes, byte[] newOnDupKeyBytes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 11 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isDupKeyIgnore(byte[] onDupKeyBytes) {
        return onDupKeyBytes != null && Bytes.compareTo((byte[])ON_DUP_KEY_IGNORE_BYTES, (byte[])onDupKeyBytes) == 0;
    }

    @Override
    public BaseScannerRegionObserver.ReplayWrite getReplayWrite(Mutation m) {
        return PhoenixIndexMetaData.getReplayWrite(m.getAttributesMap());
    }
}

