/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.util.Arrays;
import org.apache.phoenix.thirdparty.com.google.common.base.Predicate;

public class TableSamplerPredicate
implements Predicate<byte[]> {
    private final double tableSamplingRate;

    private TableSamplerPredicate(double tableSamplingRate) {
        this.tableSamplingRate = tableSamplingRate;
    }

    public static TableSamplerPredicate of(Double tableSamplingRateRaw) {
        assert (tableSamplingRateRaw != null) : "tableSamplingRate can not be null";
        assert (tableSamplingRateRaw >= 0.0 && tableSamplingRateRaw <= 100.0) : "tableSamplingRate input has to be a rational number between 0 and 100";
        TableSamplerPredicate self = new TableSamplerPredicate(tableSamplingRateRaw);
        return self;
    }

    public boolean apply(byte[] bytes) {
        int hashcode_FNV1Lazy = TableSamplerPredicate.FNV1LazyImpl(bytes);
        boolean result = this.evaluateWithChance(hashcode_FNV1Lazy);
        return result;
    }

    private static final int FNV1LazyImpl(byte[] bytes) {
        int contentBasedHashCode = Arrays.hashCode(bytes);
        return TableSamplerPredicate.lazyRedistribute(contentBasedHashCode);
    }

    private static final int lazyRedistribute(int hashcode) {
        return Math.abs(hashcode % 100);
    }

    private final boolean evaluateWithChance(int hashcode) {
        assert (hashcode >= 0 && hashcode <= 100) : "hashcode should be re-distribute into 0 to 100";
        return (double)hashcode < this.tableSamplingRate;
    }
}

