/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.ExpressionProjector;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.LikeExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.StringBasedLikeExpression;
import org.apache.phoenix.hbase.index.util.VersionUtil;
import org.apache.phoenix.iterate.MaterializedResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.LikeParseNode;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeyValueAccessor;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.SingleKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;

public class PhoenixDatabaseMetaData
implements DatabaseMetaData {
    public static final int FAMILY_NAME_INDEX = 4;
    public static final int COLUMN_NAME_INDEX = 3;
    public static final int TABLE_NAME_INDEX = 2;
    public static final int SCHEMA_NAME_INDEX = 1;
    public static final int TENANT_ID_INDEX = 0;
    public static final int TYPE_INDEX = 2;
    public static final int FUNTION_NAME_INDEX = 1;
    public static final String SYSTEM_CATALOG_SCHEMA = "SYSTEM";
    public static final byte[] SYSTEM_CATALOG_SCHEMA_BYTES = QueryConstants.SYSTEM_SCHEMA_NAME_BYTES;
    public static final String SYSTEM_SCHEMA_NAME = "SYSTEM";
    public static final byte[] SYSTEM_SCHEMA_NAME_BYTES = QueryConstants.SYSTEM_SCHEMA_NAME_BYTES;
    public static final TableName SYSTEM_SCHEMA_HBASE_TABLE_NAME = TableName.valueOf((String)"SYSTEM");
    public static final String SYSTEM_CATALOG_TABLE = "CATALOG";
    public static final byte[] SYSTEM_CATALOG_TABLE_BYTES = Bytes.toBytes((String)"CATALOG");
    public static final String SYSTEM_CATALOG = "SYSTEM.\"CATALOG\"";
    public static final String SYSTEM_CATALOG_NAME = SchemaUtil.getTableName("SYSTEM", "CATALOG");
    public static final TableName SYSTEM_CATALOG_HBASE_TABLE_NAME = TableName.valueOf((String)SYSTEM_CATALOG_NAME);
    public static final byte[] SYSTEM_CATALOG_NAME_BYTES = Bytes.toBytes((String)SYSTEM_CATALOG_NAME);
    public static final String SYSTEM_STATS_TABLE = "STATS";
    public static final String SYSTEM_STATS_NAME = SchemaUtil.getTableName("SYSTEM", "STATS");
    public static final String IS_NAMESPACE_MAPPED = "IS_NAMESPACE_MAPPED";
    public static final byte[] IS_NAMESPACE_MAPPED_BYTES = Bytes.toBytes((String)"IS_NAMESPACE_MAPPED");
    public static final byte[] SYSTEM_STATS_NAME_BYTES = Bytes.toBytes((String)SYSTEM_STATS_NAME);
    public static final byte[] SYSTEM_STATS_TABLE_BYTES = Bytes.toBytes((String)"STATS");
    public static final TableName SYSTEM_STATS_HBASE_TABLE_NAME = TableName.valueOf((String)SYSTEM_STATS_NAME);
    public static final String SYSTEM_CATALOG_ALIAS = "\"SYSTEM.TABLE\"";
    public static final byte[] SYSTEM_SEQUENCE_FAMILY_BYTES = QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES;
    public static final String SYSTEM_SEQUENCE_SCHEMA = "SYSTEM";
    public static final byte[] SYSTEM_SEQUENCE_SCHEMA_BYTES = Bytes.toBytes((String)"SYSTEM");
    public static final String SYSTEM_SEQUENCE_TABLE = "SEQUENCE";
    public static final byte[] SYSTEM_SEQUENCE_TABLE_BYTES = Bytes.toBytes((String)"SEQUENCE");
    public static final String SYSTEM_SEQUENCE = "SYSTEM.\"SEQUENCE\"";
    public static final String SYSTEM_SEQUENCE_NAME = SchemaUtil.getTableName("SYSTEM", "SEQUENCE");
    public static final byte[] SYSTEM_SEQUENCE_NAME_BYTES = Bytes.toBytes((String)SYSTEM_SEQUENCE_NAME);
    public static final TableName SYSTEM_SEQUENCE_HBASE_TABLE_NAME = TableName.valueOf((String)SYSTEM_SEQUENCE_NAME);
    public static final String TABLE_NAME = "TABLE_NAME";
    public static final byte[] TABLE_NAME_BYTES = Bytes.toBytes((String)"TABLE_NAME");
    public static final String TABLE_TYPE = "TABLE_TYPE";
    public static final byte[] TABLE_TYPE_BYTES = Bytes.toBytes((String)"TABLE_TYPE");
    public static final String PHYSICAL_NAME = "PHYSICAL_NAME";
    public static final byte[] PHYSICAL_NAME_BYTES = Bytes.toBytes((String)"PHYSICAL_NAME");
    public static final String COLUMN_FAMILY = "COLUMN_FAMILY";
    public static final byte[] COLUMN_FAMILY_BYTES = Bytes.toBytes((String)"COLUMN_FAMILY");
    public static final String TABLE_CAT = "TABLE_CAT";
    public static final String TABLE_CATALOG = "TABLE_CATALOG";
    public static final String TABLE_SCHEM = "TABLE_SCHEM";
    public static final String REMARKS = "REMARKS";
    public static final String TYPE_SCHEM = "TYPE_SCHEM";
    public static final String SELF_REFERENCING_COL_NAME = "SELF_REFERENCING_COL_NAME";
    public static final String REF_GENERATION = "REF_GENERATION";
    public static final String PK_NAME = "PK_NAME";
    public static final byte[] PK_NAME_BYTES = Bytes.toBytes((String)"PK_NAME");
    public static final String TABLE_SEQ_NUM = "TABLE_SEQ_NUM";
    public static final byte[] TABLE_SEQ_NUM_BYTES = Bytes.toBytes((String)"TABLE_SEQ_NUM");
    public static final String COLUMN_COUNT = "COLUMN_COUNT";
    public static final byte[] COLUMN_COUNT_BYTES = Bytes.toBytes((String)"COLUMN_COUNT");
    public static final String SALT_BUCKETS = "SALT_BUCKETS";
    public static final byte[] SALT_BUCKETS_BYTES = Bytes.toBytes((String)"SALT_BUCKETS");
    public static final String STORE_NULLS = "STORE_NULLS";
    public static final byte[] STORE_NULLS_BYTES = Bytes.toBytes((String)"STORE_NULLS");
    public static final String DATA_TABLE_NAME = "DATA_TABLE_NAME";
    public static final byte[] DATA_TABLE_NAME_BYTES = Bytes.toBytes((String)"DATA_TABLE_NAME");
    public static final String INDEX_STATE = "INDEX_STATE";
    public static final byte[] INDEX_STATE_BYTES = Bytes.toBytes((String)"INDEX_STATE");
    public static final String TENANT_ID = "TENANT_ID";
    public static final byte[] TENANT_ID_BYTES = Bytes.toBytes((String)"TENANT_ID");
    public static final String COLUMN_NAME = "COLUMN_NAME";
    public static final String DATA_TYPE = "DATA_TYPE";
    public static final byte[] DATA_TYPE_BYTES = Bytes.toBytes((String)"DATA_TYPE");
    public static final String TYPE_NAME = "TYPE_NAME";
    public static final String COLUMN_SIZE = "COLUMN_SIZE";
    public static final byte[] COLUMN_SIZE_BYTES = Bytes.toBytes((String)"COLUMN_SIZE");
    public static final String BUFFER_LENGTH = "BUFFER_LENGTH";
    public static final String DECIMAL_DIGITS = "DECIMAL_DIGITS";
    public static final byte[] DECIMAL_DIGITS_BYTES = Bytes.toBytes((String)"DECIMAL_DIGITS");
    public static final String NUM_PREC_RADIX = "NUM_PREC_RADIX";
    public static final String NULLABLE = "NULLABLE";
    public static final byte[] NULLABLE_BYTES = Bytes.toBytes((String)"NULLABLE");
    public static final String COLUMN_DEF = "COLUMN_DEF";
    public static final byte[] COLUMN_DEF_BYTES = Bytes.toBytes((String)"COLUMN_DEF");
    public static final String SQL_DATA_TYPE = "SQL_DATA_TYPE";
    public static final String SQL_DATETIME_SUB = "SQL_DATETIME_SUB";
    public static final String CHAR_OCTET_LENGTH = "CHAR_OCTET_LENGTH";
    public static final String ORDINAL_POSITION = "ORDINAL_POSITION";
    public static final byte[] ORDINAL_POSITION_BYTES = Bytes.toBytes((String)"ORDINAL_POSITION");
    public static final String IS_NULLABLE = "IS_NULLABLE";
    public static final String SCOPE_CATALOG = "SCOPE_CATALOG";
    public static final String SCOPE_SCHEMA = "SCOPE_SCHEMA";
    public static final String SCOPE_TABLE = "SCOPE_TABLE";
    public static final String SOURCE_DATA_TYPE = "SOURCE_DATA_TYPE";
    public static final String IS_AUTOINCREMENT = "IS_AUTOINCREMENT";
    public static final String SORT_ORDER = "SORT_ORDER";
    public static final byte[] SORT_ORDER_BYTES = Bytes.toBytes((String)"SORT_ORDER");
    public static final String IMMUTABLE_ROWS = "IMMUTABLE_ROWS";
    public static final byte[] IMMUTABLE_ROWS_BYTES = Bytes.toBytes((String)"IMMUTABLE_ROWS");
    public static final String DEFAULT_COLUMN_FAMILY_NAME = "DEFAULT_COLUMN_FAMILY";
    public static final byte[] DEFAULT_COLUMN_FAMILY_NAME_BYTES = Bytes.toBytes((String)"DEFAULT_COLUMN_FAMILY");
    public static final String VIEW_STATEMENT = "VIEW_STATEMENT";
    public static final byte[] VIEW_STATEMENT_BYTES = Bytes.toBytes((String)"VIEW_STATEMENT");
    public static final String DISABLE_WAL = "DISABLE_WAL";
    public static final byte[] DISABLE_WAL_BYTES = Bytes.toBytes((String)"DISABLE_WAL");
    public static final String MULTI_TENANT = "MULTI_TENANT";
    public static final byte[] MULTI_TENANT_BYTES = Bytes.toBytes((String)"MULTI_TENANT");
    public static final String VIEW_TYPE = "VIEW_TYPE";
    public static final byte[] VIEW_TYPE_BYTES = Bytes.toBytes((String)"VIEW_TYPE");
    public static final String INDEX_TYPE = "INDEX_TYPE";
    public static final byte[] INDEX_TYPE_BYTES = Bytes.toBytes((String)"INDEX_TYPE");
    public static final String LINK_TYPE = "LINK_TYPE";
    public static final byte[] LINK_TYPE_BYTES = Bytes.toBytes((String)"LINK_TYPE");
    public static final String TASK_TYPE = "TASK_TYPE";
    public static final byte[] TASK_TYPE_BYTES = Bytes.toBytes((String)"TASK_TYPE");
    public static final String TASK_TS = "TASK_TS";
    public static final byte[] TASK_TS_BYTES = Bytes.toBytes((String)"TASK_TS");
    public static final String TASK_STATUS = "TASK_STATUS";
    public static final String TASK_END_TS = "TASK_END_TS";
    public static final String TASK_PRIORITY = "TASK_PRIORITY";
    public static final String TASK_DATA = "TASK_DATA";
    public static final String TASK_TABLE_TTL = "864000";
    public static final int TTL_FOR_MUTEX = 900;
    public static final String ARRAY_SIZE = "ARRAY_SIZE";
    public static final byte[] ARRAY_SIZE_BYTES = Bytes.toBytes((String)"ARRAY_SIZE");
    public static final String VIEW_CONSTANT = "VIEW_CONSTANT";
    public static final byte[] VIEW_CONSTANT_BYTES = Bytes.toBytes((String)"VIEW_CONSTANT");
    public static final String IS_VIEW_REFERENCED = "IS_VIEW_REFERENCED";
    public static final byte[] IS_VIEW_REFERENCED_BYTES = Bytes.toBytes((String)"IS_VIEW_REFERENCED");
    public static final String VIEW_INDEX_ID = "VIEW_INDEX_ID";
    public static final byte[] VIEW_INDEX_ID_BYTES = Bytes.toBytes((String)"VIEW_INDEX_ID");
    public static final String VIEW_INDEX_ID_DATA_TYPE = "VIEW_INDEX_ID_DATA_TYPE";
    public static final byte[] VIEW_INDEX_ID_DATA_TYPE_BYTES = Bytes.toBytes((String)"VIEW_INDEX_ID_DATA_TYPE");
    public static final String BASE_COLUMN_COUNT = "BASE_COLUMN_COUNT";
    public static final byte[] BASE_COLUMN_COUNT_BYTES = Bytes.toBytes((String)"BASE_COLUMN_COUNT");
    public static final String IS_ROW_TIMESTAMP = "IS_ROW_TIMESTAMP";
    public static final byte[] IS_ROW_TIMESTAMP_BYTES = Bytes.toBytes((String)"IS_ROW_TIMESTAMP");
    public static final String TABLE_FAMILY = "0";
    public static final byte[] TABLE_FAMILY_BYTES = QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES;
    public static final byte[] PENDING_DISABLE_COUNT_BYTES = Bytes.toBytes((String)"PENDING_DISABLE_COUNT");
    public static final String TYPE_SEQUENCE = "SEQUENCE";
    public static final String SYSTEM_FUNCTION_TABLE = "FUNCTION";
    public static final String SYSTEM_FUNCTION = "SYSTEM.\"FUNCTION\"";
    public static final String SYSTEM_FUNCTION_NAME = SchemaUtil.getTableName("SYSTEM", "FUNCTION");
    public static final byte[] SYSTEM_FUNCTION_NAME_BYTES = Bytes.toBytes((String)SYSTEM_FUNCTION_NAME);
    public static final TableName SYSTEM_FUNCTION_HBASE_TABLE_NAME = TableName.valueOf((String)SYSTEM_FUNCTION_NAME);
    public static final String FUNCTION_NAME = "FUNCTION_NAME";
    public static final byte[] FUNCTION_NAME_BYTES = Bytes.toBytes((String)"FUNCTION_NAME");
    public static final String CLASS_NAME = "CLASS_NAME";
    public static final byte[] CLASS_NAME_BYTES = Bytes.toBytes((String)"CLASS_NAME");
    public static final String JAR_PATH = "JAR_PATH";
    public static final byte[] JAR_PATH_BYTES = Bytes.toBytes((String)"JAR_PATH");
    public static final String TYPE = "TYPE";
    public static final byte[] TYPE_BYTES = Bytes.toBytes((String)"TYPE");
    public static final String ARG_POSITION = "ARG_POSITION";
    public static final byte[] ARG_POSITION_TYPE = Bytes.toBytes((String)"ARG_POSITION");
    public static final String RETURN_TYPE = "RETURN_TYPE";
    public static final byte[] RETURN_TYPE_BYTES = Bytes.toBytes((String)"RETURN_TYPE");
    public static final String IS_ARRAY = "IS_ARRAY";
    public static final byte[] IS_ARRAY_BYTES = Bytes.toBytes((String)"IS_ARRAY");
    public static final String IS_CONSTANT = "IS_CONSTANT";
    public static final byte[] IS_CONSTANT_BYTES = Bytes.toBytes((String)"IS_CONSTANT");
    public static final String DEFAULT_VALUE = "DEFAULT_VALUE";
    public static final byte[] DEFAULT_VALUE_BYTES = Bytes.toBytes((String)"DEFAULT_VALUE");
    public static final String NUM_ARGS = "NUM_ARGS";
    public static final byte[] NUM_ARGS_BYTES = Bytes.toBytes((String)"NUM_ARGS");
    public static final String SEQUENCE_SCHEMA = "SEQUENCE_SCHEMA";
    public static final String SEQUENCE_NAME = "SEQUENCE_NAME";
    public static final String CURRENT_VALUE = "CURRENT_VALUE";
    public static final byte[] CURRENT_VALUE_BYTES = Bytes.toBytes((String)"CURRENT_VALUE");
    public static final String START_WITH = "START_WITH";
    public static final byte[] START_WITH_BYTES = Bytes.toBytes((String)"START_WITH");
    public static final String MIN_VALUE = "MIN_VALUE";
    public static final byte[] MIN_VALUE_BYTES = Bytes.toBytes((String)"MIN_VALUE");
    public static final String MAX_VALUE = "MAX_VALUE";
    public static final byte[] MAX_VALUE_BYTES = Bytes.toBytes((String)"MAX_VALUE");
    public static final String INCREMENT_BY = "INCREMENT_BY";
    public static final byte[] INCREMENT_BY_BYTES = Bytes.toBytes((String)"INCREMENT_BY");
    public static final String CACHE_SIZE = "CACHE_SIZE";
    public static final byte[] CACHE_SIZE_BYTES = Bytes.toBytes((String)"CACHE_SIZE");
    public static final String CYCLE_FLAG = "CYCLE_FLAG";
    public static final byte[] CYCLE_FLAG_BYTES = Bytes.toBytes((String)"CYCLE_FLAG");
    public static final String LIMIT_REACHED_FLAG = "LIMIT_REACHED_FLAG";
    public static final byte[] LIMIT_REACHED_FLAG_BYTES = Bytes.toBytes((String)"LIMIT_REACHED_FLAG");
    public static final String KEY_SEQ = "KEY_SEQ";
    public static final byte[] KEY_SEQ_BYTES = Bytes.toBytes((String)"KEY_SEQ");
    public static final String SUPERTABLE_NAME = "SUPERTABLE_NAME";
    public static final String TYPE_ID = "TYPE_ID";
    public static final String INDEX_DISABLE_TIMESTAMP = "INDEX_DISABLE_TIMESTAMP";
    public static final byte[] INDEX_DISABLE_TIMESTAMP_BYTES = Bytes.toBytes((String)"INDEX_DISABLE_TIMESTAMP");
    public static final String REGION_NAME = "REGION_NAME";
    public static final byte[] REGION_NAME_BYTES = Bytes.toBytes((String)"REGION_NAME");
    public static final String GUIDE_POSTS = "GUIDE_POSTS";
    public static final byte[] GUIDE_POSTS_BYTES = Bytes.toBytes((String)"GUIDE_POSTS");
    public static final String GUIDE_POSTS_COUNT = "GUIDE_POSTS_COUNT";
    public static final byte[] GUIDE_POSTS_COUNT_BYTES = Bytes.toBytes((String)"GUIDE_POSTS_COUNT");
    public static final String GUIDE_POSTS_WIDTH = "GUIDE_POSTS_WIDTH";
    public static final byte[] GUIDE_POSTS_WIDTH_BYTES = Bytes.toBytes((String)"GUIDE_POSTS_WIDTH");
    public static final String GUIDE_POSTS_ROW_COUNT = "GUIDE_POSTS_ROW_COUNT";
    public static final byte[] GUIDE_POSTS_ROW_COUNT_BYTES = Bytes.toBytes((String)"GUIDE_POSTS_ROW_COUNT");
    public static final String MIN_KEY = "MIN_KEY";
    public static final byte[] MIN_KEY_BYTES = Bytes.toBytes((String)"MIN_KEY");
    public static final String MAX_KEY = "MAX_KEY";
    public static final byte[] MAX_KEY_BYTES = Bytes.toBytes((String)"MAX_KEY");
    public static final String LAST_STATS_UPDATE_TIME = "LAST_STATS_UPDATE_TIME";
    public static final byte[] LAST_STATS_UPDATE_TIME_BYTES = Bytes.toBytes((String)"LAST_STATS_UPDATE_TIME");
    public static final String GUIDE_POST_KEY = "GUIDE_POST_KEY";
    public static final String ASYNC_REBUILD_TIMESTAMP = "ASYNC_REBUILD_TIMESTAMP";
    public static final byte[] ASYNC_REBUILD_TIMESTAMP_BYTES = Bytes.toBytes((String)"ASYNC_REBUILD_TIMESTAMP");
    public static final String COLUMN_ENCODED_BYTES = "COLUMN_ENCODED_BYTES";
    public static final String PARENT_TENANT_ID = "PARENT_TENANT_ID";
    public static final byte[] PARENT_TENANT_ID_BYTES = Bytes.toBytes((String)"PARENT_TENANT_ID");
    private static final String TENANT_POS_SHIFT = "TENANT_POS_SHIFT";
    private static final byte[] TENANT_POS_SHIFT_BYTES = Bytes.toBytes((String)"TENANT_POS_SHIFT");
    public static final String TRANSACTIONAL = "TRANSACTIONAL";
    public static final byte[] TRANSACTIONAL_BYTES = Bytes.toBytes((String)"TRANSACTIONAL");
    public static final String TRANSACTION_PROVIDER = "TRANSACTION_PROVIDER";
    public static final byte[] TRANSACTION_PROVIDER_BYTES = Bytes.toBytes((String)"TRANSACTION_PROVIDER");
    public static final String UPDATE_CACHE_FREQUENCY = "UPDATE_CACHE_FREQUENCY";
    public static final byte[] UPDATE_CACHE_FREQUENCY_BYTES = Bytes.toBytes((String)"UPDATE_CACHE_FREQUENCY");
    public static final String AUTO_PARTITION_SEQ = "AUTO_PARTITION_SEQ";
    public static final byte[] AUTO_PARTITION_SEQ_BYTES = Bytes.toBytes((String)"AUTO_PARTITION_SEQ");
    public static final String APPEND_ONLY_SCHEMA = "APPEND_ONLY_SCHEMA";
    public static final byte[] APPEND_ONLY_SCHEMA_BYTES = Bytes.toBytes((String)"APPEND_ONLY_SCHEMA");
    public static final String ASYNC_CREATED_DATE = "ASYNC_CREATED_DATE";
    public static final String SEQUENCE_TABLE_TYPE = "SEQUENCE";
    public static final String SYNC_INDEX_CREATED_DATE = "SYNC_INDEX_CREATED_DATE";
    public static final String SYSTEM_MUTEX_COLUMN_NAME = "MUTEX_VALUE";
    public static final byte[] SYSTEM_MUTEX_COLUMN_NAME_BYTES = Bytes.toBytes((String)"MUTEX_VALUE");
    public static final String SYSTEM_MUTEX_TABLE_NAME = "MUTEX";
    public static final String SYSTEM_MUTEX_NAME = SchemaUtil.getTableName("SYSTEM", "MUTEX");
    public static final TableName SYSTEM_MUTEX_HBASE_TABLE_NAME = TableName.valueOf((String)SYSTEM_MUTEX_NAME);
    public static final byte[] SYSTEM_MUTEX_NAME_BYTES = Bytes.toBytes((String)SYSTEM_MUTEX_NAME);
    public static final byte[] SYSTEM_MUTEX_FAMILY_NAME_BYTES = TABLE_FAMILY_BYTES;
    private final PhoenixConnection connection;
    private final ResultSet emptyResultSet;
    public static final int MAX_LOCAL_SI_VERSION_DISALLOW = VersionUtil.encodeVersion("0", "98", "8");
    public static final int MIN_LOCAL_SI_VERSION_DISALLOW = VersionUtil.encodeVersion("0", "98", "6");
    public static final int MIN_RENEW_LEASE_VERSION = VersionUtil.encodeVersion("1", "1", "3");
    public static final int MIN_NAMESPACE_MAPPED_PHOENIX_VERSION = VersionUtil.encodeVersion("4", "8", "0");
    public static final int MIN_PENDING_ACTIVE_INDEX = VersionUtil.encodeVersion("4", "12", "0");
    public static final int MIN_CLIENT_RETRY_INDEX_WRITES = VersionUtil.encodeVersion("4", "14", "0");
    public static final int MIN_TX_CLIENT_SIDE_MAINTENANCE = VersionUtil.encodeVersion("4", "14", "0");
    public static final int MIN_PENDING_DISABLE_INDEX = VersionUtil.encodeVersion("4", "14", "0");
    public static final int ESSENTIAL_FAMILY_VERSION_THRESHOLD = VersionUtil.encodeVersion("0", "94", "7");
    public static final int MUTABLE_SI_VERSION_THRESHOLD = VersionUtil.encodeVersion("0", "94", "10");
    public static final int CLIENT_KEY_VALUE_BUILDER_THRESHOLD = VersionUtil.encodeVersion("0", "94", "14");
    public static final String IMMUTABLE_STORAGE_SCHEME = "IMMUTABLE_STORAGE_SCHEME";
    public static final byte[] STORAGE_SCHEME_BYTES = Bytes.toBytes((String)"IMMUTABLE_STORAGE_SCHEME");
    public static final String ENCODING_SCHEME = "ENCODING_SCHEME";
    public static final byte[] ENCODING_SCHEME_BYTES = Bytes.toBytes((String)"ENCODING_SCHEME");
    public static final String COLUMN_QUALIFIER = "COLUMN_QUALIFIER";
    public static final byte[] COLUMN_QUALIFIER_BYTES = Bytes.toBytes((String)"COLUMN_QUALIFIER");
    public static final String COLUMN_QUALIFIER_COUNTER = "QUALIFIER_COUNTER";
    public static final byte[] COLUMN_QUALIFIER_COUNTER_BYTES = Bytes.toBytes((String)"QUALIFIER_COUNTER");
    public static final String USE_STATS_FOR_PARALLELIZATION = "USE_STATS_FOR_PARALLELIZATION";
    public static final byte[] USE_STATS_FOR_PARALLELIZATION_BYTES = Bytes.toBytes((String)"USE_STATS_FOR_PARALLELIZATION");
    public static final long PHOENIX_TTL_NOT_DEFINED = 0L;
    public static final String PHOENIX_TTL = "PHOENIX_TTL";
    public static final byte[] PHOENIX_TTL_BYTES = Bytes.toBytes((String)"PHOENIX_TTL");
    public static final long MIN_PHOENIX_TTL_HWM = 0L;
    public static final String PHOENIX_TTL_HWM = "PHOENIX_TTL_HWM";
    public static final byte[] PHOENIX_TTL_HWM_BYTES = Bytes.toBytes((String)"PHOENIX_TTL_HWM");
    public static final String LAST_DDL_TIMESTAMP = "LAST_DDL_TIMESTAMP";
    public static final byte[] LAST_DDL_TIMESTAMP_BYTES = Bytes.toBytes((String)"LAST_DDL_TIMESTAMP");
    public static final String CHANGE_DETECTION_ENABLED = "CHANGE_DETECTION_ENABLED";
    public static final byte[] CHANGE_DETECTION_ENABLED_BYTES = Bytes.toBytes((String)"CHANGE_DETECTION_ENABLED");
    public static final String SYSTEM_CHILD_LINK_TABLE = "CHILD_LINK";
    public static final String SYSTEM_CHILD_LINK_NAME = SchemaUtil.getTableName("SYSTEM", "CHILD_LINK");
    public static final byte[] SYSTEM_CHILD_LINK_NAME_BYTES = Bytes.toBytes((String)SYSTEM_CHILD_LINK_NAME);
    public static final TableName SYSTEM_LINK_HBASE_TABLE_NAME = TableName.valueOf((String)SYSTEM_CHILD_LINK_NAME);
    public static final String SYSTEM_TASK_TABLE = "TASK";
    public static final String SYSTEM_TASK_NAME = SchemaUtil.getTableName("SYSTEM", "TASK");
    public static final byte[] SYSTEM_TASK_NAME_BYTES = Bytes.toBytes((String)SYSTEM_TASK_NAME);
    public static final TableName SYSTEM_TASK_HBASE_TABLE_NAME = TableName.valueOf((String)SYSTEM_TASK_NAME);
    public static final String SYSTEM_LOG_TABLE = "LOG";
    public static final String SYSTEM_LOG_NAME = SchemaUtil.getTableName("SYSTEM", "LOG");
    public static final String QUERY_ID = "QUERY_ID";
    public static final String USER = "USER";
    public static final String CLIENT_IP = "CLIENT_IP";
    public static final String QUERY = "QUERY";
    public static final String EXPLAIN_PLAN = "EXPLAIN_PLAN";
    public static final String TOTAL_EXECUTION_TIME = "TOTAL_EXECUTION_TIME";
    public static final String NO_OF_RESULTS_ITERATED = "NO_OF_RESULTS_ITERATED";
    public static final String QUERY_STATUS = "QUERY_STATUS";
    public static final String EXCEPTION_TRACE = "EXCEPTION_TRACE";
    public static final String GLOBAL_SCAN_DETAILS = "GLOBAL_SCAN_DETAILS";
    public static final String SCAN_METRICS_JSON = "SCAN_METRICS_JSON";
    public static final String START_TIME = "START_TIME";
    public static final String BIND_PARAMETERS = "BIND_PARAMETERS";
    public static final String GLOBAL_TENANANTS_ONLY = "null";
    private static final PColumnImpl TENANT_ID_COLUMN = new PColumnImpl(PNameFactory.newName("TENANT_ID"), PNameFactory.newName(TABLE_FAMILY_BYTES), PVarchar.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, DATA_TYPE_BYTES, Long.MAX_VALUE);
    private static final PColumnImpl TABLE_SCHEM_COLUMN = new PColumnImpl(PNameFactory.newName("TABLE_SCHEM"), PNameFactory.newName(TABLE_FAMILY_BYTES), PVarchar.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, DATA_TYPE_BYTES, Long.MAX_VALUE);
    private static final PColumnImpl TABLE_NAME_COLUMN = new PColumnImpl(PNameFactory.newName("TABLE_NAME"), PNameFactory.newName(TABLE_FAMILY_BYTES), PVarchar.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, DATA_TYPE_BYTES, Long.MAX_VALUE);
    private static final PColumnImpl COLUMN_NAME_COLUMN = new PColumnImpl(PNameFactory.newName("COLUMN_NAME"), PNameFactory.newName(TABLE_FAMILY_BYTES), PVarchar.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, DATA_TYPE_BYTES, Long.MAX_VALUE);
    private static final PColumnImpl DATA_TYPE_COLUMN = new PColumnImpl(PNameFactory.newName("DATA_TYPE"), PNameFactory.newName(TABLE_FAMILY_BYTES), PInteger.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, DATA_TYPE_BYTES, Long.MAX_VALUE);
    private static final PColumnImpl TYPE_NAME_COLUMN = new PColumnImpl(PNameFactory.newName("TYPE_NAME"), PNameFactory.newName(TABLE_FAMILY_BYTES), PVarchar.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, Bytes.toBytes((String)"TYPE_NAME"), Long.MAX_VALUE);
    private static final PColumnImpl COLUMN_SIZE_COLUMN = new PColumnImpl(PNameFactory.newName("COLUMN_SIZE"), PNameFactory.newName(TABLE_FAMILY_BYTES), PInteger.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, COLUMN_SIZE_BYTES, Long.MAX_VALUE);
    private static final PColumnImpl BUFFER_LENGTH_COLUMN = new PColumnImpl(PNameFactory.newName("BUFFER_LENGTH"), PNameFactory.newName(TABLE_FAMILY_BYTES), PInteger.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, Bytes.toBytes((String)"BUFFER_LENGTH"), Long.MAX_VALUE);
    private static final PColumnImpl DECIMAL_DIGITS_COLUMN = new PColumnImpl(PNameFactory.newName("DECIMAL_DIGITS"), PNameFactory.newName(TABLE_FAMILY_BYTES), PInteger.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, DECIMAL_DIGITS_BYTES, Long.MAX_VALUE);
    private static final PColumnImpl NUM_PREC_RADIX_COLUMN = new PColumnImpl(PNameFactory.newName("NUM_PREC_RADIX"), PNameFactory.newName(TABLE_FAMILY_BYTES), PInteger.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, Bytes.toBytes((String)"NUM_PREC_RADIX"), Long.MAX_VALUE);
    private static final PColumnImpl NULLABLE_COLUMN = new PColumnImpl(PNameFactory.newName("NULLABLE"), PNameFactory.newName(TABLE_FAMILY_BYTES), PInteger.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, NULLABLE_BYTES, Long.MAX_VALUE);
    private static final PColumnImpl REMARKS_COLUMN = new PColumnImpl(PNameFactory.newName("REMARKS"), PNameFactory.newName(TABLE_FAMILY_BYTES), PVarchar.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, Bytes.toBytes((String)"REMARKS"), Long.MAX_VALUE);
    private static final PColumnImpl COLUMN_DEF_COLUMN = new PColumnImpl(PNameFactory.newName("COLUMN_DEF"), PNameFactory.newName(TABLE_FAMILY_BYTES), PVarchar.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, Bytes.toBytes((String)"COLUMN_DEF"), Long.MAX_VALUE);
    private static final PColumnImpl SQL_DATA_TYPE_COLUMN = new PColumnImpl(PNameFactory.newName("SQL_DATA_TYPE"), PNameFactory.newName(TABLE_FAMILY_BYTES), PInteger.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, Bytes.toBytes((String)"SQL_DATA_TYPE"), Long.MAX_VALUE);
    private static final PColumnImpl SQL_DATETIME_SUB_COLUMN = new PColumnImpl(PNameFactory.newName("SQL_DATETIME_SUB"), PNameFactory.newName(TABLE_FAMILY_BYTES), PInteger.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, Bytes.toBytes((String)"SQL_DATETIME_SUB"), Long.MAX_VALUE);
    private static final PColumnImpl CHAR_OCTET_LENGTH_COLUMN = new PColumnImpl(PNameFactory.newName("COLUMN_SIZE"), PNameFactory.newName(TABLE_FAMILY_BYTES), PInteger.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, Bytes.toBytes((String)"CHAR_OCTET_LENGTH"), Long.MAX_VALUE);
    private static final PColumnImpl ORDINAL_POSITION_COLUMN = new PColumnImpl(PNameFactory.newName("ORDINAL_POSITION"), PNameFactory.newName(TABLE_FAMILY_BYTES), PInteger.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, ORDINAL_POSITION_BYTES, Long.MAX_VALUE);
    private static final PColumnImpl IS_NULLABLE_COLUMN = new PColumnImpl(PNameFactory.newName("IS_NULLABLE"), PNameFactory.newName(TABLE_FAMILY_BYTES), PVarchar.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, Bytes.toBytes((String)"IS_NULLABLE"), Long.MAX_VALUE);
    private static final PColumnImpl SCOPE_CATALOG_COLUMN = new PColumnImpl(PNameFactory.newName("SCOPE_CATALOG"), PNameFactory.newName(TABLE_FAMILY_BYTES), PVarchar.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, Bytes.toBytes((String)"SCOPE_CATALOG"), Long.MAX_VALUE);
    private static final PColumnImpl SCOPE_SCHEMA_COLUMN = new PColumnImpl(PNameFactory.newName("SCOPE_SCHEMA"), PNameFactory.newName(TABLE_FAMILY_BYTES), PVarchar.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, Bytes.toBytes((String)"SCOPE_SCHEMA"), Long.MAX_VALUE);
    private static final PColumnImpl SCOPE_TABLE_COLUMN = new PColumnImpl(PNameFactory.newName("SCOPE_TABLE"), PNameFactory.newName(TABLE_FAMILY_BYTES), PVarchar.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, Bytes.toBytes((String)"SCOPE_TABLE"), Long.MAX_VALUE);
    private static final PColumnImpl SOURCE_DATA_TYPE_COLUMN = new PColumnImpl(PNameFactory.newName("SOURCE_DATA_TYPE"), PNameFactory.newName(TABLE_FAMILY_BYTES), PVarchar.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, Bytes.toBytes((String)"SOURCE_DATA_TYPE"), Long.MAX_VALUE);
    private static final PColumnImpl IS_AUTOINCREMENT_COLUMN = new PColumnImpl(PNameFactory.newName("COLUMN_SIZE"), PNameFactory.newName(TABLE_FAMILY_BYTES), PSmallint.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, Bytes.toBytes((String)"SCOPE_CATALOG"), Long.MAX_VALUE);
    private static final PColumnImpl ARRAY_SIZE_COLUMN = new PColumnImpl(PNameFactory.newName("ARRAY_SIZE"), PNameFactory.newName(TABLE_FAMILY_BYTES), PInteger.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, ARRAY_SIZE_BYTES, Long.MAX_VALUE);
    private static final PColumnImpl COLUMN_FAMILY_COLUMN = new PColumnImpl(PNameFactory.newName("COLUMN_FAMILY"), PNameFactory.newName(TABLE_FAMILY_BYTES), PVarchar.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, COLUMN_FAMILY_BYTES, Long.MAX_VALUE);
    private static final PColumnImpl TYPE_ID_COLUMN = new PColumnImpl(PNameFactory.newName("COLUMN_SIZE"), PNameFactory.newName(TABLE_FAMILY_BYTES), PInteger.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, Bytes.toBytes((String)"TYPE_ID"), Long.MAX_VALUE);
    private static final PColumnImpl VIEW_CONSTANT_COLUMN = new PColumnImpl(PNameFactory.newName("VIEW_CONSTANT"), PNameFactory.newName(TABLE_FAMILY_BYTES), PVarbinary.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, VIEW_CONSTANT_BYTES, Long.MAX_VALUE);
    private static final PColumnImpl MULTI_TENANT_COLUMN = new PColumnImpl(PNameFactory.newName("MULTI_TENANT"), PNameFactory.newName(TABLE_FAMILY_BYTES), PBoolean.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, MULTI_TENANT_BYTES, Long.MAX_VALUE);
    private static final PColumnImpl KEY_SEQ_COLUMN = new PColumnImpl(PNameFactory.newName("KEY_SEQ"), PNameFactory.newName(TABLE_FAMILY_BYTES), PSmallint.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, KEY_SEQ_BYTES, Long.MAX_VALUE);
    private static final PColumnImpl PK_NAME_COLUMN = new PColumnImpl(PNameFactory.newName("PK_NAME"), PNameFactory.newName(TABLE_FAMILY_BYTES), PVarchar.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, PK_NAME_BYTES, Long.MAX_VALUE);
    public static final String ASC_OR_DESC = "ASC_OR_DESC";
    public static final byte[] ASC_OR_DESC_BYTES = Bytes.toBytes((String)"ASC_OR_DESC");
    private static final PColumnImpl ASC_OR_DESC_COLUMN = new PColumnImpl(PNameFactory.newName("ASC_OR_DESC"), PNameFactory.newName(TABLE_FAMILY_BYTES), PVarchar.INSTANCE, null, null, false, 1, SortOrder.getDefault(), 0, null, false, null, false, false, ASC_OR_DESC_BYTES, Long.MAX_VALUE);
    private static final List<PColumnImpl> PK_DATUM_LIST = Lists.newArrayList((Object[])new PColumnImpl[]{TENANT_ID_COLUMN, TABLE_SCHEM_COLUMN, TABLE_NAME_COLUMN, COLUMN_NAME_COLUMN});
    private static final RowProjector GET_COLUMNS_ROW_PROJECTOR = new RowProjector(Arrays.asList(new ExpressionProjector("TABLE_CAT", "SYSTEM.\"CATALOG\"", new RowKeyColumnExpression(TENANT_ID_COLUMN, new RowKeyValueAccessor(PK_DATUM_LIST, 0)), false), new ExpressionProjector("TABLE_SCHEM", "SYSTEM.\"CATALOG\"", new RowKeyColumnExpression(TABLE_SCHEM_COLUMN, new RowKeyValueAccessor(PK_DATUM_LIST, 1)), false), new ExpressionProjector("TABLE_NAME", "SYSTEM.\"CATALOG\"", new RowKeyColumnExpression(TABLE_NAME_COLUMN, new RowKeyValueAccessor(PK_DATUM_LIST, 2)), false), new ExpressionProjector("COLUMN_NAME", "SYSTEM.\"CATALOG\"", new RowKeyColumnExpression(COLUMN_NAME_COLUMN, new RowKeyValueAccessor(PK_DATUM_LIST, 3)), false), new ExpressionProjector("DATA_TYPE", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(DATA_TYPE_COLUMN), false), new ExpressionProjector("TYPE_NAME", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(TYPE_NAME_COLUMN), false), new ExpressionProjector("COLUMN_SIZE", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(COLUMN_SIZE_COLUMN), false), new ExpressionProjector("BUFFER_LENGTH", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(BUFFER_LENGTH_COLUMN), false), new ExpressionProjector("DECIMAL_DIGITS", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(DECIMAL_DIGITS_COLUMN), false), new ExpressionProjector("NUM_PREC_RADIX", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(NUM_PREC_RADIX_COLUMN), false), new ExpressionProjector("NULLABLE", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(NULLABLE_COLUMN), false), new ExpressionProjector("REMARKS", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(REMARKS_COLUMN), false), new ExpressionProjector("COLUMN_DEF", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(COLUMN_DEF_COLUMN), false), new ExpressionProjector("SQL_DATA_TYPE", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(SQL_DATA_TYPE_COLUMN), false), new ExpressionProjector("SQL_DATETIME_SUB", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(SQL_DATETIME_SUB_COLUMN), false), new ExpressionProjector("CHAR_OCTET_LENGTH", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(CHAR_OCTET_LENGTH_COLUMN), false), new ExpressionProjector("ORDINAL_POSITION", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(ORDINAL_POSITION_COLUMN), false), new ExpressionProjector("IS_NULLABLE", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(IS_NULLABLE_COLUMN), false), new ExpressionProjector("SCOPE_CATALOG", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(SCOPE_CATALOG_COLUMN), false), new ExpressionProjector("SCOPE_SCHEMA", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(SCOPE_SCHEMA_COLUMN), false), new ExpressionProjector("SCOPE_TABLE", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(SCOPE_TABLE_COLUMN), false), new ExpressionProjector("SOURCE_DATA_TYPE", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(SOURCE_DATA_TYPE_COLUMN), false), new ExpressionProjector("IS_AUTOINCREMENT", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(IS_AUTOINCREMENT_COLUMN), false), new ExpressionProjector("ARRAY_SIZE", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(ARRAY_SIZE_COLUMN), false), new ExpressionProjector("COLUMN_FAMILY", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(COLUMN_FAMILY_COLUMN), false), new ExpressionProjector("TYPE_ID", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(TYPE_ID_COLUMN), false), new ExpressionProjector("VIEW_CONSTANT", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(VIEW_CONSTANT_COLUMN), false), new ExpressionProjector("MULTI_TENANT", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(MULTI_TENANT_COLUMN), false), new ExpressionProjector("KEY_SEQ", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(KEY_SEQ_COLUMN), false)), 0, true);
    private static final RowProjector GET_PRIMARY_KEYS_ROW_PROJECTOR = new RowProjector(Arrays.asList(new ExpressionProjector("TABLE_CAT", "SYSTEM.\"CATALOG\"", new RowKeyColumnExpression(TENANT_ID_COLUMN, new RowKeyValueAccessor(PK_DATUM_LIST, 0)), false), new ExpressionProjector("TABLE_SCHEM", "SYSTEM.\"CATALOG\"", new RowKeyColumnExpression(TABLE_SCHEM_COLUMN, new RowKeyValueAccessor(PK_DATUM_LIST, 1)), false), new ExpressionProjector("TABLE_NAME", "SYSTEM.\"CATALOG\"", new RowKeyColumnExpression(TABLE_NAME_COLUMN, new RowKeyValueAccessor(PK_DATUM_LIST, 2)), false), new ExpressionProjector("COLUMN_NAME", "SYSTEM.\"CATALOG\"", new RowKeyColumnExpression(COLUMN_NAME_COLUMN, new RowKeyValueAccessor(PK_DATUM_LIST, 3)), false), new ExpressionProjector("KEY_SEQ", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(KEY_SEQ_COLUMN), false), new ExpressionProjector("PK_NAME", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(PK_NAME_COLUMN), false), new ExpressionProjector("ASC_OR_DESC", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(ASC_OR_DESC_COLUMN), false), new ExpressionProjector("DATA_TYPE", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(DATA_TYPE_COLUMN), false), new ExpressionProjector("TYPE_NAME", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(TYPE_NAME_COLUMN), false), new ExpressionProjector("COLUMN_SIZE", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(COLUMN_SIZE_COLUMN), false), new ExpressionProjector("TYPE_ID", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(TYPE_ID_COLUMN), false), new ExpressionProjector("VIEW_CONSTANT", "SYSTEM.\"CATALOG\"", new KeyValueColumnExpression(VIEW_CONSTANT_COLUMN), false)), 0, true);
    private static final PDatum TABLE_TYPE_DATUM = new PDatum(){

        @Override
        public boolean isNullable() {
            return true;
        }

        @Override
        public PDataType getDataType() {
            return PVarchar.INSTANCE;
        }

        @Override
        public Integer getMaxLength() {
            return null;
        }

        @Override
        public Integer getScale() {
            return null;
        }

        @Override
        public SortOrder getSortOrder() {
            return SortOrder.getDefault();
        }
    };
    private static final RowProjector TABLE_TYPE_ROW_PROJECTOR = new RowProjector(Arrays.asList(new ExpressionProjector("TABLE_TYPE", "SYSTEM.\"CATALOG\"", new RowKeyColumnExpression(TABLE_TYPE_DATUM, new RowKeyValueAccessor(Collections.singletonList(TABLE_TYPE_DATUM), 0)), false)), 0, true);
    private static final Collection<Tuple> TABLE_TYPE_TUPLES = Lists.newArrayListWithExpectedSize((int)PTableType.values().length);

    PhoenixDatabaseMetaData(PhoenixConnection connection) throws SQLException {
        this.emptyResultSet = new PhoenixResultSet(ResultIterator.EMPTY_ITERATOR, RowProjector.EMPTY_PROJECTOR, new StatementContext(new PhoenixStatement(connection), false));
        this.connection = connection;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return this.emptyResultSet;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return this.emptyResultSet;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "Tenant";
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        PreparedStatement stmt = QueryUtil.getCatalogsStmt(this.connection);
        return stmt.executeQuery();
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return this.emptyResultSet;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return this.emptyResultSet;
    }

    private static void appendConjunction(StringBuilder buf) {
        buf.append(buf.length() == 0 ? "" : " and ");
    }

    private boolean match(String str, String pattern) throws SQLException {
        LiteralExpression strExpr = LiteralExpression.newConstant((Object)str, (PDataType)PVarchar.INSTANCE, SortOrder.ASC);
        LiteralExpression patternExpr = LiteralExpression.newConstant((Object)pattern, (PDataType)PVarchar.INSTANCE, SortOrder.ASC);
        List<Expression> children = Arrays.asList(strExpr, patternExpr);
        LikeExpression likeExpr = StringBasedLikeExpression.create(children, LikeParseNode.LikeType.CASE_SENSITIVE);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        boolean evaluated = likeExpr.evaluate(null, ptr);
        Boolean result = (Boolean)likeExpr.getDataType().toObject(ptr);
        if (evaluated) {
            return result;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            boolean isTenantSpecificConnection = this.connection.getTenantId() != null;
            ArrayList tuples = Lists.newArrayListWithExpectedSize((int)10);
            String colPattern = null;
            String cfPattern = null;
            if (columnNamePattern != null && columnNamePattern.length() > 0) {
                int index = columnNamePattern.indexOf(46);
                if (index <= 0) {
                    colPattern = columnNamePattern;
                } else {
                    cfPattern = columnNamePattern.substring(0, index);
                    if (columnNamePattern.length() > index + 1) {
                        colPattern = columnNamePattern.substring(index + 1);
                    }
                }
            }
            ResultSet rs = this.getTables(catalog, schemaPattern, tableNamePattern, null);
            while (rs.next()) {
                String schemaName = rs.getString(TABLE_SCHEM);
                String tableName = rs.getString(TABLE_NAME);
                String tenantId = rs.getString(TABLE_CAT);
                String fullTableName = SchemaUtil.getTableName(schemaName, tableName);
                PTable table = PhoenixRuntime.getTableNoCache(this.connection, fullTableName);
                boolean isSalted = table.getBucketNum() != null;
                boolean tenantColSkipped = false;
                ArrayList columns = table.getColumns();
                int startOffset = isSalted ? 1 : 0;
                columns = Lists.newArrayList(columns.subList(startOffset, columns.size()));
                for (PColumn column : columns) {
                    if (isTenantSpecificConnection && column.equals(table.getPKColumns().get(startOffset))) {
                        tenantColSkipped = true;
                        continue;
                    }
                    String columnFamily = column.getFamilyName() != null ? column.getFamilyName().getString() : null;
                    String columnName = column.getName().getString();
                    if (cfPattern != null && cfPattern.length() > 0 && (columnFamily == null || !this.match(columnFamily, cfPattern)) || colPattern != null && colPattern.length() > 0 && !this.match(columnName, colPattern)) continue;
                    byte[] rowKey = SchemaUtil.getColumnKey(tenantId, schemaName, tableName, columnName, null);
                    ArrayList cells = Lists.newArrayListWithCapacity((int)25);
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, DATA_TYPE_BYTES, 0L, PInteger.INSTANCE.toBytes(column.getDataType().getResultSetSqlType())));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, Bytes.toBytes((String)TYPE_NAME), 0L, column.getDataType().getSqlTypeNameBytes()));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, COLUMN_SIZE_BYTES, 0L, column.getMaxLength() != null ? PInteger.INSTANCE.toBytes(column.getMaxLength()) : ByteUtil.EMPTY_BYTE_ARRAY));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, Bytes.toBytes((String)BUFFER_LENGTH), 0L, ByteUtil.EMPTY_BYTE_ARRAY));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, DECIMAL_DIGITS_BYTES, 0L, column.getScale() != null ? PInteger.INSTANCE.toBytes(column.getScale()) : ByteUtil.EMPTY_BYTE_ARRAY));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, Bytes.toBytes((String)NUM_PREC_RADIX), 0L, ByteUtil.EMPTY_BYTE_ARRAY));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, NULLABLE_BYTES, 0L, PInteger.INSTANCE.toBytes(SchemaUtil.getIsNullableInt(column.isNullable()))));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, Bytes.toBytes((String)REMARKS), 0L, ByteUtil.EMPTY_BYTE_ARRAY));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, Bytes.toBytes((String)COLUMN_DEF), 0L, PVarchar.INSTANCE.toBytes(column.getExpressionStr())));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, Bytes.toBytes((String)SQL_DATA_TYPE), 0L, ByteUtil.EMPTY_BYTE_ARRAY));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, Bytes.toBytes((String)SQL_DATETIME_SUB), 0L, ByteUtil.EMPTY_BYTE_ARRAY));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, Bytes.toBytes((String)CHAR_OCTET_LENGTH), 0L, ByteUtil.EMPTY_BYTE_ARRAY));
                    int ordinal = column.getPosition() + (isSalted ? 0 : 1) - (tenantColSkipped ? 1 : 0);
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, ORDINAL_POSITION_BYTES, 0L, PInteger.INSTANCE.toBytes(ordinal)));
                    String isNullable = column.isNullable() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, Bytes.toBytes((String)IS_NULLABLE), 0L, PVarchar.INSTANCE.toBytes(isNullable)));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, Bytes.toBytes((String)SCOPE_CATALOG), 0L, ByteUtil.EMPTY_BYTE_ARRAY));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, Bytes.toBytes((String)SCOPE_SCHEMA), 0L, ByteUtil.EMPTY_BYTE_ARRAY));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, Bytes.toBytes((String)SCOPE_TABLE), 0L, ByteUtil.EMPTY_BYTE_ARRAY));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, Bytes.toBytes((String)SOURCE_DATA_TYPE), 0L, ByteUtil.EMPTY_BYTE_ARRAY));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, Bytes.toBytes((String)IS_AUTOINCREMENT), 0L, ByteUtil.EMPTY_BYTE_ARRAY));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, ARRAY_SIZE_BYTES, 0L, column.getArraySize() != null ? PInteger.INSTANCE.toBytes(column.getArraySize()) : ByteUtil.EMPTY_BYTE_ARRAY));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, COLUMN_FAMILY_BYTES, 0L, column.getFamilyName() != null ? column.getFamilyName().getBytes() : ByteUtil.EMPTY_BYTE_ARRAY));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, Bytes.toBytes((String)TYPE_ID), 0L, PInteger.INSTANCE.toBytes(column.getDataType().getSqlType())));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, VIEW_CONSTANT_BYTES, 0L, column.getViewConstant() != null ? column.getViewConstant() : ByteUtil.EMPTY_BYTE_ARRAY));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, MULTI_TENANT_BYTES, 0L, PBoolean.INSTANCE.toBytes(table.isMultiTenant())));
                    byte[] keySeqBytes = ByteUtil.EMPTY_BYTE_ARRAY;
                    int pkPos = table.getPKColumns().indexOf(column);
                    if (pkPos != -1) {
                        short keySeq = (short)(pkPos + 1 - startOffset - (tenantColSkipped ? 1 : 0));
                        keySeqBytes = PSmallint.INSTANCE.toBytes(keySeq);
                    }
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, KEY_SEQ_BYTES, 0L, keySeqBytes));
                    Collections.sort(cells, new CellComparatorImpl());
                    MultiKeyValueTuple tuple = new MultiKeyValueTuple(cells);
                    tuples.add(tuple);
                }
            }
            PhoenixResultSet phoenixResultSet = new PhoenixResultSet(new MaterializedResultIterator(tuples), GET_COLUMNS_ROW_PROJECTOR, new StatementContext(new PhoenixStatement(this.connection), false));
            return phoenixResultSet;
        }
        finally {
            if (this.connection.getAutoCommit()) {
                this.connection.commit();
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.emptyResultSet;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 5;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return 1;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "Phoenix";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return Integer.toString(this.getDatabaseMajorVersion()) + "." + Integer.toString(this.getDatabaseMinorVersion());
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    @Override
    public int getDriverMajorVersion() {
        return Integer.parseInt(this.connection.getClientInfo("DriverMajorVersion"));
    }

    @Override
    public int getDriverMinorVersion() {
        return Integer.parseInt(this.connection.getClientInfo("DriverMinorVersion"));
    }

    @Override
    public String getDriverName() throws SQLException {
        return this.connection.getClientInfo("DriverName");
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return this.connection.getClientInfo("DriverMajorVersion") + "." + this.connection.getClientInfo("DriverMinorVersion");
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.emptyResultSet;
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return this.emptyResultSet;
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return this.emptyResultSet;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.emptyResultSet;
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        PreparedStatement stmt = QueryUtil.getIndexInfoStmt(this.connection, catalog, schema, table, unique, approximate);
        if (stmt == null) {
            return this.emptyResultSet;
        }
        return stmt.executeQuery();
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 1;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 4000;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 200;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 1;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 1;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPrimaryKeys(String catalog, String schemaName, String tableName) throws SQLException {
        if (tableName == null || tableName.length() == 0) {
            return this.emptyResultSet;
        }
        String fullTableName = SchemaUtil.getTableName(schemaName, tableName);
        PTable table = PhoenixRuntime.getTableNoCache(this.connection, fullTableName);
        boolean isSalted = table.getBucketNum() != null;
        boolean tenantColSkipped = false;
        List<PColumn> pkColumns = table.getPKColumns();
        ArrayList sorderPkColumns = Lists.newArrayList(pkColumns.subList(isSalted ? 1 : 0, pkColumns.size()));
        Collections.sort(sorderPkColumns, new Comparator<PColumn>(){

            @Override
            public int compare(PColumn c1, PColumn c2) {
                return c1.getName().getString().compareTo(c2.getName().getString());
            }
        });
        try {
            ArrayList tuples = Lists.newArrayListWithExpectedSize((int)10);
            ResultSet rs = this.getTables(catalog, schemaName, tableName, null);
            while (rs.next()) {
                String tenantId = rs.getString(TABLE_CAT);
                for (PColumn column : sorderPkColumns) {
                    String columnName = column.getName().getString();
                    byte[] rowKey = SchemaUtil.getColumnKey(tenantId, schemaName, tableName, columnName, null);
                    ArrayList cells = Lists.newArrayListWithCapacity((int)8);
                    byte[] keySeqBytes = ByteUtil.EMPTY_BYTE_ARRAY;
                    int pkPos = pkColumns.indexOf(column);
                    if (pkPos != -1) {
                        short keySeq = (short)(pkPos + 1 - (isSalted ? 1 : 0) - (tenantColSkipped ? 1 : 0));
                        keySeqBytes = PSmallint.INSTANCE.toBytes(keySeq);
                    }
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, KEY_SEQ_BYTES, 0L, keySeqBytes));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, PK_NAME_BYTES, 0L, table.getPKName() != null ? table.getPKName().getBytes() : ByteUtil.EMPTY_BYTE_ARRAY));
                    int sortOrder = column.getSortOrder() == SortOrder.ASC ? 65 : 68;
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, ASC_OR_DESC_BYTES, 0L, Bytes.toBytes((int)sortOrder)));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, DATA_TYPE_BYTES, 0L, PInteger.INSTANCE.toBytes(column.getDataType().getResultSetSqlType())));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, Bytes.toBytes((String)TYPE_NAME), 0L, column.getDataType().getSqlTypeNameBytes()));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, COLUMN_SIZE_BYTES, 0L, column.getMaxLength() != null ? PInteger.INSTANCE.toBytes(column.getMaxLength()) : ByteUtil.EMPTY_BYTE_ARRAY));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, Bytes.toBytes((String)TYPE_ID), 0L, PInteger.INSTANCE.toBytes(column.getDataType().getSqlType())));
                    cells.add(PhoenixKeyValueUtil.newKeyValue(rowKey, TABLE_FAMILY_BYTES, VIEW_CONSTANT_BYTES, 0L, column.getViewConstant() != null ? column.getViewConstant() : ByteUtil.EMPTY_BYTE_ARRAY));
                    Collections.sort(cells, new CellComparatorImpl());
                    MultiKeyValueTuple tuple = new MultiKeyValueTuple(cells);
                    tuples.add(tuple);
                }
            }
            PhoenixResultSet phoenixResultSet = new PhoenixResultSet(new MaterializedResultIterator(tuples), GET_PRIMARY_KEYS_ROW_PROJECTOR, new StatementContext(new PhoenixStatement(this.connection), false));
            return phoenixResultSet;
        }
        finally {
            if (this.connection.getAutoCommit()) {
                this.connection.commit();
            }
        }
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return this.emptyResultSet;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "procedure";
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return this.emptyResultSet;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.connection.getHoldability();
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "";
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas("", null);
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        PreparedStatement stmt = QueryUtil.getSchemasStmt(this.connection, catalog, schemaPattern);
        return stmt.executeQuery();
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        PreparedStatement stmt = QueryUtil.getSuperTablesStmt(this.connection, catalog, schemaPattern, tableNamePattern);
        return stmt.executeQuery();
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return this.emptyResultSet;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.emptyResultSet;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return new PhoenixResultSet(new MaterializedResultIterator(TABLE_TYPE_TUPLES), TABLE_TYPE_ROW_PROJECTOR, new StatementContext(new PhoenixStatement(this.connection), false));
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        PreparedStatement stmt = QueryUtil.getTablesStmt(this.connection, catalog, schemaPattern, tableNamePattern, types);
        if (stmt == null) {
            return this.emptyResultSet;
        }
        return stmt.executeQuery();
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return this.emptyResultSet;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return this.emptyResultSet;
    }

    @Override
    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        String userName = this.connection.getQueryServices().getUserName();
        return userName == null ? "" : userName;
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return this.emptyResultSet;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return type == 1003 && concurrency == 2;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == this.connection.getHoldability();
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isInstance(this)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CLASS_NOT_UNWRAPPABLE).setMessage(this.getClass().getName() + " not unwrappable from " + iface.getName()).build().buildException();
        }
        return (T)this;
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.emptyResultSet;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    private void setParameters(PreparedStatement stmt, List<String> parameterValues) throws SQLException {
        for (int i = 0; i < parameterValues.size(); ++i) {
            stmt.setString(i + 1, parameterValues.get(i));
        }
    }

    static {
        ArrayList tableTypes = Lists.newArrayList((Object[])new byte[][]{PTableType.INDEX.getValue().getBytes(), Bytes.toBytes((String)"SEQUENCE"), PTableType.SYSTEM.getValue().getBytes(), PTableType.TABLE.getValue().getBytes(), PTableType.VIEW.getValue().getBytes()});
        for (byte[] tableType : tableTypes) {
            TABLE_TYPE_TUPLES.add(new SingleKeyValueTuple(PhoenixKeyValueUtil.newKeyValue(tableType, TABLE_FAMILY_BYTES, TABLE_TYPE_BYTES, 0L, ByteUtil.EMPTY_BYTE_ARRAY)));
        }
    }
}

