/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.io.IOException;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.phoenix.mapreduce.FormatToBytesWritableMapper;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.JacksonUtil;
import org.apache.phoenix.util.UpsertExecutor;
import org.apache.phoenix.util.json.JsonUpsertExecutor;

public class JsonToKeyValueMapper
extends FormatToBytesWritableMapper<Map<?, ?>> {
    private FormatToBytesWritableMapper.LineParser<Map<?, ?>> lineParser;

    @Override
    protected FormatToBytesWritableMapper.LineParser<Map<?, ?>> getLineParser() {
        return this.lineParser;
    }

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.lineParser = new JsonLineParser();
    }

    @Override
    @VisibleForTesting
    protected UpsertExecutor<Map<?, ?>, ?> buildUpsertExecutor(Configuration conf) {
        String tableName = conf.get("phoenix.mapreduce.import.tablename");
        Preconditions.checkNotNull((Object)tableName, (Object)"table name is not configured");
        List<ColumnInfo> columnInfoList = JsonToKeyValueMapper.buildColumnInfoList(conf);
        return new JsonUpsertExecutor((Connection)this.conn, tableName, columnInfoList, (UpsertExecutor.UpsertListener<Map<?, ?>>)this.upsertListener);
    }

    @VisibleForTesting
    static class JsonLineParser
    implements FormatToBytesWritableMapper.LineParser<Map<?, ?>> {
        JsonLineParser() {
        }

        @Override
        public Map<?, ?> parse(String input) throws IOException {
            return (Map)JacksonUtil.getObjectReader(Map.class).readValue(input);
        }
    }
}

