/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.lang.reflect.Field;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.monitoring.CombinableMetric;
import org.apache.phoenix.monitoring.CombinableMetricImpl;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.MetricsStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricUtil.class);

    public static CombinableMetric getCombinableMetric(boolean isRequestMetricsEnabled, LogLevel connectionLogLevel, MetricType type) {
        if (!type.isLoggingEnabled(connectionLogLevel) && !isRequestMetricsEnabled) {
            return CombinableMetric.NoOpRequestMetric.INSTANCE;
        }
        return new CombinableMetricImpl(type);
    }

    public static MetricsStopWatch getMetricsStopWatch(boolean isRequestMetricsEnabled, LogLevel connectionLogLevel, MetricType type) {
        if (!type.isLoggingEnabled(connectionLogLevel) && !isRequestMetricsEnabled) {
            return new MetricsStopWatch(false);
        }
        return new MetricsStopWatch(true);
    }

    public static boolean isDefaultMetricsInitialized() {
        try {
            MetricsSystemImpl metrics = (MetricsSystemImpl)DefaultMetricsSystem.instance();
            Field prefixField = MetricsSystemImpl.class.getDeclaredField("prefix");
            prefixField.setAccessible(true);
            String prefix = (String)prefixField.get(metrics);
            prefixField.setAccessible(false);
            if (prefix != null) {
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception trying to determine if HBase metrics is initialized", (Throwable)e);
        }
        return false;
    }
}

