/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.ShowStatement;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;

public class ShowSchemasStatement
extends ShowStatement {
    @Nullable
    private final String schemaPattern;

    public ShowSchemasStatement(String pattern) {
        this.schemaPattern = pattern;
    }

    @Nullable
    protected String getSchemaPattern() {
        return this.schemaPattern;
    }

    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        Preconditions.checkNotNull((Object)buf);
        buf.append("SHOW SCHEMAS");
        if (this.schemaPattern != null) {
            buf.append(" LIKE ");
            buf.append("'").append(this.schemaPattern).append("'");
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toSQL(null, buf);
        return buf.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ShowSchemasStatement)) {
            return false;
        }
        ShowSchemasStatement stmt = (ShowSchemasStatement)other;
        return Objects.equals(this.schemaPattern, stmt.getSchemaPattern());
    }

    public int hashCode() {
        return Objects.hashCode(this.schemaPattern);
    }
}

