/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.EmptyStatsLoader;
import org.apache.phoenix.query.GuidePostsCache;
import org.apache.phoenix.query.GuidePostsCacheFactory;
import org.apache.phoenix.query.GuidePostsCacheImpl;
import org.apache.phoenix.query.PhoenixStatsCacheLoader;
import org.apache.phoenix.query.PhoenixStatsLoader;
import org.apache.phoenix.query.StatsLoaderImpl;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.ReadOnlyProps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGuidePostsCacheFactory
implements GuidePostsCacheFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultGuidePostsCacheFactory.class);

    @Override
    public PhoenixStatsLoader getPhoenixStatsLoader(ConnectionQueryServices queryServices, ReadOnlyProps readOnlyProps, Configuration config) {
        Preconditions.checkNotNull((Object)config);
        boolean isStatsEnabled = config.getBoolean("phoenix.stats.collection.enabled", true);
        if (queryServices == null || !isStatsEnabled) {
            LOGGER.info("Using EmptyStatsLoader from DefaultGuidePostsCacheFactory");
            return new EmptyStatsLoader();
        }
        return new StatsLoaderImpl(queryServices);
    }

    @Override
    public GuidePostsCache getGuidePostsCache(PhoenixStatsLoader phoenixStatsLoader, Configuration config) {
        LOGGER.debug("DefaultGuidePostsCacheFactory guide post cache construction.");
        PhoenixStatsCacheLoader cacheLoader = new PhoenixStatsCacheLoader(phoenixStatsLoader, config);
        return new GuidePostsCacheImpl(cacheLoader, config);
    }
}

