/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.sql.SQLException;
import java.util.Set;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.ColumnExpression;
import org.apache.phoenix.expression.ProjectedColumnExpression;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.MetaDataEntityNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.IndexUtil;

public class IndexDataColumnRef
extends ColumnRef {
    private final int position;
    private final Set<PColumn> columns;
    private static final ParseNodeFactory FACTORY = new ParseNodeFactory();

    public IndexDataColumnRef(StatementContext context, TableRef tRef, String indexColumnName) throws MetaDataEntityNotFoundException, SQLException {
        super(FromCompiler.getResolver(FACTORY.namedTable(null, TableName.create(tRef.getTable().getSchemaName().getString(), tRef.getTable().getParentTableName().getString())), context.getConnection(), false).resolveTable(context.getCurrentTable().getTable().getSchemaName().getString(), tRef.getTable().getParentTableName().getString()), IndexUtil.getDataColumnFamilyName(indexColumnName), IndexUtil.getDataColumnName(indexColumnName));
        this.position = context.getDataColumnPosition(this.getColumn());
        this.columns = context.getDataColumns();
    }

    protected IndexDataColumnRef(IndexDataColumnRef indexDataColumnRef, long timestamp) {
        super(indexDataColumnRef, timestamp);
        this.position = indexDataColumnRef.position;
        this.columns = indexDataColumnRef.columns;
    }

    @Override
    public ColumnRef cloneAtTimestamp(long timestamp) {
        return new IndexDataColumnRef(this, timestamp);
    }

    @Override
    public ColumnExpression newColumnExpression(boolean schemaNameCaseSensitive, boolean colNameCaseSensitive) {
        String displayName = this.getTableRef().getColumnDisplayName(this, schemaNameCaseSensitive, colNameCaseSensitive);
        return new ProjectedColumnExpression(this.getColumn(), this.columns, this.position, displayName);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.position;
        result = 31 * result + (this.columns == null ? 0 : this.columns.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        IndexDataColumnRef that = (IndexDataColumnRef)o;
        if (this.position != that.position) {
            return false;
        }
        return this.columns.equals(that.columns);
    }
}

