/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.PSchema;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableRef;
import org.apache.phoenix.thirdparty.com.google.common.cache.Cache;
import org.apache.phoenix.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.phoenix.thirdparty.com.google.common.cache.RemovalListener;
import org.apache.phoenix.thirdparty.com.google.common.cache.RemovalNotification;
import org.apache.phoenix.thirdparty.com.google.common.cache.Weigher;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TimeKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PMetaDataCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(PMetaDataCache.class);
    private final TimeKeeper timeKeeper;
    private final Cache<PTableKey, PTableRef> tables;
    final Map<PTableKey, PFunction> functions;
    final Map<PTableKey, PSchema> schemas;

    public PMetaDataCache(int initialCapacity, long maxByteSize, TimeKeeper timeKeeper) {
        this.tables = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<PTableKey, PTableRef>(){

            public void onRemoval(RemovalNotification<PTableKey, PTableRef> notification) {
                String key = ((PTableKey)notification.getKey()).toString();
                LOGGER.debug("Expiring " + key + " because of " + notification.getCause().name());
            }
        }).maximumWeight(maxByteSize).weigher((Weigher)new Weigher<PTableKey, PTableRef>(){

            public int weigh(PTableKey tableKey, PTableRef tableRef) {
                if ("SYSTEM".equals(SchemaUtil.getSchemaNameFromFullName(tableKey.getName()))) {
                    return 0;
                }
                return tableRef.getEstimatedSize();
            }
        }).build();
        this.functions = new ConcurrentHashMap<PTableKey, PFunction>(initialCapacity);
        this.schemas = new ConcurrentHashMap<PTableKey, PSchema>(initialCapacity);
        this.timeKeeper = timeKeeper;
    }

    public PTableRef get(PTableKey key) {
        PTableRef tableAccess = (PTableRef)this.tables.getIfPresent((Object)key);
        return tableAccess;
    }

    PTable put(PTableKey key, PTableRef ref) {
        PTableRef oldTableRef = this.tables.asMap().put(key, ref);
        if (oldTableRef == null) {
            return null;
        }
        return oldTableRef.getTable();
    }

    public long getAge(PTableRef ref) {
        return this.timeKeeper.getCurrentTime() - ref.getCreateTime();
    }

    public PTable remove(PTableKey key) {
        PTableRef value = (PTableRef)this.tables.getIfPresent((Object)key);
        this.tables.invalidate((Object)key);
        if (value == null) {
            return null;
        }
        return value.getTable();
    }

    public Iterator<PTable> iterator() {
        final Iterator iterator = this.tables.asMap().values().iterator();
        return new Iterator<PTable>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public PTable next() {
                return ((PTableRef)iterator.next()).getTable();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public long size() {
        return this.tables.size();
    }
}

