/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.thirdparty.com.google.common.primitives.Longs;
import org.apache.phoenix.util.ByteUtil;

public class GuidePostsInfo {
    public static final GuidePostsInfo NO_GUIDEPOST = new GuidePostsInfo(Collections.emptyList(), new ImmutableBytesWritable(ByteUtil.EMPTY_BYTE_ARRAY), Collections.emptyList(), 0, 0, Collections.emptyList()){

        @Override
        public int getEstimatedSize() {
            return 0;
        }
    };
    public static final byte[] EMPTY_GUIDEPOST_KEY = ByteUtil.EMPTY_BYTE_ARRAY;
    private final ImmutableBytesWritable guidePosts;
    private final int maxLength;
    private final int guidePostsCount;
    private final long[] rowCounts;
    private final long[] byteCounts;
    private final int estimatedSize;
    private final long[] gpTimestamps;

    public GuidePostsInfo(List<Long> byteCounts, ImmutableBytesWritable guidePosts, List<Long> rowCounts, int maxLength, int guidePostsCount, List<Long> updateTimes) {
        int estimatedSize;
        this.guidePosts = new ImmutableBytesWritable(guidePosts);
        this.maxLength = maxLength;
        this.guidePostsCount = guidePostsCount;
        this.rowCounts = Longs.toArray(rowCounts);
        this.byteCounts = Longs.toArray(byteCounts);
        this.gpTimestamps = Longs.toArray(updateTimes);
        this.estimatedSize = estimatedSize = 64 + guidePosts.getLength() + 4 + 4 + 24 + this.rowCounts.length * 8 + 24 + this.byteCounts.length * 8 + 24 + this.gpTimestamps.length * 8 + 4;
    }

    public ImmutableBytesWritable getGuidePosts() {
        return this.guidePosts;
    }

    public int getGuidePostsCount() {
        return this.guidePostsCount;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public long[] getRowCounts() {
        return this.rowCounts;
    }

    public long[] getByteCounts() {
        return this.byteCounts;
    }

    public long[] getGuidePostTimestamps() {
        return this.gpTimestamps;
    }

    public int getEstimatedSize() {
        return this.estimatedSize;
    }

    @SuppressWarnings(value={"EC_ARRAY_AND_NONARRAY"}, justification="ImmutableBytesWritable DOES implement equals(byte])")
    public boolean isEmptyGuidePost() {
        return this.guidePosts.equals((Object)EMPTY_GUIDEPOST_KEY) && this.guidePostsCount == 0 && this.byteCounts.length == 1 && this.gpTimestamps.length == 1;
    }

    public static GuidePostsInfo createEmptyGuidePost(long byteCount, long guidePostUpdateTime) {
        return new GuidePostsInfo(Collections.singletonList(byteCount), new ImmutableBytesWritable(EMPTY_GUIDEPOST_KEY), Collections.emptyList(), 0, 0, Collections.singletonList(guidePostUpdateTime));
    }

    public static boolean isEmptyGpsKey(byte[] key) {
        return Bytes.equals((byte[])key, (byte[])EMPTY_GUIDEPOST_KEY);
    }
}

