/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.tool;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.phoenix.schema.tool.SchemaExtractionProcessor;
import org.apache.phoenix.schema.tool.SchemaProcessor;
import org.apache.phoenix.schema.tool.SchemaSynthesisProcessor;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.DefaultParser;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Option;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Options;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaTool
extends Configured
implements Tool {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaTool.class);
    private static final Option HELP_OPTION = new Option("h", "help", false, "Help");
    private static final Option MODE_OPTION = new Option("m", "mode", true, "[Required] Takes either synth or extract value");
    private static final Option DDL_OPTION = new Option("d", "ddl", true, "[Required with synth mode] SQL file that has one or more ddl statements for the same entity");
    private static final Option TABLE_OPTION = new Option("tb", "table", true, "[Required with extract mode] Table name ex. table1");
    private static final Option SCHEMA_OPTION = new Option("s", "schema", true, "[Optional] Schema name ex. schema");
    private static final Option TENANT_OPTION = new Option("t", "tenant", true, "[Optional] Tenant Id ex. abc");
    private String pTableName;
    private String pSchemaName;
    private String tenantId;
    private Enum mode;
    protected static Configuration conf;
    private String output;
    private String ddlFile;
    private String alterDDLFile;

    public int run(String[] args) throws Exception {
        this.populateToolAttributes(args);
        SchemaProcessor processor = null;
        if (Mode.SYNTH.equals(this.mode)) {
            processor = new SchemaSynthesisProcessor(this.ddlFile);
        } else if (Mode.EXTRACT.equals(this.mode)) {
            conf = HBaseConfiguration.addHbaseResources((Configuration)this.getConf());
            processor = new SchemaExtractionProcessor(this.tenantId, conf, this.pSchemaName, this.pTableName);
        } else {
            throw new Exception(this.mode + " is not accepted, provide [synth or extract]");
        }
        this.output = processor.process();
        LOGGER.info("Effective DDL with " + this.mode.toString() + ": " + this.output);
        return 0;
    }

    public String getOutput() {
        return this.output;
    }

    private void populateToolAttributes(String[] args) {
        try {
            CommandLine cmdLine = this.parseOptions(args);
            this.mode = Mode.valueOf(cmdLine.getOptionValue(MODE_OPTION.getOpt()));
            this.ddlFile = cmdLine.getOptionValue(DDL_OPTION.getOpt());
            this.pTableName = cmdLine.getOptionValue(TABLE_OPTION.getOpt());
            this.pSchemaName = cmdLine.getOptionValue(SCHEMA_OPTION.getOpt());
            this.tenantId = cmdLine.getOptionValue(TENANT_OPTION.getOpt());
            LOGGER.info("Schema Tool initiated: " + StringUtils.join((Object[])args, (String)","));
        }
        catch (IllegalStateException e) {
            this.printHelpAndExit(e.getMessage(), this.getOptions());
        }
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="null path call calls System.exit()")
    private CommandLine parseOptions(String[] args) {
        Options options = this.getOptions();
        DefaultParser parser = new DefaultParser(false, false);
        CommandLine cmdLine = null;
        try {
            cmdLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            this.printHelpAndExit("severe parsing command line options: " + e.getMessage(), options);
        }
        if (cmdLine == null) {
            this.printHelpAndExit("parsed command line object is null", options);
        }
        if (cmdLine.hasOption(HELP_OPTION.getOpt())) {
            this.printHelpAndExit(options, 0);
        }
        if (!cmdLine.hasOption(TABLE_OPTION.getOpt()) && cmdLine.getOptionValue(MODE_OPTION.getOpt()).equalsIgnoreCase(Mode.EXTRACT.toString())) {
            throw new IllegalStateException("Table name should be passed with EXTRACT mode" + TABLE_OPTION.getLongOpt());
        }
        if (!cmdLine.hasOption(DDL_OPTION.getOpt()) && cmdLine.getOptionValue(MODE_OPTION.getOpt()).equalsIgnoreCase(Mode.SYNTH.toString())) {
            throw new IllegalStateException("ddl option should be passed with SYNTH mode" + DDL_OPTION.getLongOpt());
        }
        return cmdLine;
    }

    private Options getOptions() {
        Options options = new Options();
        options.addOption(TABLE_OPTION);
        options.addOption(MODE_OPTION);
        options.addOption(DDL_OPTION);
        SCHEMA_OPTION.setOptionalArg(true);
        options.addOption(SCHEMA_OPTION);
        TENANT_OPTION.setOptionalArg(true);
        options.addOption(TENANT_OPTION);
        return options;
    }

    private void printHelpAndExit(String severeMessage, Options options) {
        System.err.println(severeMessage);
        this.printHelpAndExit(options, 1);
    }

    private void printHelpAndExit(Options options, int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("help", options);
        System.exit(exitCode);
    }

    public static void main(String[] args) throws Exception {
        int result = ToolRunner.run((Tool)new SchemaTool(), (String[])args);
        System.exit(result);
    }

    static enum Mode {
        SYNTH,
        EXTRACT;

    }
}

