/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PhoenixArray;

public class PUnsignedFloatArray
extends PArrayDataType<float[]> {
    public static final PUnsignedFloatArray INSTANCE = new PUnsignedFloatArray();

    private PUnsignedFloatArray() {
        super("UNSIGNED_FLOAT ARRAY", 3000 + PUnsignedFloat.INSTANCE.getSqlType(), PhoenixArray.class, null, 46);
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return this.compareTo(lhs, rhs);
    }

    @Override
    public Integer getByteSize() {
        return null;
    }

    @Override
    public byte[] toBytes(Object object) {
        return this.toBytes(object, SortOrder.ASC);
    }

    @Override
    public byte[] toBytes(Object object, SortOrder sortOrder) {
        return this.toBytes(object, PUnsignedFloat.INSTANCE, sortOrder);
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        return this.toObject(bytes, offset, length, PUnsignedFloat.INSTANCE, sortOrder, maxLength, scale, PUnsignedFloat.INSTANCE);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return this.isCoercibleTo(targetType, this);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        float[] floatArr;
        if (value == null) {
            return true;
        }
        PhoenixArray.PrimitiveFloatPhoenixArray pArr = (PhoenixArray.PrimitiveFloatPhoenixArray)value;
        float[] fArray = floatArr = (float[])pArr.array;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            Float i2 = Float.valueOf(fArray[i]);
            if (super.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE, i2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return this.getSampleValue(PUnsignedFloat.INSTANCE, arrayLength, maxLength);
    }
}

