/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.text.Format;
import java.util.Random;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.StringUtil;

public class PVarchar
extends PDataType<String> {
    public static final PVarchar INSTANCE = new PVarchar();
    private char[] sampleChars = new char[1];

    private PVarchar() {
        super("VARCHAR", 12, String.class, null, 0);
    }

    @Override
    public byte[] toBytes(Object object) {
        if (object == null) {
            return ByteUtil.EMPTY_BYTE_ARRAY;
        }
        return Bytes.toBytes((String)((String)object));
    }

    @Override
    public int toBytes(Object object, byte[] bytes, int offset) {
        if (object == null) {
            return 0;
        }
        byte[] b = this.toBytes(object);
        System.arraycopy(b, 0, bytes, offset, b.length);
        return b.length;
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        if (length == 0) {
            return null;
        }
        if (!actualType.isCoercibleTo(this)) {
            PVarchar.throwConstraintViolationException(actualType, this);
        }
        if (sortOrder == SortOrder.DESC) {
            bytes = SortOrder.invert(bytes, offset, length);
            offset = 0;
        }
        return Bytes.toString((byte[])bytes, (int)offset, (int)length);
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        if (PVarchar.equalsAny(actualType, this, PChar.INSTANCE)) {
            String s = (String)object;
            return s == null || s.length() > 0 ? s : null;
        }
        return PVarchar.throwConstraintViolationException(actualType, this);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return PVarchar.equalsAny(targetType, this, PChar.INSTANCE, PVarbinary.INSTANCE, PBinary.INSTANCE);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        if (this.isCoercibleTo(targetType)) {
            if (targetType.equals(PChar.INSTANCE)) {
                return value != null;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isSizeCompatible(ImmutableBytesWritable ptr, Object value, PDataType srcType, SortOrder sortOrder, Integer maxLength, Integer scale, Integer desiredMaxLength, Integer desiredScale) {
        if (ptr.getLength() != 0 && desiredMaxLength != null && (maxLength == null || maxLength > desiredMaxLength)) {
            if (value != null) {
                maxLength = value.toString().length();
            } else {
                this.coerceBytes(ptr, value, srcType, maxLength, scale, sortOrder, desiredMaxLength, desiredScale, sortOrder, true);
                maxLength = StringUtil.calculateUTF8Length(ptr.get(), ptr.getOffset(), ptr.getLength(), sortOrder);
            }
            return maxLength <= desiredMaxLength;
        }
        return true;
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public int estimateByteSize(Object o) {
        String value = (String)o;
        return value == null ? 1 : value.length();
    }

    @Override
    public Integer getByteSize() {
        return null;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        if (lhs == rhs) {
            return 0;
        }
        if (lhs == null) {
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        return ((String)lhs).compareTo((String)rhs);
    }

    @Override
    public Object toObject(String value) {
        return value;
    }

    @Override
    public boolean isBytesComparableWith(PDataType otherType) {
        return super.isBytesComparableWith(otherType) || otherType == PChar.INSTANCE;
    }

    @Override
    public String toStringLiteral(Object o, Format formatter) {
        if (formatter != null) {
            return "'" + formatter.format(o) + "'";
        }
        return null == o ? String.valueOf(o) : "'" + StringUtil.escapeStringConstant(o.toString()) + "'";
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        int length;
        Preconditions.checkArgument((maxLength == null || maxLength >= 0 ? 1 : 0) != 0);
        int n = length = maxLength != null ? maxLength : 1;
        if (length != this.sampleChars.length) {
            this.sampleChars = new char[length];
        }
        for (int i = 0; i < length; ++i) {
            this.sampleChars[i] = (char)(((Random)RANDOM.get()).nextInt(125) + 1);
        }
        return new String(this.sampleChars);
    }
}

