/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.SQLCloseable;

public class PhoenixArray
implements Array,
SQLCloseable {
    private static final String TO_STRING_SEPARATOR = ", ";
    private static final String TO_STRING_END = "]";
    private static final String TO_STRING_BEGIN = "[";
    PDataType baseType;
    Object array;
    int numElements;
    Integer maxLength;
    protected int hashCode = Integer.MIN_VALUE;

    public PhoenixArray() {
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public boolean isPrimitiveType() {
        return this.baseType.getCodec() != null;
    }

    private static Object[] coerceToNewLength(PDataType baseType, Object[] elements, int maxLength) {
        Object[] resizedElements = new Object[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            Integer length = baseType.getMaxLength(elements[i]);
            if (length != null) {
                if (length == maxLength) {
                    resizedElements[i] = elements[i];
                    continue;
                }
                resizedElements[i] = baseType.pad(elements[i], maxLength);
                continue;
            }
            resizedElements[i] = baseType.pad(elements[i], maxLength);
        }
        return resizedElements;
    }

    private static Object[] coerceToEqualLength(PDataType baseType, Object[] elements) {
        if (elements == null || elements.length == 0) {
            return elements;
        }
        int maxLength = 0;
        boolean resizeElements = false;
        for (int i = 0; i < elements.length; ++i) {
            Integer length = baseType.getMaxLength(elements[i]);
            if (length != null) {
                if (maxLength == 0) {
                    maxLength = length;
                    continue;
                }
                if (length > maxLength) {
                    maxLength = length;
                    resizeElements = true;
                    continue;
                }
                if (length >= maxLength) continue;
                resizeElements = true;
                continue;
            }
            resizeElements = true;
        }
        if (!resizeElements) {
            return elements;
        }
        return PhoenixArray.coerceToNewLength(baseType, elements, maxLength);
    }

    public PhoenixArray(PDataType baseType, Object[] elements) {
        this.baseType = baseType;
        if (baseType.isFixedWidth() && baseType.getByteSize() == null && (elements = PhoenixArray.coerceToEqualLength(baseType, elements)) != null && elements.length > 0) {
            for (int i = 0; i < elements.length; ++i) {
                if (elements[i] == null) continue;
                this.maxLength = baseType.getMaxLength(elements[i]);
                break;
            }
        }
        this.array = this.convertObjectArrayToPrimitiveArray(elements);
        this.numElements = elements.length;
    }

    public PhoenixArray(PhoenixArray pArr, Integer desiredMaxLength) {
        this.baseType = pArr.baseType;
        Object[] elements = (Object[])pArr.array;
        if (this.baseType.isFixedWidth() && this.baseType.getByteSize() == null) {
            elements = PhoenixArray.coerceToNewLength(this.baseType, (Object[])pArr.array, desiredMaxLength);
            this.maxLength = desiredMaxLength;
        }
        this.array = this.convertObjectArrayToPrimitiveArray(elements);
        this.numElements = elements.length;
    }

    public Object convertObjectArrayToPrimitiveArray(Object[] elements) {
        return elements;
    }

    @Override
    public void free() throws SQLException {
    }

    @Override
    public Object getArray() throws SQLException {
        return this.array;
    }

    @Override
    public void close() throws SQLException {
        this.array = null;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("Currently not supported");
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        if (index < 1L) {
            throw new IllegalArgumentException("Index cannot be less than 1");
        }
        Object[] intArr = (Object[])this.array;
        this.boundaryCheck(index, count, intArr);
        Object[] newArr = new Object[count];
        int i = 0;
        for (int j = (int)index; j < count; ++j) {
            newArr[i] = intArr[j];
            ++i;
        }
        return newArr;
    }

    private void boundaryCheck(long index, int count, Object[] arr) {
        if (index - 1L + (long)count > (long)arr.length) {
            throw new IllegalArgumentException("The array index is out of range of the total number of elements in the array " + arr.length);
        }
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        if (map != null && !map.isEmpty()) {
            throw new UnsupportedOperationException("Currently not supported");
        }
        return null;
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.baseType.getSqlType();
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.baseType.getSqlTypeName();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw new UnsupportedOperationException("Currently not supported");
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> arg0) throws SQLException {
        throw new UnsupportedOperationException("Currently not supported");
    }

    @Override
    public ResultSet getResultSet(long arg0, int arg1) throws SQLException {
        throw new UnsupportedOperationException("Currently not supported");
    }

    @Override
    public ResultSet getResultSet(long arg0, int arg1, Map<String, Class<?>> arg2) throws SQLException {
        throw new UnsupportedOperationException("Currently not supported");
    }

    public Object getElement(int index) {
        return ((Object[])this.array)[index];
    }

    public int getDimensions() {
        return this.numElements;
    }

    public int estimateByteSize(int pos) {
        if (((Object[])this.array)[pos] == null) {
            return 0;
        }
        return this.baseType.estimateByteSize(((Object[])this.array)[pos]);
    }

    public Integer getMaxLength(int pos) {
        return this.baseType.getMaxLength(((Object[])this.array)[pos]);
    }

    public byte[] toBytes(int pos) {
        return this.baseType.toBytes(((Object[])this.array)[pos]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(TO_STRING_BEGIN);
        boolean isFirst = true;
        for (int i = 0; i < this.getDimensions(); ++i) {
            Object o = this.getElement(i);
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(TO_STRING_SEPARATOR);
            }
            sb.append(this.baseType.toStringLiteral(o));
        }
        sb.append(TO_STRING_END);
        return sb.toString();
    }

    public boolean isNull(int pos) {
        return this.baseType.toBytes(((Object[])this.array)[pos]).length == 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PhoenixArray)) {
            return false;
        }
        PhoenixArray oArray = (PhoenixArray)obj;
        if (this.numElements != oArray.numElements) {
            return false;
        }
        if (this.baseType.getSqlType() != oArray.baseType.getSqlType()) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.array, (Object[])oArray.array);
    }

    public int hashCode() {
        if (this.hashCode != Integer.MIN_VALUE) {
            return this.hashCode;
        }
        this.hashCode = 17;
        this.hashCode = this.hashCode * 37 + this.numElements;
        this.hashCode = this.hashCode * 37 + this.baseType.getSqlType();
        this.hashCode = this.hashCode * 37 + Arrays.deepHashCode((Object[])this.array);
        return this.hashCode;
    }

    public static class PrimitiveBooleanPhoenixArray
    extends PhoenixArray {
        private boolean[] booleanArr;

        public PrimitiveBooleanPhoenixArray(PDataType dataType, Object[] elements) {
            super(dataType, elements);
        }

        @Override
        public boolean isPrimitiveType() {
            return true;
        }

        @Override
        public Object convertObjectArrayToPrimitiveArray(Object[] elements) {
            this.booleanArr = new boolean[elements.length];
            int i = 0;
            for (Object o : elements) {
                if (o != null) {
                    this.booleanArr[i] = (Boolean)o;
                }
                ++i;
            }
            return this.booleanArr;
        }

        @Override
        public int estimateByteSize(int pos) {
            return this.baseType.estimateByteSize(this.booleanArr[pos]);
        }

        @Override
        public byte[] toBytes(int pos) {
            return this.baseType.toBytes(this.booleanArr[pos]);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PrimitiveBooleanPhoenixArray oArray = (PrimitiveBooleanPhoenixArray)obj;
            if (this.numElements != oArray.numElements) {
                return false;
            }
            if (this.baseType.getSqlType() != oArray.baseType.getSqlType()) {
                return false;
            }
            return Arrays.equals((boolean[])this.array, (boolean[])oArray.array);
        }

        @Override
        public int hashCode() {
            if (this.hashCode != Integer.MIN_VALUE) {
                return this.hashCode;
            }
            this.hashCode = 17;
            this.hashCode = this.hashCode * 37 + this.numElements;
            this.hashCode = this.hashCode * 37 + this.baseType.getSqlType();
            this.hashCode = this.hashCode * 37 + Arrays.hashCode((boolean[])this.array);
            return this.hashCode;
        }

        @Override
        public Object getElement(int index) {
            return ((boolean[])this.array)[index];
        }
    }

    public static class PrimitiveBytePhoenixArray
    extends PhoenixArray {
        private byte[] byteArr;

        public PrimitiveBytePhoenixArray(PDataType dataType, Object[] elements) {
            super(dataType, elements);
        }

        @Override
        public Object convertObjectArrayToPrimitiveArray(Object[] elements) {
            this.byteArr = new byte[elements.length];
            int i = 0;
            for (Object o : elements) {
                if (o != null) {
                    this.byteArr[i] = (Byte)o;
                }
                ++i;
            }
            return this.byteArr;
        }

        @Override
        public int estimateByteSize(int pos) {
            return this.baseType.estimateByteSize(this.byteArr[pos]);
        }

        @Override
        public byte[] toBytes(int pos) {
            return this.baseType.toBytes(this.byteArr[pos]);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PrimitiveBytePhoenixArray oArray = (PrimitiveBytePhoenixArray)obj;
            if (this.numElements != oArray.numElements) {
                return false;
            }
            if (this.baseType.getSqlType() != oArray.baseType.getSqlType()) {
                return false;
            }
            return Arrays.equals((byte[])this.array, (byte[])oArray.array);
        }

        @Override
        public int hashCode() {
            if (this.hashCode != Integer.MIN_VALUE) {
                return this.hashCode;
            }
            this.hashCode = 17;
            this.hashCode = this.hashCode * 37 + this.numElements;
            this.hashCode = this.hashCode * 37 + this.baseType.getSqlType();
            this.hashCode = this.hashCode * 37 + Arrays.hashCode((byte[])this.array);
            return this.hashCode;
        }

        @Override
        public Object getElement(int index) {
            return ((byte[])this.array)[index];
        }
    }

    public static class PrimitiveFloatPhoenixArray
    extends PhoenixArray {
        private float[] floatArr;

        public PrimitiveFloatPhoenixArray(PDataType dataType, Object[] elements) {
            super(dataType, elements);
        }

        @Override
        public Object convertObjectArrayToPrimitiveArray(Object[] elements) {
            this.floatArr = new float[elements.length];
            int i = 0;
            for (Object o : elements) {
                if (o != null) {
                    this.floatArr[i] = ((Float)o).floatValue();
                }
                ++i;
            }
            return this.floatArr;
        }

        @Override
        public int estimateByteSize(int pos) {
            return this.baseType.estimateByteSize(Float.valueOf(this.floatArr[pos]));
        }

        @Override
        public byte[] toBytes(int pos) {
            return this.baseType.toBytes(Float.valueOf(this.floatArr[pos]));
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PrimitiveFloatPhoenixArray oArray = (PrimitiveFloatPhoenixArray)obj;
            if (this.numElements != oArray.numElements) {
                return false;
            }
            if (this.baseType.getSqlType() != oArray.baseType.getSqlType()) {
                return false;
            }
            return Arrays.equals((float[])this.array, (float[])oArray.array);
        }

        @Override
        public int hashCode() {
            if (this.hashCode != Integer.MIN_VALUE) {
                return this.hashCode;
            }
            this.hashCode = 17;
            this.hashCode = this.hashCode * 37 + this.numElements;
            this.hashCode = this.hashCode * 37 + this.baseType.getSqlType();
            this.hashCode = this.hashCode * 37 + Arrays.hashCode((float[])this.array);
            return this.hashCode;
        }

        @Override
        public Object getElement(int index) {
            return Float.valueOf(((float[])this.array)[index]);
        }
    }

    public static class PrimitiveDoublePhoenixArray
    extends PhoenixArray {
        private double[] doubleArr;

        public PrimitiveDoublePhoenixArray(PDataType dataType, Object[] elements) {
            super(dataType, elements);
        }

        @Override
        public Object convertObjectArrayToPrimitiveArray(Object[] elements) {
            this.doubleArr = new double[elements.length];
            int i = 0;
            for (Object o : elements) {
                if (o != null) {
                    this.doubleArr[i] = (Double)o;
                }
                ++i;
            }
            return this.doubleArr;
        }

        @Override
        public int estimateByteSize(int pos) {
            return this.baseType.estimateByteSize(this.doubleArr[pos]);
        }

        @Override
        public byte[] toBytes(int pos) {
            return this.baseType.toBytes(this.doubleArr[pos]);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PrimitiveDoublePhoenixArray oArray = (PrimitiveDoublePhoenixArray)obj;
            if (this.numElements != oArray.numElements) {
                return false;
            }
            if (this.baseType.getSqlType() != oArray.baseType.getSqlType()) {
                return false;
            }
            return Arrays.equals((double[])this.array, (double[])oArray.array);
        }

        @Override
        public int hashCode() {
            if (this.hashCode != Integer.MIN_VALUE) {
                return this.hashCode;
            }
            this.hashCode = 17;
            this.hashCode = this.hashCode * 37 + this.numElements;
            this.hashCode = this.hashCode * 37 + this.baseType.getSqlType();
            this.hashCode = this.hashCode * 37 + Arrays.hashCode((double[])this.array);
            return this.hashCode;
        }

        @Override
        public Object getElement(int index) {
            return ((double[])this.array)[index];
        }
    }

    public static class PrimitiveLongPhoenixArray
    extends PhoenixArray {
        private long[] longArr;

        public PrimitiveLongPhoenixArray(PDataType dataType, Object[] elements) {
            super(dataType, elements);
        }

        @Override
        public Object convertObjectArrayToPrimitiveArray(Object[] elements) {
            this.longArr = new long[elements.length];
            int i = 0;
            for (Object o : elements) {
                if (o != null) {
                    this.longArr[i] = (Long)o;
                }
                ++i;
            }
            return this.longArr;
        }

        @Override
        public int estimateByteSize(int pos) {
            return this.baseType.estimateByteSize(this.longArr[pos]);
        }

        @Override
        public byte[] toBytes(int pos) {
            return this.baseType.toBytes(this.longArr[pos]);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PrimitiveLongPhoenixArray oArray = (PrimitiveLongPhoenixArray)obj;
            if (this.numElements != oArray.numElements) {
                return false;
            }
            if (this.baseType.getSqlType() != oArray.baseType.getSqlType()) {
                return false;
            }
            return Arrays.equals((long[])this.array, (long[])oArray.array);
        }

        @Override
        public int hashCode() {
            if (this.hashCode != Integer.MIN_VALUE) {
                return this.hashCode;
            }
            this.hashCode = 17;
            this.hashCode = this.hashCode * 37 + this.numElements;
            this.hashCode = this.hashCode * 37 + this.baseType.getSqlType();
            this.hashCode = this.hashCode * 37 + Arrays.hashCode((long[])this.array);
            return this.hashCode;
        }

        @Override
        public Object getElement(int index) {
            return ((long[])this.array)[index];
        }
    }

    public static class PrimitiveShortPhoenixArray
    extends PhoenixArray {
        private short[] shortArr;

        public PrimitiveShortPhoenixArray(PDataType dataType, Object[] elements) {
            super(dataType, elements);
        }

        @Override
        public Object convertObjectArrayToPrimitiveArray(Object[] elements) {
            this.shortArr = new short[elements.length];
            int i = 0;
            for (Object o : elements) {
                if (o != null) {
                    this.shortArr[i] = (Short)o;
                }
                ++i;
            }
            return this.shortArr;
        }

        @Override
        public int estimateByteSize(int pos) {
            return this.baseType.estimateByteSize(this.shortArr[pos]);
        }

        @Override
        public byte[] toBytes(int pos) {
            return this.baseType.toBytes(this.shortArr[pos]);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PrimitiveShortPhoenixArray oArray = (PrimitiveShortPhoenixArray)obj;
            if (this.numElements != oArray.numElements) {
                return false;
            }
            if (this.baseType.getSqlType() != oArray.baseType.getSqlType()) {
                return false;
            }
            return Arrays.equals((short[])this.array, (short[])oArray.array);
        }

        @Override
        public int hashCode() {
            if (this.hashCode != Integer.MIN_VALUE) {
                return this.hashCode;
            }
            this.hashCode = 17;
            this.hashCode = this.hashCode * 37 + this.numElements;
            this.hashCode = this.hashCode * 37 + this.baseType.getSqlType();
            this.hashCode = this.hashCode * 37 + Arrays.hashCode((short[])this.array);
            return this.hashCode;
        }

        @Override
        public Object getElement(int index) {
            return ((short[])this.array)[index];
        }
    }

    public static class PrimitiveIntPhoenixArray
    extends PhoenixArray {
        private int[] intArr;

        public PrimitiveIntPhoenixArray(PDataType dataType, Object[] elements) {
            super(dataType, elements);
        }

        @Override
        public Object convertObjectArrayToPrimitiveArray(Object[] elements) {
            this.intArr = new int[elements.length];
            int i = 0;
            for (Object o : elements) {
                if (o != null) {
                    this.intArr[i] = (Integer)o;
                }
                ++i;
            }
            return this.intArr;
        }

        @Override
        public int estimateByteSize(int pos) {
            return this.baseType.estimateByteSize(this.intArr[pos]);
        }

        @Override
        public byte[] toBytes(int pos) {
            return this.baseType.toBytes(this.intArr[pos]);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PrimitiveIntPhoenixArray oArray = (PrimitiveIntPhoenixArray)obj;
            if (this.numElements != oArray.numElements) {
                return false;
            }
            if (this.baseType.getSqlType() != oArray.baseType.getSqlType()) {
                return false;
            }
            return Arrays.equals((int[])this.array, (int[])oArray.array);
        }

        @Override
        public int hashCode() {
            if (this.hashCode != Integer.MIN_VALUE) {
                return this.hashCode;
            }
            this.hashCode = 17;
            this.hashCode = this.hashCode * 37 + this.numElements;
            this.hashCode = this.hashCode * 37 + this.baseType.getSqlType();
            this.hashCode = this.hashCode * 37 + Arrays.hashCode((int[])this.array);
            return this.hashCode;
        }

        @Override
        public Object getElement(int index) {
            return ((int[])this.array)[index];
        }
    }
}

