/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util.json;

import java.sql.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.collect.Iterables;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.json.JsonUpsertExecutor;

class ObjectToArrayConverter {
    private final Connection conn;
    private final PDataType elementDataType;
    private final JsonUpsertExecutor.SimpleDatatypeConversionFunction elementConvertFunction;

    public ObjectToArrayConverter(Connection conn, PDataType elementDataType) {
        this.conn = conn;
        this.elementDataType = elementDataType;
        this.elementConvertFunction = new JsonUpsertExecutor.SimpleDatatypeConversionFunction(elementDataType, this.conn);
    }

    public Array toArray(Object input) throws SQLException {
        if (input == null) {
            return this.conn.createArrayOf(this.elementDataType.getSqlTypeName(), new Object[0]);
        }
        List list = (List)input;
        if (list.isEmpty()) {
            return this.conn.createArrayOf(this.elementDataType.getSqlTypeName(), new Object[0]);
        }
        return this.conn.createArrayOf(this.elementDataType.getSqlTypeName(), Lists.newArrayList((Iterable)Iterables.transform((Iterable)list, (Function)this.elementConvertFunction)).toArray());
    }
}

