/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.scanner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.scanner.ClassPathScanner;
import org.apache.drill.common.scanner.persistence.ScanResult;
import org.apache.drill.common.util.JacksonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildTimeScan {
    private static final Logger logger = LoggerFactory.getLogger(BuildTimeScan.class);
    private static final String REGISTRY_FILE = "META-INF/drill-module-scan/registry.json";
    private static final ObjectMapper mapper = JacksonUtils.createObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private static final ObjectReader reader = mapper.readerFor(ScanResult.class);
    private static final ObjectWriter writer = mapper.writerFor(ScanResult.class);

    static Set<URL> getPrescannedPaths() {
        return ClassPathScanner.forResource(REGISTRY_FILE, true);
    }

    static ScanResult load() {
        return BuildTimeScan.loadExcept(null);
    }

    private static ScanResult loadExcept(URL ignored) {
        Set<URL> preScanned = ClassPathScanner.forResource(REGISTRY_FILE, false);
        ScanResult result = null;
        for (URL u : preScanned) {
            if (ignored != null && u.toString().startsWith(ignored.toString())) continue;
            try {
                InputStream reflections = u.openStream();
                try {
                    ScanResult ref = (ScanResult)reader.readValue(reflections);
                    if (result == null) {
                        result = ref;
                        continue;
                    }
                    result = result.merge(ref);
                }
                finally {
                    if (reflections == null) continue;
                    reflections.close();
                }
            }
            catch (IOException e) {
                throw new DrillRuntimeException("can't read function registry at " + String.valueOf(u), e);
            }
        }
        if (result != null) {
            if (logger.isInfoEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append(String.format("Loaded prescanned packages %s from locations:\n", result.getScannedPackages()));
                for (URL u : preScanned) {
                    sb.append('\t');
                    sb.append(u.toExternalForm());
                    sb.append('\n');
                }
            }
            logger.info(String.format("Loaded prescanned packages %s from locations %s", result.getScannedPackages(), preScanned));
            return result;
        }
        return ClassPathScanner.emptyResult();
    }

    private static void save(ScanResult scanResult, File file) {
        try {
            writer.writeValue(file, (Object)scanResult);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            throw new IllegalArgumentException("Usage: java {cp} " + BuildTimeScan.class.getName() + " path/to/scan");
        }
        Object basePath = args[0];
        logger.info("Scanning: {}", basePath);
        File registryFile = new File((String)basePath, REGISTRY_FILE);
        File dir = registryFile.getParentFile();
        if (!dir.exists() && !dir.mkdirs() || !dir.isDirectory()) {
            throw new IllegalArgumentException("could not create dir " + dir.getAbsolutePath());
        }
        DrillConfig config = DrillConfig.create();
        if (!((String)basePath).endsWith("/")) {
            basePath = (String)basePath + "/";
        }
        if (!((String)basePath).startsWith("/")) {
            basePath = "/" + (String)basePath;
        }
        URL url = new URL("file:" + (String)basePath);
        Set<URL> markedPaths = ClassPathScanner.getMarkedPaths("drill-module.conf");
        if (!markedPaths.contains(url)) {
            throw new IllegalArgumentException(String.valueOf(url) + " not in " + String.valueOf(markedPaths));
        }
        List<String> packagePrefixes = ClassPathScanner.getPackagePrefixes(config);
        List<String> baseClasses = ClassPathScanner.getScannedBaseClasses(config);
        List<String> scannedAnnotations = ClassPathScanner.getScannedAnnotations(config);
        ScanResult preScanned = BuildTimeScan.loadExcept(url);
        ScanResult scan = ClassPathScanner.scan(Arrays.asList(url), packagePrefixes, baseClasses, scannedAnnotations, preScanned);
        BuildTimeScan.save(scan, registryFile);
    }
}

