/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs.store;

import com.google.common.base.Supplier;
import com.oracle.bmc.hdfs.store.BmcFSInputStream;
import com.oracle.bmc.hdfs.util.FSStreamUtils;
import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.requests.GetObjectRequest;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmcDirectFSInputStream
extends BmcFSInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(BmcDirectFSInputStream.class);

    public BmcDirectFSInputStream(ObjectStorage objectStorage, FileStatus status, Supplier<GetObjectRequest.Builder> requestBuilder, FileSystem.Statistics statistics) {
        super(objectStorage, status, requestBuilder, statistics);
    }

    @Override
    protected long doSeek(long position) throws IOException {
        IOUtils.closeQuietly((InputStream)super.getSourceInputStream());
        super.setSourceInputStream(null);
        super.validateState(position);
        return super.getPos();
    }

    @Override
    public int read() throws IOException {
        try {
            return super.read();
        }
        catch (IOException e) {
            LOG.warn("Read failed, possibly a stale connection. Will re-attempt.", (Throwable)e);
            FSStreamUtils.closeQuietly(super.getSourceInputStream());
            super.setSourceInputStream(null);
            return super.read();
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return super.read(b, off, len);
        }
        catch (IOException e) {
            LOG.warn("Read failed, possibly a stale connection. Will re-attempt.", (Throwable)e);
            FSStreamUtils.closeQuietly(super.getSourceInputStream());
            super.setSourceInputStream(null);
            return super.read(b, off, len);
        }
    }
}

