/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs.store;

import com.oracle.bmc.hdfs.util.BiFunction;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.objectstorage.transfer.UploadManager;
import com.oracle.bmc.util.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BmcOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(BmcOutputStream.class);
    private final BiFunction<Long, InputStream, UploadManager.UploadRequest> requestBuilderFn;
    private final UploadManager uploadManager;
    private OutputStream outputBufferStream;
    private boolean closed = false;

    public BmcOutputStream(UploadManager uploadManager, BiFunction<Long, InputStream, UploadManager.UploadRequest> requestBuilderFn) {
        this.uploadManager = uploadManager;
        this.requestBuilderFn = requestBuilderFn;
    }

    @Override
    public void write(int b) throws IOException {
        this.validateState();
        this.outputBufferStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.validateState();
        this.outputBufferStream.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.validateState();
        this.outputBufferStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            LOG.debug("Output stream already closed");
            return;
        }
        this.validateState();
        this.closed = true;
        this.outputBufferStream.flush();
        this.outputBufferStream.close();
        this.outputBufferStream = null;
        InputStream fromBufferedStream = null;
        try {
            fromBufferedStream = this.getInputStreamFromBufferedStream();
            UploadManager.UploadRequest request = this.requestBuilderFn.apply(this.getInputStreamLengthInBytes(), fromBufferedStream);
            UploadManager.UploadResponse response = this.uploadManager.upload(request);
            LOG.debug("Put new file with etag {}", (Object)response.getETag());
        }
        catch (BmcException e) {
            throw new IOException("Unable to put object", e);
        }
        finally {
            StreamUtils.closeQuietly((InputStream)fromBufferedStream);
            super.close();
        }
    }

    protected abstract InputStream getInputStreamFromBufferedStream() throws IOException;

    protected abstract long getInputStreamLengthInBytes() throws IOException;

    protected abstract OutputStream createOutputBufferStream() throws IOException;

    private void validateState() throws IOException {
        this.checkNotClosed();
        this.verifyInitialized();
    }

    private void verifyInitialized() throws IOException {
        if (this.outputBufferStream == null) {
            this.outputBufferStream = this.createOutputBufferStream();
        }
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
    }
}

