/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.shaded.esri.core.geometry;

import com.datastax.oss.driver.shaded.esri.core.geometry.StridedIndexTypeCollection;

class IndexMultiDCList {
    StridedIndexTypeCollection m_list_nodes = new StridedIndexTypeCollection(3);
    StridedIndexTypeCollection m_lists = new StridedIndexTypeCollection(6);
    int m_list_of_lists = IndexMultiDCList.nullNode();
    boolean m_b_store_list_index_with_node = false;

    void freeNode_(int node) {
        this.m_list_nodes.deleteElement(node);
    }

    int newNode_() {
        int node = this.m_list_nodes.newElement();
        return node;
    }

    void freeList_(int list) {
        this.m_lists.deleteElement(list);
    }

    int newList_() {
        int list = this.m_lists.newElement();
        return list;
    }

    void setPrev_(int node, int prev) {
        this.m_list_nodes.setField(node, 1, prev);
    }

    void setNext_(int node, int next) {
        this.m_list_nodes.setField(node, 2, next);
    }

    void setData_(int node, int data) {
        this.m_list_nodes.setField(node, 0, data);
    }

    void setList_(int node, int list) {
        this.m_list_nodes.setField(node, 3, list);
    }

    void setListSize_(int list, int newsize) {
        this.m_lists.setField(list, 4, newsize);
    }

    void setNextList_(int list, int next) {
        this.m_lists.setField(list, 3, next);
    }

    void setPrevList_(int list, int prev) {
        this.m_lists.setField(list, 2, prev);
    }

    IndexMultiDCList() {
    }

    IndexMultiDCList(boolean b_store_list_index_with_node) {
    }

    int createList(int listData) {
        int list = this.newList_();
        this.m_lists.setField(list, 3, this.m_list_of_lists);
        this.m_lists.setField(list, 4, 0);
        this.m_lists.setField(list, 5, listData);
        if (this.m_list_of_lists != IndexMultiDCList.nullNode()) {
            this.setPrevList_(this.m_list_of_lists, list);
        }
        this.m_list_of_lists = list;
        return list;
    }

    int deleteList(int list) {
        this.clear(list);
        int prevList = this.m_lists.getField(list, 2);
        int nextList = this.m_lists.getField(list, 3);
        if (prevList != IndexMultiDCList.nullNode()) {
            this.setNextList_(prevList, nextList);
        } else {
            this.m_list_of_lists = nextList;
        }
        if (nextList != IndexMultiDCList.nullNode()) {
            this.setPrevList_(nextList, prevList);
        }
        this.freeList_(list);
        return nextList;
    }

    void reserveLists(int listCount) {
        this.m_lists.setCapacity(listCount);
    }

    int getListData(int list) {
        return this.m_lists.getField(list, 5);
    }

    int getList(int node_index) {
        assert (this.m_b_store_list_index_with_node);
        return this.m_list_nodes.getField(node_index, 3);
    }

    void setListData(int list, int data) {
        this.m_lists.setField(list, 5, data);
    }

    int addElement(int list, int data) {
        return this.insertElement(list, -1, data);
    }

    int insertElement(int list, int beforeNode, int data) {
        int head;
        int node = this.newNode_();
        int prev = -1;
        if (beforeNode != IndexMultiDCList.nullNode()) {
            prev = this.getPrev(beforeNode);
            this.setPrev_(beforeNode, node);
        }
        this.setNext_(node, beforeNode);
        if (prev != IndexMultiDCList.nullNode()) {
            this.setNext_(prev, node);
        }
        if (beforeNode == (head = this.m_lists.getField(list, 0))) {
            this.m_lists.setField(list, 0, node);
        }
        if (beforeNode == IndexMultiDCList.nullNode()) {
            int tail = this.m_lists.getField(list, 1);
            this.setPrev_(node, tail);
            if (tail != -1) {
                this.setNext_(tail, node);
            }
            this.m_lists.setField(list, 1, node);
        }
        this.setData(node, data);
        this.setListSize_(list, this.getListSize(list) + 1);
        if (this.m_b_store_list_index_with_node) {
            this.setList_(node, list);
        }
        return node;
    }

    int deleteElement(int list, int node) {
        int prev = this.getPrev(node);
        int next = this.getNext(node);
        if (prev != IndexMultiDCList.nullNode()) {
            this.setNext_(prev, next);
        } else {
            this.m_lists.setField(list, 0, next);
        }
        if (next != IndexMultiDCList.nullNode()) {
            this.setPrev_(next, prev);
        } else {
            this.m_lists.setField(list, 1, prev);
        }
        this.freeNode_(node);
        this.setListSize_(list, this.getListSize(list) - 1);
        return next;
    }

    void reserveNodes(int nodeCount) {
        this.m_list_nodes.setCapacity(nodeCount);
    }

    int getData(int node_index) {
        return this.m_list_nodes.getField(node_index, 0);
    }

    void setData(int node_index, int element) {
        this.m_list_nodes.setField(node_index, 0, element);
    }

    int getNext(int node_index) {
        return this.m_list_nodes.getField(node_index, 2);
    }

    int getPrev(int node_index) {
        return this.m_list_nodes.getField(node_index, 1);
    }

    int getFirst(int list) {
        return this.m_lists.getField(list, 0);
    }

    int getLast(int list) {
        return this.m_lists.getField(list, 1);
    }

    static int nullNode() {
        return -1;
    }

    void clear() {
        int list = this.getFirstList();
        while (list != -1) {
            list = this.deleteList(list);
        }
    }

    void clear(int list) {
        int last = this.getLast(list);
        while (last != IndexMultiDCList.nullNode()) {
            int n = last;
            last = this.getPrev(n);
            this.freeNode_(n);
        }
        this.m_lists.setField(list, 0, -1);
        this.m_lists.setField(list, 1, -1);
        this.setListSize_(list, 0);
    }

    boolean isEmpty(int list) {
        return this.m_lists.getField(list, 0) == -1;
    }

    boolean isEmpty() {
        return this.m_list_nodes.size() == 0;
    }

    int getNodeCount() {
        return this.m_list_nodes.size();
    }

    int getListCount() {
        return this.m_lists.size();
    }

    int getListSize(int list) {
        return this.m_lists.getField(list, 4);
    }

    int getFirstList() {
        return this.m_list_of_lists;
    }

    int getNextList(int list) {
        return this.m_lists.getField(list, 3);
    }
}

