/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.store.AbstractRecordWriter;
import org.apache.drill.exec.store.EventBasedRecordWriter;
import org.apache.drill.exec.store.jdbc.JdbcWriter;
import org.apache.drill.exec.store.jdbc.utils.CreateTableStmtBuilder;
import org.apache.drill.exec.store.jdbc.utils.InsertStatementBuilder;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcRecordWriter
extends AbstractRecordWriter {
    private static final Logger logger = LoggerFactory.getLogger(JdbcRecordWriter.class);
    private final List<String> tableIdentifier;
    private final Connection connection;
    protected final SqlDialect dialect;
    private final InsertStatementBuilder insertStatementBuilder;
    private final JdbcWriter config;
    private int recordCount;

    public JdbcRecordWriter(UserBitShared.UserCredentials userCredentials, List<String> tableIdentifier, JdbcWriter config) {
        this.tableIdentifier = tableIdentifier;
        this.dialect = config.getPlugin().getDialect(userCredentials);
        this.config = config;
        this.recordCount = 0;
        this.insertStatementBuilder = this.getInsertStatementBuilder(tableIdentifier);
        try {
            this.connection = config.getPlugin().getDataSource(userCredentials).get().getConnection();
        }
        catch (SQLException e) {
            throw UserException.connectionError().message("Unable to open JDBC connection for writing.", new Object[0]).addContext(e.getSQLState()).build(logger);
        }
    }

    protected InsertStatementBuilder getInsertStatementBuilder(List<String> tableIdentifier) {
        return new InsertStatementBuilder(tableIdentifier, this.dialect);
    }

    public void init(Map<String, String> writerOptions) {
    }

    public void updateSchema(VectorAccessible batch) {
        BatchSchema schema = batch.getSchema();
        CreateTableStmtBuilder queryBuilder = new CreateTableStmtBuilder(this.tableIdentifier, this.dialect);
        for (MaterializedField field : schema) {
            logger.debug("Adding column {} of type {}.", (Object)field.getName(), (Object)field.getType().getMinorType());
            if (field.getType().getMode() == TypeProtos.DataMode.REPEATED) {
                throw UserException.dataWriteError().message("Drill does not yet support writing arrays to JDBC. " + field.getName() + " is an array.", new Object[0]).build(logger);
            }
            queryBuilder.addColumn(field);
        }
        String sql = queryBuilder.build();
        logger.debug("Final query: {}", (Object)sql);
        try (Statement statement = this.connection.createStatement();){
            logger.debug("Executing CREATE query: {}", (Object)sql);
            statement.execute(sql);
        }
        catch (SQLException e) {
            throw UserException.dataReadError((Throwable)e).message("The JDBC storage plugin failed while trying to create the schema. ", new Object[0]).addContext("Sql", sql).build(logger);
        }
    }

    public void startRecord() {
        this.insertStatementBuilder.resetRow();
        logger.debug("Start record");
    }

    public void endRecord() throws IOException {
        logger.debug("Ending record");
        this.insertStatementBuilder.endRecord();
        ++this.recordCount;
        if (this.recordCount >= this.config.getPlugin().getConfig().getWriterBatchSize()) {
            this.executeInsert(this.insertStatementBuilder.buildInsertQuery());
            this.recordCount = 0;
        }
        this.insertStatementBuilder.resetRow();
    }

    public void abort() {
        logger.debug("Abort insert.");
    }

    public void cleanup() throws IOException {
        logger.debug("Cleanup record");
        if (this.recordCount != 0) {
            this.executeInsert(this.insertStatementBuilder.buildInsertQuery());
        }
        AutoCloseables.closeSilently((AutoCloseable[])new AutoCloseable[]{this.connection});
    }

    private void executeInsert(String insertQuery) throws IOException {
        try (Statement stmt = this.connection.createStatement();){
            logger.debug("Executing insert query: {}", (Object)insertQuery);
            stmt.execute(insertQuery);
            logger.debug("Query complete");
            AutoCloseables.closeSilently((AutoCloseable[])new AutoCloseable[]{stmt});
        }
        catch (SQLException e) {
            logger.error("Error: {} {} {}", new Object[]{e.getMessage(), e.getSQLState(), e.getErrorCode()});
            AutoCloseables.closeSilently((AutoCloseable[])new AutoCloseable[]{this.connection});
            throw new IOException(e.getMessage() + " " + e.getSQLState() + "\n" + insertQuery);
        }
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableJdbcConverter(fieldId, fieldName, reader, new ExactNumericJdbcConverter(fieldId, fieldName, reader));
    }

    public EventBasedRecordWriter.FieldConverter getNewIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new ExactNumericJdbcConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableBigIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableJdbcConverter(fieldId, fieldName, reader, new ExactNumericJdbcConverter(fieldId, fieldName, reader));
    }

    public EventBasedRecordWriter.FieldConverter getNewBigIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new ExactNumericJdbcConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableSmallIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableJdbcConverter(fieldId, fieldName, reader, new ExactNumericJdbcConverter(fieldId, fieldName, reader));
    }

    public EventBasedRecordWriter.FieldConverter getNewSmallIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new ExactNumericJdbcConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableTinyIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableJdbcConverter(fieldId, fieldName, reader, new ExactNumericJdbcConverter(fieldId, fieldName, reader));
    }

    public EventBasedRecordWriter.FieldConverter getNewTinyIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new ExactNumericJdbcConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableFloat4Converter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableJdbcConverter(fieldId, fieldName, reader, new ApproxNumericJdbcConverter(fieldId, fieldName, reader));
    }

    public EventBasedRecordWriter.FieldConverter getNewFloat4Converter(int fieldId, String fieldName, FieldReader reader) {
        return new ApproxNumericJdbcConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableFloat8Converter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableJdbcConverter(fieldId, fieldName, reader, new ApproxNumericJdbcConverter(fieldId, fieldName, reader));
    }

    public EventBasedRecordWriter.FieldConverter getNewFloat8Converter(int fieldId, String fieldName, FieldReader reader) {
        return new ApproxNumericJdbcConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableVarDecimalConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableJdbcConverter(fieldId, fieldName, reader, new ExactNumericJdbcConverter(fieldId, fieldName, reader));
    }

    public EventBasedRecordWriter.FieldConverter getNewVarDecimalConverter(int fieldId, String fieldName, FieldReader reader) {
        return new ExactNumericJdbcConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableVarCharConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableJdbcConverter(fieldId, fieldName, reader, new VarCharJDBCConverter(fieldId, fieldName, reader));
    }

    public EventBasedRecordWriter.FieldConverter getNewVarCharConverter(int fieldId, String fieldName, FieldReader reader) {
        return new VarCharJDBCConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableDateConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableJdbcConverter(fieldId, fieldName, reader, new DateJDBCConverter(fieldId, fieldName, reader));
    }

    public EventBasedRecordWriter.FieldConverter getNewDateConverter(int fieldId, String fieldName, FieldReader reader) {
        return new DateJDBCConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableTimeConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableJdbcConverter(fieldId, fieldName, reader, new TimeJDBCConverter(fieldId, fieldName, reader));
    }

    public EventBasedRecordWriter.FieldConverter getNewTimeConverter(int fieldId, String fieldName, FieldReader reader) {
        return new TimeJDBCConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableTimeStampConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableJdbcConverter(fieldId, fieldName, reader, new TimeStampJDBCConverter(fieldId, fieldName, reader));
    }

    public EventBasedRecordWriter.FieldConverter getNewTimeStampConverter(int fieldId, String fieldName, FieldReader reader) {
        return new TimeStampJDBCConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableBitConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableJdbcConverter(fieldId, fieldName, reader, new BitJDBCConverter(fieldId, fieldName, reader));
    }

    public EventBasedRecordWriter.FieldConverter getNewBitConverter(int fieldId, String fieldName, FieldReader reader) {
        return new BitJDBCConverter(fieldId, fieldName, reader);
    }

    public class NullableJdbcConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final EventBasedRecordWriter.FieldConverter delegate;

        public NullableJdbcConverter(int fieldId, String fieldName, FieldReader reader, EventBasedRecordWriter.FieldConverter delegate) {
            super(fieldId, fieldName, reader);
            this.delegate = delegate;
        }

        public void writeField() throws IOException {
            if (this.reader.isSet()) {
                this.delegate.writeField();
            } else {
                JdbcRecordWriter.this.insertStatementBuilder.addRowValue((SqlNode)SqlLiteral.createNull((SqlParserPos)SqlParserPos.ZERO));
            }
        }
    }

    public class ExactNumericJdbcConverter
    extends EventBasedRecordWriter.FieldConverter {
        public ExactNumericJdbcConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
        }

        public void writeField() {
            JdbcRecordWriter.this.insertStatementBuilder.addRowValue((SqlNode)SqlLiteral.createExactNumeric((String)String.valueOf(this.reader.readObject()), (SqlParserPos)SqlParserPos.ZERO));
        }
    }

    public class ApproxNumericJdbcConverter
    extends EventBasedRecordWriter.FieldConverter {
        public ApproxNumericJdbcConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
        }

        public void writeField() {
            JdbcRecordWriter.this.insertStatementBuilder.addRowValue((SqlNode)SqlLiteral.createApproxNumeric((String)String.valueOf(this.reader.readObject()), (SqlParserPos)SqlParserPos.ZERO));
        }
    }

    public class VarCharJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        public VarCharJDBCConverter(int fieldID, String fieldName, FieldReader reader) {
            super(fieldID, fieldName, reader);
        }

        public void writeField() {
            byte[] bytes = this.reader.readText().copyBytes();
            JdbcRecordWriter.this.insertStatementBuilder.addRowValue((SqlNode)SqlLiteral.createCharString((String)new String(bytes), (SqlParserPos)SqlParserPos.ZERO));
        }
    }

    public class DateJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        public DateJDBCConverter(int fieldID, String fieldName, FieldReader reader) {
            super(fieldID, fieldName, reader);
        }

        public void writeField() {
            JdbcRecordWriter.this.insertStatementBuilder.addRowValue((SqlNode)SqlLiteral.createDate((DateString)DateString.fromDaysSinceEpoch((int)((int)this.reader.readLocalDate().toEpochDay())), (SqlParserPos)SqlParserPos.ZERO));
        }
    }

    public class TimeJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        public TimeJDBCConverter(int fieldID, String fieldName, FieldReader reader) {
            super(fieldID, fieldName, reader);
        }

        public void writeField() {
            JdbcRecordWriter.this.insertStatementBuilder.addRowValue((SqlNode)SqlLiteral.createTime((TimeString)TimeString.fromMillisOfDay((int)((int)(this.reader.readLocalTime().toNanoOfDay() / TimeUnit.MILLISECONDS.toNanos(1L)))), (int)3, (SqlParserPos)SqlParserPos.ZERO));
        }
    }

    public class TimeStampJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        public TimeStampJDBCConverter(int fieldID, String fieldName, FieldReader reader) {
            super(fieldID, fieldName, reader);
        }

        public void writeField() {
            JdbcRecordWriter.this.insertStatementBuilder.addRowValue((SqlNode)SqlLiteral.createTimestamp((TimestampString)TimestampString.fromMillisSinceEpoch((long)this.reader.readLocalDateTime().toInstant(ZoneOffset.UTC).toEpochMilli()), (int)3, (SqlParserPos)SqlParserPos.ZERO));
        }
    }

    public class BitJDBCConverter
    extends EventBasedRecordWriter.FieldConverter {
        public BitJDBCConverter(int fieldID, String fieldName, FieldReader reader) {
            super(fieldID, fieldName, reader);
        }

        public void writeField() {
            JdbcRecordWriter.this.insertStatementBuilder.addRowValue((SqlNode)SqlLiteral.createBoolean((boolean)this.reader.readBoolean(), (SqlParserPos)SqlParserPos.ZERO));
        }
    }
}

