/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.resolver.dns;

import java.util.Random;
import org.apache.hbase.thirdparty.io.netty.util.internal.MathUtil;
import org.apache.hbase.thirdparty.io.netty.util.internal.PlatformDependent;

final class DnsQueryIdSpace {
    private static final int MAX_ID = 65535;
    private static final int BUCKETS = 4;
    private static final int BUCKET_SIZE = 16384;
    private static final int BUCKET_DROP_THRESHOLD = 500;
    private final DnsQueryIdRange[] idBuckets = new DnsQueryIdRange[4];

    DnsQueryIdSpace() {
        assert (this.idBuckets.length == MathUtil.findNextPositivePowerOfTwo(this.idBuckets.length));
        this.idBuckets[0] = DnsQueryIdSpace.newBucket(0);
    }

    private static DnsQueryIdRange newBucket(int idBucketsIdx) {
        return new DnsQueryIdRange(16384, idBucketsIdx * 16384);
    }

    int nextId() {
        DnsQueryIdRange bucket;
        int freeIdx = -1;
        for (int bucketIdx = 0; bucketIdx < this.idBuckets.length; ++bucketIdx) {
            DnsQueryIdRange bucket2 = this.idBuckets[bucketIdx];
            if (bucket2 != null) {
                int id = bucket2.nextId();
                if (id == -1) continue;
                return id;
            }
            if (freeIdx != -1 && !PlatformDependent.threadLocalRandom().nextBoolean()) continue;
            freeIdx = bucketIdx;
        }
        if (freeIdx == -1) {
            return -1;
        }
        this.idBuckets[freeIdx] = bucket = DnsQueryIdSpace.newBucket(freeIdx);
        int id = bucket.nextId();
        assert (id >= 0);
        return id;
    }

    void pushId(int id) {
        int bucketIdx = id / 16384;
        if (bucketIdx >= this.idBuckets.length) {
            throw new IllegalArgumentException("id too large: " + id);
        }
        DnsQueryIdRange bucket = this.idBuckets[bucketIdx];
        assert (bucket != null);
        bucket.pushId(id);
        if (bucket.usableIds() == bucket.maxUsableIds()) {
            for (int idx = 0; idx < this.idBuckets.length; ++idx) {
                DnsQueryIdRange otherBucket;
                if (idx == bucketIdx || (otherBucket = this.idBuckets[idx]) == null || otherBucket.usableIds() <= 500) continue;
                this.idBuckets[bucketIdx] = null;
                return;
            }
        }
    }

    int usableIds() {
        int usableIds = 0;
        for (DnsQueryIdRange bucket : this.idBuckets) {
            usableIds += bucket == null ? 16384 : bucket.usableIds();
        }
        return usableIds;
    }

    int maxUsableIds() {
        return 16384 * this.idBuckets.length;
    }

    private static final class DnsQueryIdRange {
        private final short[] ids;
        private final int startId;
        private int count;

        DnsQueryIdRange(int bucketSize, int startId) {
            this.ids = new short[bucketSize];
            this.startId = startId;
            for (int v = startId; v < bucketSize + startId; ++v) {
                this.pushId(v);
            }
        }

        int nextId() {
            assert (this.count >= 0);
            if (this.count == 0) {
                return -1;
            }
            short id = this.ids[this.count - 1];
            --this.count;
            return id & 0xFFFF;
        }

        void pushId(int id) {
            if (this.count == this.ids.length) {
                throw new IllegalStateException("overflow");
            }
            assert (id <= this.startId + this.ids.length && id >= this.startId);
            Random random = PlatformDependent.threadLocalRandom();
            int insertionPosition = random.nextInt(this.count + 1);
            this.ids[this.count] = this.ids[insertionPosition];
            this.ids[insertionPosition] = (short)id;
            ++this.count;
        }

        int usableIds() {
            return this.count;
        }

        int maxUsableIds() {
            return this.ids.length;
        }
    }
}

