
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;

import io.netty.buffer.ByteBuf;

/*
 * This class is generated using freemarker and the DateIntervalFunctionTemplates/DateTruncFunctions.java template.
 */

public class GDateTimeTruncateFunctions {

 

  /**
   * This class merely act as a placeholder so that Calcite allows 'trunc('truncationUnit', col)'
   * function in SQL.
   */
  @SuppressWarnings("unused")
  @FunctionTemplate(name = "date_trunc", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GDateDummyDateTrunc implements DrillSimpleFunc {
    @Param  VarCharHolder left;
    @Param  DateHolder right;
    @Output DateHolder out;

    @Override
    public void setup() { }

    @Override
    public void eval() { }
  }
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Second", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GDateSecondDateTrunc implements DrillSimpleFunc {
    @Param  DateHolder right;
    @Output DateHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
               
      // No truncation as there is no time part in date
      out.value = right.value;
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Minute", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GDateMinuteDateTrunc implements DrillSimpleFunc {
    @Param  DateHolder right;
    @Output DateHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
               
      // No truncation as there is no time part in date
      out.value = right.value;
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Hour", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GDateHourDateTrunc implements DrillSimpleFunc {
    @Param  DateHolder right;
    @Output DateHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
               
      // No truncation as there is no time part in date
      out.value = right.value;
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Day", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GDateDayDateTrunc implements DrillSimpleFunc {
    @Param  DateHolder right;
    @Output DateHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
               
      // No truncation as there is no time part in date
      out.value = right.value;
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Month", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GDateMonthDateTrunc implements DrillSimpleFunc {
    @Param  DateHolder right;
    @Output DateHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    dateTime.setMillis(right.value);
      dateTime.setRounding(dateTime.getChronology().monthOfYear());
      out.value = dateTime.getMillis();
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Year", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GDateYearDateTrunc implements DrillSimpleFunc {
    @Param  DateHolder right;
    @Output DateHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    dateTime.setMillis(right.value);
      dateTime.setRounding(dateTime.getChronology().year());
      out.value = dateTime.getMillis();
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Week", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GDateWeekDateTrunc implements DrillSimpleFunc {
    @Param  DateHolder right;
    @Output DateHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    dateTime.setMillis(right.value);
      dateTime.setRounding(dateTime.getChronology().weekOfWeekyear());
      out.value = dateTime.getMillis();
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Quarter", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GDateQuarterDateTrunc implements DrillSimpleFunc {
    @Param  DateHolder right;
    @Output DateHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;
    @Workspace org.joda.time.MutableDateTime dateTime2;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
      dateTime2 = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    dateTime.setMillis(right.value);
      int month = dateTime.getMonthOfYear();
      dateTime.setRounding(dateTime.getChronology().year());
      dateTime2.setMillis(dateTime.getMillis());
      dateTime2.add(org.joda.time.DurationFieldType.months(), ((month-1)/3)*3);
      out.value = dateTime2.getMillis();
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Decade", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GDateDecadeDateTrunc implements DrillSimpleFunc {
    @Param  DateHolder right;
    @Output DateHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;
    @Workspace org.joda.time.MutableDateTime dateTime2;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
      dateTime2 = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    dateTime.setMillis(right.value);
      int year = dateTime.getYear();
      dateTime.setRounding(dateTime.getChronology().centuryOfEra());
      dateTime2.setMillis(dateTime.getMillis());
      dateTime2.add(org.joda.time.DurationFieldType.years(), ((year%100)/10)*10);
      out.value = dateTime2.getMillis();
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Century", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GDateCenturyDateTrunc implements DrillSimpleFunc {
    @Param  DateHolder right;
    @Output DateHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;
    @Workspace org.joda.time.MutableDateTime dateTime2;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
      dateTime2 = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    dateTime.setMillis(right.value);
      dateTime.add(org.joda.time.DurationFieldType.years(), -1);
      dateTime.setRounding(dateTime.getChronology().centuryOfEra());
      dateTime2.setMillis(dateTime.getMillis());
      dateTime2.add(org.joda.time.DurationFieldType.years(), 1);
      out.value = dateTime2.getMillis();
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Millennium", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GDateMillenniumDateTrunc implements DrillSimpleFunc {
    @Param  DateHolder right;
    @Output DateHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;
    @Workspace org.joda.time.MutableDateTime dateTime2;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
      dateTime2 = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    dateTime.setMillis(right.value);
      int year = dateTime.getYear();
      dateTime.setRounding(dateTime.getChronology().era());
      dateTime2.setMillis(dateTime.getMillis());
      dateTime2.add(org.joda.time.DurationFieldType.years(), ((year-1)/1000)*1000);
      out.value = dateTime2.getMillis();
         
 
    }
}
    
   
 

  /**
   * This class merely act as a placeholder so that Calcite allows 'trunc('truncationUnit', col)'
   * function in SQL.
   */
  @SuppressWarnings("unused")
  @FunctionTemplate(name = "date_trunc", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GTimeStampDummyDateTrunc implements DrillSimpleFunc {
    @Param  VarCharHolder left;
    @Param  TimeStampHolder right;
    @Output TimeStampHolder out;

    @Override
    public void setup() { }

    @Override
    public void eval() { }
  }
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Second", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GTimeStampSecondDateTrunc implements DrillSimpleFunc {
    @Param  TimeStampHolder right;
    @Output TimeStampHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    dateTime.setMillis(right.value);
      dateTime.setRounding(dateTime.getChronology().secondOfMinute());
      out.value = dateTime.getMillis();
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Minute", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GTimeStampMinuteDateTrunc implements DrillSimpleFunc {
    @Param  TimeStampHolder right;
    @Output TimeStampHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    dateTime.setMillis(right.value);
      dateTime.setRounding(dateTime.getChronology().minuteOfHour());
      out.value = dateTime.getMillis();
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Hour", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GTimeStampHourDateTrunc implements DrillSimpleFunc {
    @Param  TimeStampHolder right;
    @Output TimeStampHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    dateTime.setMillis(right.value);
      dateTime.setRounding(dateTime.getChronology().hourOfDay());
      out.value = dateTime.getMillis();
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Day", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GTimeStampDayDateTrunc implements DrillSimpleFunc {
    @Param  TimeStampHolder right;
    @Output TimeStampHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    dateTime.setMillis(right.value);
      dateTime.setRounding(dateTime.getChronology().dayOfMonth());
      out.value = dateTime.getMillis();
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Month", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GTimeStampMonthDateTrunc implements DrillSimpleFunc {
    @Param  TimeStampHolder right;
    @Output TimeStampHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    dateTime.setMillis(right.value);
      dateTime.setRounding(dateTime.getChronology().monthOfYear());
      out.value = dateTime.getMillis();
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Year", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GTimeStampYearDateTrunc implements DrillSimpleFunc {
    @Param  TimeStampHolder right;
    @Output TimeStampHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
               
      dateTime.setMillis(right.value);
      dateTime.setRounding(dateTime.getChronology().year());
      out.value = dateTime.getMillis();
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Week", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GTimeStampWeekDateTrunc implements DrillSimpleFunc {
    @Param  TimeStampHolder right;
    @Output TimeStampHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    dateTime.setMillis(right.value);
      dateTime.setRounding(dateTime.getChronology().weekOfWeekyear());
      out.value = dateTime.getMillis();
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Quarter", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GTimeStampQuarterDateTrunc implements DrillSimpleFunc {
    @Param  TimeStampHolder right;
    @Output TimeStampHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;
    @Workspace org.joda.time.MutableDateTime dateTime2;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
      dateTime2 = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    dateTime.setMillis(right.value);
      int month = dateTime.getMonthOfYear();
      dateTime.setRounding(dateTime.getChronology().year());
      dateTime2.setMillis(dateTime.getMillis());
      dateTime2.add(org.joda.time.DurationFieldType.months(), ((month-1)/3)*3);
      out.value = dateTime2.getMillis();
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Decade", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GTimeStampDecadeDateTrunc implements DrillSimpleFunc {
    @Param  TimeStampHolder right;
    @Output TimeStampHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;
    @Workspace org.joda.time.MutableDateTime dateTime2;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
      dateTime2 = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    dateTime.setMillis(right.value);
      int year = dateTime.getYear();
      dateTime.setRounding(dateTime.getChronology().centuryOfEra());
      dateTime2.setMillis(dateTime.getMillis());
      dateTime2.add(org.joda.time.DurationFieldType.years(), ((year%100)/10)*10);
      out.value = dateTime2.getMillis();
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Century", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GTimeStampCenturyDateTrunc implements DrillSimpleFunc {
    @Param  TimeStampHolder right;
    @Output TimeStampHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;
    @Workspace org.joda.time.MutableDateTime dateTime2;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
      dateTime2 = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    dateTime.setMillis(right.value);
      dateTime.add(org.joda.time.DurationFieldType.years(), -1);
      dateTime.setRounding(dateTime.getChronology().centuryOfEra());
      dateTime2.setMillis(dateTime.getMillis());
      dateTime2.add(org.joda.time.DurationFieldType.years(), 1);
      out.value = dateTime2.getMillis();
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Millennium", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GTimeStampMillenniumDateTrunc implements DrillSimpleFunc {
    @Param  TimeStampHolder right;
    @Output TimeStampHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;
    @Workspace org.joda.time.MutableDateTime dateTime2;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
      dateTime2 = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    dateTime.setMillis(right.value);
      int year = dateTime.getYear();
      dateTime.setRounding(dateTime.getChronology().era());
      dateTime2.setMillis(dateTime.getMillis());
      dateTime2.add(org.joda.time.DurationFieldType.years(), ((year-1)/1000)*1000);
      out.value = dateTime2.getMillis();
         
 
    }
}
    
   
 

  /**
   * This class merely act as a placeholder so that Calcite allows 'trunc('truncationUnit', col)'
   * function in SQL.
   */
  @SuppressWarnings("unused")
  @FunctionTemplate(name = "date_trunc", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GTimeDummyDateTrunc implements DrillSimpleFunc {
    @Param  VarCharHolder left;
    @Param  TimeHolder right;
    @Output TimeHolder out;

    @Override
    public void setup() { }

    @Override
    public void eval() { }
  }
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Second", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GTimeSecondDateTrunc implements DrillSimpleFunc {
    @Param  TimeHolder right;
    @Output TimeHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
       
              dateTime.setMillis(right.value);
      dateTime.setRounding(dateTime.getChronology().secondOfMinute());
      out.value = (int) dateTime.getMillis();
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Minute", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GTimeMinuteDateTrunc implements DrillSimpleFunc {
    @Param  TimeHolder right;
    @Output TimeHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
       
              dateTime.setMillis(right.value);
      dateTime.setRounding(dateTime.getChronology().minuteOfHour());
      out.value = (int) dateTime.getMillis();
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Hour", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GTimeHourDateTrunc implements DrillSimpleFunc {
    @Param  TimeHolder right;
    @Output TimeHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
       
         
      dateTime.setMillis(right.value);
      dateTime.setRounding(dateTime.getChronology().hourOfDay());
      out.value = (int) dateTime.getMillis();
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Day", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GTimeDayDateTrunc implements DrillSimpleFunc {
    @Param  TimeHolder right;
    @Output TimeHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
       
              out.value = 0;
         
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Month", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GTimeMonthDateTrunc implements DrillSimpleFunc {
    @Param  TimeHolder right;
    @Output TimeHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
       
              out.value = 0;
         
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Year", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GTimeYearDateTrunc implements DrillSimpleFunc {
    @Param  TimeHolder right;
    @Output TimeHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
       
              out.value = 0;
         
 
    }
}
    
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Quarter", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GTimeQuarterDateTrunc implements DrillSimpleFunc {
    @Param  TimeHolder right;
    @Output TimeHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;
    @Workspace org.joda.time.MutableDateTime dateTime2;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
      dateTime2 = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
       
              out.value = 0;
         
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Decade", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GTimeDecadeDateTrunc implements DrillSimpleFunc {
    @Param  TimeHolder right;
    @Output TimeHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;
    @Workspace org.joda.time.MutableDateTime dateTime2;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
      dateTime2 = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
       
              out.value = 0;
         
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Century", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GTimeCenturyDateTrunc implements DrillSimpleFunc {
    @Param  TimeHolder right;
    @Output TimeHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;
    @Workspace org.joda.time.MutableDateTime dateTime2;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
      dateTime2 = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
       
              out.value = 0;
         
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Millennium", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GTimeMillenniumDateTrunc implements DrillSimpleFunc {
    @Param  TimeHolder right;
    @Output TimeHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;
    @Workspace org.joda.time.MutableDateTime dateTime2;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
      dateTime2 = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
       
              out.value = 0;
         
 
    }
}
    
   
 

  /**
   * This class merely act as a placeholder so that Calcite allows 'trunc('truncationUnit', col)'
   * function in SQL.
   */
  @SuppressWarnings("unused")
  @FunctionTemplate(name = "date_trunc", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalDummyDateTrunc implements DrillSimpleFunc {
    @Param  VarCharHolder left;
    @Param  IntervalHolder right;
    @Output IntervalHolder out;

    @Override
    public void setup() { }

    @Override
    public void eval() { }
  }
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Second", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalSecondDateTrunc implements DrillSimpleFunc {
    @Param  IntervalHolder right;
    @Output IntervalHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
               
      out.months = right.months;
      out.days = right.days;
      out.milliseconds = (right.milliseconds/(org.apache.drill.exec.vector.DateUtilities.secondsToMillis))*
          (org.apache.drill.exec.vector.DateUtilities.secondsToMillis);
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Minute", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalMinuteDateTrunc implements DrillSimpleFunc {
    @Param  IntervalHolder right;
    @Output IntervalHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    out.months = right.months;
      out.days = right.days;
      out.milliseconds = (right.milliseconds/(org.apache.drill.exec.vector.DateUtilities.minutesToMillis))*
          (org.apache.drill.exec.vector.DateUtilities.minutesToMillis);
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Hour", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalHourDateTrunc implements DrillSimpleFunc {
    @Param  IntervalHolder right;
    @Output IntervalHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    out.months = right.months;
      out.days = right.days;
      out.milliseconds =
          (right.milliseconds/(org.apache.drill.exec.vector.DateUtilities.hoursToMillis))*
              (org.apache.drill.exec.vector.DateUtilities.hoursToMillis);
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Day", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalDayDateTrunc implements DrillSimpleFunc {
    @Param  IntervalHolder right;
    @Output IntervalHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    out.months = right.months;
      out.days = right.days;
      out.milliseconds = 0;
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Month", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalMonthDateTrunc implements DrillSimpleFunc {
    @Param  IntervalHolder right;
    @Output IntervalHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    out.months = right.months;
      out.days = 0;
      out.milliseconds = 0;
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Year", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalYearDateTrunc implements DrillSimpleFunc {
    @Param  IntervalHolder right;
    @Output IntervalHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    out.months = (right.months / 12) * 12;
      out.days = 0;
      out.milliseconds = 0;
 
 
    }
}
    
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Quarter", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalQuarterDateTrunc implements DrillSimpleFunc {
    @Param  IntervalHolder right;
    @Output IntervalHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;
    @Workspace org.joda.time.MutableDateTime dateTime2;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
      dateTime2 = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    out.months = (right.months / 3) * 3;
      out.days = 0;
      out.milliseconds = 0;
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Decade", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalDecadeDateTrunc implements DrillSimpleFunc {
    @Param  IntervalHolder right;
    @Output IntervalHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;
    @Workspace org.joda.time.MutableDateTime dateTime2;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
      dateTime2 = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    out.months = (right.months / 120) * 120;
      out.days = 0;
      out.milliseconds = 0;
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Century", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalCenturyDateTrunc implements DrillSimpleFunc {
    @Param  IntervalHolder right;
    @Output IntervalHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;
    @Workspace org.joda.time.MutableDateTime dateTime2;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
      dateTime2 = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    out.months = (right.months / 1200) * 1200;
      out.days = 0;
      out.milliseconds = 0;
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Millennium", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalMillenniumDateTrunc implements DrillSimpleFunc {
    @Param  IntervalHolder right;
    @Output IntervalHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;
    @Workspace org.joda.time.MutableDateTime dateTime2;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
      dateTime2 = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    out.months = (right.months / 12000) * 12000;
      out.days = 0;
      out.milliseconds = 0;
         
 
    }
}
    
   
 

  /**
   * This class merely act as a placeholder so that Calcite allows 'trunc('truncationUnit', col)'
   * function in SQL.
   */
  @SuppressWarnings("unused")
  @FunctionTemplate(name = "date_trunc", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalDayDummyDateTrunc implements DrillSimpleFunc {
    @Param  VarCharHolder left;
    @Param  IntervalDayHolder right;
    @Output IntervalDayHolder out;

    @Override
    public void setup() { }

    @Override
    public void eval() { }
  }
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Second", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalDaySecondDateTrunc implements DrillSimpleFunc {
    @Param  IntervalDayHolder right;
    @Output IntervalDayHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
               
      out.days = right.days;
      out.milliseconds = (right.milliseconds/(org.apache.drill.exec.vector.DateUtilities.secondsToMillis))*
        (org.apache.drill.exec.vector.DateUtilities.secondsToMillis);
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Minute", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalDayMinuteDateTrunc implements DrillSimpleFunc {
    @Param  IntervalDayHolder right;
    @Output IntervalDayHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    out.days = right.days;
      out.milliseconds = (right.milliseconds/(org.apache.drill.exec.vector.DateUtilities.minutesToMillis))*
          (org.apache.drill.exec.vector.DateUtilities.minutesToMillis);
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Hour", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalDayHourDateTrunc implements DrillSimpleFunc {
    @Param  IntervalDayHolder right;
    @Output IntervalDayHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    out.days = right.days;
      out.milliseconds =
          (right.milliseconds/(org.apache.drill.exec.vector.DateUtilities.hoursToMillis))*
              (org.apache.drill.exec.vector.DateUtilities.hoursToMillis);
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Day", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalDayDayDateTrunc implements DrillSimpleFunc {
    @Param  IntervalDayHolder right;
    @Output IntervalDayHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    out.days = right.days;
      out.milliseconds = 0;
 
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Month", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalDayMonthDateTrunc implements DrillSimpleFunc {
    @Param  IntervalDayHolder right;
    @Output IntervalDayHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    out.days = 0;
      out.milliseconds = 0;
         
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Year", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalDayYearDateTrunc implements DrillSimpleFunc {
    @Param  IntervalDayHolder right;
    @Output IntervalDayHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    out.days = 0;
      out.milliseconds = 0;
         
 
    }
}
    
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Quarter", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalDayQuarterDateTrunc implements DrillSimpleFunc {
    @Param  IntervalDayHolder right;
    @Output IntervalDayHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;
    @Workspace org.joda.time.MutableDateTime dateTime2;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
      dateTime2 = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    out.days = 0;
      out.milliseconds = 0;
         
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Decade", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalDayDecadeDateTrunc implements DrillSimpleFunc {
    @Param  IntervalDayHolder right;
    @Output IntervalDayHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;
    @Workspace org.joda.time.MutableDateTime dateTime2;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
      dateTime2 = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    out.days = 0;
      out.milliseconds = 0;
         
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Century", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalDayCenturyDateTrunc implements DrillSimpleFunc {
    @Param  IntervalDayHolder right;
    @Output IntervalDayHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;
    @Workspace org.joda.time.MutableDateTime dateTime2;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
      dateTime2 = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    out.days = 0;
      out.milliseconds = 0;
         
 
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Millennium", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalDayMillenniumDateTrunc implements DrillSimpleFunc {
    @Param  IntervalDayHolder right;
    @Output IntervalDayHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;
    @Workspace org.joda.time.MutableDateTime dateTime2;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
      dateTime2 = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    out.days = 0;
      out.milliseconds = 0;
         
 
    }
}
    
   
 

  /**
   * This class merely act as a placeholder so that Calcite allows 'trunc('truncationUnit', col)'
   * function in SQL.
   */
  @SuppressWarnings("unused")
  @FunctionTemplate(name = "date_trunc", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalYearDummyDateTrunc implements DrillSimpleFunc {
    @Param  VarCharHolder left;
    @Param  IntervalYearHolder right;
    @Output IntervalYearHolder out;

    @Override
    public void setup() { }

    @Override
    public void eval() { }
  }
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Second", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalYearSecondDateTrunc implements DrillSimpleFunc {
    @Param  IntervalYearHolder right;
    @Output IntervalYearHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
               
      out.value = right.value;
 
       
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Minute", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalYearMinuteDateTrunc implements DrillSimpleFunc {
    @Param  IntervalYearHolder right;
    @Output IntervalYearHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
               
      out.value = right.value;
 
       
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Hour", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalYearHourDateTrunc implements DrillSimpleFunc {
    @Param  IntervalYearHolder right;
    @Output IntervalYearHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
               
      out.value = right.value;
 
       
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Day", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalYearDayDateTrunc implements DrillSimpleFunc {
    @Param  IntervalYearHolder right;
    @Output IntervalYearHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
               
      out.value = right.value;
 
       
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Month", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalYearMonthDateTrunc implements DrillSimpleFunc {
    @Param  IntervalYearHolder right;
    @Output IntervalYearHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    out.value = right.value;
 
       
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Year", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalYearYearDateTrunc implements DrillSimpleFunc {
    @Param  IntervalYearHolder right;
    @Output IntervalYearHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    out.value = (right.value / 12) * 12;
 
       
    }
}
    
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Quarter", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalYearQuarterDateTrunc implements DrillSimpleFunc {
    @Param  IntervalYearHolder right;
    @Output IntervalYearHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;
    @Workspace org.joda.time.MutableDateTime dateTime2;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
      dateTime2 = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    out.value = (right.value / 3) * 3;
 
       
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Decade", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalYearDecadeDateTrunc implements DrillSimpleFunc {
    @Param  IntervalYearHolder right;
    @Output IntervalYearHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;
    @Workspace org.joda.time.MutableDateTime dateTime2;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
      dateTime2 = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    out.value = (right.value / 120) * 120;
 
       
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Century", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalYearCenturyDateTrunc implements DrillSimpleFunc {
    @Param  IntervalYearHolder right;
    @Output IntervalYearHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;
    @Workspace org.joda.time.MutableDateTime dateTime2;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
      dateTime2 = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    out.value = (right.value / 1200) * 1200;
 
       
    }
}
    
    

  @SuppressWarnings("unused")
  @FunctionTemplate(names = "date_trunc_Millennium", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class GIntervalYearMillenniumDateTrunc implements DrillSimpleFunc {
    @Param  IntervalYearHolder right;
    @Output IntervalYearHolder out;
    @Workspace org.joda.time.MutableDateTime dateTime;
    @Workspace org.joda.time.MutableDateTime dateTime2;

    public void setup() {
      dateTime = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
      dateTime2 = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
    }

    public void eval() {
                    out.value = (right.value / 12000) * 12000;
         
       
    }
}
    
   
 
}