/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.Member;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.binding.AssignedName;
import org.jruby.javasupport.ext.JavaExtensions;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.util.ObjectProxyCache;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Loader;
import org.jruby.util.collections.ClassValue;
import org.jruby.util.collections.ClassValueCalculator;

public abstract class JavaSupport {
    protected final Ruby runtime;
    private final ClassValue<JavaClass> javaClassCache;
    private final ClassValue<RubyModule> proxyClassCache;
    private final Map<Class, UnfinishedProxy> unfinishedProxies;

    protected JavaSupport(final Ruby runtime2) {
        this.runtime = runtime2;
        this.javaClassCache = ClassValue.newInstance(klass -> new JavaClass(runtime2, this.getJavaClassClass(), klass));
        this.proxyClassCache = ClassValue.newInstance(new ClassValueCalculator<RubyModule>(){

            @Override
            public synchronized RubyModule computeValue(Class<?> klass) {
                RubyModule proxyKlass = Java.createProxyClassForClass(runtime2, klass);
                JavaExtensions.define(runtime2, klass, proxyKlass);
                return proxyKlass;
            }
        });
        this.unfinishedProxies = new ConcurrentHashMap<Class, UnfinishedProxy>(8, 0.75f, 1);
    }

    public Class<?> loadJavaClass(String className) throws ClassNotFoundException {
        return this.loadJavaClass(className, true);
    }

    public Class<?> loadJavaClass(String className, boolean initialize2) throws ClassNotFoundException {
        Class<?> primitiveClass = JavaUtil.getPrimitiveClass(className);
        if (primitiveClass == null) {
            if (!Ruby.isSecurityRestricted()) {
                for (Loader loader : this.runtime.getInstanceConfig().getExtraLoaders()) {
                    try {
                        return loader.loadClass(className);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
                return Class.forName(className, initialize2, this.runtime.getJRubyClassLoader());
            }
            return Class.forName(className, initialize2, JavaSupport.class.getClassLoader());
        }
        return primitiveClass;
    }

    @Deprecated
    public abstract Class loadJavaClassVerbose(String var1);

    @Deprecated
    public abstract Class loadJavaClassQuiet(String var1);

    public abstract void handleNativeException(Throwable var1, Member var2);

    public abstract ObjectProxyCache<IRubyObject, RubyClass> getObjectProxyCache();

    @Deprecated
    public abstract Map<String, JavaClass> getNameClassMap();

    @Deprecated
    public abstract Object getJavaObjectVariable(Object var1, int var2);

    @Deprecated
    public abstract void setJavaObjectVariable(Object var1, int var2, Object var3);

    public abstract RubyModule getJavaModule();

    public abstract RubyModule getJavaUtilitiesModule();

    public abstract RubyModule getJavaArrayUtilitiesModule();

    public abstract RubyClass getJavaObjectClass();

    @Deprecated
    public abstract JavaClass getObjectJavaClass();

    @Deprecated
    public abstract void setObjectJavaClass(JavaClass var1);

    public abstract RubyClass getJavaArrayClass();

    public abstract RubyClass getJavaClassClass();

    public abstract RubyClass getJavaPackageClass();

    abstract void setJavaPackageClass(RubyClass var1);

    public abstract RubyModule getJavaInterfaceTemplate();

    @Deprecated
    public abstract RubyModule getPackageModuleTemplate();

    public abstract RubyClass getJavaProxyClass();

    public abstract RubyClass getArrayJavaProxyCreatorClass();

    public abstract RubyClass getConcreteProxyClass();

    public abstract RubyClass getMapJavaProxyClass();

    public abstract RubyClass getArrayProxyClass();

    @Deprecated
    public abstract RubyClass getJavaFieldClass();

    @Deprecated
    public abstract RubyClass getJavaMethodClass();

    @Deprecated
    public abstract RubyClass getJavaConstructorClass();

    public abstract RubyClass getJavaProxyConstructorClass();

    public abstract ClassValue<Map<String, AssignedName>> getStaticAssignedNames();

    public abstract ClassValue<Map<String, AssignedName>> getInstanceAssignedNames();

    @Deprecated
    public abstract Map<Set<?>, JavaProxyClass> getJavaProxyClassCache();

    protected abstract JavaProxyClass fetchJavaProxyClass(ProxyClassKey var1);

    protected abstract JavaProxyClass saveJavaProxyClass(ProxyClassKey var1, JavaProxyClass var2);

    final void beginProxy(Class clazz, RubyModule proxy2) {
        UnfinishedProxy up = new UnfinishedProxy(proxy2);
        up.lock();
        this.unfinishedProxies.put(clazz, up);
    }

    final void endProxy(Class clazz) {
        UnfinishedProxy up = this.unfinishedProxies.remove(clazz);
        up.unlock();
    }

    final RubyModule getUnfinishedProxy(Class clazz) {
        UnfinishedProxy up = this.unfinishedProxies.get(clazz);
        if (up != null && up.isHeldByCurrentThread()) {
            return up.proxy;
        }
        return null;
    }

    RubyModule getProxyClassFromCache(Class clazz) {
        return this.proxyClassCache.get(clazz);
    }

    public JavaClass getJavaClassFromCache(Class clazz) {
        return this.javaClassCache.get(clazz);
    }

    public static final class ProxyClassKey {
        final Class superClass;
        final Class[] interfaces;
        final Set<String> names;
        private int hash;

        private ProxyClassKey(Class superClass, Class[] interfaces2, Set<String> names2) {
            this.superClass = superClass;
            this.interfaces = interfaces2;
            this.names = names2;
        }

        public static ProxyClassKey getInstance(Class superClass, Class[] interfaces2, Set<String> names2) {
            return new ProxyClassKey(superClass, interfaces2, names2);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProxyClassKey) {
                ProxyClassKey that = (ProxyClassKey)obj;
                if (this.superClass != that.superClass) {
                    return false;
                }
                if (this.names.size() != that.names.size()) {
                    return false;
                }
                if (!this.names.equals(that.names)) {
                    return false;
                }
                int len = this.interfaces.length;
                if (len != that.interfaces.length) {
                    return false;
                }
                for (int i2 = 0; i2 < len; ++i2) {
                    Class iface = this.interfaces[i2];
                    boolean ifaceFound = false;
                    for (int j = 0; j < len; ++j) {
                        if (iface != that.interfaces[j]) continue;
                        ifaceFound = true;
                        break;
                    }
                    if (ifaceFound) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int hash2 = this.hash;
            if (hash2 != 0) {
                return hash2;
            }
            for (int i2 = 0; i2 < this.interfaces.length; ++i2) {
                hash2 += this.interfaces[i2].hashCode();
            }
            this.hash = hash2 * this.superClass.hashCode() ^ this.names.hashCode();
            return this.hash;
        }
    }

    static final class UnfinishedProxy
    extends ReentrantLock {
        final RubyModule proxy;

        UnfinishedProxy(RubyModule proxy2) {
            this.proxy = proxy2;
        }
    }
}

