/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.NumberType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.ByteSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ByteType
extends NumberType<Byte> {
    public static final ByteType instance = new ByteType();

    ByteType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        return accessorL.getByte(left, 0) - accessorR.getByte(right, 0);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        byte b;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            b = Byte.parseByte(source);
        }
        catch (Exception e) {
            throw new MarshalException(String.format("Unable to make byte from '%s'", source), e);
        }
        return this.decompose(b);
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        if (parsed instanceof String || parsed instanceof Number) {
            return new Constants.Value(this.fromString(String.valueOf(parsed)));
        }
        throw new MarshalException(String.format("Expected a byte value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        return this.getSerializer().deserialize(buffer).toString();
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.TINYINT;
    }

    @Override
    public TypeSerializer<Byte> getSerializer() {
        return ByteSerializer.instance;
    }

    @Override
    public byte toByte(ByteBuffer value) {
        return ByteBufferUtil.toByte(value);
    }

    @Override
    public short toShort(ByteBuffer value) {
        return this.toByte(value);
    }

    @Override
    protected int toInt(ByteBuffer value) {
        return this.toByte(value);
    }

    @Override
    public ByteBuffer add(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes((byte)(leftType.toByte(left) + rightType.toByte(right)));
    }

    @Override
    public ByteBuffer substract(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes((byte)(leftType.toByte(left) - rightType.toByte(right)));
    }

    @Override
    public ByteBuffer multiply(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes((byte)(leftType.toByte(left) * rightType.toByte(right)));
    }

    @Override
    public ByteBuffer divide(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes((byte)(leftType.toByte(left) / rightType.toByte(right)));
    }

    @Override
    public ByteBuffer mod(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes((byte)(leftType.toByte(left) % rightType.toByte(right)));
    }

    @Override
    public ByteBuffer negate(ByteBuffer input) {
        return ByteBufferUtil.bytes(-this.toByte(input));
    }
}

