/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.git;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.callback.GuiCallback;
import org.apache.hop.core.gui.plugin.menu.GuiMenuElement;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElementType;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.git.info.GitInfoExplorerFileType;
import org.apache.hop.git.info.GitInfoExplorerFileTypeHandler;
import org.apache.hop.git.model.UIFile;
import org.apache.hop.git.model.UIGit;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.EnterStringDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiMenuWidgets;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerFile;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerPerspective;
import org.apache.hop.ui.hopgui.perspective.explorer.IExplorerFilePaintListener;
import org.apache.hop.ui.hopgui.perspective.explorer.IExplorerRefreshListener;
import org.apache.hop.ui.hopgui.perspective.explorer.IExplorerRootChangedListener;
import org.apache.hop.ui.hopgui.perspective.explorer.IExplorerSelectionListener;
import org.apache.hop.ui.hopgui.perspective.explorer.file.IExplorerFileType;
import org.apache.hop.ui.hopgui.perspective.explorer.file.IExplorerFileTypeHandler;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

@GuiPlugin
public class GitGuiPlugin
implements IExplorerRootChangedListener,
IExplorerFilePaintListener,
IExplorerRefreshListener,
IExplorerSelectionListener {
    public static final Class<?> PKG = GitGuiPlugin.class;
    public static final String TOOLBAR_ITEM_GIT_INFO = "ExplorerPerspective-Toolbar-20100-GitInfo";
    public static final String TOOLBAR_ITEM_ADD = "ExplorerPerspective-Toolbar-20200-Add";
    public static final String TOOLBAR_ITEM_REVERT = "ExplorerPerspective-Toolbar-20300-Revert";
    public static final String TOOLBAR_ITEM_COMMIT = "ExplorerPerspective-Toolbar-21000-Commit";
    public static final String TOOLBAR_ITEM_PUSH = "ExplorerPerspective-Toolbar-21100-Push";
    public static final String TOOLBAR_ITEM_PULL = "ExplorerPerspective-Toolbar-21200-Pull";
    public static final String CONTEXT_MENU_GIT_INFO = "ExplorerPerspective-ContextMenu-20000-GitInfo";
    public static final String CONTEXT_MENU_GIT_ADD = "ExplorerPerspective-ContextMenu-20100-GitAdd";
    public static final String CONTEXT_MENU_GIT_REVERT = "ExplorerPerspective-ContextMenu-20200-GitRevert";
    public static final String CONTEXT_MENU_GIT_COMMIT = "ExplorerPerspective-ContextMenu-21000-GitCommit";
    public static final String TOOLBAR_ITEM_BRANCH = "ExplorerPerspective-Toolbar-22000-GitBranch";
    private static GitGuiPlugin instance;
    private static UIGit git;
    private Map<String, UIFile> changedFiles;
    private Map<String, String> ignoredFiles;
    private Color colorIgnored;
    private Color colorStaged;
    private Color colorUnstaged;

    public static GitGuiPlugin getInstance() {
        if (instance == null) {
            instance = new GitGuiPlugin();
        }
        return instance;
    }

    public GitGuiPlugin() {
        if (PropsUi.getInstance().isDarkMode()) {
            this.colorStaged = GuiResource.getInstance().getColorLightBlue();
            this.colorIgnored = GuiResource.getInstance().getColorGray();
        } else {
            this.colorStaged = GuiResource.getInstance().getColorBlue();
            this.colorIgnored = GuiResource.getInstance().getColorDarkGray();
        }
        this.colorUnstaged = GuiResource.getInstance().getColor(225, 30, 70);
        this.refreshChangedFiles();
    }

    @GuiCallback(callbackId="ExplorerPerspective-Toolbar-Created")
    public void addRootChangedListener() {
        git = null;
        ExplorerPerspective explorerPerspective = ExplorerPerspective.getInstance();
        explorerPerspective.getRootChangedListeners().add(this);
        explorerPerspective.getFilePaintListeners().add(this);
        explorerPerspective.getRefreshListeners().add(this);
        explorerPerspective.getSelectionListeners().add(this);
        this.enableButtons();
    }

    @GuiMenuElement(root="ExplorerPerspective-ContextMenu", parentId="ExplorerPerspective-ContextMenu", id="ExplorerPerspective-ContextMenu-21000-GitCommit", label="i18n::GitGuiPlugin.Menu.Commit.Text", image="git-commit.svg")
    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-21000-Commit", toolTip="i18n::GitGuiPlugin.Toolbar.Commit.Tooltip", image="git-commit.svg")
    public void gitCommit() {
        try {
            ExplorerFile explorerFile = this.getSelectedFile();
            if (git == null || explorerFile == null) {
                return;
            }
            String relativePath = this.calculateRelativePath(git.getDirectory(), explorerFile);
            if (relativePath == null) {
                return;
            }
            List<String> changedFilesToCommit = git.getRevertPathFiles(relativePath);
            if (changedFilesToCommit.isEmpty()) {
                MessageBox box = new MessageBox(HopGui.getInstance().getShell(), 34);
                box.setText(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.NoFilesToCommit.Header", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.NoFilesToCommit.Message", (String[])new String[0]));
                box.open();
            } else {
                EnterStringDialog enterStringDialog;
                String message;
                String[] files = changedFilesToCommit.toArray(new String[0]);
                int[] selectedIndexes = new int[files.length];
                for (int i = 0; i < files.length; ++i) {
                    selectedIndexes[i] = i;
                }
                EnterSelectionDialog selectionDialog = new EnterSelectionDialog(HopGui.getInstance().getShell(), files, BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.StageFiles.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.StageFiles.Message", (String[])new String[0]));
                selectionDialog.setMulti(true);
                selectionDialog.setSelectedNrs(selectedIndexes);
                String selection = selectionDialog.open();
                if (selection != null && (message = (enterStringDialog = new EnterStringDialog(HopGui.getInstance().getShell(), "", BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.SelectFilesToCommit.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.SelectFilesToCommit.Message", (String[])new String[0]))).open()) != null) {
                    int[] selectedNrs;
                    for (int selectedNr : selectedNrs = selectionDialog.getSelectionIndeces()) {
                        String file = files[selectedNr];
                        if (this.fileExists(file)) {
                            git.add(file);
                            continue;
                        }
                        git.rm(file);
                    }
                    String authorName = git.getAuthorName("WORKINGTREE");
                    git.commit(authorName, message);
                }
            }
            ExplorerPerspective.getInstance().refresh();
            this.enableButtons();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.CommitError.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.CommitError.Message", (String[])new String[0]), e);
        }
    }

    private boolean fileExists(String file) throws HopFileException, FileSystemException {
        String filename = git.getDirectory() + File.separator + file;
        return HopVfs.getFileObject((String)filename).exists();
    }

    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-21100-Push", toolTip="i18n::GitGuiPlugin.Toolbar.Push.Tooltip", image="push.svg")
    public void gitPush() {
        try {
            git.push();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.PushError.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.PushError.Message", (String[])new String[0]), e);
        }
    }

    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-21200-Pull", toolTip="i18n::GitGuiPlugin.Toolbar.Pull.Tooltip", image="pull.svg")
    public void gitPull() {
        try {
            if (git.pull()) {
                ExplorerPerspective.getInstance().refresh();
                MessageBox pullSuccessful = new MessageBox(HopGui.getInstance().getShell(), 2);
                pullSuccessful.setText(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.PullSuccessful.Header", (String[])new String[0]));
                pullSuccessful.setMessage(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.PullSuccessful.Message", (String[])new String[0]));
                pullSuccessful.open();
            }
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.PullError.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.PullError.Message", (String[])new String[0]), e);
        }
    }

    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-22000-GitBranch", type=GuiToolbarElementType.LABEL, label="xxxxxxxxxxxxxxxxxxxxx", toolTip="i18n::GitGuiPlugin.Toolbar.Branch.Tooltip")
    public void gitBranches() {
        final List<String> branches = git.getBranches();
        Menu menu = new Menu((Control)HopGui.getInstance().getShell());
        String currentBranch = git.getBranch();
        MenuItem createBranch = new MenuItem(menu, 8);
        createBranch.setText(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.CreateBranch", (String[])new String[0]));
        MenuItem deleteBranch = new MenuItem(menu, 8);
        deleteBranch.setText(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.DeleteBranch", (String[])new String[0]));
        MenuItem mergeBranch = new MenuItem(menu, 8);
        mergeBranch.setText(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.MergeBranch", (String[])new String[0]));
        new MenuItem(menu, 2);
        createBranch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterStringDialog enterStringDialog = new EnterStringDialog(HopGui.getInstance().getShell(), "", BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.CreateBranch.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.CreateBranch.Message", (String[])new String[0]));
                String message = enterStringDialog.open();
                if (message != null) {
                    boolean branchCreated = git.createBranch(message);
                    if (branchCreated) {
                        MessageBox pullSuccessful = new MessageBox(HopGui.getInstance().getShell(), 2);
                        pullSuccessful.setText(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.CreateBranchSuccessFul.Header", (String[])new String[0]));
                        pullSuccessful.setMessage(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.CreateBranchSuccessFul.Message", (String[])new String[0]));
                        pullSuccessful.open();
                    }
                    ExplorerPerspective.getInstance().refresh();
                }
            }
        });
        deleteBranch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterSelectionDialog selectionDialog = new EnterSelectionDialog(HopGui.getInstance().getShell(), branches.toArray(new String[branches.size()]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.DeleteBranch.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.DeleteBranch.Message", (String[])new String[0]));
                String branchToDelete = selectionDialog.open();
                if (branchToDelete != null) {
                    boolean branchDeleted = git.deleteBranch(branchToDelete, true);
                    if (branchDeleted) {
                        MessageBox pullSuccessful = new MessageBox(HopGui.getInstance().getShell(), 2);
                        pullSuccessful.setText(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.DeleteBranchSuccessFul.Header", (String[])new String[0]));
                        pullSuccessful.setMessage(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.DeleteBranchSuccessFul.Message", (String[])new String[0]));
                        pullSuccessful.open();
                    }
                    ExplorerPerspective.getInstance().refresh();
                }
            }
        });
        mergeBranch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterSelectionDialog selectionDialog = new EnterSelectionDialog(HopGui.getInstance().getShell(), branches.toArray(new String[branches.size()]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.MergeBranch.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.MergeBranch.Message", (String[])new String[0]));
                String branchToMerge = selectionDialog.open();
                if (branchToMerge != null) {
                    try {
                        boolean branchMerged = git.mergeBranch(branchToMerge, (MergeStrategy)MergeStrategy.RECURSIVE);
                        if (branchMerged) {
                            MessageBox mergeSuccessful = new MessageBox(HopGui.getInstance().getShell(), 2);
                            mergeSuccessful.setText(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.MergeBranchSuccessFul.Header", (String[])new String[0]));
                            mergeSuccessful.setMessage(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.MergeBranchSuccessFul.Message", (String[])new String[0]));
                            mergeSuccessful.open();
                        }
                    }
                    catch (Exception ex) {
                        new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.MergeBranchError.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.MergeBranchError.Message", (String[])new String[0]), ex);
                    }
                    ExplorerPerspective.getInstance().refresh();
                }
            }
        });
        for (String branch : branches) {
            MenuItem item = new MenuItem(menu, 32);
            item.setText(branch);
            if (branch.equals(currentBranch)) {
                item.setSelection(true);
            }
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem item = (MenuItem)e.widget;
                    git.checkout(item.getText());
                    ExplorerPerspective.getInstance().refresh();
                }
            });
        }
        menu.setVisible(true);
    }

    @GuiMenuElement(root="ExplorerPerspective-ContextMenu", parentId="ExplorerPerspective-ContextMenu", id="ExplorerPerspective-ContextMenu-20100-GitAdd", label="i18n::GitGuiPlugin.Menu.Add.Text", image="git-add.svg")
    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-20200-Add", toolTip="i18n::GitGuiPlugin.Toolbar.Add.Tooltip", image="git-add.svg")
    public void gitAdd() {
        try {
            ExplorerFile explorerFile = this.getSelectedFile();
            if (git == null || explorerFile == null) {
                return;
            }
            String relativePath = this.calculateRelativePath(git.getDirectory(), explorerFile);
            if (relativePath == null) {
                return;
            }
            git.add(relativePath);
            ExplorerPerspective.getInstance().refresh();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.AddError.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.AddError.Message", (String[])new String[0]), e);
        }
    }

    @GuiMenuElement(root="ExplorerPerspective-ContextMenu", parentId="ExplorerPerspective-ContextMenu", id="ExplorerPerspective-ContextMenu-20200-GitRevert", label="i18n::GitGuiPlugin.Menu.Revert.Text", image="git-revert.svg")
    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-20300-Revert", toolTip="i18n::GitGuiPlugin.Toolbar.Revert.Tooltip", image="git-revert.svg")
    public void gitRevert() {
        try {
            ExplorerFile explorerFile = this.getSelectedFile();
            if (git == null || explorerFile == null) {
                return;
            }
            String relativePath = this.calculateRelativePath(git.getDirectory(), explorerFile);
            if (relativePath == null) {
                return;
            }
            List<String> revertPathFiles = git.getRevertPathFiles(relativePath);
            if (revertPathFiles.isEmpty()) {
                MessageBox box = new MessageBox(HopGui.getInstance().getShell(), 34);
                box.setText(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.NoFilesToRevert.Header", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.NoFilesToRevert.Message", (String[])new String[0]));
                box.open();
            } else {
                String[] files = revertPathFiles.toArray(new String[0]);
                int[] selectedIndexes = new int[files.length];
                for (int i = 0; i < files.length; ++i) {
                    selectedIndexes[i] = i;
                }
                EnterSelectionDialog selectionDialog = new EnterSelectionDialog(HopGui.getInstance().getShell(), files, BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.RevertFiles.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.RevertFiles.Message", (String[])new String[0]));
                selectionDialog.setMulti(true);
                selectionDialog.setSelectedNrs(selectedIndexes);
                String selection = selectionDialog.open();
                if (selection != null) {
                    int[] selectedNrs;
                    for (int selectedNr : selectedNrs = selectionDialog.getSelectionIndeces()) {
                        String file = files[selectedNr];
                        git.revertPath(file);
                    }
                }
                MessageBox box = new MessageBox(HopGui.getInstance().getShell(), 34);
                box.setText(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.FilesReverted.Header", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.FilesReverted.Message", (String[])new String[0]));
                box.open();
            }
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.RevertError.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.RevertError.Message", (String[])new String[0]), e);
        }
        ExplorerPerspective.getInstance().refresh();
        this.enableButtons();
    }

    private String calculateRelativePath(String directory, ExplorerFile explorerFile) {
        try {
            FileObject file = HopVfs.getFileObject((String)explorerFile.getFilename());
            FileObject root = HopVfs.getFileObject((String)directory);
            return root.getName().getRelativeName(file.getName());
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error calculating relative path for filename '" + explorerFile.getFilename() + "' against '" + directory + "'", (Throwable)e);
            return null;
        }
    }

    private ExplorerFile getSelectedFile() {
        ExplorerPerspective explorerPerspective = ExplorerPerspective.getInstance();
        return explorerPerspective.getSelectedFile();
    }

    public void rootChanged(String rootFolder, String rootName) {
        try {
            FileObject gitConfig = HopVfs.getFileObject((String)(rootFolder + "/.git/config"));
            if (gitConfig.exists()) {
                git = new UIGit();
                git.openRepo(rootFolder);
                this.setBranchLabel(git.getBranch());
            } else {
                git = null;
                this.setBranchLabel(null);
            }
        }
        catch (Exception e) {
            git = null;
            LogChannel.UI.logBasic("No git project found in " + rootFolder);
        }
        this.refreshChangedFiles();
        this.enableButtons();
    }

    private String getAbsoluteFilename(String path) {
        try {
            path = HopVfs.getFileObject((String)path).getName().getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    private String getAbsoluteFilename(String root, String relativePath) {
        Object path = root + File.separator + relativePath;
        try {
            path = HopVfs.getFileObject((String)path).getName().getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    private void refreshChangedFiles() {
        this.changedFiles = new HashMap<String, UIFile>();
        this.ignoredFiles = new HashMap<String, String>();
        if (git != null) {
            ArrayList<UIFile> files = new ArrayList<UIFile>(git.getStagedFiles());
            files.addAll(git.getUnstagedFiles());
            for (UIFile file : files) {
                String path = this.getAbsoluteFilename(git.getDirectory(), file.getName());
                this.changedFiles.put(path, file);
            }
            Set<String> ignored = git.getIgnored(null);
            for (String file : ignored) {
                String path = this.getAbsoluteFilename(git.getDirectory(), file);
                this.ignoredFiles.put(path, file);
            }
            this.setBranchLabel(git.getBranch());
        }
    }

    public void beforeRefresh() {
        this.refreshChangedFiles();
    }

    public void fileSelected() {
        this.enableButtons();
    }

    private void enableButtons() {
        boolean isGit = git != null;
        boolean isSelected = isGit && this.getSelectedFile() != null;
        GuiToolbarWidgets toolBarWidgets = ExplorerPerspective.getToolBarWidgets();
        toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_GIT_INFO, isGit);
        toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_ADD, isSelected);
        toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_REVERT, isSelected);
        toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_COMMIT, isSelected);
        toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_PUSH, isGit);
        toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_PULL, isGit);
        GuiMenuWidgets menuWidgets = ExplorerPerspective.getInstance().getMenuWidgets();
        menuWidgets.enableMenuItem(CONTEXT_MENU_GIT_INFO, isGit);
        menuWidgets.enableMenuItem(CONTEXT_MENU_GIT_ADD, isSelected);
        menuWidgets.enableMenuItem(CONTEXT_MENU_GIT_COMMIT, isSelected);
        menuWidgets.enableMenuItem(CONTEXT_MENU_GIT_REVERT, isSelected);
    }

    public void filePainted(Tree tree, TreeItem treeItem, String path, String name) {
        String ignored;
        String absolutePath = this.getAbsoluteFilename(path);
        UIFile file = this.changedFiles.get(absolutePath);
        if (file != null) {
            if (file.getChangeType().equals((Object)DiffEntry.ChangeType.ADD)) {
                if (Boolean.TRUE.equals(file.getIsStaged())) {
                    treeItem.setForeground(this.colorStaged);
                } else {
                    treeItem.setForeground(this.colorUnstaged);
                }
            } else {
                treeItem.setForeground(this.colorStaged);
            }
        }
        if ((ignored = this.ignoredFiles.get(absolutePath)) != null) {
            treeItem.setForeground(this.colorIgnored);
        }
    }

    @GuiMenuElement(root="ExplorerPerspective-ContextMenu", parentId="ExplorerPerspective-ContextMenu", id="ExplorerPerspective-ContextMenu-20000-GitInfo", label="i18n::GitGuiPlugin.Menu.Info.Text", image="git-info.svg", separator=true)
    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-20100-GitInfo", toolTip="i18n::GitGuiPlugin.Toolbar.Info.Tooltip", image="git-info.svg", separator=true)
    public void showGitInfo() {
        if (git == null) {
            return;
        }
        ExplorerPerspective explorerPerspective = ExplorerPerspective.getInstance();
        if (explorerPerspective == null) {
            return;
        }
        ExplorerFile activeFile = explorerPerspective.getSelectedFile();
        if (activeFile == null) {
            activeFile = new ExplorerFile();
            activeFile.setName(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Project.Label", (String[])new String[0]));
            activeFile.setFilename(git.getDirectory());
        }
        activeFile.setName(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Info.Label", (String[])new String[]{activeFile.getName()}));
        GitInfoExplorerFileType fileType = new GitInfoExplorerFileType();
        activeFile.setFileType((IExplorerFileType)fileType);
        GitInfoExplorerFileTypeHandler fileTypeHandler = fileType.createFileTypeHandler(HopGui.getInstance(), explorerPerspective, activeFile);
        activeFile.setFileTypeHandler((IExplorerFileTypeHandler)fileTypeHandler);
        explorerPerspective.addFile(activeFile);
    }

    public UIGit getGit() {
        return git;
    }

    public Map<String, UIFile> getChangedFiles() {
        return this.changedFiles;
    }

    public Map<String, String> getIgnoredFiles() {
        return this.ignoredFiles;
    }

    private void setBranchLabel(String branch) {
        GuiToolbarWidgets widgets = ExplorerPerspective.getToolBarWidgets();
        Map widgetsMap = widgets.getWidgetsMap();
        CLabel branchLabel = (CLabel)widgetsMap.get(TOOLBAR_ITEM_BRANCH);
        branchLabel.setText(BaseMessages.getString(PKG, (String)"GitGuiPlugin.Dialog.Branch.BranchName", (String[])new String[]{Const.NVL((String)branch, (String)"")}));
        branchLabel.setEnabled(branch != null);
    }
}

