/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class ISeriesPrinter
implements Serializable {
    static final long serialVersionUID = -609299009457592116L;
    public static final int DEVICE_STATUS_VARIED_OFF = 0;
    public static final int DEVICE_STATUS_AS36_DISABLED = 5;
    public static final int DEVICE_STATUS_VARY_OFF_PENDING = 10;
    public static final int DEVICE_STATUS_VARY_ON_PENDING = 20;
    public static final int DEVICE_STATUS_VARIED_ON = 30;
    public static final int DEVICE_STATUS_CONNECT_PENDING = 40;
    public static final int DEVICE_STATUS_SIGNON_DISPLAY = 50;
    public static final int DEVICE_STATUS_ACTIVE = 60;
    public static final int DEVICE_STATUS_AS36_ENABLED = 62;
    public static final int DEVICE_STATUS_ACTIVE_READER = 63;
    public static final int DEVICE_STATUS_ACTIVE_WRITER = 66;
    public static final int DEVICE_STATUS_HELD = 70;
    public static final int DEVICE_STATUS_POWERED_OFF = 75;
    public static final int DEVICE_STATUS_RCYPND = 80;
    public static final int DEVICE_STATUS_RCYCNL = 90;
    public static final int DEVICE_STATUS_SYSTEM_REQUEST = 95;
    public static final int DEVICE_STATUS_FAILED = 100;
    public static final int DEVICE_STATUS_FAILED_READER = 103;
    public static final int DEVICE_STATUS_FAILED_WRITER = 106;
    public static final int DEVICE_STATUS_DIAGNOSTIC_MODE = 110;
    public static final int DEVICE_STATUS_DAMAGED = 111;
    public static final int DEVICE_STATUS_LOCKED = 112;
    public static final int DEVICE_STATUS_UNKNOWN = 113;
    public static final String FORM_ALIGNMENT_WRITER = "*WTR";
    public static final String FORM_ALIGNMENT_FILE = "*FILE";
    public static final String FORM_TYPE_ALL = "*ALL";
    public static final String FORM_TYPE_FORMS = "*FORMS";
    public static final String FORM_TYPE_STANDARD = "*STD";
    public static final String MESSAGE_OPTION_STANDARD = "*MSG";
    public static final String MESSAGE_OPTION_NONE = "*NOMSG";
    public static final String MESSAGE_OPTION_INFO = "*INFOMSG";
    public static final String MESSAGE_OPTION_INQUIRY = "*INQMSG";
    public static final int OUTPUT_QUEUE_STATUS_HELD = 200;
    public static final int OUTPUT_QUEUE_STATUS_RELEASED = 217;
    public static final int OVERALL_STATUS_UNAVAILABLE = 1;
    public static final int OVERALL_STATUS_NOT_YET_AVAILABLE = 2;
    public static final int OVERALL_STATUS_STOPPED = 3;
    public static final int OVERALL_STATUS_MESSAGE_WAITING = 4;
    public static final int OVERALL_STATUS_HELD = 5;
    public static final int OVERALL_STATUS_STOP_PENDING = 6;
    public static final int OVERALL_STATUS_HOLD_PENDING = 7;
    public static final int OVERALL_STATUS_WAITING_FOR_PRINTER = 8;
    public static final int OVERALL_STATUS_WAITING_TO_START = 9;
    public static final int OVERALL_STATUS_PRINTING = 10;
    public static final int OVERALL_STATUS_WAITING_FOR_PRINTER_OUTPUT = 11;
    public static final int OVERALL_STATUS_CONNECT_PENDING = 12;
    public static final int OVERALL_STATUS_POWERED_OFF = 13;
    public static final int OVERALL_STATUS_UNUSABLE = 14;
    public static final int OVERALL_STATUS_BEING_SERVICED = 15;
    public static final int OVERALL_STATUS_UNKNOWN = 999;
    public static final int PENDING_STATUS_NONE = 213;
    public static final int PENDING_STATUS_IMMEDIATE = 201;
    public static final int PENDING_STATUS_CONTROLLED = 195;
    public static final int PENDING_STATUS_PAGE_END = 215;
    public static final String PRINTER_DEVICE_TYPE_SCS = "*SCS";
    public static final String PRINTER_DEVICE_TYPE_IPDS = "*IPDS";
    public static final int WRITER_STATUS_STARTED = 1;
    public static final int WRITER_STATUS_ENDED = 2;
    public static final int WRITER_STATUS_ON_JOB_QUEUE = 3;
    public static final int WRITER_STATUS_HELD = 4;
    public static final int WRITER_STATUS_MESSAGE_WAITING = 5;
    public static final String WRITER_TIME_ALL_DONE = "*NORDYF";
    public static final String WRITER_TIME_CURRENT_DONE = "*FILEEND";
    public static final String WRITER_TIME_WAIT = "*NO";
    public static final String WRITER_TIME_NONE = "";
    public static final int WRITING_STATUS_WRITING = 232;
    public static final int WRITING_STATUS_NOT_WRITING = 213;
    public static final int WRITING_STATUS_FILE_SEPARATORS = 226;
    private AS400 system_;
    private String name_;
    private boolean refreshed_ = false;
    private boolean writerStarted_;
    private int writerStatus_;
    private int deviceStatus_;
    private int overallStatus_;
    private String description_;
    private String starterUser_;
    private int writingStatus_;
    private boolean waitingForMessage_;
    private boolean held_;
    private int endPendingStatus_;
    private int holdPendingStatus_;
    private boolean betweenFiles_;
    private boolean betweenCopies_;
    private boolean waitingForData_;
    private boolean waitingForDevice_;
    private boolean onJobQueue_;
    private String writerJobName_;
    private String writerJobUser_;
    private String writerJobNumber_;
    private String printerDeviceType_;
    private int numberOfSeparators_;
    private int separatorDrawer_;
    private String formAlignmentMessageTime_;
    private String outputQueueName_;
    private String outputQueueLibraryName_;
    private int outputQueueStatus_;
    private boolean publishedInNetworkDirectory_;
    private String formType_;
    private String messageOption_;
    private String writerEndTime_;
    private boolean allowsDirectPrinting_;
    private String messageQueueName_;
    private String messageQueueLibraryName_;
    private String writerChangeTime_;
    private String pendingOutputQueueName_;
    private String pendingOutputQueueLibraryName_;
    private String pendingFormType_;
    private String pendingMessageOption_;
    private int pendingNumberOfSeparators_;
    private int pendingSeparatorDrawer_;
    private String spooledFileName_;
    private String spooledFileJobName_;
    private String spooledFileJobUser_;
    private String spooledFileJobNumber_;
    private int spooledFileNumber_;
    private int pageBeingWritten_;
    private int totalPages_;
    private int copiesLeft_;
    private int totalCopies_;
    private boolean supportsAFP_;
    private byte[] writerMessageKey_;
    private String spooledFileJobSystem_;
    private String spooledFileCreationDate_;
    private String spooledFileCreationTime_;

    public ISeriesPrinter(AS400 system, String name) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing ISeriesPrinter object, system: " + system + ", name: " + name);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (name == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if (name.length() > 10) {
            Trace.log(2, "Length of parameter 'name' is not valid: '" + name + "'");
            throw new ExtendedIllegalArgumentException("name (" + name + ")", 1);
        }
        this.system_ = system;
        this.name_ = name.toUpperCase().trim();
    }

    public boolean allowsDirectPrinting() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.allowsDirectPrinting_;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ISeriesPrinter) {
            ISeriesPrinter p = (ISeriesPrinter)obj;
            return p.system_.equals(this.system_) && p.name_.equals(this.name_);
        }
        return false;
    }

    public int getCopiesLeft() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.copiesLeft_;
    }

    public String getDescription() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.description_;
    }

    public int getDeviceStatus() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.deviceStatus_;
    }

    public int getEndPendingStatus() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.endPendingStatus_;
    }

    public String getFormAlignmentMessageTime() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.formAlignmentMessageTime_;
    }

    public String getFormType() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.formType_;
    }

    public int getHoldPendingStatus() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.holdPendingStatus_;
    }

    public String getMessageOption() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.messageOption_;
    }

    public String getMessageQueue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        if (this.messageQueueLibraryName_.length() == 0) {
            return WRITER_TIME_NONE;
        }
        return QSYSObjectPathName.toPath(this.messageQueueLibraryName_, this.messageQueueName_, "MSGQ");
    }

    public String getName() {
        return this.name_;
    }

    public int getNumberOfSeparators() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.numberOfSeparators_;
    }

    public String getOutputQueue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        if (this.outputQueueLibraryName_.length() == 0) {
            return WRITER_TIME_NONE;
        }
        return QSYSObjectPathName.toPath(this.outputQueueLibraryName_, this.outputQueueName_, "OUTQ");
    }

    public int getOutputQueueStatus() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.outputQueueStatus_;
    }

    public int getOverallStatus() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.overallStatus_;
    }

    public int getPageBeingWritten() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.pageBeingWritten_;
    }

    public String getPendingFormType() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.pendingFormType_;
    }

    public String getPendingMessageOption() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.pendingMessageOption_;
    }

    public int getPendingNumberOfSeparators() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.pendingNumberOfSeparators_;
    }

    public String getPendingOutputQueue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        if (this.pendingOutputQueueLibraryName_.length() == 0) {
            return WRITER_TIME_NONE;
        }
        return QSYSObjectPathName.toPath(this.pendingOutputQueueLibraryName_, this.pendingOutputQueueName_, "OUTQ");
    }

    public int getPendingSeparatorDrawer() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.pendingSeparatorDrawer_;
    }

    public String getPrinterDeviceType() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.printerDeviceType_;
    }

    public int getSeparatorDrawer() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.separatorDrawer_;
    }

    public Date getSpooledFileCreationDate() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        if (this.spooledFileCreationDate_ == null || this.spooledFileCreationDate_.length() == 0) {
            return null;
        }
        Calendar cal = AS400Calendar.getGregorianInstance();
        cal.clear();
        cal.set(Integer.parseInt(this.spooledFileCreationDate_.substring(0, 3)) + 1900, Integer.parseInt(this.spooledFileCreationDate_.substring(3, 5)) - 1, Integer.parseInt(this.spooledFileCreationDate_.substring(5, 7)), Integer.parseInt(this.spooledFileCreationTime_.substring(0, 2)), Integer.parseInt(this.spooledFileCreationTime_.substring(2, 4)), Integer.parseInt(this.spooledFileCreationTime_.substring(4, 6)));
        return cal.getTime();
    }

    public String getSpooledFileJobName() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.spooledFileJobName_;
    }

    public String getSpooledFileJobNumber() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.spooledFileJobNumber_;
    }

    public String getSpooledFileJobSystem() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.spooledFileJobSystem_;
    }

    public String getSpooledFileJobUser() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.spooledFileJobUser_;
    }

    public String getSpooledFileName() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.spooledFileName_;
    }

    public int getSpooledFileNumber() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.spooledFileNumber_;
    }

    public String getStarterUser() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.starterUser_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public int getTotalCopies() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.totalCopies_;
    }

    public int getTotalPages() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.totalPages_;
    }

    public String getWriterChangeTime() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.writerChangeTime_;
    }

    public String getWriterEndTime() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.writerEndTime_;
    }

    public String getWriterJobName() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.writerJobName_;
    }

    public String getWriterJobNumber() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.writerJobNumber_;
    }

    public String getWriterJobUser() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.writerJobUser_;
    }

    public byte[] getWriterMessageKey() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.writerMessageKey_;
    }

    public int getWriterStatus() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.writerStatus_;
    }

    public int getWritingStatus() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.writingStatus_;
    }

    public int hashCode() {
        return this.name_.hashCode();
    }

    public boolean isBetweenCopies() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.betweenCopies_;
    }

    public boolean isBetweenFiles() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.betweenFiles_;
    }

    public boolean isHeld() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.held_;
    }

    public boolean isOnJobQueue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.onJobQueue_;
    }

    public boolean isPublishedInNetworkDirectory() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.publishedInNetworkDirectory_;
    }

    public boolean isWaitingForData() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.waitingForData_;
    }

    public boolean isWaitingForDevice() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.waitingForDevice_;
    }

    public boolean isWaitingForMessage() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.waitingForMessage_;
    }

    public boolean isWriterStarted() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.writerStarted_;
    }

    public void refresh() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Refreshing printer information.");
        }
        int vrm = this.system_.getVRM();
        CharConverter conv = new CharConverter(this.system_.getCcsid(), this.system_);
        byte[] deviceName = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        conv.stringToByteArray(this.name_, deviceName, 0, 10);
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(402), new ProgramParameter(new byte[]{0, 0, 1, -110}), new ProgramParameter(new byte[]{-39, -41, -29, -63, -16, -15, -16, -16}), new ProgramParameter(deviceName), new ProgramParameter(new byte[8])};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QGYRPRTA.PGM", parameters);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        byte[] data = parameters[0].getOutputData();
        this.writerStarted_ = data[18] == -15;
        this.writerStatus_ = data[19] & 0xFF;
        this.deviceStatus_ = BinaryConverter.byteArrayToInt(data, 20);
        this.overallStatus_ = BinaryConverter.byteArrayToInt(data, 24);
        this.description_ = conv.byteArrayToString(data, 28, 50).trim();
        this.starterUser_ = conv.byteArrayToString(data, 80, 10).trim();
        this.writingStatus_ = data[90] & 0xFF;
        this.waitingForMessage_ = data[91] == -24;
        this.held_ = data[92] == -24;
        this.endPendingStatus_ = data[93] & 0xFF;
        this.holdPendingStatus_ = data[94] & 0xFF;
        this.betweenFiles_ = data[95] == -24;
        this.betweenCopies_ = data[96] == -24;
        this.waitingForData_ = data[97] == -24;
        this.waitingForDevice_ = data[98] == -24;
        this.onJobQueue_ = data[99] == -24;
        this.writerJobName_ = conv.byteArrayToString(data, 104, 10).trim();
        this.writerJobUser_ = conv.byteArrayToString(data, 114, 10).trim();
        this.writerJobNumber_ = conv.byteArrayToString(data, 124, 6).trim();
        this.printerDeviceType_ = conv.byteArrayToString(data, 130, 10).trim();
        if (this.printerDeviceType_.equals(PRINTER_DEVICE_TYPE_SCS)) {
            this.printerDeviceType_ = PRINTER_DEVICE_TYPE_SCS;
        } else if (this.printerDeviceType_.equals(PRINTER_DEVICE_TYPE_IPDS)) {
            this.printerDeviceType_ = PRINTER_DEVICE_TYPE_IPDS;
        }
        this.numberOfSeparators_ = BinaryConverter.byteArrayToInt(data, 140);
        this.separatorDrawer_ = BinaryConverter.byteArrayToInt(data, 144);
        this.formAlignmentMessageTime_ = conv.byteArrayToString(data, 148, 10).trim();
        if (this.formAlignmentMessageTime_.equals(FORM_ALIGNMENT_WRITER)) {
            this.formAlignmentMessageTime_ = FORM_ALIGNMENT_WRITER;
        } else if (this.formAlignmentMessageTime_.equals(FORM_ALIGNMENT_FILE)) {
            this.formAlignmentMessageTime_ = FORM_ALIGNMENT_FILE;
        }
        this.outputQueueName_ = conv.byteArrayToString(data, 158, 10).trim();
        this.outputQueueLibraryName_ = conv.byteArrayToString(data, 168, 10).trim();
        this.outputQueueStatus_ = data[178] & 0xFF;
        this.publishedInNetworkDirectory_ = data[179] == -15;
        this.formType_ = conv.byteArrayToString(data, 180, 10).trim();
        if (this.formType_.equals(FORM_TYPE_ALL)) {
            this.formType_ = FORM_TYPE_ALL;
        } else if (this.formType_.equals(FORM_TYPE_FORMS)) {
            this.formType_ = FORM_TYPE_FORMS;
        } else if (this.formType_.equals(FORM_TYPE_STANDARD)) {
            this.formType_ = FORM_TYPE_STANDARD;
        }
        this.messageOption_ = conv.byteArrayToString(data, 190, 10).trim();
        if (this.messageOption_.equals(MESSAGE_OPTION_STANDARD)) {
            this.messageOption_ = MESSAGE_OPTION_STANDARD;
        } else if (this.messageOption_.equals(MESSAGE_OPTION_NONE)) {
            this.messageOption_ = MESSAGE_OPTION_NONE;
        } else if (this.messageOption_.equals(MESSAGE_OPTION_INFO)) {
            this.messageOption_ = MESSAGE_OPTION_INFO;
        } else if (this.messageOption_.equals(MESSAGE_OPTION_INQUIRY)) {
            this.messageOption_ = MESSAGE_OPTION_INQUIRY;
        }
        this.writerEndTime_ = conv.byteArrayToString(data, 200, 10).trim();
        if (this.writerEndTime_.equals(WRITER_TIME_ALL_DONE)) {
            this.writerEndTime_ = WRITER_TIME_ALL_DONE;
        } else if (this.writerEndTime_.equals(WRITER_TIME_CURRENT_DONE)) {
            this.writerEndTime_ = WRITER_TIME_CURRENT_DONE;
        } else if (this.writerEndTime_.equals(WRITER_TIME_NONE)) {
            this.writerEndTime_ = WRITER_TIME_NONE;
        }
        this.allowsDirectPrinting_ = conv.byteArrayToString(data, 210, 10).trim().equals("*YES");
        this.messageQueueName_ = conv.byteArrayToString(data, 220, 10).trim();
        this.messageQueueLibraryName_ = conv.byteArrayToString(data, 230, 10).trim();
        this.writerChangeTime_ = conv.byteArrayToString(data, 242, 10).trim();
        if (this.writerChangeTime_.equals(WRITER_TIME_ALL_DONE)) {
            this.writerChangeTime_ = WRITER_TIME_ALL_DONE;
        } else if (this.writerChangeTime_.equals(WRITER_TIME_CURRENT_DONE)) {
            this.writerChangeTime_ = WRITER_TIME_CURRENT_DONE;
        } else if (this.writerChangeTime_.equals(WRITER_TIME_NONE)) {
            this.writerChangeTime_ = WRITER_TIME_NONE;
        }
        this.pendingOutputQueueName_ = conv.byteArrayToString(data, 252, 10).trim();
        this.pendingOutputQueueLibraryName_ = conv.byteArrayToString(data, 262, 10).trim();
        this.pendingFormType_ = conv.byteArrayToString(data, 272, 10).trim();
        if (this.pendingFormType_.equals(FORM_TYPE_ALL)) {
            this.pendingFormType_ = FORM_TYPE_ALL;
        } else if (this.pendingFormType_.equals(FORM_TYPE_FORMS)) {
            this.pendingFormType_ = FORM_TYPE_FORMS;
        } else if (this.pendingFormType_.equals(FORM_TYPE_STANDARD)) {
            this.pendingFormType_ = FORM_TYPE_STANDARD;
        }
        this.pendingMessageOption_ = conv.byteArrayToString(data, 282, 10).trim();
        if (this.pendingMessageOption_.equals(MESSAGE_OPTION_STANDARD)) {
            this.pendingMessageOption_ = MESSAGE_OPTION_STANDARD;
        } else if (this.pendingMessageOption_.equals(MESSAGE_OPTION_NONE)) {
            this.pendingMessageOption_ = MESSAGE_OPTION_NONE;
        } else if (this.pendingMessageOption_.equals(MESSAGE_OPTION_INFO)) {
            this.pendingMessageOption_ = MESSAGE_OPTION_INFO;
        } else if (this.pendingMessageOption_.equals(MESSAGE_OPTION_INQUIRY)) {
            this.pendingMessageOption_ = MESSAGE_OPTION_INQUIRY;
        }
        this.pendingNumberOfSeparators_ = BinaryConverter.byteArrayToInt(data, 292);
        this.pendingSeparatorDrawer_ = BinaryConverter.byteArrayToInt(data, 296);
        this.spooledFileName_ = conv.byteArrayToString(data, 300, 10).trim();
        this.spooledFileJobName_ = conv.byteArrayToString(data, 310, 10).trim();
        this.spooledFileJobUser_ = conv.byteArrayToString(data, 320, 10).trim();
        this.spooledFileJobNumber_ = conv.byteArrayToString(data, 330, 6).trim();
        this.spooledFileNumber_ = BinaryConverter.byteArrayToInt(data, 336);
        this.pageBeingWritten_ = BinaryConverter.byteArrayToInt(data, 340);
        this.totalPages_ = BinaryConverter.byteArrayToInt(data, 344);
        this.copiesLeft_ = BinaryConverter.byteArrayToInt(data, 348);
        this.totalCopies_ = BinaryConverter.byteArrayToInt(data, 352);
        this.supportsAFP_ = conv.byteArrayToString(data, 356, 10).trim().equals("*YES");
        this.writerMessageKey_ = new byte[4];
        System.arraycopy(data, 366, this.writerMessageKey_, 0, 4);
        if (vrm >= 328192) {
            this.spooledFileJobSystem_ = conv.byteArrayToString(data, 381, 8).trim();
            this.spooledFileCreationDate_ = conv.byteArrayToString(data, 389, 7).trim();
            this.spooledFileCreationTime_ = conv.byteArrayToString(data, 396, 6).trim();
        }
        this.refreshed_ = true;
    }

    public boolean supportsAFP() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refresh();
        }
        return this.supportsAFP_;
    }
}

