/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.deletionvectors;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.fs.Path;
import org.apache.paimon.reader.FileRecordIterator;

public class ApplyDeletionFileRecordIterator<T>
implements FileRecordIterator<T> {
    private final FileRecordIterator<T> iterator;
    private final DeletionVector deletionVector;

    public ApplyDeletionFileRecordIterator(FileRecordIterator<T> iterator, DeletionVector deletionVector) {
        this.iterator = iterator;
        this.deletionVector = deletionVector;
    }

    public FileRecordIterator<T> iterator() {
        return this.iterator;
    }

    public DeletionVector deletionVector() {
        return this.deletionVector;
    }

    @Override
    public long returnedPosition() {
        return this.iterator.returnedPosition();
    }

    @Override
    public Path filePath() {
        return this.iterator.filePath();
    }

    @Override
    @Nullable
    public T next() throws IOException {
        Object next;
        do {
            if ((next = this.iterator.next()) != null) continue;
            return null;
        } while (this.deletionVector.isDeleted(this.returnedPosition()));
        return next;
    }

    @Override
    public void releaseBatch() {
        this.iterator.releaseBatch();
    }
}

