/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.tag;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.paimon.operation.TagDeletion;
import org.apache.paimon.table.sink.TagCallback;
import org.apache.paimon.tag.Tag;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagTimeExpire {
    private static final Logger LOG = LoggerFactory.getLogger(TagTimeExpire.class);
    private final SnapshotManager snapshotManager;
    private final TagManager tagManager;
    private final TagDeletion tagDeletion;
    private final List<TagCallback> callbacks;

    private TagTimeExpire(SnapshotManager snapshotManager, TagManager tagManager, TagDeletion tagDeletion, List<TagCallback> callbacks) {
        this.snapshotManager = snapshotManager;
        this.tagManager = tagManager;
        this.tagDeletion = tagDeletion;
        this.callbacks = callbacks;
    }

    public void run() {
        List<Pair<Tag, String>> tags = this.tagManager.tagObjects();
        for (Pair<Tag, String> pair : tags) {
            Tag tag = pair.getLeft();
            String tagName = pair.getRight();
            LocalDateTime createTime = tag.getTagCreateTime();
            Duration timeRetained = tag.getTagTimeRetained();
            if (createTime == null || timeRetained == null || !LocalDateTime.now().isAfter(createTime.plus(timeRetained))) continue;
            LOG.info("Delete tag {}, because its existence time has reached its timeRetained of {}.", (Object)tagName, (Object)timeRetained);
            this.tagManager.deleteTag(tagName, this.tagDeletion, this.snapshotManager, this.callbacks);
        }
    }

    public static TagTimeExpire create(SnapshotManager snapshotManager, TagManager tagManager, TagDeletion tagDeletion, List<TagCallback> callbacks) {
        return new TagTimeExpire(snapshotManager, tagManager, tagDeletion, callbacks);
    }
}

