/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.AmoroTableMetastore;
import org.apache.amoro.api.BlockableOperation;
import org.apache.amoro.api.Blocker;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.api.NoSuchObjectException;
import org.apache.amoro.api.OperationConflictException;
import org.apache.amoro.api.ServerTableIdentifier;
import org.apache.amoro.api.TableCommitMeta;
import org.apache.amoro.api.TableIdentifier;
import org.apache.amoro.api.TableMeta;
import org.apache.amoro.server.catalog.InternalCatalog;
import org.apache.amoro.server.catalog.ServerCatalog;
import org.apache.amoro.server.table.TableMetadata;
import org.apache.amoro.server.table.TableService;
import org.apache.amoro.server.utils.InternalTableUtil;
import org.apache.amoro.shade.thrift.org.apache.thrift.TException;

public class TableManagementService
implements AmoroTableMetastore.Iface {
    private final TableService tableService;

    public TableManagementService(TableService tableService) {
        this.tableService = tableService;
    }

    public void ping() {
    }

    public List<CatalogMeta> getCatalogs() {
        return this.tableService.listCatalogMetas();
    }

    public CatalogMeta getCatalog(String name) {
        return this.tableService.getCatalogMeta(name);
    }

    public List<String> getDatabases(String catalogName) {
        ServerCatalog serverCatalog = this.tableService.getServerCatalog(catalogName);
        return serverCatalog.listDatabases();
    }

    public void createDatabase(String catalogName, String database) {
        InternalCatalog serverCatalog = this.tableService.getInternalCatalog(catalogName);
        serverCatalog.createDatabase(database);
    }

    public void dropDatabase(String catalogName, String database) {
        InternalCatalog serverCatalog = this.tableService.getInternalCatalog(catalogName);
        serverCatalog.dropDatabase(database);
    }

    public void createTableMeta(TableMeta tableMeta) {
        if (tableMeta == null) {
            throw new IllegalArgumentException("table meta should not be null");
        }
        ServerTableIdentifier identifier = ServerTableIdentifier.of((TableIdentifier)tableMeta.getTableIdentifier(), (TableFormat)TableFormat.valueOf((String)tableMeta.getFormat()));
        InternalCatalog catalog = this.tableService.getInternalCatalog(identifier.getCatalog());
        CatalogMeta catalogMeta = catalog.getMetadata();
        TableMetadata tableMetadata = new TableMetadata(identifier, tableMeta, catalogMeta);
        this.tableService.createTable(catalog.name(), tableMetadata);
    }

    public List<TableMeta> listTables(String catalogName, String database) {
        InternalCatalog serverCatalog = this.tableService.getInternalCatalog(catalogName);
        List<TableMetadata> tableMetadataList = serverCatalog.listTableMetadataInDatabase(database);
        return tableMetadataList.stream().map(TableMetadata::buildTableMeta).collect(Collectors.toList());
    }

    public TableMeta getTable(TableIdentifier tableIdentifier) {
        InternalCatalog serverCatalog = this.tableService.getInternalCatalog(tableIdentifier.getCatalog());
        TableMetadata tableMetadata = serverCatalog.loadTableMetadata(tableIdentifier.getDatabase(), tableIdentifier.getTableName());
        if (tableMetadata.getFormat() == TableFormat.MIXED_ICEBERG && !InternalTableUtil.isLegacyMixedIceberg(tableMetadata)) {
            throw new IllegalArgumentException("The table " + tableIdentifier.toString() + " is based on rest-catalog, please upgrade your connector");
        }
        return tableMetadata.buildTableMeta();
    }

    public void removeTable(TableIdentifier tableIdentifier, boolean deleteData) {
        this.tableService.dropTableMetadata(tableIdentifier, deleteData);
    }

    public void tableCommit(TableCommitMeta commit) {
    }

    public long allocateTransactionId(TableIdentifier tableIdentifier, String transactionSignature) throws TException {
        throw new UnsupportedOperationException("allocate TransactionId from AMS is not supported now");
    }

    public Blocker block(TableIdentifier tableIdentifier, List<BlockableOperation> operations, Map<String, String> properties) throws OperationConflictException {
        return this.tableService.block(tableIdentifier, operations, properties);
    }

    public void releaseBlocker(TableIdentifier tableIdentifier, String blockerId) {
        this.tableService.releaseBlocker(tableIdentifier, blockerId);
    }

    public long renewBlocker(TableIdentifier tableIdentifier, String blockerId) throws NoSuchObjectException {
        return this.tableService.renewBlocker(tableIdentifier, blockerId);
    }

    public List<Blocker> getBlockers(TableIdentifier tableIdentifier) {
        return this.tableService.getBlockers(tableIdentifier);
    }
}

