/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.model;

import org.apache.iceberg.PartitionField;
import org.apache.iceberg.Schema;

public class AMSPartitionField {
    String field;
    String sourceField;
    String transform;
    Integer fieldId;
    Integer sourceFieldId;

    public AMSPartitionField() {
    }

    public AMSPartitionField(String field, String sourceField, String transform, Integer fieldId, Integer sourceFieldId) {
        this.field = field;
        this.sourceField = sourceField;
        this.transform = transform;
        this.fieldId = fieldId;
        this.sourceFieldId = sourceFieldId;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getSourceField() {
        return this.sourceField;
    }

    public void setSourceField(String sourceField) {
        this.sourceField = sourceField;
    }

    public String getTransform() {
        return this.transform;
    }

    public void setTransform(String transform) {
        this.transform = transform;
    }

    public Integer getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(Integer fieldId) {
        this.fieldId = fieldId;
    }

    public Integer getSourceFieldId() {
        return this.sourceFieldId;
    }

    public void setSourceFieldId(Integer sourceFieldId) {
        this.sourceFieldId = sourceFieldId;
    }

    public static AMSPartitionField buildFromPartitionSpec(Schema schema, PartitionField pf) {
        return new Builder().field(pf.name()).sourceField(schema.findColumnName(pf.sourceId())).transform(pf.transform().toString()).fieldId(pf.fieldId()).sourceFieldId(pf.sourceId()).build();
    }

    public static class Builder {
        String field;
        String sourceField;
        String transform;
        Integer fieldId;
        Integer sourceFieldId;

        public Builder field(String field) {
            this.field = field;
            return this;
        }

        public Builder sourceField(String sourceField) {
            this.sourceField = sourceField;
            return this;
        }

        public Builder transform(String transform) {
            this.transform = transform;
            return this;
        }

        public Builder fieldId(Integer fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public Builder sourceFieldId(Integer sourceFieldId) {
            this.sourceFieldId = sourceFieldId;
            return this;
        }

        public AMSPartitionField build() {
            return new AMSPartitionField(this.field, this.sourceField, this.transform, this.fieldId, this.sourceFieldId);
        }
    }
}

